/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.geospatial;

import java.util.HashMap;
import org.web3d.vrml.lang.InvalidFieldAccessException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.geospatial.BaseGeoSRFTParametersNode;

public class BaseGeoLCE3DParameters
extends BaseGeoSRFTParametersNode {
    protected static final int FIELD_LOCOCENTER = 1;
    protected static final int FIELD_PRIMARY_AXIS = 2;
    protected static final int FIELD_SECONDARY_AXIS = 3;
    protected static final int LAST_TMPARAMS_INDEX = 3;
    private static final int NUM_FIELDS = 4;
    private static final String OUT_OF_RANGE_MSG = "Found an out of range value for a SFVec3f field. Valid values lie in the range [-1,1]";
    protected static final VRMLFieldDeclaration[] fieldDecl;
    protected static final HashMap<String, Integer> fieldMap;
    private static final int[] nodeFields;
    protected float[] vfLococenter;
    protected float[] vfPrimaryAxis;
    protected float[] vfSecondaryAxis;

    public BaseGeoLCE3DParameters() {
        super("GeoLCE3DParameters");
        this.hasChanged = new boolean[4];
        this.vfLococenter = new float[3];
        this.vfPrimaryAxis = new float[]{0.0f, 1.0f, 0.0f};
        this.vfSecondaryAxis = new float[]{0.0f, 0.0f, 1.0f};
    }

    public BaseGeoLCE3DParameters(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("lococenter");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfLococenter[0] = vRMLFieldData.floatArrayValue[0];
            this.vfLococenter[1] = vRMLFieldData.floatArrayValue[1];
            this.vfLococenter[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("primaryAxis");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfPrimaryAxis[0] = vRMLFieldData.floatArrayValue[0];
            this.vfPrimaryAxis[1] = vRMLFieldData.floatArrayValue[1];
            this.vfPrimaryAxis[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("secondaryAxis");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfSecondaryAxis[0] = vRMLFieldData.floatArrayValue[0];
            this.vfSecondaryAxis[1] = vRMLFieldData.floatArrayValue[1];
            this.vfSecondaryAxis[2] = vRMLFieldData.floatArrayValue[2];
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public int getFieldIndex(String string) {
        Integer n = fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        return n < 0 || n > 3 ? null : fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 1: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfLococenter;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 2: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfPrimaryAxis;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 3: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfSecondaryAxis;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = 1;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 1: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: lococenter");
                }
                this.checkSFVec3fRange(fArray, "lococenter");
                this.vfLococenter[0] = fArray[0];
                this.vfLococenter[1] = fArray[1];
                this.vfLococenter[2] = fArray[2];
                break;
            }
            case 2: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: primaryAxis");
                }
                this.checkSFVec3fRange(fArray, "primaryAxis");
                this.vfPrimaryAxis[0] = fArray[0];
                this.vfPrimaryAxis[1] = fArray[1];
                this.vfPrimaryAxis[2] = fArray[2];
                break;
            }
            case 3: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: secondaryAxis");
                }
                this.checkSFVec3fRange(fArray, "secondaryAxis");
                this.vfSecondaryAxis[0] = fArray[0];
                this.vfSecondaryAxis[1] = fArray[1];
                this.vfSecondaryAxis[2] = fArray[2];
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }

    private void checkSFVec3fRange(float[] fArray, String string) {
        if (fArray[0] < -1.0f || fArray[0] > -1.0f) {
            String string2 = OUT_OF_RANGE_MSG + fArray[0];
            throw new InvalidFieldValueException(string2, string);
        }
        if (fArray[1] < -1.0f || fArray[1] > -1.0f) {
            String string3 = OUT_OF_RANGE_MSG + fArray[1];
            throw new InvalidFieldValueException(string3, string);
        }
        if (fArray[2] < -1.0f || fArray[2] > -1.0f) {
            String string4 = OUT_OF_RANGE_MSG + fArray[2];
            throw new InvalidFieldValueException(string4, string);
        }
    }

    static {
        nodeFields = new int[]{0};
        fieldDecl = new VRMLFieldDeclaration[4];
        fieldMap = new HashMap(12);
        BaseGeoLCE3DParameters.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseGeoLCE3DParameters.fieldDecl[1] = new VRMLFieldDeclaration(2, "SFVec3f", "lococenter");
        BaseGeoLCE3DParameters.fieldDecl[2] = new VRMLFieldDeclaration(2, "SFVec3f", "primaryAxis");
        BaseGeoLCE3DParameters.fieldDecl[3] = new VRMLFieldDeclaration(2, "SFVec3f", "secondaryAxis");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        fieldMap.put("lococenter", new Integer(1));
        fieldMap.put("primaryAxis", new Integer(2));
        fieldMap.put("secondaryAxis", new Integer(3));
    }
}

