/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.geom3d;

import java.util.HashMap;
import org.web3d.vrml.lang.InvalidFieldAccessException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.LocalColorsListener;
import org.web3d.vrml.nodes.TexCoordGenModeListener;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLGeometryNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.AbstractNode;

public abstract class BaseExtrusion
extends AbstractNode
implements VRMLGeometryNodeType {
    protected static final int FIELD_BEGIN_CAP = 1;
    protected static final int FIELD_CCW = 2;
    protected static final int FIELD_CONVEX = 3;
    protected static final int FIELD_CREASE_ANGLE = 4;
    protected static final int FIELD_CROSS_SECTION = 5;
    protected static final int FIELD_END_CAP = 6;
    protected static final int FIELD_ORIENTATION = 7;
    protected static final int FIELD_SCALE = 8;
    protected static final int FIELD_SOLID = 9;
    protected static final int FIELD_SPINE = 10;
    protected static final int FIELD_SET_CROSS_SECTION = 11;
    protected static final int FIELD_SET_ORIENTATION = 12;
    protected static final int FIELD_SET_SCALE = 13;
    protected static final int FIELD_SET_SPINE = 14;
    protected static final int LAST_EXTRUSION_INDEX = 14;
    protected static final int NUM_FIELDS = 15;
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    protected boolean vfCCW;
    protected boolean vfConvex;
    protected float vfCreaseAngle;
    protected float[] vfCrossSection;
    protected int numCrossSection;
    protected boolean vfBeginCap;
    protected boolean vfEndCap;
    protected float[] vfOrientation;
    protected int numOrientation;
    protected float[] vfScale;
    protected int numScale;
    protected boolean vfSolid;
    protected float[] vfSpine;
    protected int numSpine;

    protected BaseExtrusion() {
        super("Extrusion");
        this.hasChanged = new boolean[15];
        this.vfBeginCap = true;
        this.vfCCW = true;
        this.vfConvex = true;
        this.vfCreaseAngle = 0.9f;
        this.vfCrossSection = new float[]{1.0f, 1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f};
        this.numCrossSection = this.vfCrossSection.length / 2;
        this.vfEndCap = true;
        this.vfOrientation = new float[]{0.0f, 0.0f, 1.0f, 0.0f};
        this.numOrientation = this.vfOrientation.length / 4;
        this.vfScale = new float[]{1.0f, 1.0f};
        this.numScale = this.vfScale.length / 2;
        this.vfSolid = true;
        this.vfSpine = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f};
        this.numSpine = this.vfSpine.length / 3;
    }

    public BaseExtrusion(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("beginCap");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfBeginCap = vRMLFieldData.booleanValue;
            n = vRMLNodeType.getFieldIndex("ccw");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfCCW = vRMLFieldData.booleanValue;
            n = vRMLNodeType.getFieldIndex("convex");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfConvex = vRMLFieldData.booleanValue;
            n = vRMLNodeType.getFieldIndex("creaseAngle");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfCreaseAngle = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("crossSection");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfCrossSection = new float[vRMLFieldData.numElements * 2];
                System.arraycopy(vRMLFieldData.floatArrayValue, 0, this.vfCrossSection, 0, vRMLFieldData.numElements * 2);
                this.numCrossSection = vRMLFieldData.numElements;
            }
            n = vRMLNodeType.getFieldIndex("endCap");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfEndCap = vRMLFieldData.booleanValue;
            n = vRMLNodeType.getFieldIndex("orientation");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfOrientation = new float[vRMLFieldData.numElements * 4];
                System.arraycopy(vRMLFieldData.floatArrayValue, 0, this.vfOrientation, 0, vRMLFieldData.numElements * 4);
                this.numOrientation = vRMLFieldData.numElements;
            }
            n = vRMLNodeType.getFieldIndex("scale");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfScale = new float[vRMLFieldData.numElements * 2];
                System.arraycopy(vRMLFieldData.floatArrayValue, 0, this.vfScale, 0, vRMLFieldData.numElements * 2);
                this.numScale = vRMLFieldData.numElements;
            }
            n = vRMLNodeType.getFieldIndex("solid");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfSolid = vRMLFieldData.booleanValue;
            n = vRMLNodeType.getFieldIndex("spine");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfSpine = new float[vRMLFieldData.numElements * 3];
                System.arraycopy(vRMLFieldData.floatArrayValue, 0, this.vfSpine, 0, vRMLFieldData.numElements * 3);
                this.numSpine = vRMLFieldData.numElements;
            }
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public boolean hasLocalColors() {
        return false;
    }

    public boolean hasLocalColorAlpha() {
        return false;
    }

    public void addLocalColorsListener(LocalColorsListener localColorsListener) {
    }

    public void removeLocalColorsListener(LocalColorsListener localColorsListener) {
    }

    public void addTexCoordGenModeChanged(TexCoordGenModeListener texCoordGenModeListener) {
    }

    public void removeTexCoordGenModeChanged(TexCoordGenModeListener texCoordGenModeListener) {
    }

    public String getTexCoordGenMode(int n) {
        return null;
    }

    public int getNumSets() {
        return 0;
    }

    public boolean isSolid() {
        return this.vfSolid;
    }

    public boolean isCCW() {
        return true;
    }

    public boolean isLightingEnabled() {
        return true;
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 14) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 21;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        vRMLFieldData.clear();
        switch (n) {
            case 1: {
                vRMLFieldData.booleanValue = this.vfBeginCap;
                vRMLFieldData.dataType = 1;
                break;
            }
            case 2: {
                vRMLFieldData.booleanValue = this.vfCCW;
                vRMLFieldData.dataType = 1;
                break;
            }
            case 3: {
                vRMLFieldData.booleanValue = this.vfConvex;
                vRMLFieldData.dataType = 1;
                break;
            }
            case 4: {
                vRMLFieldData.floatValue = this.vfCreaseAngle;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 5: {
                vRMLFieldData.floatArrayValue = this.vfCrossSection;
                vRMLFieldData.numElements = this.numCrossSection;
                vRMLFieldData.dataType = (short)11;
                break;
            }
            case 6: {
                vRMLFieldData.booleanValue = this.vfEndCap;
                vRMLFieldData.dataType = 1;
                break;
            }
            case 7: {
                vRMLFieldData.floatArrayValue = this.vfOrientation;
                vRMLFieldData.numElements = this.numOrientation;
                vRMLFieldData.dataType = (short)11;
                break;
            }
            case 8: {
                vRMLFieldData.floatArrayValue = this.vfScale;
                vRMLFieldData.numElements = this.numScale;
                vRMLFieldData.dataType = (short)11;
                break;
            }
            case 9: {
                vRMLFieldData.booleanValue = this.vfSolid;
                vRMLFieldData.dataType = 1;
                break;
            }
            case 10: {
                vRMLFieldData.floatArrayValue = this.vfSpine;
                vRMLFieldData.numElements = this.numSpine;
                vRMLFieldData.dataType = (short)11;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void setValue(int n, boolean bl) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 1: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: beginCap");
                }
                this.vfBeginCap = bl;
                break;
            }
            case 2: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: ccw");
                }
                this.vfCCW = bl;
                break;
            }
            case 3: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: convex");
                }
                this.vfConvex = bl;
                break;
            }
            case 6: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: endCap");
                }
                this.vfEndCap = bl;
                break;
            }
            case 9: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: solid");
                }
                this.vfSolid = bl;
                break;
            }
            default: {
                super.setValue(n, bl);
            }
        }
    }

    public void setValue(int n, float f) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 4: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: creaseAngle");
                }
                this.vfCreaseAngle = f;
                break;
            }
            default: {
                super.setValue(n, f);
            }
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        if (this.inSetup) {
            switch (n) {
                case 5: {
                    this.vfCrossSection = fArray;
                    this.numCrossSection = n2 / 2;
                    break;
                }
                case 7: {
                    this.vfOrientation = fArray;
                    this.numOrientation = n2 / 4;
                    break;
                }
                case 8: {
                    this.vfScale = fArray;
                    this.numScale = n2 / 2;
                    break;
                }
                case 10: {
                    this.vfSpine = fArray;
                    this.numSpine = n2 / 3;
                    break;
                }
                case 11: {
                    throw new InvalidFieldAccessException("Cannot set eventIn set_crossSection at startup");
                }
                case 12: {
                    throw new InvalidFieldAccessException("Cannot set eventIn set_orientation at startup");
                }
                case 13: {
                    throw new InvalidFieldAccessException("Cannot set eventIn set_scale at startup");
                }
                case 14: {
                    throw new InvalidFieldAccessException("Cannot set eventIn set_spine at startup");
                }
                default: {
                    super.setValue(n, fArray, n2);
                    break;
                }
            }
        } else {
            switch (n) {
                case 11: {
                    if (this.vfCrossSection.length < n2) {
                        this.vfCrossSection = new float[n2];
                    }
                    if (n2 != 0) {
                        System.arraycopy(fArray, 0, this.vfCrossSection, 0, n2);
                    }
                    this.numCrossSection = n2 / 2;
                    break;
                }
                case 12: {
                    if (this.vfOrientation.length < n2) {
                        this.vfOrientation = new float[n2];
                    }
                    if (n2 != 0) {
                        System.arraycopy(fArray, 0, this.vfOrientation, 0, n2);
                    }
                    this.numOrientation = n2 / 4;
                    break;
                }
                case 13: {
                    if (this.vfScale.length < n2) {
                        this.vfScale = new float[n2];
                    }
                    if (n2 != 0) {
                        System.arraycopy(fArray, 0, this.vfScale, 0, n2);
                    }
                    this.numScale = n2 / 2;
                    break;
                }
                case 14: {
                    if (this.vfSpine.length < n2) {
                        this.vfSpine = new float[n2];
                    }
                    if (n2 != 0) {
                        System.arraycopy(fArray, 0, this.vfSpine, 0, n2);
                    }
                    this.numSpine = n2 / 3;
                    break;
                }
                case 5: {
                    throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: crossSection.");
                }
                case 7: {
                    throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: orientation.");
                }
                case 8: {
                    throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: scale.");
                }
                case 10: {
                    throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: spine.");
                }
                default: {
                    super.setValue(n, fArray, n2);
                }
            }
            this.hasChanged[n] = true;
            this.fireFieldChanged(n);
        }
    }

    static {
        nodeFields = new int[]{0};
        fieldDecl = new VRMLFieldDeclaration[15];
        fieldMap = new HashMap(45);
        BaseExtrusion.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseExtrusion.fieldDecl[1] = new VRMLFieldDeclaration(2, "SFBool", "beginCap");
        BaseExtrusion.fieldDecl[2] = new VRMLFieldDeclaration(2, "SFBool", "ccw");
        BaseExtrusion.fieldDecl[3] = new VRMLFieldDeclaration(2, "SFBool", "convex");
        BaseExtrusion.fieldDecl[4] = new VRMLFieldDeclaration(2, "SFFloat", "creaseAngle");
        BaseExtrusion.fieldDecl[5] = new VRMLFieldDeclaration(2, "MFVec2f", "crossSection");
        BaseExtrusion.fieldDecl[6] = new VRMLFieldDeclaration(2, "SFBool", "endCap");
        BaseExtrusion.fieldDecl[7] = new VRMLFieldDeclaration(2, "MFRotation", "orientation");
        BaseExtrusion.fieldDecl[8] = new VRMLFieldDeclaration(2, "MFVec2f", "scale");
        BaseExtrusion.fieldDecl[9] = new VRMLFieldDeclaration(2, "SFBool", "solid");
        BaseExtrusion.fieldDecl[10] = new VRMLFieldDeclaration(2, "MFVec3f", "spine");
        BaseExtrusion.fieldDecl[11] = new VRMLFieldDeclaration(1, "MFVec2f", "set_crossSection");
        BaseExtrusion.fieldDecl[12] = new VRMLFieldDeclaration(1, "MFRotation", "set_orientation");
        BaseExtrusion.fieldDecl[13] = new VRMLFieldDeclaration(1, "MFVec2f", "set_scale");
        BaseExtrusion.fieldDecl[14] = new VRMLFieldDeclaration(1, "MFVec3f", "set_spine");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        fieldMap.put("beginCap", new Integer(1));
        fieldMap.put("endCap", new Integer(6));
        fieldMap.put("ccw", new Integer(2));
        fieldMap.put("convex", new Integer(3));
        fieldMap.put("creaseAngle", new Integer(4));
        fieldMap.put("solid", new Integer(9));
        fieldMap.put("scale", new Integer(8));
        fieldMap.put("set_scale", new Integer(13));
        fieldMap.put("orientation", new Integer(7));
        fieldMap.put("set_orientation", new Integer(12));
        fieldMap.put("crossSection", new Integer(5));
        fieldMap.put("set_crossSection", new Integer(11));
        fieldMap.put("spine", new Integer(10));
        fieldMap.put("set_spine", new Integer(14));
    }
}

