/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.enveffects;

import java.util.HashMap;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLBindableNodeType;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLFogNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.BaseBindableNode;
import org.web3d.vrml.util.FieldValidator;

public abstract class BaseFog
extends BaseBindableNode
implements VRMLFogNodeType {
    private static final String UNKNOWN_TYPE_MSG = "The fog type provided is not recognised";
    private static final String NEGATIVE_RANGE_MSG = "The fog visibility range is negative";
    protected static final int FIELD_COLOR = 4;
    protected static final int FIELD_FOGTYPE = 5;
    protected static final int FIELD_VISIBILITY_RANGE = 6;
    public static final int LAST_FOG_INDEX = 6;
    protected static final int NUM_FIELDS = 7;
    protected static final String LINEAR_TYPE = "LINEAR";
    protected static final String EXPONENTIAL_TYPE = "EXPONENTIAL";
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static HashMap typeMap;
    private static int[] nodeFields;
    protected float vfVisibilityRange;
    protected String vfFogType;
    protected float[] vfColor;
    protected int fogType;

    protected BaseFog() {
        super("Fog");
        this.hasChanged = new boolean[7];
        this.vfVisibilityRange = 0.0f;
        this.vfFogType = LINEAR_TYPE;
        this.vfColor = new float[]{1.0f, 1.0f, 1.0f};
        this.fogType = 1;
    }

    protected BaseFog(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((VRMLBindableNodeType)vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("color");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfColor[0] = vRMLFieldData.floatArrayValue[0];
            this.vfColor[1] = vRMLFieldData.floatArrayValue[1];
            this.vfColor[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("visibilityRange");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfVisibilityRange = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("fogType");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfFogType = vRMLFieldData.stringValue;
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public void getColor(float[] fArray) {
        fArray[0] = this.vfColor[0];
        fArray[1] = this.vfColor[1];
        fArray[2] = this.vfColor[2];
    }

    public void setColor(float[] fArray) throws InvalidFieldValueException {
        FieldValidator.checkColorVector((String)"Fog.color", (float[])fArray);
        this.vfColor[0] = fArray[0];
        this.vfColor[1] = fArray[1];
        this.vfColor[2] = fArray[2];
        if (!this.inSetup) {
            this.hasChanged[4] = true;
            this.fireFieldChanged(4);
        }
    }

    public float getVisibilityRange() {
        return this.vfVisibilityRange;
    }

    public void setVisibilityRange(float f) throws InvalidFieldValueException {
        if (f < 0.0f) {
            throw new InvalidFieldValueException(NEGATIVE_RANGE_MSG);
        }
        this.vfVisibilityRange = f;
        if (!this.inSetup) {
            this.hasChanged[6] = true;
            this.fireFieldChanged(6);
        }
    }

    public int getFogType() {
        return this.fogType;
    }

    public void setFogType(int n) throws InvalidFieldValueException {
        if (n < 0 && n > 2) {
            throw new InvalidFieldValueException(UNKNOWN_TYPE_MSG);
        }
        this.fogType = n;
        if (!this.inSetup) {
            this.hasChanged[5] = true;
            this.fireFieldChanged(5);
        }
    }

    public void setDEF() {
        if (!this.inSetup) {
            throw new IllegalStateException("Setting DEF out of node setup");
        }
        this.isDEF = true;
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 6) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 18;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 4: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfColor;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 6: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfVisibilityRange;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 5: {
                vRMLFieldData.clear();
                vRMLFieldData.stringValue = this.vfFogType;
                vRMLFieldData.dataType = (short)6;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 4: {
                    vRMLNodeType.setValue(n2, this.vfColor, 3);
                    break;
                }
                case 6: {
                    vRMLNodeType.setValue(n2, this.vfVisibilityRange);
                    break;
                }
                case 5: {
                    vRMLNodeType.setValue(n2, this.vfFogType);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("Fog sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("Fog sendRoute: Invalid field Value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, float f) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 6: {
                this.setVisibilityRange(f);
                break;
            }
            default: {
                super.setValue(n, f);
            }
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 4: {
                this.setColor(fArray);
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }

    public void setValue(int n, String string) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 5: {
                this.setFogType(string);
                break;
            }
            default: {
                super.setValue(n, string);
            }
        }
    }

    protected void setFogType(String string) throws InvalidFieldValueException {
        if (!string.equals(LINEAR_TYPE) && !string.equals(EXPONENTIAL_TYPE)) {
            throw new InvalidFieldValueException(UNKNOWN_TYPE_MSG);
        }
        this.vfFogType = string;
        Integer n = (Integer)typeMap.get(string);
        this.setFogType(n);
    }

    static {
        nodeFields = new int[]{0};
        fieldDecl = new VRMLFieldDeclaration[7];
        fieldMap = new HashMap(21);
        BaseFog.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseFog.fieldDecl[3] = new VRMLFieldDeclaration(4, "SFBool", "isBound");
        BaseFog.fieldDecl[1] = new VRMLFieldDeclaration(1, "SFBool", "set_bind");
        BaseFog.fieldDecl[2] = new VRMLFieldDeclaration(4, "SFTime", "bindTime");
        BaseFog.fieldDecl[4] = new VRMLFieldDeclaration(3, "SFColor", "color");
        BaseFog.fieldDecl[6] = new VRMLFieldDeclaration(3, "SFFloat", "visibilityRange");
        BaseFog.fieldDecl[5] = new VRMLFieldDeclaration(3, "SFString", "fogType");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        fieldMap.put("isBound", new Integer(3));
        fieldMap.put("set_bind", new Integer(1));
        n = new Integer(2);
        fieldMap.put("bindTime", n);
        fieldMap.put("bindTime_changed", n);
        n = new Integer(4);
        fieldMap.put("color", n);
        fieldMap.put("set_color", n);
        fieldMap.put("color_changed", n);
        n = new Integer(6);
        fieldMap.put("visibilityRange", n);
        fieldMap.put("set_visibilityRange", n);
        fieldMap.put("visibilityRange_changed", n);
        n = new Integer(5);
        fieldMap.put("fogType", n);
        fieldMap.put("set_fogType", n);
        fieldMap.put("intensity_fogType", n);
        typeMap = new HashMap();
        typeMap.put(LINEAR_TYPE, new Integer(1));
        typeMap.put(EXPONENTIAL_TYPE, new Integer(2));
    }
}

