/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.dis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4f;
import javax.vecmath.Quat4d;
import javax.vecmath.Vector3f;
import mil.navy.nps.dis.ArticulationParameter;
import mil.navy.nps.dis.DetonationPdu;
import mil.navy.nps.dis.EntityID;
import mil.navy.nps.dis.EntityStatePdu;
import mil.navy.nps.dis.FirePdu;
import mil.navy.nps.dis.LinearVelocity;
import mil.navy.nps.dis.ProtocolDataUnit;
import mil.navy.nps.math.Quaternion;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.MathTransform;
import org.web3d.vrml.lang.FieldConstants;
import org.web3d.vrml.lang.InvalidFieldAccessException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.FrameStateListener;
import org.web3d.vrml.nodes.NetworkRoleListener;
import org.web3d.vrml.nodes.VRMLClock;
import org.web3d.vrml.nodes.VRMLDISNodeType;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLGroupingNodeType;
import org.web3d.vrml.nodes.VRMLLocalOriginNodeType;
import org.web3d.vrml.nodes.VRMLNetworkInterfaceNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLTimeDependentNodeType;
import org.web3d.vrml.renderer.common.geospatial.GTTransformUtils;
import org.web3d.vrml.renderer.common.nodes.BaseGroupingNode;
import org.web3d.xmsf.dis.ArticulationParametersType;
import org.web3d.xmsf.dis.DeadReckoningParametersType;
import org.web3d.xmsf.dis.EntityIDType;
import org.web3d.xmsf.dis.EntityStatePduType;
import org.web3d.xmsf.dis.EulerAnglesType;
import org.web3d.xmsf.dis.HeaderType;
import org.web3d.xmsf.dis.ProtocolDataUnitType;
import org.web3d.xmsf.dis.Vector3Double;
import org.web3d.xmsf.dis.Vector3Float;
import org.web3d.xmsf.dis.impl.EntityIDTypeImpl;
import org.web3d.xmsf.dis.impl.EulerAnglesTypeImpl;
import org.web3d.xmsf.dis.impl.Vector3DoubleImpl;
import org.web3d.xmsf.dis.impl.Vector3FloatImpl;
import org.web3d.xmsf.disutil.PduFactory;

public class BaseEspduTransform
extends BaseGroupingNode
implements VRMLNetworkInterfaceNodeType,
VRMLDISNodeType,
VRMLTimeDependentNodeType {
    protected static final int MODE_STANDALONE = 2;
    protected static final int MODE_WRITER = 1;
    protected static final int MODE_READER = 0;
    protected static final String PROTOCOL = "DIS";
    protected static final String DISPROTOCOL_HANDLER_PROP = "org.web3d.xj3d.disprotocol_handler.class";
    private static final int[] SECONDARY_TYPE = new int[]{52};
    protected static final int FIELD_CENTER = 6;
    protected static final int FIELD_ROTATION = 7;
    protected static final int FIELD_SCALE = 8;
    protected static final int FIELD_SCALE_ORIENTATION = 9;
    protected static final int FIELD_TRANSLATION = 10;
    protected static final int FIELD_MARKING = 11;
    protected static final int FIELD_SITE_ID = 12;
    protected static final int FIELD_APPLICATION_ID = 13;
    protected static final int FIELD_ENTITY_ID = 14;
    protected static final int FIELD_READ_INTERVAL = 15;
    protected static final int FIELD_WRITE_INTERVAL = 16;
    protected static final int FIELD_NETWORK_MODE = 17;
    protected static final int FIELD_ADDRESS = 18;
    protected static final int FIELD_PORT = 19;
    protected static final int FIELD_ARTICULATION_PARAMETER_COUNT = 20;
    protected static final int FIELD_ARTICULATION_PARAMETER_ARRAY = 21;
    protected static final int FIELD_ARTICULATION_PARAMETER_VALUE0_CHANGED = 22;
    protected static final int FIELD_ARTICULATION_PARAMETER_VALUE1_CHANGED = 23;
    protected static final int FIELD_ARTICULATION_PARAMETER_VALUE2_CHANGED = 24;
    protected static final int FIELD_ARTICULATION_PARAMETER_VALUE3_CHANGED = 25;
    protected static final int FIELD_ARTICULATION_PARAMETER_VALUE4_CHANGED = 26;
    protected static final int FIELD_ARTICULATION_PARAMETER_VALUE5_CHANGED = 27;
    protected static final int FIELD_ARTICULATION_PARAMETER_VALUE6_CHANGED = 28;
    protected static final int FIELD_ARTICULATION_PARAMETER_VALUE7_CHANGED = 29;
    protected static final int FIELD_IS_ACTIVE = 30;
    protected static final int FIELD_SET_ARTICULATION_PARAMETER_VALUE0 = 31;
    protected static final int FIELD_SET_ARTICULATION_PARAMETER_VALUE1 = 32;
    protected static final int FIELD_SET_ARTICULATION_PARAMETER_VALUE2 = 33;
    protected static final int FIELD_SET_ARTICULATION_PARAMETER_VALUE3 = 34;
    protected static final int FIELD_SET_ARTICULATION_PARAMETER_VALUE4 = 35;
    protected static final int FIELD_SET_ARTICULATION_PARAMETER_VALUE5 = 36;
    protected static final int FIELD_SET_ARTICULATION_PARAMETER_VALUE6 = 37;
    protected static final int FIELD_SET_ARTICULATION_PARAMETER_VALUE7 = 38;
    protected static final int FIELD_TIMESTAMP = 39;
    protected static final int FIELD_DETONATION_RESULT = 40;
    protected static final int FIELD_DETONATION_LOCATION = 41;
    protected static final int FIELD_DETONATION_RELATIVE_LOCATION = 42;
    protected static final int FIELD_IS_DETONATED = 43;
    protected static final int FIELD_DETONATE_TIME = 44;
    protected static final int FIELD_EVENT_APPLICATION_ID = 45;
    protected static final int FIELD_EVENT_ENTITY_ID = 46;
    protected static final int FIELD_EVENT_SITE_ID = 47;
    protected static final int FIELD_FIRED_1 = 48;
    protected static final int FIELD_FIRED_2 = 49;
    protected static final int FIELD_FIRE_MISSION_INDEX = 50;
    protected static final int FIELD_FIRING_RANGE = 51;
    protected static final int FIELD_FIRING_RATE = 52;
    protected static final int FIELD_MUNITION_APPLICATION_ID = 53;
    protected static final int FIELD_MUNITION_END_POINT = 54;
    protected static final int FIELD_MUNITION_ENTITY_ID = 55;
    protected static final int FIELD_MUNITION_SITE_ID = 56;
    protected static final int FIELD_MUNITION_START_POINT = 57;
    protected static final int FIELD_FIRED_TIME = 58;
    protected static final int FIELD_GEO_SYSTEM = 59;
    protected static final int FIELD_GEO_ORIGIN = 60;
    protected static final int FIELD_ENTITY_CATEGORY = 61;
    protected static final int FIELD_ENTITY_DOMAIN = 62;
    protected static final int FIELD_ENTITY_EXTRA = 63;
    protected static final int FIELD_ENTITY_KIND = 64;
    protected static final int FIELD_ENTITY_SPECIFIC = 65;
    protected static final int FIELD_ENTITY_COUNTRY = 66;
    protected static final int FIELD_ENTITY_SUBCATEGORY = 67;
    protected static final int FIELD_APPEARANCE = 68;
    protected static final int FIELD_LINEAR_VELOCITY = 69;
    protected static final int FIELD_LINEAR_ACCELERATION = 70;
    protected static final int FIELD_FORCE_ID = 71;
    protected static final int FIELD_XMPP_PARAMS = 72;
    protected static final int FIELD_NOT_IMPL = 73;
    protected static final int LAST_TRANSFORM_INDEX = 72;
    private static final String FACTORY_ERR_MSG = "Unable to create an appropriate set of operations for the defined geoSystem setup. May be either user or tools setup error";
    protected static final int NUM_FIELDS = 73;
    private static final String GEO_ORIGIN_PROTO_MSG = "Proto does not describe a GeoOrigin object";
    private static final String GEO_ORIGIN_NODE_MSG = "Node does not describe a GeoOrigin object";
    private static final float ZEROEPS = 1.0E-4f;
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    protected float[] vfCenter;
    protected float[] vfRotation;
    protected float[] vfScale;
    protected float[] vfScaleOrientation;
    protected float[] vfTranslation;
    protected String vfMarking;
    protected int vfSiteID;
    protected int vfApplicationID;
    protected int vfEntityID;
    protected int vfEntityCategory;
    protected int vfAppearance;
    protected int vfEntityDomain;
    protected int vfEntityExtra;
    protected int vfEntityKind;
    protected int vfEntitySpecific;
    protected int vfEntitySubCategory;
    protected int vfEntityCountry;
    protected double vfReadInterval;
    protected double vfWriteInterval;
    protected String vfNetworkMode;
    protected String[] vfXMPPParams;
    protected static HashMap networkModes;
    protected int currentMode;
    protected String vfAddress;
    protected int vfPort;
    protected int vfEventApplicationID;
    protected int vfEventEntityID;
    protected int vfEventSiteID;
    protected boolean vfFired1;
    protected boolean vfFired2;
    protected int vfFireMissionIndex;
    protected float vfFiringRange;
    protected int vfFiringRate;
    protected int vfMunitionApplicationID;
    protected int vfMunitionEntityID;
    protected int vfMunitionSiteID;
    protected float[] vfMunitionEndPoint;
    protected float[] vfMunitionStartPoint;
    protected double vfFiredTime;
    protected boolean vfIsDetonated;
    protected double vfDetonateTime;
    protected int vfDetonationResult;
    protected float[] vfDetonationLocation;
    protected float[] vfDetonationRelativeLocation;
    protected int vfArticulationParameterCount;
    protected float[] vfArticulationParameterArray;
    protected int numArticulationParameterArray;
    protected float vfArticulationParameterValue0;
    protected float vfArticulationParameterValue1;
    protected float vfArticulationParameterValue2;
    protected float vfArticulationParameterValue3;
    protected float vfArticulationParameterValue4;
    protected float vfArticulationParameterValue5;
    protected float vfArticulationParameterValue6;
    protected float vfArticulationParameterValue7;
    protected int vfForceID;
    protected boolean vfIsActive;
    protected float[] vfLinearVelocity;
    protected float[] vfLinearAcceleration;
    protected String[] vfGeoSystem;
    protected VRMLProtoInstance pGeoOrigin;
    protected VRMLLocalOriginNodeType vfGeoOrigin;
    protected double vfTimestamp;
    protected boolean needToWrite;
    protected double lastWrite;
    protected ArrayList roleListeners;
    private Vector3f tempVec;
    private AxisAngle4f tempAxis;
    private Matrix4f tempMtx1;
    private Matrix4f tempMtx2;
    protected Matrix4f tmatrix;
    Matrix3d rotationMatrix;
    Matrix3d psiMat;
    Matrix3d thetaMat;
    Matrix3d phiMat;
    Quat4d rotationQuat;
    private ArticulationParameter[] artVals;
    private ArticulationParametersType[] artValsDX;
    protected VRMLClock vrmlClock;
    protected boolean ignoreEspdu;
    private float[] dRorientation;
    private Quaternion quaternion;
    private EntityStatePdu espdu;
    private EntityID id;
    private EntityStatePduType espduDX;
    private EntityIDType idDX;
    private Vector3Double v3d;
    private Vector3Float v3f;
    private Vector3Float scrLinearVelo;
    private Vector3Float scrLinearAccel;
    private AxisAngle4d aa;
    private EulerAnglesType eat;
    private String xmppUsername;
    private String xmppPassword;
    private String[] xmppAuthServer;
    private String xmppMucServer;
    private String xmppMucRoom;
    private MathTransform geoTransform;
    private boolean geoCoordSwap;
    private double[] origin;
    private static VRMLFieldDeclaration notimpl_decl;
    private static long simStartTime;
    private boolean useDX;
    double yaw;
    double pitch;
    double roll;

    public BaseEspduTransform() {
        super("EspduTransform");
        this.hasChanged = new boolean[73];
        this.vfCenter = new float[]{0.0f, 0.0f, 0.0f};
        this.vfRotation = new float[]{0.0f, 0.0f, 1.0f, 0.0f};
        this.vfScale = new float[]{1.0f, 1.0f, 1.0f};
        this.vfScaleOrientation = new float[]{0.0f, 0.0f, 1.0f, 0.0f};
        this.vfTranslation = new float[]{0.0f, 0.0f, 0.0f};
        this.vfEventApplicationID = 1;
        this.vfEntityID = 0;
        this.vfForceID = 0;
        this.vfAppearance = 1;
        this.vfEntityCategory = 0;
        this.vfEntityCountry = 0;
        this.vfEntityDomain = 0;
        this.vfEntityKind = 0;
        this.vfEntitySpecific = 0;
        this.vfEntityExtra = 0;
        this.vfEntitySubCategory = 0;
        this.vfEventSiteID = 0;
        this.vfFired1 = false;
        this.vfFired2 = false;
        this.vfFireMissionIndex = 0;
        this.vfFiringRange = 0.0f;
        this.vfFiringRate = 0;
        this.vfMunitionApplicationID = 1;
        this.vfMunitionEntityID = 0;
        this.vfMunitionSiteID = 0;
        this.vfFiredTime = 0.0;
        this.vfMunitionStartPoint = new float[]{0.0f, 0.0f, 0.0f};
        this.vfMunitionEndPoint = new float[]{0.0f, 0.0f, 0.0f};
        this.vfDetonationLocation = new float[]{0.0f, 0.0f, 0.0f};
        this.vfDetonationRelativeLocation = new float[]{0.0f, 0.0f, 0.0f};
        this.vfMarking = "";
        this.vfSiteID = 0;
        this.vfApplicationID = 0;
        this.vfReadInterval = 0.1;
        this.vfWriteInterval = 1.0;
        this.vfNetworkMode = "standAlone";
        this.vfGeoSystem = new String[]{"GD", "WE"};
        this.vfXMPPParams = new String[0];
        this.currentMode = 2;
        this.vfPort = 0;
        this.vfAddress = "";
        this.vfIsActive = false;
        this.vfIsDetonated = false;
        this.vfArticulationParameterCount = 0;
        this.vfArticulationParameterArray = FieldConstants.EMPTY_MFFLOAT;
        this.vfArticulationParameterValue0 = 0.0f;
        this.vfArticulationParameterValue1 = 0.0f;
        this.vfArticulationParameterValue2 = 0.0f;
        this.vfArticulationParameterValue3 = 0.0f;
        this.vfArticulationParameterValue4 = 0.0f;
        this.vfArticulationParameterValue5 = 0.0f;
        this.vfArticulationParameterValue6 = 0.0f;
        this.vfArticulationParameterValue7 = 0.0f;
        this.vfLinearVelocity = new float[]{0.0f, 0.0f, 0.0f};
        this.vfLinearAcceleration = new float[]{0.0f, 0.0f, 0.0f};
        this.artVals = new ArticulationParameter[0];
        this.artValsDX = new ArticulationParametersType[0];
        this.tmatrix = new Matrix4f();
        this.tempVec = new Vector3f();
        this.tempAxis = new AxisAngle4f();
        this.tempMtx1 = new Matrix4f();
        this.tempMtx2 = new Matrix4f();
        this.dRorientation = new float[3];
        this.quaternion = new Quaternion();
        this.roleListeners = new ArrayList(1);
        this.rotationMatrix = new Matrix3d();
        this.psiMat = new Matrix3d();
        this.thetaMat = new Matrix3d();
        this.phiMat = new Matrix3d();
        this.rotationQuat = new Quat4d();
        String string = System.getProperty(DISPROTOCOL_HANDLER_PROP);
        this.aa = new AxisAngle4d();
        if (string != null && string.equals("org.web3d.vrml.renderer.common.input.dis.DISXMLProtocolHandler")) {
            this.useDX = true;
            PduFactory pduFactory = new PduFactory();
            this.espduDX = pduFactory.getEntityStatePdu();
            this.v3d = new Vector3DoubleImpl();
            this.v3f = new Vector3FloatImpl();
            this.scrLinearVelo = new Vector3FloatImpl();
            this.scrLinearAccel = new Vector3FloatImpl();
            this.eat = new EulerAnglesTypeImpl();
        } else {
            this.espdu = new EntityStatePdu();
        }
    }

    public BaseEspduTransform(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((VRMLGroupingNodeType)vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("center");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfCenter[0] = vRMLFieldData.floatArrayValue[0];
            this.vfCenter[1] = vRMLFieldData.floatArrayValue[1];
            this.vfCenter[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("rotation");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfRotation[0] = vRMLFieldData.floatArrayValue[0];
            this.vfRotation[1] = vRMLFieldData.floatArrayValue[1];
            this.vfRotation[2] = vRMLFieldData.floatArrayValue[2];
            this.vfRotation[3] = vRMLFieldData.floatArrayValue[3];
            n = vRMLNodeType.getFieldIndex("scale");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfScale[0] = vRMLFieldData.floatArrayValue[0];
            this.vfScale[1] = vRMLFieldData.floatArrayValue[1];
            this.vfScale[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("scaleOrientation");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfScaleOrientation[0] = vRMLFieldData.floatArrayValue[0];
            this.vfScaleOrientation[1] = vRMLFieldData.floatArrayValue[1];
            this.vfScaleOrientation[2] = vRMLFieldData.floatArrayValue[2];
            this.vfScaleOrientation[3] = vRMLFieldData.floatArrayValue[3];
            n = vRMLNodeType.getFieldIndex("translation");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfTranslation[0] = vRMLFieldData.floatArrayValue[0];
            this.vfTranslation[1] = vRMLFieldData.floatArrayValue[1];
            this.vfTranslation[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("marking");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfMarking = vRMLFieldData.stringValue;
            n = vRMLNodeType.getFieldIndex("geoSystem");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfGeoSystem = new String[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.stringArrayValue, 0, this.vfGeoSystem, 0, vRMLFieldData.numElements);
            }
            n = vRMLNodeType.getFieldIndex("appearance");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfAppearance = vRMLFieldData.intValue;
            n = vRMLNodeType.getFieldIndex("siteID");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfSiteID = vRMLFieldData.intValue;
            n = vRMLNodeType.getFieldIndex("applicationID");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfApplicationID = vRMLFieldData.intValue;
            n = vRMLNodeType.getFieldIndex("entityID");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfEntityID = vRMLFieldData.intValue;
            n = vRMLNodeType.getFieldIndex("forceID");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfForceID = vRMLFieldData.intValue;
            n = vRMLNodeType.getFieldIndex("entityCategory");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfEntityCategory = vRMLFieldData.intValue;
            n = vRMLNodeType.getFieldIndex("entityDomain");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfEntityDomain = vRMLFieldData.intValue;
            n = vRMLNodeType.getFieldIndex("entityExtra");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfEntityExtra = vRMLFieldData.intValue;
            n = vRMLNodeType.getFieldIndex("entityKind");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfEntityKind = vRMLFieldData.intValue;
            n = vRMLNodeType.getFieldIndex("entitySpecific");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfEntitySpecific = vRMLFieldData.intValue;
            n = vRMLNodeType.getFieldIndex("entitySubCategory");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfEntitySubCategory = vRMLFieldData.intValue;
            n = vRMLNodeType.getFieldIndex("entityCountry");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfEntityCountry = vRMLFieldData.intValue;
            n = vRMLNodeType.getFieldIndex("eventApplicationID");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfEventApplicationID = vRMLFieldData.intValue;
            n = vRMLNodeType.getFieldIndex("eventEntityID");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfEventEntityID = vRMLFieldData.intValue;
            n = vRMLNodeType.getFieldIndex("eventSiteID");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfEventSiteID = vRMLFieldData.intValue;
            n = vRMLNodeType.getFieldIndex("fireMissionIndex");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfFireMissionIndex = vRMLFieldData.intValue;
            n = vRMLNodeType.getFieldIndex("firingRate");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfFiringRate = vRMLFieldData.intValue;
            n = vRMLNodeType.getFieldIndex("munitionApplicationID");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfMunitionApplicationID = vRMLFieldData.intValue;
            n = vRMLNodeType.getFieldIndex("munitionEntityID");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfMunitionEntityID = vRMLFieldData.intValue;
            n = vRMLNodeType.getFieldIndex("munitionSiteID");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfMunitionSiteID = vRMLFieldData.intValue;
            n = vRMLNodeType.getFieldIndex("munitionEndPoint");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfMunitionEndPoint[0] = vRMLFieldData.floatArrayValue[0];
            this.vfMunitionEndPoint[1] = vRMLFieldData.floatArrayValue[1];
            this.vfMunitionEndPoint[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("munitionStartPoint");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfMunitionStartPoint[0] = vRMLFieldData.floatArrayValue[0];
            this.vfMunitionStartPoint[1] = vRMLFieldData.floatArrayValue[1];
            this.vfMunitionStartPoint[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("firedTime");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfFiredTime = vRMLFieldData.doubleValue;
            n = vRMLNodeType.getFieldIndex("firingRange");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfFiringRange = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("fired1");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfFired1 = vRMLFieldData.booleanValue;
            n = vRMLNodeType.getFieldIndex("fired2");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfFired2 = vRMLFieldData.booleanValue;
            n = vRMLNodeType.getFieldIndex("isDetonated");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfIsDetonated = vRMLFieldData.booleanValue;
            n = vRMLNodeType.getFieldIndex("detonateTime");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfDetonateTime = vRMLFieldData.doubleValue;
            n = vRMLNodeType.getFieldIndex("readInterval");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfReadInterval = vRMLFieldData.doubleValue;
            n = vRMLNodeType.getFieldIndex("writeInterval");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfWriteInterval = vRMLFieldData.doubleValue;
            n = vRMLNodeType.getFieldIndex("networkMode");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfNetworkMode = vRMLFieldData.stringValue;
            Integer n2 = (Integer)networkModes.get(this.vfNetworkMode);
            if (n2 == null) {
                throw new InvalidFieldValueException("Invalid networkMode: " + this.vfNetworkMode);
            }
            this.currentMode = n2;
            n = vRMLNodeType.getFieldIndex("address");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfAddress = vRMLFieldData.stringValue;
            n = vRMLNodeType.getFieldIndex("port");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfPort = vRMLFieldData.intValue;
            n = vRMLNodeType.getFieldIndex("detonationResult");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfDetonationResult = vRMLFieldData.intValue;
            n = vRMLNodeType.getFieldIndex("detonationLocation");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfDetonationLocation[0] = vRMLFieldData.floatArrayValue[0];
            this.vfDetonationLocation[1] = vRMLFieldData.floatArrayValue[1];
            this.vfDetonationLocation[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("detonationRelativeLocation");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfDetonationRelativeLocation[0] = vRMLFieldData.floatArrayValue[0];
            this.vfDetonationRelativeLocation[1] = vRMLFieldData.floatArrayValue[1];
            this.vfDetonationRelativeLocation[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("articulationParameterCount");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfArticulationParameterCount = vRMLFieldData.intValue;
            n = vRMLNodeType.getFieldIndex("articulationParameterArray");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfArticulationParameterArray = new float[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.floatArrayValue, 0, this.vfArticulationParameterArray, 0, vRMLFieldData.numElements);
                this.numArticulationParameterArray = vRMLFieldData.numElements;
            }
            n = vRMLNodeType.getFieldIndex("xmppParams");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfXMPPParams = new String[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.stringArrayValue, 0, this.vfXMPPParams, 0, vRMLFieldData.numElements);
                this.setXMPPParams(this.vfXMPPParams, vRMLFieldData.numElements);
            }
            n = vRMLNodeType.getFieldIndex("linearVelocity");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfLinearVelocity[0] = vRMLFieldData.floatArrayValue[0];
            this.vfLinearVelocity[1] = vRMLFieldData.floatArrayValue[1];
            this.vfLinearVelocity[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("linearAcceleration");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfLinearAcceleration[0] = vRMLFieldData.floatArrayValue[0];
            this.vfLinearAcceleration[1] = vRMLFieldData.floatArrayValue[1];
            this.vfLinearAcceleration[2] = vRMLFieldData.floatArrayValue[2];
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public void allEventsComplete() {
        this.updateMatrix();
    }

    public int getPrimaryType() {
        return 75;
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        if (this.pGeoOrigin != null) {
            this.pGeoOrigin.setupFinished();
        } else if (this.vfGeoOrigin != null) {
            this.vfGeoOrigin.setupFinished();
        }
        if (this.vfGeoOrigin != null) {
            try {
                GTTransformUtils gTTransformUtils = GTTransformUtils.getInstance();
                boolean[] blArray = new boolean[1];
                this.geoTransform = gTTransformUtils.createSystemTransform(this.vfGeoSystem, blArray);
                this.geoCoordSwap = blArray[0];
                this.origin = this.vfGeoOrigin.getConvertedCoordRef();
            }
            catch (FactoryException factoryException) {
                this.errorReporter.errorReport(FACTORY_ERR_MSG, (Exception)((Object)factoryException));
            }
        }
        this.regenID();
        this.inSetup = false;
    }

    public String getProtocol() {
        return PROTOCOL;
    }

    public int getRole() {
        return this.currentMode;
    }

    public void addNetworkRoleListener(NetworkRoleListener networkRoleListener) {
        if (!this.roleListeners.contains(networkRoleListener)) {
            this.roleListeners.add(networkRoleListener);
        }
    }

    public void removeNetworkRoleListener(NetworkRoleListener networkRoleListener) {
        this.roleListeners.remove(networkRoleListener);
    }

    public void setVRMLClock(VRMLClock vRMLClock) {
        this.vrmlClock = vRMLClock;
    }

    public void setRotation(float[] fArray) throws InvalidFieldValueException {
        if (fArray == null) {
            throw new InvalidFieldValueException("Rotation value null");
        }
        this.vfRotation[0] = fArray[0];
        this.vfRotation[1] = fArray[1];
        this.vfRotation[2] = fArray[2];
        this.vfRotation[3] = fArray[3];
        if (!this.inSetup) {
            this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
            this.hasChanged[7] = true;
            this.fireFieldChanged(7);
            this.needToWrite = true;
        }
    }

    public float[] getRotation() {
        return this.vfRotation;
    }

    public void setTranslation(float[] fArray) throws InvalidFieldValueException {
        if (fArray == null) {
            throw new InvalidFieldValueException("Translation value null");
        }
        this.vfTranslation[0] = fArray[0];
        this.vfTranslation[1] = fArray[1];
        this.vfTranslation[2] = fArray[2];
        if (this.currentMode == 0 && this.vfGeoOrigin != null) {
            this.vfTranslation[0] = (float)((double)this.vfTranslation[0] - this.origin[0]);
            this.vfTranslation[1] = (float)((double)this.vfTranslation[1] - this.origin[1]);
            this.vfTranslation[2] = (float)((double)this.vfTranslation[2] - this.origin[2]);
        }
        if (!this.inSetup) {
            this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
            this.hasChanged[10] = true;
            this.fireFieldChanged(10);
            this.needToWrite = true;
        }
    }

    public float[] getTranslation() {
        return this.vfTranslation;
    }

    public void setScale(float[] fArray) throws InvalidFieldValueException {
        if (fArray == null) {
            throw new InvalidFieldValueException("Scale value null");
        }
        this.vfScale[0] = fArray[0];
        this.vfScale[1] = fArray[1];
        this.vfScale[2] = fArray[2];
        if (!this.inSetup) {
            this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
            this.hasChanged[8] = true;
            this.fireFieldChanged(8);
        }
    }

    public float[] getScale() {
        return this.vfScale;
    }

    public void setScaleOrientation(float[] fArray) throws InvalidFieldValueException {
        if (fArray == null) {
            throw new InvalidFieldValueException("Scale Orientation value null");
        }
        this.vfScaleOrientation[0] = fArray[0];
        this.vfScaleOrientation[1] = fArray[1];
        this.vfScaleOrientation[2] = fArray[2];
        this.vfScaleOrientation[3] = fArray[3];
        if (!this.inSetup) {
            this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
            this.hasChanged[9] = true;
            this.fireFieldChanged(9);
        }
    }

    public float[] getScaleOrientation() {
        return this.vfScaleOrientation;
    }

    public void setCenter(float[] fArray) throws InvalidFieldValueException {
        if (fArray == null) {
            throw new InvalidFieldValueException("Center value null");
        }
        this.vfCenter[0] = fArray[0];
        this.vfCenter[1] = fArray[1];
        this.vfCenter[2] = fArray[2];
        if (!this.inSetup) {
            this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
            this.hasChanged[6] = true;
            this.fireFieldChanged(6);
        }
    }

    public float[] getCenter() {
        return this.vfCenter;
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? 73 : n;
    }

    public int[] getSecondaryType() {
        return SECONDARY_TYPE;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n == 73) {
            return notimpl_decl;
        }
        if (n < 0 || n > 72) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 60: {
                vRMLFieldData.clear();
                vRMLFieldData.nodeValue = this.pGeoOrigin != null ? this.pGeoOrigin : this.vfGeoOrigin;
                vRMLFieldData.dataType = (short)7;
                break;
            }
            case 6: {
                vRMLFieldData.clear();
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.floatArrayValue = this.vfCenter;
                break;
            }
            case 7: {
                vRMLFieldData.clear();
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.floatArrayValue = this.vfRotation;
                break;
            }
            case 8: {
                vRMLFieldData.clear();
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.floatArrayValue = this.vfScale;
                break;
            }
            case 9: {
                vRMLFieldData.clear();
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.floatArrayValue = this.vfScaleOrientation;
                break;
            }
            case 10: {
                vRMLFieldData.clear();
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.floatArrayValue = this.vfTranslation;
                break;
            }
            case 41: {
                vRMLFieldData.clear();
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.floatArrayValue = this.vfDetonationLocation;
                break;
            }
            case 42: {
                vRMLFieldData.clear();
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.floatArrayValue = this.vfDetonationRelativeLocation;
                break;
            }
            case 11: {
                vRMLFieldData.clear();
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)6;
                vRMLFieldData.stringValue = this.vfMarking;
                break;
            }
            case 12: {
                vRMLFieldData.clear();
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)2;
                vRMLFieldData.intValue = this.vfSiteID;
                break;
            }
            case 14: {
                vRMLFieldData.clear();
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)2;
                vRMLFieldData.intValue = this.vfEntityID;
                break;
            }
            case 71: {
                vRMLFieldData.clear();
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)2;
                vRMLFieldData.intValue = this.vfForceID;
                break;
            }
            case 61: {
                vRMLFieldData.clear();
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)2;
                vRMLFieldData.intValue = this.vfEntityCategory;
                break;
            }
            case 68: {
                vRMLFieldData.clear();
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)2;
                vRMLFieldData.intValue = this.vfAppearance;
                break;
            }
            case 66: {
                vRMLFieldData.clear();
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)2;
                vRMLFieldData.intValue = this.vfEntityCountry;
                break;
            }
            case 62: {
                vRMLFieldData.clear();
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)2;
                vRMLFieldData.intValue = this.vfEntityDomain;
                break;
            }
            case 63: {
                vRMLFieldData.clear();
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)2;
                vRMLFieldData.intValue = this.vfEntityExtra;
                break;
            }
            case 64: {
                vRMLFieldData.clear();
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)2;
                vRMLFieldData.intValue = this.vfEntityKind;
                break;
            }
            case 65: {
                vRMLFieldData.clear();
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)2;
                vRMLFieldData.intValue = this.vfEntitySpecific;
                break;
            }
            case 67: {
                vRMLFieldData.clear();
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)2;
                vRMLFieldData.intValue = this.vfEntitySubCategory;
                break;
            }
            case 15: {
                vRMLFieldData.clear();
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)5;
                vRMLFieldData.doubleValue = this.vfReadInterval;
                break;
            }
            case 16: {
                vRMLFieldData.clear();
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)5;
                vRMLFieldData.doubleValue = this.vfWriteInterval;
                break;
            }
            case 17: {
                vRMLFieldData.clear();
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)6;
                vRMLFieldData.stringValue = this.vfNetworkMode;
                break;
            }
            case 59: {
                vRMLFieldData.clear();
                vRMLFieldData.stringArrayValue = this.vfGeoSystem;
                vRMLFieldData.dataType = (short)14;
                vRMLFieldData.numElements = this.vfGeoSystem.length;
                break;
            }
            case 13: {
                vRMLFieldData.clear();
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)2;
                vRMLFieldData.intValue = this.vfApplicationID;
                break;
            }
            case 19: {
                vRMLFieldData.clear();
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)2;
                vRMLFieldData.intValue = this.vfPort;
                break;
            }
            case 40: {
                vRMLFieldData.clear();
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)2;
                vRMLFieldData.intValue = this.vfDetonationResult;
                break;
            }
            case 18: {
                vRMLFieldData.clear();
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)6;
                vRMLFieldData.stringValue = this.vfAddress;
                break;
            }
            case 45: {
                vRMLFieldData.clear();
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)2;
                vRMLFieldData.intValue = this.vfEventApplicationID;
                break;
            }
            case 46: {
                vRMLFieldData.clear();
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)2;
                vRMLFieldData.intValue = this.vfEventEntityID;
                break;
            }
            case 47: {
                vRMLFieldData.clear();
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)2;
                vRMLFieldData.intValue = this.vfEventSiteID;
                break;
            }
            case 50: {
                vRMLFieldData.clear();
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)2;
                vRMLFieldData.intValue = this.vfFireMissionIndex;
                break;
            }
            case 53: {
                vRMLFieldData.clear();
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)2;
                vRMLFieldData.intValue = this.vfMunitionApplicationID;
                break;
            }
            case 55: {
                vRMLFieldData.clear();
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)2;
                vRMLFieldData.intValue = this.vfMunitionEntityID;
                break;
            }
            case 56: {
                vRMLFieldData.clear();
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)2;
                vRMLFieldData.intValue = this.vfMunitionSiteID;
                break;
            }
            case 54: {
                vRMLFieldData.clear();
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.floatArrayValue = this.vfMunitionEndPoint;
                break;
            }
            case 57: {
                vRMLFieldData.clear();
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.floatArrayValue = this.vfMunitionStartPoint;
                break;
            }
            case 58: {
                vRMLFieldData.clear();
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)5;
                vRMLFieldData.doubleValue = this.vfFiredTime;
                break;
            }
            case 48: {
                vRMLFieldData.clear();
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = 1;
                vRMLFieldData.booleanValue = this.vfFired1;
                break;
            }
            case 49: {
                vRMLFieldData.clear();
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = 1;
                vRMLFieldData.booleanValue = this.vfFired2;
                break;
            }
            case 51: {
                vRMLFieldData.clear();
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)4;
                vRMLFieldData.floatValue = this.vfFiringRange;
                break;
            }
            case 52: {
                vRMLFieldData.clear();
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)2;
                vRMLFieldData.intValue = this.vfFiringRate;
                break;
            }
            case 43: {
                vRMLFieldData.clear();
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = 1;
                vRMLFieldData.booleanValue = this.vfIsDetonated;
                break;
            }
            case 44: {
                vRMLFieldData.clear();
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)5;
                vRMLFieldData.doubleValue = this.vfDetonateTime;
                break;
            }
            case 30: {
                vRMLFieldData.clear();
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = 1;
                vRMLFieldData.booleanValue = this.vfIsActive;
                break;
            }
            case 39: {
                vRMLFieldData.clear();
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)5;
                vRMLFieldData.doubleValue = this.vfTimestamp;
                break;
            }
            case 20: {
                vRMLFieldData.clear();
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)2;
                vRMLFieldData.intValue = this.vfArticulationParameterCount;
                break;
            }
            case 21: {
                vRMLFieldData.floatArrayValue = this.vfArticulationParameterArray;
                vRMLFieldData.numElements = this.numArticulationParameterArray;
                break;
            }
            case 22: {
                vRMLFieldData.clear();
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.floatValue = this.vfArticulationParameterValue0;
                break;
            }
            case 23: {
                vRMLFieldData.clear();
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.floatValue = this.vfArticulationParameterValue1;
                break;
            }
            case 24: {
                vRMLFieldData.clear();
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.floatValue = this.vfArticulationParameterValue2;
                break;
            }
            case 25: {
                vRMLFieldData.clear();
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.floatValue = this.vfArticulationParameterValue3;
                break;
            }
            case 26: {
                vRMLFieldData.clear();
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.floatValue = this.vfArticulationParameterValue4;
                break;
            }
            case 27: {
                vRMLFieldData.clear();
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.floatValue = this.vfArticulationParameterValue5;
                break;
            }
            case 28: {
                vRMLFieldData.clear();
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.floatValue = this.vfArticulationParameterValue6;
                break;
            }
            case 29: {
                vRMLFieldData.clear();
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.floatValue = this.vfArticulationParameterValue7;
                break;
            }
            case 72: {
                vRMLFieldData.clear();
                vRMLFieldData.stringArrayValue = this.vfXMPPParams;
                vRMLFieldData.dataType = (short)14;
                vRMLFieldData.numElements = this.vfXMPPParams.length;
                break;
            }
            case 69: {
                vRMLFieldData.clear();
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.floatArrayValue = this.vfLinearVelocity;
                break;
            }
            case 70: {
                vRMLFieldData.clear();
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.floatArrayValue = this.vfLinearAcceleration;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 6: {
                    vRMLNodeType.setValue(n2, this.vfCenter, 3);
                    break;
                }
                case 7: {
                    vRMLNodeType.setValue(n2, this.vfRotation, 4);
                    break;
                }
                case 8: {
                    vRMLNodeType.setValue(n2, this.vfScale, 3);
                    break;
                }
                case 9: {
                    vRMLNodeType.setValue(n2, this.vfScaleOrientation, 4);
                    break;
                }
                case 10: {
                    vRMLNodeType.setValue(n2, this.vfTranslation, 3);
                    break;
                }
                case 59: {
                    vRMLNodeType.setValue(n2, this.vfGeoSystem, this.vfGeoSystem.length);
                    break;
                }
                case 45: {
                    vRMLNodeType.setValue(n2, this.vfEventApplicationID);
                    break;
                }
                case 46: {
                    vRMLNodeType.setValue(n2, this.vfEventEntityID);
                    break;
                }
                case 61: {
                    vRMLNodeType.setValue(n2, this.vfEntityCategory);
                    break;
                }
                case 62: {
                    vRMLNodeType.setValue(n2, this.vfEntityDomain);
                    break;
                }
                case 68: {
                    vRMLNodeType.setValue(n2, this.vfAppearance);
                    break;
                }
                case 66: {
                    vRMLNodeType.setValue(n2, this.vfEntityCountry);
                    break;
                }
                case 67: {
                    vRMLNodeType.setValue(n2, this.vfEntitySubCategory);
                    break;
                }
                case 65: {
                    vRMLNodeType.setValue(n2, this.vfEntitySpecific);
                    break;
                }
                case 64: {
                    vRMLNodeType.setValue(n2, this.vfEntityKind);
                    break;
                }
                case 63: {
                    vRMLNodeType.setValue(n2, this.vfEntityExtra);
                    break;
                }
                case 47: {
                    vRMLNodeType.setValue(n2, this.vfEventSiteID);
                    break;
                }
                case 50: {
                    vRMLNodeType.setValue(n2, this.vfFireMissionIndex);
                    break;
                }
                case 52: {
                    vRMLNodeType.setValue(n2, this.vfFiringRate);
                    break;
                }
                case 53: {
                    vRMLNodeType.setValue(n2, this.vfMunitionApplicationID);
                    break;
                }
                case 56: {
                    vRMLNodeType.setValue(n2, this.vfMunitionSiteID);
                    break;
                }
                case 55: {
                    vRMLNodeType.setValue(n2, this.vfMunitionEntityID);
                    break;
                }
                case 57: {
                    vRMLNodeType.setValue(n2, this.vfMunitionStartPoint, 3);
                    break;
                }
                case 54: {
                    vRMLNodeType.setValue(n2, this.vfMunitionEndPoint, 3);
                    break;
                }
                case 58: {
                    vRMLNodeType.setValue(n2, this.vfFiredTime);
                    break;
                }
                case 48: {
                    vRMLNodeType.setValue(n2, this.vfFired1);
                    break;
                }
                case 49: {
                    vRMLNodeType.setValue(n2, this.vfFired2);
                    break;
                }
                case 51: {
                    vRMLNodeType.setValue(n2, this.vfFiringRange);
                    break;
                }
                case 41: {
                    vRMLNodeType.setValue(n2, this.vfDetonationLocation, 3);
                    break;
                }
                case 42: {
                    vRMLNodeType.setValue(n2, this.vfDetonationRelativeLocation, 3);
                    break;
                }
                case 11: {
                    vRMLNodeType.setValue(n2, this.vfMarking);
                    break;
                }
                case 12: {
                    vRMLNodeType.setValue(n2, this.vfSiteID);
                    break;
                }
                case 43: {
                    vRMLNodeType.setValue(n2, this.vfIsDetonated);
                    break;
                }
                case 44: {
                    vRMLNodeType.setValue(n2, this.vfDetonateTime);
                    break;
                }
                case 30: {
                    vRMLNodeType.setValue(n2, this.vfIsActive);
                    break;
                }
                case 39: {
                    vRMLNodeType.setValue(n2, this.vfTimestamp);
                    break;
                }
                case 14: {
                    vRMLNodeType.setValue(n2, this.vfEntityID);
                    break;
                }
                case 71: {
                    vRMLNodeType.setValue(n2, this.vfForceID);
                    break;
                }
                case 15: {
                    vRMLNodeType.setValue(n2, this.vfReadInterval);
                    break;
                }
                case 16: {
                    vRMLNodeType.setValue(n2, this.vfWriteInterval);
                    break;
                }
                case 17: {
                    vRMLNodeType.setValue(n2, this.vfNetworkMode);
                    break;
                }
                case 19: {
                    vRMLNodeType.setValue(n2, this.vfPort);
                    break;
                }
                case 40: {
                    vRMLNodeType.setValue(n2, this.vfDetonationResult);
                    break;
                }
                case 18: {
                    vRMLNodeType.setValue(n2, this.vfAddress);
                    break;
                }
                case 20: {
                    vRMLNodeType.setValue(n2, this.vfArticulationParameterCount);
                    break;
                }
                case 21: {
                    vRMLNodeType.setValue(n2, this.vfArticulationParameterArray, this.numArticulationParameterArray);
                    break;
                }
                case 22: {
                    vRMLNodeType.setValue(n2, this.vfArticulationParameterValue0);
                    break;
                }
                case 23: {
                    vRMLNodeType.setValue(n2, this.vfArticulationParameterValue1);
                    break;
                }
                case 24: {
                    vRMLNodeType.setValue(n2, this.vfArticulationParameterValue2);
                    break;
                }
                case 25: {
                    vRMLNodeType.setValue(n2, this.vfArticulationParameterValue3);
                    break;
                }
                case 26: {
                    vRMLNodeType.setValue(n2, this.vfArticulationParameterValue4);
                    break;
                }
                case 27: {
                    vRMLNodeType.setValue(n2, this.vfArticulationParameterValue5);
                    break;
                }
                case 28: {
                    vRMLNodeType.setValue(n2, this.vfArticulationParameterValue6);
                    break;
                }
                case 29: {
                    vRMLNodeType.setValue(n2, this.vfArticulationParameterValue7);
                    break;
                }
                case 69: {
                    vRMLNodeType.setValue(n2, this.vfLinearVelocity, 3);
                    break;
                }
                case 70: {
                    vRMLNodeType.setValue(n2, this.vfLinearAcceleration, 3);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("BaseTransform.sendRoute: No field!" + n);
            invalidFieldException.printStackTrace();
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid fieldValue: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, String[] stringArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 59: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: geoSystem");
                }
                if (this.vfGeoSystem.length != n2) {
                    this.vfGeoSystem = new String[n2];
                }
                for (int i = 0; i < n2; ++i) {
                    this.vfGeoSystem[i] = stringArray[i];
                }
                break;
            }
            case 72: {
                if (this.vfXMPPParams.length != n2) {
                    this.vfXMPPParams = new String[n2];
                }
                for (int i = 0; i < n2; ++i) {
                    this.vfXMPPParams[i] = stringArray[i];
                }
                this.setXMPPParams(stringArray, n2);
                break;
            }
            default: {
                super.setValue(n, stringArray, n2);
            }
        }
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldException, InvalidFieldValueException {
        VRMLNodeType vRMLNodeType2 = vRMLNodeType;
        switch (n) {
            case 60: {
                this.setGeoOrigin(vRMLNodeType);
                break;
            }
            default: {
                super.setValue(n, vRMLNodeType);
            }
        }
    }

    public void setValue(int n, boolean bl) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 48: {
                this.vfFired1 = bl;
                if (this.inSetup) break;
                this.hasChanged[48] = true;
                this.fireFieldChanged(48);
                break;
            }
            case 49: {
                this.vfFired2 = bl;
                if (this.inSetup) break;
                this.hasChanged[49] = true;
                this.fireFieldChanged(49);
                break;
            }
            case 43: {
                this.vfIsDetonated = bl;
                if (this.inSetup) break;
                this.hasChanged[43] = true;
                this.fireFieldChanged(43);
                break;
            }
            default: {
                super.setValue(n, bl);
            }
        }
    }

    public void setValue(int n, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 12: {
                this.vfSiteID = n2;
                if (this.inSetup) break;
                this.regenID();
                this.hasChanged[12] = true;
                this.fireFieldChanged(12);
                break;
            }
            case 13: {
                this.vfApplicationID = n2;
                if (this.inSetup) break;
                this.regenID();
                this.hasChanged[13] = true;
                this.fireFieldChanged(13);
                break;
            }
            case 14: {
                this.vfEntityID = n2;
                if (this.inSetup) break;
                this.regenID();
                this.hasChanged[14] = true;
                this.fireFieldChanged(14);
                break;
            }
            case 71: {
                this.vfForceID = n2;
                if (this.inSetup) break;
                this.hasChanged[71] = true;
                this.fireFieldChanged(71);
                break;
            }
            case 61: {
                this.vfEntityCategory = n2;
                if (this.inSetup) break;
                this.regenID();
                this.hasChanged[61] = true;
                this.fireFieldChanged(61);
                break;
            }
            case 68: {
                this.vfAppearance = n2;
                if (this.inSetup) break;
                this.regenID();
                this.hasChanged[68] = true;
                this.fireFieldChanged(68);
                break;
            }
            case 66: {
                this.vfEntityCountry = n2;
                if (this.inSetup) break;
                this.regenID();
                this.hasChanged[66] = true;
                this.fireFieldChanged(66);
                break;
            }
            case 67: {
                this.vfEntitySubCategory = n2;
                if (this.inSetup) break;
                this.regenID();
                this.hasChanged[67] = true;
                this.fireFieldChanged(67);
                break;
            }
            case 62: {
                this.vfEntityDomain = n2;
                if (this.inSetup) break;
                this.regenID();
                this.hasChanged[62] = true;
                this.fireFieldChanged(62);
                break;
            }
            case 64: {
                this.vfEntityKind = n2;
                if (this.inSetup) break;
                this.regenID();
                this.hasChanged[64] = true;
                this.fireFieldChanged(64);
                break;
            }
            case 63: {
                this.vfEntityExtra = n2;
                if (this.inSetup) break;
                this.regenID();
                this.hasChanged[63] = true;
                this.fireFieldChanged(63);
                break;
            }
            case 65: {
                this.vfEntitySpecific = n2;
                if (this.inSetup) break;
                this.regenID();
                this.hasChanged[65] = true;
                this.fireFieldChanged(65);
                break;
            }
            case 19: {
                this.vfPort = n2;
                if (this.inSetup) break;
                this.hasChanged[19] = true;
                this.fireFieldChanged(19);
                break;
            }
            case 45: {
                this.vfEventApplicationID = n2;
                if (this.inSetup) break;
                this.hasChanged[45] = true;
                this.fireFieldChanged(45);
                break;
            }
            case 46: {
                this.vfEventEntityID = n2;
                if (this.inSetup) break;
                this.hasChanged[46] = true;
                this.fireFieldChanged(46);
                break;
            }
            case 47: {
                this.vfEventSiteID = n2;
                if (this.inSetup) break;
                this.hasChanged[47] = true;
                this.fireFieldChanged(47);
                break;
            }
            case 50: {
                this.vfFireMissionIndex = n2;
                if (this.inSetup) break;
                this.hasChanged[50] = true;
                this.fireFieldChanged(50);
                break;
            }
            case 52: {
                this.vfFiringRate = n2;
                if (this.inSetup) break;
                this.hasChanged[52] = true;
                this.fireFieldChanged(52);
                break;
            }
            case 53: {
                this.vfMunitionApplicationID = n2;
                if (this.inSetup) break;
                this.hasChanged[53] = true;
                this.fireFieldChanged(53);
                break;
            }
            case 55: {
                this.vfMunitionEntityID = n2;
                if (this.inSetup) break;
                this.hasChanged[55] = true;
                this.fireFieldChanged(55);
                break;
            }
            case 56: {
                this.vfMunitionSiteID = n2;
                if (this.inSetup) break;
                this.hasChanged[56] = true;
                this.fireFieldChanged(56);
                break;
            }
            case 40: {
                this.vfDetonationResult = n2;
                if (this.inSetup) break;
                this.hasChanged[40] = true;
                this.fireFieldChanged(40);
                break;
            }
            case 20: {
                this.vfArticulationParameterCount = n2;
                if (this.artVals.length < n2) {
                    this.artVals = new ArticulationParameter[n2];
                    this.vfArticulationParameterArray = new float[n2];
                }
                for (int i = 0; i < n2; ++i) {
                    this.artVals[i] = new ArticulationParameter();
                }
                this.numArticulationParameterArray = n2;
                if (this.inSetup) break;
                this.needToWrite = true;
                this.hasChanged[20] = true;
                this.fireFieldChanged(20);
                break;
            }
            default: {
                super.setValue(n, n2);
            }
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 6: {
                this.setCenter(fArray);
                break;
            }
            case 7: {
                this.setRotation(fArray);
                break;
            }
            case 8: {
                this.setScale(fArray);
                break;
            }
            case 9: {
                this.setScaleOrientation(fArray);
                break;
            }
            case 10: {
                this.setTranslation(fArray);
                break;
            }
            case 57: {
                this.vfMunitionStartPoint[0] = fArray[0];
                this.vfMunitionStartPoint[1] = fArray[1];
                this.vfMunitionStartPoint[2] = fArray[2];
                if (this.inSetup) break;
                this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
                this.hasChanged[57] = true;
                this.fireFieldChanged(57);
                this.needToWrite = true;
                break;
            }
            case 54: {
                this.vfMunitionEndPoint[0] = fArray[0];
                this.vfMunitionEndPoint[1] = fArray[1];
                this.vfMunitionEndPoint[2] = fArray[2];
                if (this.inSetup) break;
                this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
                this.hasChanged[54] = true;
                this.fireFieldChanged(54);
                this.needToWrite = true;
                break;
            }
            case 42: {
                this.vfDetonationRelativeLocation[0] = fArray[0];
                this.vfDetonationRelativeLocation[1] = fArray[1];
                this.vfDetonationRelativeLocation[2] = fArray[2];
                if (this.inSetup) break;
                this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
                this.hasChanged[42] = true;
                this.fireFieldChanged(42);
                this.needToWrite = true;
                break;
            }
            case 41: {
                this.vfDetonationLocation[0] = fArray[0];
                this.vfDetonationLocation[1] = fArray[1];
                this.vfDetonationLocation[2] = fArray[2];
                if (this.inSetup) break;
                this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
                this.hasChanged[41] = true;
                this.fireFieldChanged(41);
                this.needToWrite = true;
                break;
            }
            case 21: {
                if (n2 > this.vfArticulationParameterArray.length) {
                    this.vfArticulationParameterArray = new float[n2];
                }
                System.arraycopy(this.vfArticulationParameterArray, 0, fArray, 0, n2);
                this.numArticulationParameterArray = n2;
                if (this.inSetup) break;
                this.needToWrite = true;
                this.hasChanged[21] = true;
                this.fireFieldChanged(21);
                break;
            }
            case 69: {
                this.vfLinearVelocity[0] = fArray[0];
                this.vfLinearVelocity[1] = fArray[1];
                this.vfLinearVelocity[2] = fArray[2];
                if (this.inSetup) break;
                this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
                this.hasChanged[69] = true;
                this.fireFieldChanged(69);
                this.needToWrite = true;
                break;
            }
            case 70: {
                this.vfLinearAcceleration[0] = fArray[0];
                this.vfLinearAcceleration[1] = fArray[1];
                this.vfLinearAcceleration[2] = fArray[2];
                if (this.inSetup) break;
                this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
                this.hasChanged[70] = true;
                this.fireFieldChanged(70);
                this.needToWrite = true;
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }

    public void setValue(int n, float f) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 51: {
                this.vfFiringRange = f;
                if (this.inSetup) break;
                this.needToWrite = true;
                this.hasChanged[51] = true;
                this.fireFieldChanged(51);
                break;
            }
            case 31: {
                this.resizeAPA(1);
                this.vfArticulationParameterArray[0] = f;
                this.vfArticulationParameterValue0 = f;
                if (this.inSetup) break;
                this.needToWrite = true;
                this.hasChanged[22] = true;
                this.fireFieldChanged(22);
                break;
            }
            case 32: {
                this.resizeAPA(2);
                this.vfArticulationParameterArray[1] = f;
                this.vfArticulationParameterValue1 = f;
                if (this.inSetup) break;
                this.needToWrite = true;
                this.hasChanged[32] = true;
                this.fireFieldChanged(32);
                break;
            }
            case 33: {
                this.resizeAPA(3);
                this.vfArticulationParameterArray[2] = f;
                this.vfArticulationParameterValue2 = f;
                if (this.inSetup) break;
                this.needToWrite = true;
                this.hasChanged[33] = true;
                this.fireFieldChanged(33);
                break;
            }
            case 34: {
                this.resizeAPA(4);
                this.vfArticulationParameterArray[3] = f;
                this.vfArticulationParameterValue3 = f;
                if (this.inSetup) break;
                this.needToWrite = true;
                this.hasChanged[34] = true;
                this.fireFieldChanged(34);
                break;
            }
            case 35: {
                this.resizeAPA(5);
                this.vfArticulationParameterArray[4] = f;
                this.vfArticulationParameterValue4 = f;
                if (this.inSetup) break;
                this.needToWrite = true;
                this.hasChanged[35] = true;
                this.fireFieldChanged(35);
                break;
            }
            case 36: {
                this.resizeAPA(6);
                this.vfArticulationParameterArray[5] = f;
                this.vfArticulationParameterValue5 = f;
                if (this.inSetup) break;
                this.needToWrite = true;
                this.hasChanged[36] = true;
                this.fireFieldChanged(36);
                break;
            }
            case 37: {
                this.resizeAPA(7);
                this.vfArticulationParameterArray[6] = f;
                this.vfArticulationParameterValue6 = f;
                if (this.inSetup) break;
                this.needToWrite = true;
                this.hasChanged[37] = true;
                this.fireFieldChanged(37);
                break;
            }
            case 38: {
                this.resizeAPA(8);
                if (this.inSetup) break;
                this.needToWrite = true;
                this.hasChanged[38] = true;
                this.fireFieldChanged(38);
                break;
            }
            default: {
                super.setValue(n, f);
            }
        }
    }

    public void setValue(int n, double d) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 58: {
                this.vfFiredTime = d;
                if (this.inSetup) break;
                this.hasChanged[58] = true;
                this.fireFieldChanged(58);
                break;
            }
            case 44: {
                this.vfDetonateTime = d;
                if (this.inSetup) break;
                this.hasChanged[44] = true;
                this.fireFieldChanged(44);
                break;
            }
            case 15: {
                this.vfReadInterval = d;
                if (this.inSetup) break;
                this.hasChanged[15] = true;
                this.fireFieldChanged(15);
                break;
            }
            case 16: {
                this.vfWriteInterval = d;
                if (this.inSetup) break;
                this.hasChanged[16] = true;
                this.fireFieldChanged(16);
                break;
            }
            default: {
                super.setValue(n, d);
            }
        }
    }

    public void setValue(int n, String string) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 11: {
                this.vfMarking = string;
                if (this.inSetup) break;
                this.hasChanged[11] = true;
                this.fireFieldChanged(11);
                break;
            }
            case 17: {
                if (this.vfNetworkMode.equals(string)) {
                    return;
                }
                this.vfNetworkMode = string;
                Integer n2 = (Integer)networkModes.get(this.vfNetworkMode);
                if (n2 == null) {
                    throw new InvalidFieldValueException("Invalid networkMode: " + string);
                }
                this.currentMode = n2;
                if (this.inSetup) break;
                this.hasChanged[17] = true;
                this.fireFieldChanged(17);
                this.fireRoleChanged();
                break;
            }
            case 18: {
                this.vfAddress = string;
                if (this.inSetup) break;
                this.hasChanged[18] = true;
                this.fireFieldChanged(18);
                break;
            }
            case 73: {
                break;
            }
            default: {
                super.setValue(n, string);
            }
        }
    }

    public int getSiteID() {
        return this.vfSiteID;
    }

    public int getAppID() {
        return this.vfApplicationID;
    }

    public int getEntityID() {
        return this.vfEntityID;
    }

    public String getAddress() {
        return this.vfAddress;
    }

    public int getPort() {
        return this.vfPort;
    }

    public String getUsername() {
        return this.xmppUsername;
    }

    public String getPassword() {
        return this.xmppPassword;
    }

    public String[] getAuthServer() {
        return this.xmppAuthServer;
    }

    public String getMucServer() {
        return this.xmppMucServer;
    }

    public String getMucRoom() {
        return this.xmppMucRoom;
    }

    public void setIsActive(boolean bl) {
        this.vfIsActive = bl;
        if (!this.inSetup) {
            this.hasChanged[30] = true;
            this.fireFieldChanged(30);
        }
    }

    public boolean valuesToWrite() {
        if (!this.needToWrite || this.currentMode == 0) {
            return false;
        }
        double d = this.vrmlClock.getTime();
        return d - this.lastWrite > this.vfWriteInterval;
    }

    public ProtocolDataUnitType getStateDX() {
        if (this.espduDX == null) {
            return null;
        }
        this.espduDX.setEntityID(this.idDX);
        for (int i = 0; i < this.vfArticulationParameterCount; ++i) {
            this.artVals[i].setParameterValue((double)this.vfArticulationParameterArray[i]);
            this.espdu.addArticulationParameter(this.artVals[i]);
        }
        this.v3d.setX((double)this.vfTranslation[0]);
        this.v3d.setY((double)this.vfTranslation[2]);
        this.v3d.setZ((double)(-this.vfTranslation[1]));
        this.espduDX.setEntityLocation(this.v3d);
        this.aa.x = this.vfRotation[0];
        this.aa.y = this.vfRotation[1];
        this.aa.z = this.vfRotation[2];
        this.aa.angle = this.vfRotation[3];
        this.rotationQuat.set(this.aa);
        this.rotationQuat.normalize();
        this.set(this.rotationQuat);
        this.eat.setPhi((float)this.roll);
        this.eat.setTheta((float)this.pitch);
        this.eat.setPsi((float)(-this.yaw));
        this.espduDX.setEntityOrientation(this.eat);
        this.scrLinearVelo.setX(this.vfLinearVelocity[0]);
        this.scrLinearVelo.setY(this.vfLinearVelocity[2]);
        this.scrLinearVelo.setZ(-this.vfLinearVelocity[1]);
        this.espduDX.setEntityLinearVelocity(this.scrLinearVelo);
        DeadReckoningParametersType deadReckoningParametersType = this.espduDX.getDeadReckoningParameters();
        this.scrLinearAccel.setX(this.vfLinearAcceleration[0]);
        this.scrLinearAccel.setY(this.vfLinearAcceleration[2]);
        this.scrLinearAccel.setZ(-this.vfLinearAcceleration[1]);
        deadReckoningParametersType.setEntityLinearAcceleration(this.scrLinearAccel);
        HeaderType headerType = this.espduDX.getPduHeader();
        long l = System.currentTimeMillis();
        headerType.setTimestamp((long)((int)(l - simStartTime)));
        this.lastWrite = this.vrmlClock.getTime();
        this.needToWrite = false;
        return this.espduDX;
    }

    public ProtocolDataUnit getState() {
        this.espdu.reset();
        this.espdu.setEntityID(this.id);
        for (int i = 0; i < this.vfArticulationParameterCount; ++i) {
            this.artVals[i].setParameterValue((double)this.vfArticulationParameterArray[i]);
            this.espdu.addArticulationParameter(this.artVals[i]);
        }
        this.espdu.setEntityLocationX((double)this.vfTranslation[0]);
        this.espdu.setEntityLocationY((double)this.vfTranslation[2]);
        this.espdu.setEntityLocationZ((double)(-this.vfTranslation[1]));
        this.aa.x = this.vfRotation[0];
        this.aa.y = this.vfRotation[1];
        this.aa.z = this.vfRotation[2];
        this.aa.angle = this.vfRotation[3];
        this.rotationQuat.set(this.aa);
        this.rotationQuat.normalize();
        this.set(this.rotationQuat);
        this.espdu.setEntityOrientationPhi((float)this.roll);
        this.espdu.setEntityOrientationTheta((float)this.pitch);
        this.espdu.setEntityOrientationPsi((float)(-this.yaw));
        this.espdu.setEntityLinearVelocityX(this.vfLinearVelocity[0]);
        this.espdu.setEntityLinearVelocityY(this.vfLinearVelocity[2]);
        this.espdu.setEntityLinearVelocityZ(-this.vfLinearVelocity[1]);
        this.espdu.setEntityLinearAccelerationX(this.vfLinearAcceleration[0]);
        this.espdu.setEntityLinearAccelerationY(this.vfLinearAcceleration[2]);
        this.espdu.setEntityLinearAccelerationZ(-this.vfLinearAcceleration[1]);
        this.espdu.makeTimestampCurrent();
        this.lastWrite = this.vrmlClock.getTime();
        this.needToWrite = false;
        return this.espdu;
    }

    public void packetArrived(ProtocolDataUnit protocolDataUnit) {
        int n = protocolDataUnit.getPduTypeValue();
        switch (n) {
            case 2: 
            case 143: {
                FirePdu firePdu = (FirePdu)protocolDataUnit;
                this.vfFired1 = true;
                this.hasChanged[48] = true;
                this.fireFieldChanged(48);
                this.vfFired2 = false;
                this.hasChanged[49] = true;
                this.fireFieldChanged(49);
                this.vfFiredTime = this.vrmlClock.getTime();
                this.hasChanged[58] = true;
                this.fireFieldChanged(58);
                this.vfEventApplicationID = firePdu.getEventID().getApplicationID().intValue();
                this.hasChanged[45] = true;
                this.fireFieldChanged(45);
                this.vfEventEntityID = firePdu.getEventID().getEventID().intValue();
                this.hasChanged[46] = true;
                this.fireFieldChanged(46);
                this.vfEventSiteID = firePdu.getEventID().getSiteID().intValue();
                this.hasChanged[47] = true;
                this.fireFieldChanged(47);
                this.vfMunitionApplicationID = firePdu.getMunitionID().getApplicationID().intValue();
                this.hasChanged[53] = true;
                this.fireFieldChanged(53);
                this.vfMunitionEntityID = firePdu.getMunitionID().getEntityID().intValue();
                this.hasChanged[55] = true;
                this.fireFieldChanged(55);
                this.vfMunitionSiteID = firePdu.getMunitionID().getSiteID().intValue();
                this.hasChanged[56] = true;
                this.fireFieldChanged(56);
                this.vfFireMissionIndex = firePdu.getFireMissionIndex().intValue();
                this.hasChanged[50] = true;
                this.fireFieldChanged(50);
                this.vfFiringRate = firePdu.getBurstDescriptor().getRate().intValue();
                this.hasChanged[52] = true;
                this.fireFieldChanged(52);
                this.vfFiringRange = firePdu.getRange();
                this.hasChanged[51] = true;
                this.fireFieldChanged(51);
                this.vfMunitionStartPoint[0] = (float)firePdu.getLocationInWorldCoordinate().getX();
                this.vfMunitionStartPoint[1] = -((float)firePdu.getLocationInWorldCoordinate().getZ());
                this.vfMunitionStartPoint[2] = (float)firePdu.getLocationInWorldCoordinate().getY();
                this.hasChanged[57] = true;
                this.fireFieldChanged(57);
                this.calculateMunitionEndPoint(firePdu.getVelocity());
                this.hasChanged[54] = true;
                this.fireFieldChanged(54);
                break;
            }
            case 3: 
            case 144: {
                DetonationPdu detonationPdu = (DetonationPdu)protocolDataUnit;
                this.vfIsDetonated = true;
                this.hasChanged[43] = true;
                this.fireFieldChanged(43);
                this.vfDetonateTime = this.vrmlClock.getTime();
                this.hasChanged[44] = true;
                this.fireFieldChanged(44);
                this.vfDetonationResult = detonationPdu.getDetonationResult().intValue();
                this.hasChanged[40] = true;
                this.fireFieldChanged(40);
                this.vfDetonationRelativeLocation[0] = detonationPdu.getLocationInEntityCoordinates().getX();
                this.vfDetonationRelativeLocation[1] = -detonationPdu.getLocationInEntityCoordinates().getZ();
                this.vfDetonationRelativeLocation[2] = detonationPdu.getLocationInEntityCoordinates().getY();
                this.hasChanged[42] = true;
                this.fireFieldChanged(42);
                this.vfDetonationLocation[0] = (float)detonationPdu.getLocationInWorldCoordinate().getX();
                this.vfDetonationLocation[1] = -((float)detonationPdu.getLocationInWorldCoordinate().getZ());
                this.vfDetonationLocation[2] = (float)detonationPdu.getLocationInWorldCoordinate().getY();
                this.hasChanged[41] = true;
                this.fireFieldChanged(41);
                break;
            }
            case 1: {
                EntityStatePdu entityStatePdu = (EntityStatePdu)protocolDataUnit;
                if (!this.ignoreEspdu) {
                    this.vfTranslation[0] = (float)entityStatePdu.getEntityLocationX();
                    this.vfTranslation[1] = -((float)entityStatePdu.getEntityLocationZ());
                    this.vfTranslation[2] = (float)entityStatePdu.getEntityLocationY();
                    if (this.currentMode == 0 && this.vfGeoOrigin != null) {
                        this.vfTranslation[0] = (float)((double)this.vfTranslation[0] - this.origin[0]);
                        this.vfTranslation[1] = (float)((double)this.vfTranslation[1] - this.origin[1]);
                        this.vfTranslation[2] = (float)((double)this.vfTranslation[2] - this.origin[2]);
                    }
                    this.hasChanged[10] = true;
                    this.fireFieldChanged(10);
                    float f = entityStatePdu.getEntityOrientationPhi();
                    float f2 = entityStatePdu.getEntityOrientationTheta();
                    float f3 = entityStatePdu.getEntityOrientationPsi();
                    float[] fArray = new float[]{-f3, f, f2};
                    this.quaternion.setEulers(fArray);
                    this.quaternion.getAxisAngle(this.vfRotation);
                    this.hasChanged[7] = true;
                    this.fireFieldChanged(7);
                    this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
                }
                this.vfEntityCategory = entityStatePdu.getEntityTypeCategory().intValue();
                this.hasChanged[61] = true;
                this.fireFieldChanged(61);
                this.vfEntityDomain = entityStatePdu.getEntityTypeDomain().intValue();
                this.hasChanged[62] = true;
                this.fireFieldChanged(62);
                this.vfEntityKind = entityStatePdu.getEntityTypeKind().intValue();
                this.hasChanged[64] = true;
                this.fireFieldChanged(64);
                this.vfForceID = entityStatePdu.getForceID().intValue();
                this.hasChanged[71] = true;
                this.fireFieldChanged(71);
                this.vfEntitySubCategory = entityStatePdu.getEntityTypeSubcategory().intValue();
                this.hasChanged[67] = true;
                this.fireFieldChanged(67);
                this.vfEntityExtra = entityStatePdu.getEntityTypeExtra().intValue();
                this.hasChanged[63] = true;
                this.fireFieldChanged(63);
                this.vfEntitySpecific = entityStatePdu.getEntityTypeSpecific().intValue();
                this.hasChanged[65] = true;
                this.fireFieldChanged(65);
                this.vfAppearance = entityStatePdu.getEntityAppearance().intValue();
                this.hasChanged[68] = true;
                this.fireFieldChanged(68);
                this.vfEntityCountry = entityStatePdu.getEntityTypeCountry().intValue();
                this.hasChanged[66] = true;
                this.fireFieldChanged(66);
                int n2 = entityStatePdu.articulationParameterCountValue();
                if (n2 <= 0) break;
                this.vfArticulationParameterCount = n2;
                this.numArticulationParameterArray = n2;
                this.hasChanged[20] = true;
                this.fireFieldChanged(20);
                if (this.vfArticulationParameterArray.length != n2) {
                    this.vfArticulationParameterArray = new float[n2];
                }
                if (this.artVals.length < n2) {
                    this.artVals = new ArticulationParameter[n2];
                }
                entityStatePdu.getArticulationParameters(this.artVals);
                block15: for (int i = 0; i < n2; ++i) {
                    this.vfArticulationParameterArray[i] = (float)this.artVals[i].getParameterValue();
                    switch (i) {
                        case 0: {
                            this.vfArticulationParameterValue0 = this.vfArticulationParameterArray[i];
                            this.hasChanged[22] = true;
                            continue block15;
                        }
                        case 1: {
                            this.vfArticulationParameterValue1 = this.vfArticulationParameterArray[i];
                            this.hasChanged[23] = true;
                            continue block15;
                        }
                        case 2: {
                            this.vfArticulationParameterValue2 = this.vfArticulationParameterArray[i];
                            this.hasChanged[24] = true;
                            continue block15;
                        }
                        case 3: {
                            this.vfArticulationParameterValue3 = this.vfArticulationParameterArray[i];
                            this.hasChanged[25] = true;
                            continue block15;
                        }
                        case 4: {
                            this.vfArticulationParameterValue4 = this.vfArticulationParameterArray[i];
                            this.hasChanged[26] = true;
                            continue block15;
                        }
                        case 5: {
                            this.vfArticulationParameterValue5 = this.vfArticulationParameterArray[i];
                            this.hasChanged[27] = true;
                            continue block15;
                        }
                        case 6: {
                            this.vfArticulationParameterValue6 = this.vfArticulationParameterArray[i];
                            this.hasChanged[28] = true;
                            continue block15;
                        }
                        case 7: {
                            this.vfArticulationParameterValue7 = this.vfArticulationParameterArray[i];
                            this.hasChanged[29] = true;
                        }
                    }
                }
                this.hasChanged[21] = true;
                this.fireFieldChanged(21);
            }
        }
    }

    public void packetArrived(ProtocolDataUnitType protocolDataUnitType) {
        byte by = protocolDataUnitType.getPduHeader().getPduType();
        switch (by) {
            case 2: {
                FirePdu firePdu = (FirePdu)protocolDataUnitType;
                this.vfFired1 = true;
                this.hasChanged[48] = true;
                this.fireFieldChanged(48);
                this.vfFired2 = false;
                this.hasChanged[49] = true;
                this.fireFieldChanged(49);
                this.vfFiredTime = this.vrmlClock.getTime();
                this.hasChanged[58] = true;
                this.fireFieldChanged(58);
                this.vfEventApplicationID = firePdu.getEventID().getApplicationID().intValue();
                this.hasChanged[45] = true;
                this.fireFieldChanged(45);
                this.vfEventEntityID = firePdu.getEventID().getEventID().intValue();
                this.hasChanged[46] = true;
                this.fireFieldChanged(46);
                this.vfEventSiteID = firePdu.getEventID().getSiteID().intValue();
                this.hasChanged[47] = true;
                this.fireFieldChanged(47);
                this.vfMunitionApplicationID = firePdu.getMunitionID().getApplicationID().intValue();
                this.hasChanged[53] = true;
                this.fireFieldChanged(53);
                this.vfMunitionEntityID = firePdu.getMunitionID().getEntityID().intValue();
                this.hasChanged[55] = true;
                this.fireFieldChanged(55);
                this.vfMunitionSiteID = firePdu.getMunitionID().getSiteID().intValue();
                this.hasChanged[56] = true;
                this.fireFieldChanged(56);
                this.vfFireMissionIndex = firePdu.getFireMissionIndex().intValue();
                this.hasChanged[50] = true;
                this.fireFieldChanged(50);
                this.vfFiringRate = firePdu.getBurstDescriptor().getRate().intValue();
                this.hasChanged[52] = true;
                this.fireFieldChanged(52);
                this.vfFiringRange = firePdu.getRange();
                this.hasChanged[51] = true;
                this.fireFieldChanged(51);
                this.vfMunitionStartPoint[0] = (float)firePdu.getLocationInWorldCoordinate().getX();
                this.vfMunitionStartPoint[1] = -((float)firePdu.getLocationInWorldCoordinate().getZ());
                this.vfMunitionStartPoint[2] = (float)firePdu.getLocationInWorldCoordinate().getY();
                this.hasChanged[57] = true;
                this.fireFieldChanged(57);
                this.calculateMunitionEndPoint(firePdu.getVelocity());
                this.hasChanged[54] = true;
                this.fireFieldChanged(54);
                break;
            }
            case 3: {
                DetonationPdu detonationPdu = (DetonationPdu)protocolDataUnitType;
                this.vfIsDetonated = true;
                this.hasChanged[43] = true;
                this.fireFieldChanged(43);
                this.vfDetonateTime = this.vrmlClock.getTime();
                this.hasChanged[44] = true;
                this.fireFieldChanged(44);
                this.vfDetonationResult = detonationPdu.getDetonationResult().intValue();
                this.hasChanged[40] = true;
                this.fireFieldChanged(40);
                this.vfDetonationRelativeLocation[0] = detonationPdu.getLocationInEntityCoordinates().getX();
                this.vfDetonationRelativeLocation[1] = -detonationPdu.getLocationInEntityCoordinates().getZ();
                this.vfDetonationRelativeLocation[2] = detonationPdu.getLocationInEntityCoordinates().getY();
                this.hasChanged[42] = true;
                this.fireFieldChanged(42);
                this.vfDetonationLocation[0] = (float)detonationPdu.getLocationInWorldCoordinate().getX();
                this.vfDetonationLocation[1] = -((float)detonationPdu.getLocationInWorldCoordinate().getZ());
                this.vfDetonationLocation[2] = (float)detonationPdu.getLocationInWorldCoordinate().getY();
                this.hasChanged[41] = true;
                this.fireFieldChanged(41);
                break;
            }
            case 1: {
                Vector3Double vector3Double;
                EntityStatePduType entityStatePduType = (EntityStatePduType)protocolDataUnitType;
                if (!this.ignoreEspdu) {
                    vector3Double = entityStatePduType.getEntityLocation();
                    this.vfTranslation[0] = (float)vector3Double.getX();
                    this.vfTranslation[1] = -((float)vector3Double.getZ());
                    this.vfTranslation[2] = (float)vector3Double.getY();
                    if (this.currentMode == 0 && this.vfGeoOrigin != null) {
                        this.vfTranslation[0] = (float)((double)this.vfTranslation[0] - this.origin[0]);
                        this.vfTranslation[1] = (float)((double)this.vfTranslation[1] - this.origin[1]);
                        this.vfTranslation[2] = (float)((double)this.vfTranslation[2] - this.origin[2]);
                    }
                    this.hasChanged[10] = true;
                    this.fireFieldChanged(10);
                    EulerAnglesType eulerAnglesType = entityStatePduType.getEntityOrientation();
                    float f = eulerAnglesType.getPhi();
                    float f2 = eulerAnglesType.getTheta();
                    float f3 = eulerAnglesType.getPsi();
                    float[] fArray = new float[]{-f3, f, f2};
                    this.quaternion.setEulers(fArray);
                    this.quaternion.getAxisAngle(this.vfRotation);
                    this.hasChanged[7] = true;
                    this.fireFieldChanged(7);
                    this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
                }
                this.vfForceID = entityStatePduType.getForceID();
                this.hasChanged[71] = true;
                this.fireFieldChanged(71);
                vector3Double = entityStatePduType.getEntity();
                this.vfEntityCategory = vector3Double.getCategory();
                this.hasChanged[61] = true;
                this.fireFieldChanged(61);
                this.vfEntityDomain = vector3Double.getDomain();
                this.hasChanged[62] = true;
                this.fireFieldChanged(62);
                this.vfEntityKind = vector3Double.getEntityKind();
                this.hasChanged[64] = true;
                this.fireFieldChanged(64);
                this.vfEntitySubCategory = vector3Double.getSubCategory();
                this.hasChanged[67] = true;
                this.fireFieldChanged(67);
                this.vfEntityExtra = vector3Double.getExtra();
                this.hasChanged[63] = true;
                this.fireFieldChanged(63);
                this.vfEntitySpecific = vector3Double.getSpecific();
                this.hasChanged[65] = true;
                this.fireFieldChanged(65);
                this.vfAppearance = entityStatePduType.getEntityAppearance();
                this.hasChanged[68] = true;
                this.fireFieldChanged(68);
                this.vfEntityCountry = vector3Double.getCountry();
                this.hasChanged[66] = true;
                this.fireFieldChanged(66);
                int n = entityStatePduType.getNumberOfArticulationParameters();
                if (n <= 0) break;
                this.vfArticulationParameterCount = n;
                this.numArticulationParameterArray = n;
                this.hasChanged[20] = true;
                this.fireFieldChanged(20);
                if (this.vfArticulationParameterArray.length != n) {
                    this.vfArticulationParameterArray = new float[n];
                }
                if (this.artValsDX.length < n) {
                    this.artValsDX = new ArticulationParametersType[n];
                }
                List list = entityStatePduType.getArticulationParameters();
                list.toArray(this.artValsDX);
                block15: for (int i = 0; i < n; ++i) {
                    this.vfArticulationParameterArray[i] = (float)this.artValsDX[i].getParameterValue();
                    switch (i) {
                        case 0: {
                            this.vfArticulationParameterValue0 = this.vfArticulationParameterArray[i];
                            this.hasChanged[22] = true;
                            continue block15;
                        }
                        case 1: {
                            this.vfArticulationParameterValue1 = this.vfArticulationParameterArray[i];
                            this.hasChanged[23] = true;
                            continue block15;
                        }
                        case 2: {
                            this.vfArticulationParameterValue2 = this.vfArticulationParameterArray[i];
                            this.hasChanged[24] = true;
                            continue block15;
                        }
                        case 3: {
                            this.vfArticulationParameterValue3 = this.vfArticulationParameterArray[i];
                            this.hasChanged[25] = true;
                            continue block15;
                        }
                        case 4: {
                            this.vfArticulationParameterValue4 = this.vfArticulationParameterArray[i];
                            this.hasChanged[26] = true;
                            continue block15;
                        }
                        case 5: {
                            this.vfArticulationParameterValue5 = this.vfArticulationParameterArray[i];
                            this.hasChanged[27] = true;
                            continue block15;
                        }
                        case 6: {
                            this.vfArticulationParameterValue6 = this.vfArticulationParameterArray[i];
                            this.hasChanged[28] = true;
                            continue block15;
                        }
                        case 7: {
                            this.vfArticulationParameterValue7 = this.vfArticulationParameterArray[i];
                            this.hasChanged[29] = true;
                        }
                    }
                }
                this.hasChanged[21] = true;
                this.fireFieldChanged(21);
            }
        }
    }

    private void calculateMunitionEndPoint(LinearVelocity linearVelocity) {
        double d = Math.sqrt(linearVelocity.getX() * linearVelocity.getX() + linearVelocity.getY() * linearVelocity.getY());
        double d2 = Math.atan2(linearVelocity.getX(), linearVelocity.getY());
        double d3 = Math.atan2(-linearVelocity.getZ(), d);
        this.vfMunitionEndPoint[0] = this.vfMunitionStartPoint[0] + (float)((double)this.vfFiringRange * Math.cos(d3) * Math.sin(d2));
        this.vfMunitionEndPoint[1] = this.vfMunitionStartPoint[1] + (float)((double)this.vfFiringRange * Math.sin(d3));
        this.vfMunitionEndPoint[2] = this.vfMunitionStartPoint[2] + (float)((double)this.vfFiringRange * Math.cos(d3) * Math.cos(d2));
    }

    private boolean floatEq(float f, float f2) {
        float f3 = f - f2;
        if (f3 < 0.0f) {
            f3 *= -1.0f;
        }
        return f3 < 1.0E-4f;
    }

    protected void updateMatrix() {
        this.tempVec.x = -this.vfCenter[0];
        this.tempVec.y = -this.vfCenter[1];
        this.tempVec.z = -this.vfCenter[2];
        this.tmatrix.setIdentity();
        this.tmatrix.setTranslation(this.tempVec);
        float f = 1.0f;
        if (this.floatEq(this.vfScale[0], this.vfScale[1]) && this.floatEq(this.vfScale[0], this.vfScale[2])) {
            f = this.vfScale[0];
            this.tempMtx1.set(f);
        } else {
            this.tempAxis.x = this.vfScaleOrientation[0];
            this.tempAxis.y = this.vfScaleOrientation[1];
            this.tempAxis.z = this.vfScaleOrientation[2];
            this.tempAxis.angle = -this.vfScaleOrientation[3];
            double d = 1.0 / Math.sqrt(this.tempAxis.x * this.tempAxis.x + this.tempAxis.y * this.tempAxis.y + this.tempAxis.z * this.tempAxis.z);
            this.tempAxis.x = (float)((double)this.tempAxis.x * d);
            this.tempAxis.y = (float)((double)this.tempAxis.y * d);
            this.tempAxis.z = (float)((double)this.tempAxis.z * d);
            this.tempMtx1.set(this.tempAxis);
            this.tempMtx2.mul(this.tempMtx1, this.tmatrix);
            this.tempMtx1.setIdentity();
            this.tempMtx1.m00 = this.vfScale[0];
            this.tempMtx1.m11 = this.vfScale[1];
            this.tempMtx1.m22 = this.vfScale[2];
            this.tmatrix.mul(this.tempMtx1, this.tempMtx2);
            this.tempAxis.x = this.vfScaleOrientation[0];
            this.tempAxis.y = this.vfScaleOrientation[1];
            this.tempAxis.z = this.vfScaleOrientation[2];
            this.tempAxis.angle = this.vfScaleOrientation[3];
            this.tempMtx1.set(this.tempAxis);
        }
        this.tempMtx2.mul(this.tempMtx1, this.tmatrix);
        float f2 = this.vfRotation[0] * this.vfRotation[0] + this.vfRotation[1] * this.vfRotation[1] + this.vfRotation[2] * this.vfRotation[2];
        if (f2 < 1.0E-4f) {
            this.tempAxis.x = 0.0f;
            this.tempAxis.y = 0.0f;
            this.tempAxis.z = 1.0f;
            this.tempAxis.angle = 0.0f;
        } else {
            if ((double)f2 > 1.01 || (double)f2 < 0.99) {
                float f3 = (float)(1.0 / Math.sqrt(f2));
                this.tempAxis.x = this.vfRotation[0] * f3;
                this.tempAxis.y = this.vfRotation[1] * f3;
                this.tempAxis.z = this.vfRotation[2] * f3;
            } else {
                this.tempAxis.x = this.vfRotation[0];
                this.tempAxis.y = this.vfRotation[1];
                this.tempAxis.z = this.vfRotation[2];
            }
            this.tempAxis.angle = this.vfRotation[3];
        }
        this.tempMtx1.set(this.tempAxis);
        this.tmatrix.mul(this.tempMtx1, this.tempMtx2);
        this.tempVec.x = this.vfCenter[0];
        this.tempVec.y = this.vfCenter[1];
        this.tempVec.z = this.vfCenter[2];
        this.tempMtx1.setIdentity();
        this.tempMtx1.setTranslation(this.tempVec);
        this.tempMtx2.mul(this.tempMtx1, this.tmatrix);
        this.tempVec.x = this.vfTranslation[0];
        this.tempVec.y = this.vfTranslation[1];
        this.tempVec.z = this.vfTranslation[2];
        this.tempMtx1.setIdentity();
        this.tempMtx1.setTranslation(this.tempVec);
        this.tmatrix.mul(this.tempMtx1, this.tempMtx2);
    }

    protected void fireRoleChanged() {
        int n = this.roleListeners.size();
        for (int i = 0; i < n; ++i) {
            NetworkRoleListener networkRoleListener = (NetworkRoleListener)this.roleListeners.get(i);
            networkRoleListener.roleChanged(this.currentMode, (Object)this);
        }
    }

    public void regenID() {
        this.id = new EntityID(this.vfSiteID, this.vfApplicationID, this.vfEntityID);
        if (this.useDX) {
            this.idDX = new EntityIDTypeImpl();
            this.idDX.setSite(this.vfSiteID);
            this.idDX.setApplication(this.vfApplicationID);
            this.idDX.setEntity(this.vfEntityID);
        }
    }

    private void setGeoOrigin(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException, InvalidFieldAccessException {
        VRMLLocalOriginNodeType vRMLLocalOriginNodeType;
        if (!this.inSetup) {
            throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: geoOrigin");
        }
        Object object = this.pGeoOrigin != null ? this.pGeoOrigin : this.vfGeoOrigin;
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            VRMLNodeType vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            while (vRMLNodeType2 != null && vRMLNodeType2 instanceof VRMLProtoInstance) {
                vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType2).getImplementationNode();
            }
            if (vRMLNodeType2 != null && !(vRMLNodeType2 instanceof VRMLLocalOriginNodeType)) {
                throw new InvalidFieldValueException(GEO_ORIGIN_PROTO_MSG);
            }
            vRMLLocalOriginNodeType = vRMLNodeType2;
            this.pGeoOrigin = (VRMLProtoInstance)vRMLNodeType;
        } else {
            if (vRMLNodeType != null && !(vRMLNodeType instanceof VRMLLocalOriginNodeType)) {
                throw new InvalidFieldValueException(GEO_ORIGIN_NODE_MSG);
            }
            this.pGeoOrigin = null;
            vRMLLocalOriginNodeType = (VRMLLocalOriginNodeType)vRMLNodeType;
        }
        this.vfGeoOrigin = vRMLLocalOriginNodeType;
        if (vRMLNodeType != null) {
            this.updateRefs(vRMLNodeType, true);
        }
        if (object != null) {
            this.updateRefs((VRMLNodeType)object, false);
        }
    }

    private void resizeAPA(int n) {
        if (this.artVals.length < n) {
            this.artVals = new ArticulationParameter[n];
            for (int i = 0; i < this.artVals.length; ++i) {
                this.artVals[i] = new ArticulationParameter();
            }
            float[] fArray = new float[n];
            for (int i = 0; i < this.vfArticulationParameterArray.length; ++i) {
                fArray[i] = this.vfArticulationParameterArray[i];
            }
            this.vfArticulationParameterArray = fArray;
            if (this.vfArticulationParameterCount < n) {
                this.vfArticulationParameterCount = n;
            }
        }
    }

    private void setXMPPParams(String[] stringArray, int n) {
        int n2;
        if (n < 5) {
            System.out.println("Invalid number of XMPP params.  Must be 5 or greater.");
            return;
        }
        for (n2 = 0; n2 < n; ++n2) {
            if (stringArray[n2].length() >= 1) continue;
            stringArray[n2] = null;
        }
        this.xmppUsername = stringArray[0];
        this.xmppPassword = stringArray[1];
        this.xmppMucServer = stringArray[2];
        this.xmppMucRoom = stringArray[3];
        n2 = n - 4;
        this.xmppAuthServer = new String[n2];
        for (int i = 0; i < n2; ++i) {
            this.xmppAuthServer[i] = stringArray[4 + i];
        }
    }

    private void eulersToMatrix(double d, double d2, double d3, Matrix3d matrix3d) {
        this.psiMat.setIdentity();
        this.psiMat.rotY(-d3);
        this.thetaMat.rotZ(d2);
        this.phiMat.rotX(d);
        matrix3d.mul(this.phiMat, this.thetaMat);
        matrix3d.mul(this.psiMat);
    }

    private void set(Quat4d quat4d) {
        double d = quat4d.x * quat4d.y + quat4d.z * quat4d.w;
        double d2 = quat4d.x * quat4d.x;
        double d3 = quat4d.y * quat4d.y;
        double d4 = quat4d.z * quat4d.z;
        double d5 = quat4d.w * quat4d.w;
        double d6 = d2 + d3 + d4 + d5;
        if (d > 0.499 * d6) {
            this.yaw = 2.0 * Math.atan2(quat4d.x, quat4d.w);
            this.pitch = 1.5707963267948966;
            this.roll = 0.0;
            return;
        }
        if (d < -0.499 * d6) {
            this.yaw = -2.0 * Math.atan2(quat4d.x, quat4d.w);
            this.pitch = -1.5707963267948966;
            this.roll = 0.0;
            return;
        }
        this.yaw = Math.atan2(2.0 * quat4d.y * quat4d.w - 2.0 * quat4d.x * quat4d.z, d2 - d3 - d4 + d5);
        this.pitch = Math.asin(2.0 * d / d6);
        this.roll = Math.atan2(2.0 * quat4d.x * quat4d.w - 2.0 * quat4d.y * quat4d.z, -d2 + d3 - d4 + d5);
    }

    static {
        simStartTime = System.currentTimeMillis();
        nodeFields = new int[]{1, 0, 60};
        fieldDecl = new VRMLFieldDeclaration[73];
        fieldMap = new HashMap(73);
        BaseEspduTransform.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseEspduTransform.fieldDecl[1] = new VRMLFieldDeclaration(3, "MFNode", "children");
        BaseEspduTransform.fieldDecl[2] = new VRMLFieldDeclaration(1, "MFNode", "addChildren");
        BaseEspduTransform.fieldDecl[3] = new VRMLFieldDeclaration(1, "MFNode", "removeChildren");
        BaseEspduTransform.fieldDecl[4] = new VRMLFieldDeclaration(2, "SFVec3f", "bboxCenter");
        BaseEspduTransform.fieldDecl[5] = new VRMLFieldDeclaration(2, "SFVec3f", "bboxSize");
        BaseEspduTransform.fieldDecl[6] = new VRMLFieldDeclaration(3, "SFVec3f", "center");
        BaseEspduTransform.fieldDecl[7] = new VRMLFieldDeclaration(3, "SFRotation", "rotation");
        BaseEspduTransform.fieldDecl[8] = new VRMLFieldDeclaration(3, "SFVec3f", "scale");
        BaseEspduTransform.fieldDecl[9] = new VRMLFieldDeclaration(3, "SFRotation", "scaleOrientation");
        BaseEspduTransform.fieldDecl[10] = new VRMLFieldDeclaration(3, "SFVec3f", "translation");
        BaseEspduTransform.fieldDecl[11] = new VRMLFieldDeclaration(3, "SFString", "marking");
        BaseEspduTransform.fieldDecl[68] = new VRMLFieldDeclaration(3, "SFInt32", "appearance");
        BaseEspduTransform.fieldDecl[12] = new VRMLFieldDeclaration(3, "SFInt32", "siteID");
        BaseEspduTransform.fieldDecl[14] = new VRMLFieldDeclaration(3, "SFInt32", "entityID");
        BaseEspduTransform.fieldDecl[61] = new VRMLFieldDeclaration(3, "SFInt32", "entityCategory");
        BaseEspduTransform.fieldDecl[62] = new VRMLFieldDeclaration(3, "SFInt32", "entityDomain");
        BaseEspduTransform.fieldDecl[64] = new VRMLFieldDeclaration(3, "SFInt32", "entityKind");
        BaseEspduTransform.fieldDecl[65] = new VRMLFieldDeclaration(3, "SFInt32", "entitySpecific");
        BaseEspduTransform.fieldDecl[67] = new VRMLFieldDeclaration(3, "SFInt32", "entitySubCategory");
        BaseEspduTransform.fieldDecl[66] = new VRMLFieldDeclaration(3, "SFInt32", "entityCountry");
        BaseEspduTransform.fieldDecl[63] = new VRMLFieldDeclaration(3, "SFInt32", "entityExtra");
        BaseEspduTransform.fieldDecl[45] = new VRMLFieldDeclaration(3, "SFInt32", "eventApplicationID");
        BaseEspduTransform.fieldDecl[46] = new VRMLFieldDeclaration(3, "SFInt32", "eventEntityID");
        BaseEspduTransform.fieldDecl[47] = new VRMLFieldDeclaration(3, "SFInt32", "eventSiteID");
        BaseEspduTransform.fieldDecl[48] = new VRMLFieldDeclaration(3, "SFBool", "fired1");
        BaseEspduTransform.fieldDecl[49] = new VRMLFieldDeclaration(3, "SFBool", "fired2");
        BaseEspduTransform.fieldDecl[50] = new VRMLFieldDeclaration(3, "SFInt32", "fireMissionIndex");
        BaseEspduTransform.fieldDecl[51] = new VRMLFieldDeclaration(3, "SFFloat", "firingRange");
        BaseEspduTransform.fieldDecl[53] = new VRMLFieldDeclaration(3, "SFInt32", "munitionApplicationID");
        BaseEspduTransform.fieldDecl[55] = new VRMLFieldDeclaration(3, "SFInt32", "munitionEntityID");
        BaseEspduTransform.fieldDecl[56] = new VRMLFieldDeclaration(3, "SFInt32", "munitionSiteID");
        BaseEspduTransform.fieldDecl[54] = new VRMLFieldDeclaration(3, "SFVec3f", "munitionEndPoint");
        BaseEspduTransform.fieldDecl[57] = new VRMLFieldDeclaration(3, "SFVec3f", "munitionStartPoint");
        BaseEspduTransform.fieldDecl[58] = new VRMLFieldDeclaration(3, "SFTime", "firedTime");
        BaseEspduTransform.fieldDecl[52] = new VRMLFieldDeclaration(3, "SFInt32", "firingRate");
        BaseEspduTransform.fieldDecl[41] = new VRMLFieldDeclaration(3, "SFVec3f", "detonationLocation");
        BaseEspduTransform.fieldDecl[42] = new VRMLFieldDeclaration(3, "SFVec3f", "detonationRelativeLocation");
        BaseEspduTransform.fieldDecl[40] = new VRMLFieldDeclaration(3, "SFInt32", "detonationResult");
        BaseEspduTransform.fieldDecl[15] = new VRMLFieldDeclaration(3, "SFTime", "readInterval");
        BaseEspduTransform.fieldDecl[16] = new VRMLFieldDeclaration(3, "SFTime", "writeInterval");
        BaseEspduTransform.fieldDecl[17] = new VRMLFieldDeclaration(3, "SFString", "networkMode");
        BaseEspduTransform.fieldDecl[18] = new VRMLFieldDeclaration(3, "SFString", "address");
        BaseEspduTransform.fieldDecl[71] = new VRMLFieldDeclaration(3, "SFInt32", "forceID");
        BaseEspduTransform.fieldDecl[20] = new VRMLFieldDeclaration(3, "SFInt32", "articulationParameterCount");
        BaseEspduTransform.fieldDecl[21] = new VRMLFieldDeclaration(3, "MFFloat", "articulationParameterArray");
        BaseEspduTransform.fieldDecl[22] = new VRMLFieldDeclaration(4, "SFFloat", "articulationParameterValue0_changed");
        BaseEspduTransform.fieldDecl[23] = new VRMLFieldDeclaration(4, "SFFloat", "articulationParameterValue1_changed");
        BaseEspduTransform.fieldDecl[24] = new VRMLFieldDeclaration(4, "SFFloat", "articulationParameterValue2_changed");
        BaseEspduTransform.fieldDecl[25] = new VRMLFieldDeclaration(4, "SFFloat", "articulationParameterValue3_changed");
        BaseEspduTransform.fieldDecl[26] = new VRMLFieldDeclaration(4, "SFFloat", "articulationParameterValue4_changed");
        BaseEspduTransform.fieldDecl[27] = new VRMLFieldDeclaration(4, "SFFloat", "articulationParameterValue5_changed");
        BaseEspduTransform.fieldDecl[28] = new VRMLFieldDeclaration(4, "SFFloat", "articulationParameterValue6_changed");
        BaseEspduTransform.fieldDecl[29] = new VRMLFieldDeclaration(4, "SFFloat", "articulationParameterValue7_changed");
        BaseEspduTransform.fieldDecl[31] = new VRMLFieldDeclaration(1, "SFFloat", "set_articulationParameterValue0");
        BaseEspduTransform.fieldDecl[32] = new VRMLFieldDeclaration(1, "SFFloat", "set_articulationParameterValue1");
        BaseEspduTransform.fieldDecl[33] = new VRMLFieldDeclaration(1, "SFFloat", "set_articulationParameterValue2");
        BaseEspduTransform.fieldDecl[34] = new VRMLFieldDeclaration(1, "SFFloat", "set_articulationParameterValue3");
        BaseEspduTransform.fieldDecl[35] = new VRMLFieldDeclaration(1, "SFFloat", "set_articulationParameterValue4");
        BaseEspduTransform.fieldDecl[36] = new VRMLFieldDeclaration(1, "SFFloat", "set_articulationParameterValue5");
        BaseEspduTransform.fieldDecl[37] = new VRMLFieldDeclaration(1, "SFFloat", "set_articulationParameterValue6");
        BaseEspduTransform.fieldDecl[38] = new VRMLFieldDeclaration(1, "SFFloat", "set_articulationParameterValue7");
        BaseEspduTransform.fieldDecl[59] = new VRMLFieldDeclaration(3, "MFString", "geoSystem");
        BaseEspduTransform.fieldDecl[19] = new VRMLFieldDeclaration(3, "SFInt32", "port");
        BaseEspduTransform.fieldDecl[13] = new VRMLFieldDeclaration(3, "SFInt32", "applicationID");
        BaseEspduTransform.fieldDecl[44] = new VRMLFieldDeclaration(4, "SFTime", "detonateTime");
        BaseEspduTransform.fieldDecl[43] = new VRMLFieldDeclaration(4, "SFBool", "isDetonated");
        BaseEspduTransform.fieldDecl[39] = new VRMLFieldDeclaration(4, "SFTime", "timestamp");
        BaseEspduTransform.fieldDecl[30] = new VRMLFieldDeclaration(4, "SFBool", "isActive");
        BaseEspduTransform.fieldDecl[60] = new VRMLFieldDeclaration(2, "SFNode", "geoOrigin");
        BaseEspduTransform.fieldDecl[72] = new VRMLFieldDeclaration(3, "MFString", "xmppParams");
        BaseEspduTransform.fieldDecl[69] = new VRMLFieldDeclaration(3, "SFVec3f", "linearVelocity");
        BaseEspduTransform.fieldDecl[70] = new VRMLFieldDeclaration(3, "SFVec3f", "linearAcceleration");
        BaseEspduTransform.fieldDecl[72] = new VRMLFieldDeclaration(3, "MFString", "xmppParams");
        notimpl_decl = new VRMLFieldDeclaration(3, "SFString", "invalid");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("children", n);
        fieldMap.put("set_children", n);
        fieldMap.put("children_changed", n);
        n = new Integer(2);
        fieldMap.put("addChildren", n);
        fieldMap.put("set_addChildren", n);
        n = new Integer(3);
        fieldMap.put("removeChildren", n);
        fieldMap.put("set_removeChildren", n);
        fieldMap.put("bboxCenter", new Integer(4));
        fieldMap.put("bboxSize", new Integer(5));
        n = new Integer(6);
        fieldMap.put("center", n);
        fieldMap.put("set_center", n);
        fieldMap.put("center_changed", n);
        n = new Integer(7);
        fieldMap.put("rotation", n);
        fieldMap.put("set_rotation", n);
        fieldMap.put("rotation_changed", n);
        n = new Integer(8);
        fieldMap.put("scale", n);
        fieldMap.put("set_scale", n);
        fieldMap.put("scale_changed", n);
        n = new Integer(9);
        fieldMap.put("scaleOrientation", n);
        fieldMap.put("set_scaleOrientation", n);
        fieldMap.put("scaleOrientation_changed", n);
        n = new Integer(10);
        fieldMap.put("translation", n);
        fieldMap.put("set_translation", n);
        fieldMap.put("translation_changed", n);
        n = new Integer(11);
        fieldMap.put("marking", n);
        fieldMap.put("set_marking", n);
        fieldMap.put("marking_changed", n);
        n = new Integer(68);
        fieldMap.put("appearance", n);
        fieldMap.put("set_appearance", n);
        fieldMap.put("appearance_changed", n);
        n = new Integer(12);
        fieldMap.put("siteID", n);
        fieldMap.put("set_siteID", n);
        fieldMap.put("siteID_changed", n);
        n = new Integer(13);
        fieldMap.put("applicationID", n);
        fieldMap.put("set_applicationID", n);
        fieldMap.put("applicationID_changed", n);
        n = new Integer(14);
        fieldMap.put("entityID", n);
        fieldMap.put("set_entityID", n);
        fieldMap.put("entityID_changed", n);
        n = new Integer(71);
        fieldMap.put("forceID", n);
        fieldMap.put("set_forceID", n);
        fieldMap.put("forceID_changed", n);
        n = new Integer(61);
        fieldMap.put("entityCategory", n);
        fieldMap.put("set_entityCategory", n);
        fieldMap.put("entityCategory_changed", n);
        n = new Integer(66);
        fieldMap.put("entityCountry", n);
        fieldMap.put("set_entityCountry", n);
        fieldMap.put("entityCountry_changed", n);
        n = new Integer(62);
        fieldMap.put("entityDomain", n);
        fieldMap.put("set_entityDomain", n);
        fieldMap.put("entityDomain_changed", n);
        n = new Integer(63);
        fieldMap.put("entityExtra", n);
        fieldMap.put("set_entityExtra", n);
        fieldMap.put("entityExtra_changed", n);
        n = new Integer(64);
        fieldMap.put("entityKind", n);
        fieldMap.put("set_entityKind", n);
        fieldMap.put("entityKind_changed", n);
        n = new Integer(65);
        fieldMap.put("entitySpecific", n);
        fieldMap.put("set_entitySpecific", n);
        fieldMap.put("entitySpecific_changed", n);
        n = new Integer(67);
        fieldMap.put("entitySubCategory", n);
        fieldMap.put("set_entitySubCategory", n);
        fieldMap.put("entitySubCategory_changed", n);
        n = new Integer(15);
        fieldMap.put("readInterval", n);
        fieldMap.put("set_readInterval", n);
        fieldMap.put("readInterval_changed", n);
        n = new Integer(16);
        fieldMap.put("writeInterval", n);
        fieldMap.put("set_writeInterval", n);
        fieldMap.put("writeInterval_changed", n);
        n = new Integer(17);
        fieldMap.put("networkMode", n);
        fieldMap.put("set_networkMode", n);
        fieldMap.put("networkMode_changed", n);
        n = new Integer(18);
        fieldMap.put("address", n);
        fieldMap.put("set_address", n);
        fieldMap.put("address_changed", n);
        n = new Integer(19);
        fieldMap.put("port", n);
        fieldMap.put("set_port", n);
        fieldMap.put("port_changed", n);
        n = new Integer(45);
        fieldMap.put("eventApplicationID", n);
        fieldMap.put("set_eventApplicationID", n);
        fieldMap.put("eventApplicationID_changed", n);
        n = new Integer(46);
        fieldMap.put("eventEntityID", n);
        fieldMap.put("set_eventEntityID", n);
        fieldMap.put("eventEntityID_changed", n);
        n = new Integer(50);
        fieldMap.put("fireMissionIndex", n);
        fieldMap.put("set_fireMissionIndex", n);
        fieldMap.put("fireMissionIndex_changed", n);
        n = new Integer(52);
        fieldMap.put("firingRate", n);
        fieldMap.put("set_firingRate", n);
        fieldMap.put("firingRate_changed", n);
        n = new Integer(53);
        fieldMap.put("munitionApplicationID", n);
        fieldMap.put("set_munitionApplicationID", n);
        fieldMap.put("munitionApplicationID_changed", n);
        n = new Integer(55);
        fieldMap.put("munitionEntityID", n);
        fieldMap.put("set_munitionEntityID", n);
        fieldMap.put("munitionEntityID_changed", n);
        n = new Integer(56);
        fieldMap.put("munitionSiteID", n);
        fieldMap.put("set_munitionSiteID", n);
        fieldMap.put("munitionSiteID_changed", n);
        n = new Integer(54);
        fieldMap.put("munitionEndPoint", n);
        fieldMap.put("set_munitionEndPoint", n);
        fieldMap.put("munitionEndPoint_changed", n);
        n = new Integer(57);
        fieldMap.put("munitionStartPoint", n);
        fieldMap.put("set_munitionStartPoint", n);
        fieldMap.put("munitionStartPoint_changed", n);
        n = new Integer(58);
        fieldMap.put("firedTime", n);
        fieldMap.put("set_firedTime", n);
        fieldMap.put("firedTime_changed", n);
        n = new Integer(48);
        fieldMap.put("fired1", n);
        fieldMap.put("set_fired1", n);
        fieldMap.put("fired1_changed", n);
        n = new Integer(49);
        fieldMap.put("fired2", n);
        fieldMap.put("set_fired2", n);
        fieldMap.put("fired2_changed", n);
        n = new Integer(51);
        fieldMap.put("firingRange", n);
        fieldMap.put("set_firingRange", n);
        fieldMap.put("firingRange_changed", n);
        n = new Integer(47);
        fieldMap.put("eventSiteID", n);
        fieldMap.put("set_eventSiteID", n);
        fieldMap.put("eventSiteID_changed", n);
        n = new Integer(41);
        fieldMap.put("detonationLocation", n);
        fieldMap.put("set_detonationLocation", n);
        fieldMap.put("detonationLocation_changed", n);
        n = new Integer(42);
        fieldMap.put("detonationRelativeLocation", n);
        fieldMap.put("set_detonationRelativeLocation", n);
        fieldMap.put("detonationRelativeLocation_changed", n);
        n = new Integer(40);
        fieldMap.put("detonationResult", n);
        fieldMap.put("set_detonationResult", n);
        fieldMap.put("detonationResult_changed", n);
        n = new Integer(43);
        fieldMap.put("isDetonated", n);
        fieldMap.put("isDetonated_changed", n);
        n = new Integer(44);
        fieldMap.put("detonateTime", n);
        fieldMap.put("detonateTime_changed", n);
        n = new Integer(30);
        fieldMap.put("isActive", n);
        fieldMap.put("isActive_changed", n);
        n = new Integer(39);
        fieldMap.put("timestamp", n);
        fieldMap.put("timestamp_changed", n);
        n = new Integer(20);
        fieldMap.put("articulationParameterCount", n);
        fieldMap.put("set_articulationParameterCount", n);
        fieldMap.put("articulationParameterCount_changed", n);
        n = new Integer(21);
        fieldMap.put("articulationParameterArray", n);
        fieldMap.put("set_articulationParameterArray", n);
        fieldMap.put("articulationParameterArray_changed", n);
        n = new Integer(22);
        fieldMap.put("articulationParameterValue0_changed", n);
        n = new Integer(23);
        fieldMap.put("articulationParameterValue1_changed", n);
        n = new Integer(24);
        fieldMap.put("articulationParameterValue2_changed", n);
        n = new Integer(25);
        fieldMap.put("articulationParameterValue3_changed", n);
        n = new Integer(26);
        fieldMap.put("articulationParameterValue4_changed", n);
        n = new Integer(27);
        fieldMap.put("articulationParameterValue5_changed", n);
        n = new Integer(28);
        fieldMap.put("articulationParameterValue6_changed", n);
        n = new Integer(29);
        fieldMap.put("articulationParameterValue7_changed", n);
        n = new Integer(31);
        fieldMap.put("set_articulationParameterValue0", n);
        n = new Integer(32);
        fieldMap.put("set_articulationParameterValue1", n);
        n = new Integer(33);
        fieldMap.put("set_articulationParameterValue2", n);
        n = new Integer(34);
        fieldMap.put("set_articulationParameterValue3", n);
        n = new Integer(35);
        fieldMap.put("set_articulationParameterValue4", n);
        n = new Integer(36);
        fieldMap.put("set_articulationParameterValue5", n);
        n = new Integer(37);
        fieldMap.put("set_articulationParameterValue6", n);
        n = new Integer(38);
        fieldMap.put("set_articulationParameterValue7", n);
        n = new Integer(59);
        fieldMap.put("geoSystem", n);
        n = new Integer(60);
        fieldMap.put("geoOrigin", n);
        n = new Integer(72);
        fieldMap.put("xmppParams", n);
        fieldMap.put("set_xmppParams", n);
        fieldMap.put("xmppParams_changed", n);
        n = new Integer(69);
        fieldMap.put("linearVelocity", n);
        fieldMap.put("set_linearVelocity", n);
        fieldMap.put("linearVelocity_changed", n);
        n = new Integer(70);
        fieldMap.put("linearAcceleration", n);
        fieldMap.put("set_linearAcceleration", n);
        fieldMap.put("linearAcceleration_changed", n);
        networkModes = new HashMap(3);
        networkModes.put("standAlone", new Integer(2));
        networkModes.put("networkWriter", new Integer(1));
        networkModes.put("networkReader", new Integer(0));
    }
}

