/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.core;

import java.util.ArrayList;
import java.util.HashMap;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLMetadataObjectNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.renderer.common.nodes.BaseMetadataObjectNode;

public class BaseMetadataSet
extends BaseMetadataObjectNode {
    protected static final int FIELD_VALUE = 3;
    protected static final int LAST_SET_INDEX = 3;
    protected static final String DATA_PROTO_MSG = "Proto does not describe a MetadataObject object";
    protected static final String DATA_NODE_MSG = "Node does not describe a MetadataObject object";
    protected static VRMLFieldDeclaration[] fieldDecl;
    protected static HashMap fieldMap;
    private static int[] nodeFields;
    protected VRMLNodeType[] vfValue;
    private ArrayList valueList;

    public BaseMetadataSet() {
        super("MetadataSet");
        this.hasChanged = new boolean[4];
        this.valueList = new ArrayList();
    }

    public BaseMetadataSet(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((VRMLMetadataObjectNodeType)vRMLNodeType);
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        if (this.valueList.size() != 0) {
            this.vfValue = new VRMLNodeType[this.valueList.size()];
            for (int i = 0; i < this.valueList.size(); ++i) {
                this.vfValue[i] = (VRMLNodeType)this.valueList.get(i);
                this.vfValue[i].setupFinished();
            }
        }
        this.valueList = null;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 3) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 3: {
                vRMLFieldData.clear();
                vRMLFieldData.nodeArrayValue = this.vfValue;
                vRMLFieldData.dataType = (short)13;
                if (this.vfValue == null) {
                    vRMLFieldData.numElements = 0;
                    break;
                }
                vRMLFieldData.numElements = this.vfValue.length;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 3: {
                    vRMLNodeType.setValue(n2, this.vfValue, this.vfValue.length);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 3: {
                if (vRMLNodeType instanceof VRMLMetadataObjectNodeType) {
                    if (this.inSetup) {
                        this.valueList.add(vRMLNodeType);
                    } else {
                        this.vfValue = new VRMLNodeType[1];
                        this.vfValue[0] = vRMLNodeType;
                    }
                } else if (vRMLNodeType instanceof VRMLProtoInstance) {
                    VRMLProtoInstance vRMLProtoInstance = (VRMLProtoInstance)vRMLNodeType;
                    VRMLNodeType vRMLNodeType2 = vRMLProtoInstance.getImplementationNode();
                    while (vRMLNodeType2 != null && vRMLNodeType2 instanceof VRMLProtoInstance) {
                        vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType2).getImplementationNode();
                    }
                    if (vRMLNodeType2 != null && !(vRMLNodeType2 instanceof VRMLMetadataObjectNodeType)) {
                        throw new InvalidFieldValueException(DATA_PROTO_MSG);
                    }
                    if (this.inSetup) {
                        this.valueList.add(vRMLNodeType);
                    } else {
                        this.vfValue = new VRMLNodeType[1];
                        this.vfValue[0] = vRMLNodeType;
                    }
                } else {
                    throw new InvalidFieldValueException(DATA_NODE_MSG);
                }
                if (this.inSetup) break;
                this.hasChanged[3] = true;
                this.fireFieldChanged(3);
                break;
            }
            default: {
                super.setValue(n, vRMLNodeType);
            }
        }
    }

    public void setValue(int n, VRMLNodeType[] vRMLNodeTypeArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 3: {
                for (int i = 0; i < n2; ++i) {
                    if (vRMLNodeTypeArray[i] instanceof VRMLMetadataObjectNodeType) continue;
                    if (vRMLNodeTypeArray[i] instanceof VRMLProtoInstance) {
                        VRMLProtoInstance vRMLProtoInstance = (VRMLProtoInstance)vRMLNodeTypeArray[i];
                        VRMLNodeType vRMLNodeType = vRMLProtoInstance.getImplementationNode();
                        while (vRMLNodeType != null && vRMLNodeType instanceof VRMLProtoInstance) {
                            vRMLNodeType = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
                        }
                        if (vRMLNodeType == null || vRMLNodeType instanceof VRMLMetadataObjectNodeType) continue;
                        throw new InvalidFieldValueException(DATA_PROTO_MSG);
                    }
                    throw new InvalidFieldValueException(DATA_NODE_MSG);
                }
                if (n2 == 0) {
                    this.vfValue = null;
                } else {
                    if (this.vfValue == null || this.vfValue.length != n2) {
                        this.vfValue = new VRMLNodeType[n2];
                    }
                    System.arraycopy(vRMLNodeTypeArray, 0, this.vfValue, 0, n2);
                }
                if (this.inSetup) break;
                this.hasChanged[3] = true;
                this.fireFieldChanged(3);
                break;
            }
            default: {
                super.setValue(n, vRMLNodeTypeArray, n2);
            }
        }
    }

    static {
        nodeFields = new int[]{0, 3};
        fieldDecl = new VRMLFieldDeclaration[4];
        fieldMap = new HashMap(9);
        BaseMetadataSet.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseMetadataSet.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFString", "name");
        BaseMetadataSet.fieldDecl[2] = new VRMLFieldDeclaration(3, "SFString", "reference");
        BaseMetadataSet.fieldDecl[3] = new VRMLFieldDeclaration(3, "MFNode", "value");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("name", n);
        fieldMap.put("set_name", n);
        fieldMap.put("name_changed", n);
        n = new Integer(2);
        fieldMap.put("reference", n);
        fieldMap.put("set_reference", n);
        fieldMap.put("reference_changed", n);
        n = new Integer(3);
        fieldMap.put("value", n);
        fieldMap.put("set_value", n);
        fieldMap.put("value_changed", n);
    }
}

