/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.cadgeometry;

import java.util.HashMap;
import org.web3d.vrml.lang.FieldConstants;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLGroupingNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.BaseGroupingNode;

public class BaseCADLayer
extends BaseGroupingNode {
    protected static final int FIELD_NAME = 6;
    protected static final int FIELD_VISIBLE = 7;
    protected static final int LAST_CADLAYER_INDEX = 7;
    protected static final int NUM_FIELDS = 8;
    protected static VRMLFieldDeclaration[] fieldDecl;
    protected static HashMap fieldMap;
    private static int[] nodeFields;
    protected String vfName;
    protected boolean[] vfVisible = FieldConstants.EMPTY_MFBOOL;
    protected int numVisible;

    public BaseCADLayer() {
        super("CADLayer");
        this.hasChanged = new boolean[8];
    }

    public BaseCADLayer(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((VRMLGroupingNodeType)vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("visible");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfVisible = new boolean[vRMLFieldData.numElements];
            System.arraycopy(vRMLFieldData.booleanArrayValue, 0, this.vfVisible, 0, vRMLFieldData.numElements);
            this.numVisible = vRMLFieldData.numElements;
            n = vRMLNodeType.getFieldIndex("name");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfName = vRMLFieldData.stringValue;
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public int getPrimaryType() {
        return 94;
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 7) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 6: {
                vRMLFieldData.clear();
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)6;
                vRMLFieldData.stringValue = this.vfName;
                break;
            }
            case 7: {
                vRMLFieldData.clear();
                vRMLFieldData.numElements = this.numVisible;
                vRMLFieldData.dataType = (short)8;
                vRMLFieldData.booleanArrayValue = this.vfVisible;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 6: {
                    vRMLNodeType.setValue(n2, this.vfName);
                    break;
                }
                case 7: {
                    vRMLNodeType.setValue(n2, this.vfVisible, this.numVisible);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid fieldValue: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, boolean[] blArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 7: {
                this.setVisible(blArray, n2);
                break;
            }
            default: {
                super.setValue(n, blArray, n2);
            }
        }
    }

    public void setValue(int n, String string) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 6: {
                this.vfName = string;
                if (this.inSetup) break;
                this.hasChanged[6] = true;
                this.fireFieldChanged(6);
                break;
            }
            default: {
                super.setValue(n, string);
            }
        }
    }

    protected void setVisible(boolean[] blArray, int n) {
        if (n > this.vfVisible.length) {
            this.vfVisible = new boolean[blArray.length];
        }
        System.arraycopy(blArray, 0, this.vfVisible, 0, n);
        this.numVisible = n;
        if (!this.inSetup) {
            this.hasChanged[7] = true;
            this.fireFieldChanged(7);
        }
    }

    static {
        nodeFields = new int[]{1, 0};
        fieldDecl = new VRMLFieldDeclaration[8];
        fieldMap = new HashMap(8);
        BaseCADLayer.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseCADLayer.fieldDecl[1] = new VRMLFieldDeclaration(3, "MFNode", "children");
        BaseCADLayer.fieldDecl[2] = new VRMLFieldDeclaration(1, "MFNode", "addChildren");
        BaseCADLayer.fieldDecl[3] = new VRMLFieldDeclaration(1, "MFNode", "removeChildren");
        BaseCADLayer.fieldDecl[4] = new VRMLFieldDeclaration(2, "SFVec3f", "bboxCenter");
        BaseCADLayer.fieldDecl[5] = new VRMLFieldDeclaration(2, "SFVec3f", "bboxSize");
        BaseCADLayer.fieldDecl[7] = new VRMLFieldDeclaration(3, "MFBool", "visible");
        BaseCADLayer.fieldDecl[6] = new VRMLFieldDeclaration(3, "SFString", "name");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("children", n);
        fieldMap.put("set_children", n);
        fieldMap.put("children_changed", n);
        n = new Integer(2);
        fieldMap.put("addChildren", n);
        fieldMap.put("set_addChildren", n);
        n = new Integer(3);
        fieldMap.put("removeChildren", n);
        fieldMap.put("set_removeChildren", n);
        fieldMap.put("bboxCenter", new Integer(4));
        fieldMap.put("bboxSize", new Integer(5));
        n = new Integer(6);
        fieldMap.put("name", n);
        fieldMap.put("set_name", n);
        fieldMap.put("name_changed", n);
        n = new Integer(7);
        fieldMap.put("visible", n);
        fieldMap.put("set_visible", n);
        fieldMap.put("visible_changed", n);
    }
}

