/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes;

import org.web3d.image.NIOBufferImage;
import org.web3d.vrml.lang.InvalidFieldAccessException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLNode;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLTexture2DNodeType;
import org.web3d.vrml.nodes.VRMLTextureProperties2DNodeType;
import org.web3d.vrml.renderer.common.nodes.BaseTextureNode;

public abstract class BaseTexture2DNode
extends BaseTextureNode
implements VRMLTexture2DNodeType {
    protected static final int FIELD_REPEATS = 1;
    protected static final int FIELD_REPEATT = 2;
    protected static final int FIELD_TEXTURE_PROPERTIES = 3;
    protected static final int LAST_TEXTURENODETYPE_INDEX = 3;
    protected static final String TEXTURE_PROPS_PROTO_MSG = "Proto does not describe a TextureProperties object";
    protected static final String TEXTURE_PROPS_NODE_MSG = "Node does not describe a TextureProperties object";
    protected static final String TEXPROPS_VERSION_MSG = "The textureProperties field is not available before X3D V3.2";
    protected boolean vfRepeatS = true;
    protected boolean vfRepeatT = true;
    protected VRMLProtoInstance pTextureProperties;
    protected VRMLTextureProperties2DNodeType vfTextureProperties;
    protected NIOBufferImage implImage;

    public BaseTexture2DNode(String string) {
        super(string);
    }

    protected void copy(VRMLTexture2DNodeType vRMLTexture2DNodeType) {
        boolean bl;
        this.vfRepeatS = bl = vRMLTexture2DNodeType.getRepeatS();
        this.vfRepeatT = bl = vRMLTexture2DNodeType.getRepeatT();
    }

    public int getTextureType() {
        return 0;
    }

    public NIOBufferImage getImage() {
        return this.implImage;
    }

    public boolean getRepeatS() {
        return this.vfRepeatS;
    }

    public boolean getRepeatT() {
        return this.vfRepeatT;
    }

    public VRMLNodeType getTextureProperties() throws InvalidFieldException {
        if (this.vrmlMajorVersion <= 3 && this.vrmlMinorVersion < 2) {
            InvalidFieldException invalidFieldException = new InvalidFieldException(TEXPROPS_VERSION_MSG);
            invalidFieldException.setFieldName("TextureProperties");
            throw invalidFieldException;
        }
        if (this.pTextureProperties != null) {
            return this.pTextureProperties;
        }
        return this.vfTextureProperties;
    }

    public void setTextureProperties(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException, InvalidFieldException {
        if (this.vrmlMajorVersion <= 3 && this.vrmlMinorVersion < 2) {
            InvalidFieldException invalidFieldException = new InvalidFieldException(TEXPROPS_VERSION_MSG);
            invalidFieldException.setFieldName("TextureProperties");
            throw invalidFieldException;
        }
        Object object = this.pTextureProperties != null ? this.pTextureProperties : this.vfTextureProperties;
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            VRMLNodeType vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            while (vRMLNodeType2 != null && vRMLNodeType2 instanceof VRMLProtoInstance) {
                vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType2).getImplementationNode();
            }
            if (vRMLNodeType2 != null && !(vRMLNodeType2 instanceof VRMLTextureProperties2DNodeType)) {
                throw new InvalidFieldValueException(TEXTURE_PROPS_PROTO_MSG);
            }
            this.pTextureProperties = (VRMLProtoInstance)vRMLNodeType;
            this.vfTextureProperties = (VRMLTextureProperties2DNodeType)vRMLNodeType2;
        } else {
            if (vRMLNodeType != null && !(vRMLNodeType instanceof VRMLTextureProperties2DNodeType)) {
                throw new InvalidFieldValueException(TEXTURE_PROPS_NODE_MSG);
            }
            this.pTextureProperties = null;
            this.vfTextureProperties = (VRMLTextureProperties2DNodeType)vRMLNodeType;
        }
        if (vRMLNodeType != null) {
            this.updateRefs(vRMLNodeType, true);
        }
        if (object != null) {
            this.updateRefs((VRMLNodeType)object, false);
        }
        if (!this.inSetup) {
            if (object != null) {
                this.stateManager.registerRemovedNode((VRMLNode)object);
            }
            if (vRMLNodeType != null) {
                this.stateManager.registerAddedNode((VRMLNode)vRMLNodeType);
            }
            this.hasChanged[3] = true;
            this.fireFieldChanged(3);
        }
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        if (this.pTextureProperties != null) {
            this.pTextureProperties.setupFinished();
        } else if (this.vfTextureProperties != null) {
            this.vfTextureProperties.setupFinished();
        }
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 1: {
                vRMLFieldData.clear();
                vRMLFieldData.booleanValue = this.vfRepeatS;
                vRMLFieldData.dataType = 1;
                break;
            }
            case 2: {
                vRMLFieldData.clear();
                vRMLFieldData.booleanValue = this.vfRepeatT;
                vRMLFieldData.dataType = 1;
                break;
            }
            case 3: {
                if (this.vrmlMajorVersion <= 3 && this.vrmlMinorVersion < 2) {
                    InvalidFieldException invalidFieldException = new InvalidFieldException(TEXPROPS_VERSION_MSG);
                    invalidFieldException.setFieldName("TextureProperties");
                    throw invalidFieldException;
                }
                vRMLFieldData.clear();
                vRMLFieldData.nodeValue = this.pTextureProperties != null ? this.pTextureProperties : this.vfTextureProperties;
                vRMLFieldData.dataType = (short)7;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 3: {
                    if (this.pTextureProperties != null) {
                        vRMLNodeType.setValue(n2, (VRMLNodeType)this.pTextureProperties);
                        break;
                    }
                    vRMLNodeType.setValue(n2, (VRMLNodeType)this.vfTextureProperties);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field Value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, boolean bl) throws InvalidFieldException {
        if (!this.inSetup) {
            throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: ");
        }
        switch (n) {
            case 1: {
                this.vfRepeatS = bl;
                break;
            }
            case 2: {
                this.vfRepeatT = bl;
                break;
            }
            default: {
                super.setValue(n, bl);
            }
        }
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldException, InvalidFieldValueException {
        VRMLNodeType vRMLNodeType2 = vRMLNodeType;
        switch (n) {
            case 3: {
                this.setTextureProperties(vRMLNodeType2);
                break;
            }
            default: {
                super.setValue(n, vRMLNodeType);
            }
        }
    }
}

