/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes;

import org.j3d.geom.GeometryData;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.nodes.FrameStateListener;
import org.web3d.vrml.nodes.VRMLColorNodeType;
import org.web3d.vrml.nodes.VRMLCoordinateNodeType;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeComponentListener;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.renderer.common.nodes.BaseComponentGeometryNode;

public abstract class BasePointSetGeometryNode
extends BaseComponentGeometryNode {
    protected static final String COORD_PROTO_MSG = "Proto does not describe a Coord object";
    protected static final String COORD_NODE_MSG = "Node does not describe a Coord object";
    protected static final String COLOR_PROTO_MSG = "Proto does not describe a Color object";
    protected static final String COLOR_NODE_MSG = "Node does not describe a Color object";
    protected GeometryData geomData;

    protected BasePointSetGeometryNode(String string) {
        super(string);
        this.changeFlags = 0;
    }

    protected abstract void buildImpl();

    public void allEventsComplete() {
        this.buildImpl();
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        this.buildImpl();
    }

    public synchronized void notifyExternProtoLoaded(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        if (this.inSetup) {
            return;
        }
        switch (n) {
            case 2: {
                if (vRMLNodeType.getPrimaryType() != 9) {
                    throw new InvalidFieldValueException(COLOR_PROTO_MSG);
                }
                this.changeFlags |= 8;
                this.buildImpl();
                break;
            }
            case 1: {
                if (vRMLNodeType.getPrimaryType() != 11) {
                    throw new InvalidFieldValueException(COORD_PROTO_MSG);
                }
                this.changeFlags |= 1;
                this.buildImpl();
                break;
            }
            default: {
                System.out.println("BasePointSetGeometryNode: Unknown field for notifyExternProtoLoaded");
            }
        }
        this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldException, InvalidFieldValueException {
        VRMLNodeType vRMLNodeType2 = vRMLNodeType;
        boolean bl = false;
        switch (n) {
            case 1: {
                if (vRMLNodeType == null) {
                    this.pCoord = null;
                    if (this.vfCoord != null) {
                        this.vfCoord.removeComponentListener((VRMLNodeComponentListener)this);
                    }
                } else if (vRMLNodeType instanceof VRMLProtoInstance) {
                    this.pCoord = (VRMLProtoInstance)vRMLNodeType;
                    vRMLNodeType2 = this.pCoord.getImplementationNode();
                    if (!(vRMLNodeType2 instanceof VRMLCoordinateNodeType)) {
                        this.pCoord = null;
                        throw new InvalidFieldValueException(COORD_PROTO_MSG);
                    }
                } else if (!(vRMLNodeType2 instanceof VRMLCoordinateNodeType)) {
                    throw new InvalidFieldValueException(COORD_NODE_MSG);
                }
                this.vfCoord = (VRMLCoordinateNodeType)vRMLNodeType2;
                if (this.vfCoord != null) {
                    this.vfCoord.addComponentListener((VRMLNodeComponentListener)this);
                }
                this.changeFlags |= 1;
                bl = true;
                break;
            }
            case 2: {
                if (vRMLNodeType == null) {
                    this.pColor = null;
                    if (this.vfColor != null) {
                        this.vfColor.removeComponentListener((VRMLNodeComponentListener)this);
                    }
                } else if (vRMLNodeType instanceof VRMLProtoInstance) {
                    this.pColor = (VRMLProtoInstance)vRMLNodeType;
                    vRMLNodeType2 = this.pColor.getImplementationNode();
                    if (!(vRMLNodeType2 instanceof VRMLColorNodeType)) {
                        this.pColor = null;
                        throw new InvalidFieldValueException(COLOR_PROTO_MSG);
                    }
                } else if (!(vRMLNodeType2 instanceof VRMLColorNodeType)) {
                    throw new InvalidFieldValueException(COLOR_NODE_MSG);
                }
                this.vfColor = (VRMLColorNodeType)vRMLNodeType2;
                if (this.vfColor != null) {
                    this.vfColor.addComponentListener((VRMLNodeComponentListener)this);
                }
                this.changeFlags |= 8;
                bl = true;
                break;
            }
            default: {
                super.setValue(n, vRMLNodeType);
            }
        }
        if (!this.inSetup && bl) {
            this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
            this.hasChanged[n] = true;
            this.fireFieldChanged(n);
        }
    }

    protected void setCoordinateNode(VRMLCoordinateNodeType vRMLCoordinateNodeType) {
        if (this.inSetup) {
            return;
        }
        this.changeFlags |= 1;
        this.buildImpl();
    }

    protected void setColorNode(VRMLColorNodeType vRMLColorNodeType) {
        if (this.inSetup) {
            return;
        }
        this.changeFlags |= 8;
        this.buildImpl();
    }

    public void fieldChanged(VRMLNodeType vRMLNodeType, int n) {
        if (vRMLNodeType == this.vfCoord) {
            this.changeFlags |= 1;
            this.buildImpl();
        } else if (vRMLNodeType == this.vfColor) {
            this.changeFlags |= 8;
            this.buildImpl();
        } else {
            System.out.println("BasePointSetGeometryNode: Unknown field for fieldChanged");
        }
        this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
    }

    protected void updateCoordinateArray() {
        if (this.vfCoord == null) {
            this.geomData.vertexCount = 0;
        } else {
            this.geomData.vertexCount = this.vfCoord.getNumPoints() / 3;
            this.geomData.coordinates = this.vfCoord.getPointRef();
        }
    }

    protected void updateColorArray() {
        if (this.vfColor != null) {
            int n = this.vfColor.getFieldIndex("color");
            VRMLFieldData vRMLFieldData = this.vfColor.getFieldValue(n);
            this.geomData.colors = (float[])(vRMLFieldData.numElements != 0 ? vRMLFieldData.floatArrayValue : null);
        }
    }
}

