/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes;

import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.util.IntHashMap;
import org.web3d.vrml.lang.InvalidFieldAccessException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.TypeConstants;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.FrameStateManager;
import org.web3d.vrml.nodes.NodeListenerMulticaster;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLFieldDataThreaded;
import org.web3d.vrml.nodes.VRMLMetadataObjectNodeType;
import org.web3d.vrml.nodes.VRMLNodeListener;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;

public abstract class AbstractNode
implements VRMLNodeType {
    public static final int FIELD_METADATA = 0;
    public static final int LAST_NODE_INDEX = 0;
    private static final String VRML_META_MSG = "The metadata field is not valid in VRML97";
    protected static final String BAD_NODE_MSG = "The supplied node cannot be copied as it's type is wrong. The type supplied is ";
    protected static final String INIT_ONLY_WRITE_MSG = "You have attempted to write to an initializeOnly field: ";
    protected static final String METADATA_PROTO_MSG = "Proto does not describe a Metadata object";
    protected static final String METADATA_NODE_MSG = "Node does not describe a Metadata object";
    private static final String NO_LAYER_REF_MSG = "An attempt was made to decrement a reference count to a layer that is not currently referencing this node. Layer ID is ";
    protected final String nodeName;
    protected final ThreadLocal<VRMLFieldData> fieldLocalData;
    private final IntHashMap userData;
    protected ErrorReporter errorReporter;
    protected boolean[] hasChanged;
    protected boolean inSetup;
    protected boolean isDEF;
    protected boolean isStatic;
    protected int vrmlMajorVersion;
    protected int vrmlMinorVersion;
    protected FrameStateManager stateManager;
    private VRMLNodeListener nodeListener;
    protected int[] refCounts;
    protected int[] layerIds;
    protected int[] removedLayerIds;
    protected VRMLNodeType vfMetadata;
    protected VRMLProtoInstance pMetadata;

    public AbstractNode(String string) {
        this.nodeName = string;
        this.userData = new IntHashMap();
        this.fieldLocalData = new VRMLFieldDataThreaded();
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        this.inSetup = true;
        this.isDEF = false;
    }

    public void allEventsComplete() {
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }

    public String getVRMLNodeName() {
        return this.nodeName;
    }

    public boolean isDEF() {
        return this.isDEF;
    }

    public int[] getSecondaryType() {
        return TypeConstants.NO_SECONDARY_TYPE;
    }

    public void setVersion(int n, int n2, boolean bl) {
        this.vrmlMajorVersion = n;
        this.vrmlMinorVersion = n2;
        this.isStatic = bl;
    }

    public void setUserData(int n, Object object) throws InvalidFieldException {
        if (n < 0 || n > this.hasChanged.length) {
            throw new InvalidFieldException(this.getClass().getName() + " Invalid index in getUserData");
        }
        this.userData.put(n, object);
    }

    public Object getUserData(int n) throws InvalidFieldException {
        if (n < 0 || n > this.hasChanged.length) {
            throw new InvalidFieldException(this.getClass().getName() + " Invalid index in getUserData");
        }
        return this.userData.get(n);
    }

    public void setMetadataObject(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        if (this.vrmlMajorVersion == 2) {
            throw new InvalidFieldException(VRML_META_MSG);
        }
        if (vRMLNodeType == null) {
            this.vfMetadata = null;
            this.pMetadata = null;
        } else if (vRMLNodeType instanceof VRMLMetadataObjectNodeType) {
            this.vfMetadata = vRMLNodeType;
            this.pMetadata = null;
        } else if (vRMLNodeType instanceof VRMLProtoInstance) {
            VRMLProtoInstance vRMLProtoInstance = (VRMLProtoInstance)vRMLNodeType;
            VRMLNodeType vRMLNodeType2 = vRMLProtoInstance.getImplementationNode();
            while (vRMLNodeType2 != null && vRMLNodeType2 instanceof VRMLProtoInstance) {
                vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType2).getImplementationNode();
            }
            if (vRMLNodeType2 != null && !(vRMLNodeType2 instanceof VRMLMetadataObjectNodeType)) {
                throw new InvalidFieldValueException(METADATA_PROTO_MSG);
            }
            this.vfMetadata = vRMLNodeType2;
            this.pMetadata = vRMLProtoInstance;
        } else {
            throw new InvalidFieldValueException(METADATA_NODE_MSG);
        }
        if (!this.inSetup) {
            this.hasChanged[0] = true;
            this.fireFieldChanged(0);
        }
    }

    public VRMLNodeType getMetadataObject() {
        if (this.pMetadata != null) {
            return this.pMetadata;
        }
        return this.vfMetadata;
    }

    public boolean isSetupFinished() {
        return !this.inSetup;
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        if (this.pMetadata != null) {
            this.pMetadata.setupFinished();
        } else if (this.vfMetadata != null) {
            this.vfMetadata.setupFinished();
        }
        this.inSetup = false;
    }

    public void setDEF() {
        if (!this.inSetup) {
            throw new IllegalStateException("Can't set DEF now");
        }
        this.isDEF = true;
    }

    public int getRefCount(int n) {
        if (this.layerIds == null) {
            return 0;
        }
        int n2 = 0;
        for (int i = 0; i < this.layerIds.length; ++i) {
            if (this.layerIds[i] != n) continue;
            n2 = this.refCounts[i];
            break;
        }
        return n2;
    }

    public synchronized void updateRefCount(int n, boolean bl) {
        if (this.layerIds != null) {
            int n2 = -1;
            for (int i = 0; i < this.layerIds.length; ++i) {
                if (this.layerIds[i] != n) continue;
                n2 = i;
                break;
            }
            if (n2 == -1) {
                if (!bl) {
                    throw new IllegalStateException(NO_LAYER_REF_MSG + n);
                }
                int[] nArray = new int[this.layerIds.length + 1];
                System.arraycopy(this.layerIds, 0, nArray, 0, this.layerIds.length);
                nArray[this.layerIds.length] = n;
                this.layerIds = nArray;
                nArray = new int[this.refCounts.length + 1];
                System.arraycopy(this.refCounts, 0, nArray, 0, this.refCounts.length);
                nArray[this.refCounts.length] = 1;
                this.refCounts = nArray;
                int n3 = this.removedLayerIds == null ? 0 : this.removedLayerIds.length;
                for (int i = 0; i < n3; ++i) {
                    if (this.removedLayerIds[i] != n) continue;
                    if (n3 == 1) {
                        this.removedLayerIds = null;
                        continue;
                    }
                    int[] nArray2 = new int[n3 - 1];
                    System.arraycopy(this.removedLayerIds, 0, nArray2, 0, i - 1);
                    System.arraycopy(this.removedLayerIds, i + 1, nArray2, i, n3 - i - 1);
                    this.removedLayerIds = nArray2;
                }
            } else if (bl) {
                int n4 = n2;
                this.refCounts[n4] = this.refCounts[n4] + 1;
            } else {
                int n5 = n2;
                this.refCounts[n5] = this.refCounts[n5] - 1;
                if (this.refCounts[n2] <= 0) {
                    int n6;
                    int[] nArray = new int[this.refCounts.length - 1];
                    int[] nArray3 = new int[this.refCounts.length - 1];
                    for (n6 = 0; n6 < n2; ++n6) {
                        nArray[n6] = this.refCounts[n6];
                        nArray3[n6] = this.layerIds[n6];
                    }
                    for (n6 = n2 + 1; n6 < this.refCounts.length; ++n6) {
                        nArray[n6 - 1] = this.refCounts[n6];
                        nArray3[n6 - 1] = this.layerIds[n6];
                    }
                    this.refCounts = nArray;
                    this.layerIds = nArray3;
                    if (this.removedLayerIds == null) {
                        this.removedLayerIds = new int[]{n};
                    } else {
                        int[] nArray4 = new int[this.removedLayerIds.length + 1];
                        System.arraycopy(this.removedLayerIds, 0, nArray4, 0, this.removedLayerIds.length);
                        this.removedLayerIds = nArray4;
                    }
                }
                if (this.refCounts.length == 1 && this.refCounts[0] == 0) {
                    this.refCounts = null;
                    this.layerIds = null;
                }
            }
        } else {
            if (!bl) {
                throw new IllegalStateException(NO_LAYER_REF_MSG + n);
            }
            this.layerIds = new int[]{n};
            this.refCounts = new int[]{1};
        }
    }

    public int[] getLayerIds() {
        return this.layerIds;
    }

    public int[] getRemovedLayerIds() {
        return this.removedLayerIds;
    }

    public void clearRemovedLayerIds() {
        this.removedLayerIds = null;
    }

    public void setFrameStateManager(FrameStateManager frameStateManager) {
        this.stateManager = frameStateManager;
    }

    public boolean hasFieldChanged(int n) {
        boolean bl = false;
        if (n < 0 || n > this.hasChanged.length - 1) {
            return bl;
        }
        bl = this.hasChanged[n];
        this.hasChanged[n] = false;
        return bl;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            if (n == 0) {
                if (this.pMetadata != null) {
                    vRMLNodeType.setValue(n2, (VRMLNodeType)this.pMetadata);
                } else {
                    vRMLNodeType.setValue(n2, this.vfMetadata);
                }
            } else {
                this.errorReporter.warningReport("Invalid field " + n2 + " for AbstractNode.sendRoute", null);
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            this.errorReporter.warningReport("sendRoute: No field!" + invalidFieldException.getFieldName() + " in node " + vRMLNodeType.getVRMLNodeName(), null);
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            this.errorReporter.warningReport("sendRoute: Invalid field value.", (Exception)((Object)invalidFieldValueException));
        }
    }

    public void addNodeListener(VRMLNodeListener vRMLNodeListener) {
        this.nodeListener = NodeListenerMulticaster.add((VRMLNodeListener)this.nodeListener, (VRMLNodeListener)vRMLNodeListener);
    }

    public void removeNodeListener(VRMLNodeListener vRMLNodeListener) {
        this.nodeListener = NodeListenerMulticaster.remove((VRMLNodeListener)this.nodeListener, (VRMLNodeListener)vRMLNodeListener);
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = this.fieldLocalData.get();
        if (n != 0) {
            String string = "Unknown index";
            try {
                VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
                if (vRMLFieldDeclaration != null) {
                    string = vRMLFieldDeclaration.getName();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new InvalidFieldException("Invalid Index: " + n + " " + this.getClass().getName() + " fieldName: " + string);
        }
        vRMLFieldData.clear();
        vRMLFieldData.nodeValue = this.pMetadata != null ? this.pMetadata : this.vfMetadata;
        vRMLFieldData.dataType = (short)7;
        return vRMLFieldData;
    }

    public void setValue(int n, int n2) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        String string = "Unknown index";
        try {
            VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
            if (vRMLFieldDeclaration != null) {
                string = vRMLFieldDeclaration.getName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new InvalidFieldException(this.getClass().getName() + " setValue(int): Invalid Index: " + n + " fieldName: " + string);
    }

    public void setValue(int n, int[] nArray, int n2) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        String string = "Unknown index";
        try {
            VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
            if (vRMLFieldDeclaration != null) {
                string = vRMLFieldDeclaration.getName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new InvalidFieldException(this.getClass().getName() + " setValue(int[]): Invalid Index: " + n + " fieldName: " + string);
    }

    public void setValue(int n, boolean bl) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        String string = "Unknown index";
        try {
            VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
            if (vRMLFieldDeclaration != null) {
                string = vRMLFieldDeclaration.getName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new InvalidFieldException(this.getClass().getName() + " setValue(boolean): Invalid Index: " + n + " fieldName: " + string);
    }

    public void setValue(int n, boolean[] blArray, int n2) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        String string = "Unknown index";
        try {
            VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
            if (vRMLFieldDeclaration != null) {
                string = vRMLFieldDeclaration.getName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new InvalidFieldException(this.getClass().getName() + " setValue(boolean[]): Invalid Index: " + n + " fieldName: " + string);
    }

    public void setValue(int n, float f) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        String string = "Unknown index";
        try {
            VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
            if (vRMLFieldDeclaration != null) {
                string = vRMLFieldDeclaration.getName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new InvalidFieldException(this.getClass().getName() + " setValue(float): Invalid Index: " + n + " fieldName: " + string);
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        String string = "Unknown index";
        try {
            VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
            if (vRMLFieldDeclaration != null) {
                string = vRMLFieldDeclaration.getName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new InvalidFieldException(this.getClass().getName() + " setValue(float[]): Invalid Index: " + n + " fieldName: " + string);
    }

    public void setValue(int n, long l) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        String string = "Unknown index";
        try {
            VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
            if (vRMLFieldDeclaration != null) {
                string = vRMLFieldDeclaration.getName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new InvalidFieldException(this.getClass().getName() + " setValue(long): Invalid Index: " + n + " fieldName: " + string);
    }

    public void setValue(int n, long[] lArray, int n2) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        String string = "Unknown index";
        try {
            VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
            if (vRMLFieldDeclaration != null) {
                string = vRMLFieldDeclaration.getName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new InvalidFieldException(this.getClass().getName() + " setValue(long[]): Invalid Index: " + n + " fieldName: " + string);
    }

    public void setValue(int n, double d) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        String string = "Unknown index";
        try {
            VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
            if (vRMLFieldDeclaration != null) {
                string = vRMLFieldDeclaration.getName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new InvalidFieldException(this.getClass().getName() + " setValue(double): Invalid Index: " + n + " fieldName: " + string);
    }

    public void setValue(int n, double[] dArray, int n2) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        String string = "Unknown index";
        try {
            VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
            if (vRMLFieldDeclaration != null) {
                string = vRMLFieldDeclaration.getName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new InvalidFieldException(this.getClass().getName() + " setValue(double[]): Invalid Index: " + n + " fieldName: " + string);
    }

    public void setValue(int n, String string) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        String string2 = "Unknown index";
        try {
            VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
            if (vRMLFieldDeclaration != null) {
                string2 = vRMLFieldDeclaration.getName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new InvalidFieldException(this.getClass().getName() + " setValue(String): Invalid Index: " + n + " fieldName: " + string2);
    }

    public void setValue(int n, String[] stringArray, int n2) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        String string = "Unknown index";
        try {
            VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
            if (vRMLFieldDeclaration != null) {
                string = vRMLFieldDeclaration.getName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new InvalidFieldException(this.getClass().getName() + " setValue(String): Invalid Index: " + n + " fieldName: " + string);
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        if (n != 0) {
            String string = "Unknown index";
            try {
                VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
                if (vRMLFieldDeclaration != null) {
                    string = vRMLFieldDeclaration.getName();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new InvalidFieldException(this.getClass().getName() + " setValue(VRMLNode): Invalid Index: " + n + " fieldName: " + string);
        }
        this.setMetadataObject(vRMLNodeType);
    }

    public void setValue(int n, VRMLNodeType[] vRMLNodeTypeArray, int n2) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        String string = "Unknown index";
        try {
            VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
            if (vRMLFieldDeclaration != null) {
                string = vRMLFieldDeclaration.getName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new InvalidFieldException(this.getClass().getName() + " setValue(VRMLNode[]): Invalid Index: " + n + " fieldName: " + string);
    }

    public void notifyExternProtoLoaded(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        this.errorReporter.messageReport(this.nodeName + " notifyExternProtoLoaded not implemented.");
    }

    protected void fireFieldChanged(int n) {
        if (this.nodeListener != null) {
            try {
                this.nodeListener.fieldChanged(n);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    protected void checkNodeType(VRMLNodeType vRMLNodeType) {
        String string = vRMLNodeType.getVRMLNodeName();
        if (!string.equals(this.nodeName)) {
            throw new IllegalArgumentException("The supplied node cannot be copied as it's type is wrong. The type supplied is type");
        }
    }

    protected static void checkSecondaryType(VRMLNodeType vRMLNodeType, int n, String string) {
        int[] nArray = vRMLNodeType.getSecondaryType();
        boolean bl = false;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            bl = true;
            break;
        }
        if (!bl) {
            throw new InvalidFieldValueException(string);
        }
    }

    protected static void checkSecondaryType(VRMLNodeType vRMLNodeType, int[] nArray, String string) {
        int[] nArray2 = vRMLNodeType.getSecondaryType();
        boolean bl = false;
        int n = nArray2.length;
        int n2 = nArray.length;
        block0: for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (nArray2[i] != nArray[j]) continue;
                bl = true;
                continue block0;
            }
        }
        if (!bl) {
            throw new InvalidFieldValueException(string);
        }
    }

    protected void updateRefs(VRMLNodeType vRMLNodeType, boolean bl) {
        if (this.layerIds == null) {
            return;
        }
        for (int i = 0; i < this.layerIds.length; ++i) {
            vRMLNodeType.updateRefCount(this.layerIds[i], bl);
        }
    }
}

