/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.input.dis;

import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple4d;
import javax.vecmath.Vector3d;
import org.web3d.vrml.renderer.common.input.dis.RungeKuttaSolver;
import org.web3d.vrml.renderer.common.input.dis.Solver;
import org.web3d.vrml.renderer.common.input.dis.SolverTarget;

public class Quat4dVariable
implements SolverTarget {
    private Quat4d value = new Quat4d();
    private Vector3d[] derivatives;
    private long referenceTime;
    private Solver solver;
    double[] state;
    double[] results;
    Quat4d q1;
    Quat4d q2;

    public Quat4dVariable(int n, Solver solver) {
        this.derivatives = new Vector3d[n];
        for (int i = 0; i < n; ++i) {
            this.derivatives[i] = new Vector3d();
        }
        this.state = new double[4 + n * 3];
        this.results = new double[4 + n * 3];
        this.solver = solver != null ? solver : new RungeKuttaSolver(this.state.length);
    }

    public void set(Quat4d quat4d, Vector3d[] vector3dArray, long l) {
        this.value.set((Tuple4d)quat4d);
        this.referenceTime = l;
        for (int i = 0; i < this.derivatives.length; ++i) {
            if (i < vector3dArray.length) {
                this.derivatives[i].set((Tuple3d)vector3dArray[i]);
                continue;
            }
            this.derivatives[i].set(0.0, 0.0, 0.0);
        }
    }

    public void set(Quat4dVariable quat4dVariable) {
        this.value.set((Tuple4d)quat4dVariable.value);
        this.referenceTime = quat4dVariable.referenceTime;
        for (int i = 0; i < this.derivatives.length; ++i) {
            this.derivatives[i].set((Tuple3d)quat4dVariable.derivatives[i]);
        }
    }

    public void interpolate(Quat4dVariable quat4dVariable, Quat4dVariable quat4dVariable2, double d, long l) {
        if (l > this.referenceTime) {
            quat4dVariable.makeCurrent(l);
            quat4dVariable2.makeCurrent(l);
            this.value.interpolate(quat4dVariable.value, quat4dVariable2.value, d);
            for (int i = 0; i < this.derivatives.length; ++i) {
                this.derivatives[i].interpolate((Tuple3d)quat4dVariable.derivatives[i], (Tuple3d)quat4dVariable2.derivatives[i], d);
            }
            this.referenceTime = l;
        }
    }

    public void makeCurrent(long l) {
        if (l > this.referenceTime) {
            double d = (double)(l - this.referenceTime) / 1000.0;
            this.encodeState();
            this.solver.solve(this, this.state, d, 0.001, this.results);
            this.decodeState(this.results);
            this.referenceTime = l;
        }
    }

    public void encodeState() {
        this.state[0] = this.value.x;
        this.state[1] = this.value.y;
        this.state[2] = this.value.z;
        this.state[3] = this.value.w;
        int n = 4;
        int n2 = 0;
        while (n < this.state.length) {
            this.state[n] = this.derivatives[n2].x;
            this.state[n + 1] = this.derivatives[n2].y;
            this.state[n + 2] = this.derivatives[n2].z;
            n += 3;
            ++n2;
        }
    }

    public void decodeState(double[] dArray) {
        this.value.x = dArray[0];
        this.value.y = dArray[1];
        this.value.z = dArray[2];
        this.value.w = dArray[3];
        this.value.normalize();
        int n = 4;
        int n2 = 0;
        while (n < dArray.length) {
            this.derivatives[n2].set(dArray[n], dArray[n + 1], dArray[n + 2]);
            n += 3;
            ++n2;
        }
    }

    public void getValue(Quat4d quat4d) {
        quat4d.set((Tuple4d)this.value);
    }

    public void getDerivatives(Vector3d[] vector3dArray) {
        for (int i = 0; i < vector3dArray.length; ++i) {
            if (i < this.derivatives.length) {
                vector3dArray[i].set((Tuple3d)this.derivatives[i]);
                continue;
            }
            vector3dArray[i].set(0.0, 0.0, 0.0);
        }
    }

    public void getRatesOfChange(double[] dArray, double d, double[] dArray2) {
        if (this.q1 == null) {
            this.q1 = new Quat4d();
            this.q2 = new Quat4d();
        }
        this.q1.x = dArray[0];
        this.q1.y = dArray[1];
        this.q1.z = dArray[2];
        this.q1.w = dArray[3];
        this.q2.x = dArray[4];
        this.q2.y = dArray[5];
        this.q2.z = dArray[6];
        this.q2.w = 0.0;
        this.q2.mul(this.q1);
        this.q2.scale(0.5);
        dArray2[0] = this.q2.x;
        dArray2[1] = this.q2.y;
        dArray2[2] = this.q2.z;
        dArray2[3] = this.q2.w;
        for (int i = 4; i < dArray.length - 3; i += 3) {
            dArray2[i] = dArray[i + 3];
            dArray2[i + 1] = dArray[i + 4];
            dArray2[i + 2] = dArray[i + 5];
        }
        dArray2[i] = 0.0;
        dArray2[i + 1] = 0.0;
        dArray2[i + 2] = 0.0;
    }
}

