/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.input.dis;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.FromContainsFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.muc.DiscussionHistory;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.web3d.util.PropertyTools;
import org.web3d.vrml.nodes.VRMLDISManagerNodeType;
import org.web3d.vrml.nodes.VRMLDISNodeType;
import org.web3d.vrml.renderer.common.input.dis.DISId;
import org.web3d.vrml.renderer.common.input.dis.LinkedList;
import org.web3d.vrml.renderer.common.input.dis.ListEntry;
import org.web3d.vrml.renderer.common.input.dis.LiveListEntryDX;
import org.web3d.vrml.renderer.common.input.dis.NodeMapEntry;
import org.web3d.vrml.renderer.common.input.dis.OrderNQuat4dConverger;
import org.web3d.vrml.renderer.common.input.dis.OrderNVector3dConverger;
import org.web3d.xmsf.dis.EntityIDType;
import org.web3d.xmsf.dis.EntityStatePduType;
import org.web3d.xmsf.dis.HeaderType;
import org.web3d.xmsf.dis.ProtocolDataUnitType;
import org.web3d.xmsf.dis.Vector3Double;
import org.web3d.xmsf.disutil.DisMarshaller;
import org.web3d.xmsf.disutil.DisUnmarshaller;

class DISXMLConnectionHandler
implements PacketListener {
    private static final int DEFAULT_ORDER = 2;
    private static final int DEFAULT_CONVERGENCE_INTERVAL = 200;
    private static final String USERNAME_PROP = "org.web3d.vrml.renderer.common.input.dis.username";
    private static final String DEFAULT_USERNAME = "guest";
    private static final String PASSWORD_PROP = "org.web3d.vrml.renderer.common.input.dis.password";
    private static final String DEFAULT_PASSWORD = "guest";
    private static String username;
    private static String password;
    private DatagramSocket socket;
    InetAddress address;
    Thread readThread;
    private int port;
    private String group;
    int cnt;
    private LinkedList liveList;
    private DISId disId;
    private float[] translation;
    private float[] rotation;
    private float[] dRorientation;
    private Map nodeMap;
    private List managerList;
    private Set notifiedSet;
    private XMPPConnection connection;
    private MultiUserChat load;
    private PacketFilter filter;
    private DisUnmarshaller disUnmarshaller;
    private boolean live;
    private static long simStartTime;
    DisMarshaller marshaller;
    private final String xmppUsername;
    private final String xmppPassword;
    private final String[] xmppAuthServer;
    private final String xmppMucServer;
    private final String xmppMucRoom;
    int idx = 0;

    public DISXMLConnectionHandler(Map map, LinkedList linkedList, List list, Set set, String string, int n, String string2, String string3, String[] stringArray, String string4, String string5) {
        this.nodeMap = map;
        this.group = string;
        this.port = n;
        this.liveList = linkedList;
        this.managerList = list;
        this.notifiedSet = set;
        this.disUnmarshaller = new DisUnmarshaller();
        this.live = false;
        this.xmppUsername = string2 != null ? string2 : username;
        this.xmppPassword = string3 != null ? string3 : password;
        this.xmppAuthServer = stringArray;
        this.xmppMucServer = string4;
        this.xmppMucRoom = string5;
        this.disId = new DISId(0, 0, 0);
        this.translation = new float[3];
        this.rotation = new float[4];
        this.dRorientation = new float[3];
        this.marshaller = new DisMarshaller();
        try {
            System.out.println("DISXML Listening to port: " + n + " group: " + string);
            this.address = InetAddress.getByName(string);
            try {
                this.socket = new MulticastSocket(n);
                ((MulticastSocket)this.socket).joinGroup(this.address);
            }
            catch (Exception exception) {
                System.out.println("Failed to listen to multicast port.  Trying unicast");
                this.socket.close();
                this.socket = new DatagramSocket(n);
            }
            Thread thread = new Thread(){

                public void run() {
                    System.out.println("XMPP Params: " + DISXMLConnectionHandler.this.xmppAuthServer + " " + DISXMLConnectionHandler.this.xmppMucRoom);
                    DISXMLConnectionHandler.this.login(DISXMLConnectionHandler.this.xmppUsername, DISXMLConnectionHandler.this.xmppPassword, DISXMLConnectionHandler.this.xmppAuthServer, DISXMLConnectionHandler.this.xmppMucServer, DISXMLConnectionHandler.this.xmppMucRoom);
                }
            };
            thread.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void login(String string, String string2, String[] stringArray, String string3, String string4) {
        try {
            System.out.println("Attempting login: " + string);
            String string5 = "xj3d_" + Integer.toString((int)(Math.random() * 2.147483647E9), 36);
            if (stringArray == null || string3 == null || string4 == null) {
                System.out.println("Invalid XMPP params.  Using defaults for now");
                stringArray = new String[]{"surfaris.cs.nps.navy.mil", "xchat.movesinstitute.org"};
                string3 = "conference.xchat.movesinstitute.org";
                string4 = "auvw";
            }
            block6: for (int i = 2; this.connection == null && i > 0; --i) {
                for (int j = 0; j < stringArray.length; ++j) {
                    try {
                        System.out.println("Xj3D trying authServer: " + stringArray[j]);
                        this.connection = new XMPPConnection(stringArray[j]);
                        this.connection.login(string, string2, string5);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (this.connection == null) continue;
                    System.out.println("Xj3D connected to: " + stringArray[j]);
                    continue block6;
                }
            }
            String string6 = string4 + "@" + string3;
            System.out.println("Xj3D Connecting to MUC room: " + string6);
            DiscussionHistory discussionHistory = new DiscussionHistory();
            discussionHistory.setMaxStanzas(0);
            this.load = new MultiUserChat(this.connection, string6);
            boolean bl = false;
            System.out.println("Xj3D Logging into chatroom with username: " + string + string5);
            for (int i = 0; !bl && i < 5; ++i) {
                try {
                    this.load.join(string + string5, string2, discussionHistory, (long)SmackConfiguration.getPacketReplyTimeout());
                    bl = this.load.isJoined();
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("Failed to connect, retrying");
                    System.out.println("Msg: " + exception);
                }
            }
            if (this.load.isJoined()) {
                System.out.println("Xj3D successfully joined chat");
                AndFilter andFilter = new AndFilter((PacketFilter)new PacketTypeFilter(Message.class), (PacketFilter)new FromContainsFilter(string6));
                this.connection.addPacketListener((PacketListener)this, (PacketFilter)andFilter);
                this.live = true;
            } else {
                System.out.println("***Couldn't join chat room");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void processPacket(Packet packet) {
        Iterator iterator = packet.getPropertyNames();
        if (!iterator.hasNext()) {
            System.out.println("empty properties in packet");
            return;
        }
        String string = (String)packet.getProperty("messageType");
        if (string == null) {
            return;
        }
        if (string.equalsIgnoreCase("dis")) {
            String string2 = (String)packet.getProperty("disInformation");
            String string3 = (String)packet.getProperty("disFormat");
            if (string3.equalsIgnoreCase("xml")) {
                try {
                    List list = this.disUnmarshaller.unmarshallFromXML((InputStream)new ByteArrayInputStream(string2.getBytes()));
                    for (int i = 0; i < list.size(); ++i) {
                        Object object;
                        ProtocolDataUnitType protocolDataUnitType = (ProtocolDataUnitType)list.get(i);
                        EntityStatePduType entityStatePduType = (EntityStatePduType)protocolDataUnitType;
                        EntityIDType entityIDType = entityStatePduType.getEntityID();
                        this.disId.setValue(entityIDType.getSite(), entityIDType.getApplication(), entityIDType.getEntity());
                        NodeMapEntry nodeMapEntry = (NodeMapEntry)this.nodeMap.get(this.disId);
                        if (nodeMapEntry == null) {
                            int n = this.managerList.size();
                            for (int j = 0; j < n; ++j) {
                                object = (VRMLDISManagerNodeType)this.managerList.get(j);
                                if (this.notifiedSet.contains(this.disId)) continue;
                                object.entityArrived(entityStatePduType);
                                this.notifiedSet.add(this.disId.clone());
                            }
                            return;
                        }
                        VRMLDISNodeType vRMLDISNodeType = nodeMapEntry.node;
                        if (vRMLDISNodeType.getRole() != 0) {
                            System.out.println("Ignoring ESPDU");
                            return;
                        }
                        long l = System.currentTimeMillis();
                        HeaderType headerType = protocolDataUnitType.getPduHeader();
                        long l2 = headerType.getTimestamp();
                        if (vRMLDISNodeType == null) continue;
                        if (nodeMapEntry.listEntry != null) {
                            object = (LiveListEntryDX)nodeMapEntry.listEntry;
                            if (l2 > object.espduTimestamp) {
                                object.avgTime += (float)(l - object.lastTime) / 5.0f;
                                object.lastTime = l;
                                object.lastEspdu = object.currEspdu;
                                object.currEspdu = entityStatePduType;
                                object.closeEnough = false;
                                object.newPackets = true;
                                continue;
                            }
                            System.out.println("Tossing packet: " + l2 + " last: " + object.espduTimestamp);
                            continue;
                        }
                        object = new LiveListEntryDX(vRMLDISNodeType, System.currentTimeMillis());
                        nodeMapEntry.listEntry = object;
                        object.lastEspdu = entityStatePduType;
                        object.currEspdu = entityStatePduType;
                        object.rotationConverger = new OrderNQuat4dConverger(2, 200, null);
                        object.translationConverger = new OrderNVector3dConverger(2, 200, null);
                        object.espduTimestamp = l2;
                        object.closeEnough = false;
                        object.avgTime = 0.01f;
                        object.newPackets = true;
                        this.liveList.add((ListEntry)object);
                        vRMLDISNodeType.setIsActive(true);
                    }
                }
                catch (Exception exception) {
                    System.out.println("Can't reconsitute XML XMPP information " + exception);
                    exception.printStackTrace();
                }
            }
        }
    }

    public void write(ProtocolDataUnitType protocolDataUnitType) {
        if (!this.live) {
            return;
        }
        protocolDataUnitType.getPduHeader().setTimestamp((long)((int)(System.currentTimeMillis() - simStartTime)));
        try {
            ArrayList<ProtocolDataUnitType> arrayList = new ArrayList<ProtocolDataUnitType>();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            arrayList.add(protocolDataUnitType);
            Vector3Double vector3Double = ((EntityStatePduType)protocolDataUnitType).getEntityLocation();
            System.out.println("Write pdu: " + protocolDataUnitType + " Loc: " + vector3Double.getX() + " " + vector3Double.getZ());
            this.marshaller.marshallPdus(arrayList, (OutputStream)byteArrayOutputStream);
            String string = byteArrayOutputStream.toString();
            Message message = this.load.createMessage();
            message.setProperty("disInformation", (Object)string);
            message.setProperty("messageType", (Object)"dis");
            message.setProperty("disFormat", (Object)"xml");
            this.load.sendMessage(message);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        simStartTime = System.currentTimeMillis() - 86400000L;
        username = PropertyTools.fetchSystemProperty((String)USERNAME_PROP, (String)"guest");
        password = PropertyTools.fetchSystemProperty((String)PASSWORD_PROP, (String)"guest");
    }
}

