/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.geospatial;

import java.util.HashMap;
import javax.units.NonSI;
import javax.units.SI;
import javax.units.Unit;
import org.geotools.factory.Hints;
import org.geotools.referencing.FactoryFinder;
import org.geotools.referencing.factory.FactoryGroup;
import org.geotools.referencing.factory.GeotoolsFactory;
import org.geotools.referencing.operation.matrix.Matrix4;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.datum.VerticalDatumType;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.web3d.util.HashSet;

public class GTTransformUtils {
    private static final String SELENOGRAPHIC_ID = "GCS_Moon_2000";
    private static final String SELENOCENTRIC_ID = "Selenocentric_Fixed";
    private static final String LUNAR_WKT = "GEOGCS[\"GCS_Moon_2000\",DATUM[\"D_Moon_2000\",SPHEROID[\"Moon_2000_IAU_IAG\",1737400.0,0.0]],PRIMEM[\"Reference_Meridian\",0.0],UNIT[\"Degree\",0.0174532925199433]]";
    private static final HashSet<String> allEllipsoidSet = new HashSet();
    private static final Unit DEGREE;
    private static GTTransformUtils instance;
    private CoordinateOperationFactory transformFactory;
    private CRSFactory crsFactory;
    private CSFactory csFactory;
    private DatumFactory datumFactory;
    private MathTransformFactory mathFactory;
    private FactoryGroup factoryHelper;
    private CoordinateReferenceSystem outputCRS;
    private CoordinateReferenceSystem heightOnlyCRS;
    private CoordinateReferenceSystem geodeticCRS;
    private CoordinateSystemAxis northAxis;
    private CoordinateSystemAxis eastAxis;
    private CoordinateSystemAxis heightAxis;
    private VerticalDatum amslVertical;
    private VerticalDatum defaultVertical;
    private PrimeMeridian greenwichMeridian;
    private Ellipsoid wgs84Ellipsoid;
    private GeodeticDatum wgs84EllipsoidHD;
    private CartesianCS utmCartesianCS;
    private GeographicCRS utmGeographicCRS;
    private HashSet<String> csDefs;
    private HashMap<String, Ellipsoid> cachedEllipsoidMap;
    private HashMap<String, CoordinateOperation> utmZoneMap;
    private CoordinateReferenceSystem selenocentric;
    private CoordinateReferenceSystem selenodetic;

    private GTTransformUtils() throws FactoryException {
        Hints hints = new Hints(null);
        this.transformFactory = FactoryFinder.getCoordinateOperationFactory((Hints)hints);
        this.datumFactory = FactoryFinder.getDatumFactory((Hints)hints);
        this.crsFactory = FactoryFinder.getCRSFactory((Hints)hints);
        this.mathFactory = FactoryFinder.getMathTransformFactory((Hints)hints);
        this.factoryHelper = new FactoryGroup(this.datumFactory, this.csFactory, this.crsFactory, this.mathFactory);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("name", "Greenwich Meridian");
        this.greenwichMeridian = this.datumFactory.createPrimeMeridian(hashMap, 0.0, DEGREE);
        hashMap = new HashMap();
        hashMap.put("name", "WGS 84");
        this.wgs84Ellipsoid = this.datumFactory.createFlattenedSphere(hashMap, 6378137.0, 298.257223563, (Unit)SI.METER);
        this.csDefs = new HashSet();
        this.utmZoneMap = new HashMap();
        this.cachedEllipsoidMap = new HashMap();
        this.cachedEllipsoidMap.put("WE", this.wgs84Ellipsoid);
        this.csFactory = FactoryFinder.getCSFactory((Hints)hints);
        hashMap = new HashMap();
        hashMap.put("name", "Geocentric X");
        CoordinateSystemAxis coordinateSystemAxis = this.csFactory.createCoordinateSystemAxis(hashMap, "X", AxisDirection.GEOCENTRIC_X, (Unit)SI.METER);
        hashMap = new HashMap();
        hashMap.put("name", "Geocentric Y");
        CoordinateSystemAxis coordinateSystemAxis2 = this.csFactory.createCoordinateSystemAxis(hashMap, "Y", AxisDirection.GEOCENTRIC_Y, (Unit)SI.METER);
        hashMap = new HashMap();
        hashMap.put("name", "Geocentric Z");
        CoordinateSystemAxis coordinateSystemAxis3 = this.csFactory.createCoordinateSystemAxis(hashMap, "Z", AxisDirection.GEOCENTRIC_Z, (Unit)SI.METER);
        hashMap = new HashMap();
        hashMap.put("name", "X");
        CoordinateSystemAxis coordinateSystemAxis4 = this.csFactory.createCoordinateSystemAxis(hashMap, "X", AxisDirection.OTHER, (Unit)SI.METER);
        hashMap = new HashMap();
        hashMap.put("name", "Y");
        CoordinateSystemAxis coordinateSystemAxis5 = this.csFactory.createCoordinateSystemAxis(hashMap, "Y", AxisDirection.EAST, (Unit)SI.METER);
        CoordinateSystemAxis coordinateSystemAxis6 = this.csFactory.createCoordinateSystemAxis(hashMap, "Y", AxisDirection.WEST, (Unit)SI.METER);
        hashMap = new HashMap();
        hashMap.put("name", "Z");
        CoordinateSystemAxis coordinateSystemAxis7 = this.csFactory.createCoordinateSystemAxis(hashMap, "Z", AxisDirection.NORTH, (Unit)SI.METER);
        hashMap = new HashMap();
        hashMap.put("name", "Geodetic Lattitude");
        this.northAxis = this.csFactory.createCoordinateSystemAxis(hashMap, "N", AxisDirection.NORTH, NonSI.DEGREE_ANGLE);
        hashMap = new HashMap();
        hashMap.put("name", "Geodetic Longitude");
        this.eastAxis = this.csFactory.createCoordinateSystemAxis(hashMap, "E", AxisDirection.EAST, NonSI.DEGREE_ANGLE);
        hashMap = new HashMap();
        hashMap.put("name", "Ellipsoidal height");
        this.heightAxis = this.csFactory.createCoordinateSystemAxis(hashMap, "Up", AxisDirection.UP, (Unit)SI.METER);
        hashMap = new HashMap();
        hashMap.put("name", "Northing");
        CoordinateSystemAxis coordinateSystemAxis8 = this.csFactory.createCoordinateSystemAxis(hashMap, "N", AxisDirection.NORTH, (Unit)SI.METER);
        hashMap = new HashMap();
        hashMap.put("name", "Easting");
        CoordinateSystemAxis coordinateSystemAxis9 = this.csFactory.createCoordinateSystemAxis(hashMap, "E", AxisDirection.EAST, (Unit)SI.METER);
        hashMap = new HashMap();
        hashMap.put("name", "Rendered Cartesian CS");
        CartesianCS cartesianCS = this.csFactory.createCartesianCS(hashMap, coordinateSystemAxis4, coordinateSystemAxis7, coordinateSystemAxis6);
        hashMap = new HashMap();
        hashMap.put("name", "WGS84 Height Datum");
        this.wgs84EllipsoidHD = this.datumFactory.createGeodeticDatum(hashMap, this.wgs84Ellipsoid, this.greenwichMeridian);
        hashMap = new HashMap();
        hashMap.put("name", "Output Cartesian CS");
        this.outputCRS = this.crsFactory.createGeocentricCRS(hashMap, this.wgs84EllipsoidHD, cartesianCS);
        hashMap = new HashMap();
        hashMap.put("name", "UTM Cartesian CS");
        this.utmCartesianCS = this.csFactory.createCartesianCS(hashMap, coordinateSystemAxis9, coordinateSystemAxis8, this.heightAxis);
        hashMap = new HashMap();
        hashMap.put("name", "Geodetic reference cartesian CS");
        CartesianCS cartesianCS2 = this.csFactory.createCartesianCS(hashMap, coordinateSystemAxis, coordinateSystemAxis2, coordinateSystemAxis3);
        hashMap = new HashMap();
        hashMap.put("name", "X3D Geodetic CRS");
        this.geodeticCRS = this.crsFactory.createGeocentricCRS(hashMap, this.wgs84EllipsoidHD, cartesianCS2);
        hashMap = new HashMap();
        hashMap.put("name", "WGS84 Ellispoidal height");
        this.defaultVertical = this.datumFactory.createVerticalDatum(hashMap, VerticalDatumType.ELLIPSOIDAL);
        hashMap = new HashMap();
        hashMap.put("name", "UTM geodetic");
        EllipsoidalCS ellipsoidalCS = this.csFactory.createEllipsoidalCS(hashMap, this.eastAxis, this.northAxis, this.heightAxis);
        hashMap = new HashMap();
        hashMap.put("name", "3D geographic CRS");
        this.utmGeographicCRS = this.crsFactory.createGeographicCRS(hashMap, this.wgs84EllipsoidHD, ellipsoidalCS);
        hashMap = new HashMap();
        hashMap.put("name", "UTM Height CS");
        VerticalCS verticalCS = this.csFactory.createVerticalCS(hashMap, this.heightAxis);
        hashMap = new HashMap();
        hashMap.put("name", "UTM WGS84 Height CRS");
        this.heightOnlyCRS = this.crsFactory.createVerticalCRS(hashMap, this.defaultVertical, verticalCS);
    }

    public static GTTransformUtils getInstance() throws FactoryException {
        if (instance == null) {
            instance = new GTTransformUtils();
        }
        return instance;
    }

    public synchronized MathTransform createSystemTransform(String[] stringArray, boolean[] blArray) throws FactoryException {
        for (int i = 0; i < stringArray.length; ++i) {
            this.csDefs.add((Object)stringArray[i]);
        }
        MathTransform mathTransform = null;
        if (this.csDefs.contains((Object)"GC") || this.csDefs.contains((Object)"GCC") || this.csDefs.contains((Object)SELENOCENTRIC_ID)) {
            mathTransform = this.mathFactory.createAffineTransform((Matrix)new Matrix4());
            blArray[0] = false;
        } else if (this.csDefs.contains((Object)SELENOGRAPHIC_ID)) {
            mathTransform = this.createLunarSystemTransform();
            blArray[0] = false;
        } else {
            CoordinateOperation coordinateOperation = this.createCoordSystem(stringArray, blArray);
            mathTransform = coordinateOperation.getMathTransform();
        }
        this.csDefs.clear();
        return mathTransform;
    }

    private CoordinateOperation createCoordSystem(String[] stringArray, boolean[] blArray) throws FactoryException {
        CoordinateOperation coordinateOperation = null;
        if (this.csDefs.contains((Object)"GD") || this.csDefs.contains((Object)"GDC")) {
            EllipsoidalCS ellipsoidalCS;
            blArray[0] = false;
            Ellipsoid ellipsoid = this.fetchEllipsoid(stringArray);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            if (this.csDefs.contains((Object)"longitude_first")) {
                hashMap.put("name", "<long>,<lat> geodetic");
                ellipsoidalCS = this.csFactory.createEllipsoidalCS(hashMap, this.eastAxis, this.northAxis, this.heightAxis);
            } else {
                hashMap.put("name", "<long>,<lat> geodetic");
                ellipsoidalCS = this.csFactory.createEllipsoidalCS(hashMap, this.northAxis, this.eastAxis, this.heightAxis);
            }
            if (this.csDefs.contains((Object)"WGS84")) {
                System.out.println("Geospatial cannont handle WGS84 geoid heights yet");
            }
            hashMap = new HashMap();
            hashMap.put("name", "Map for geoSystem");
            GeographicCRS geographicCRS = this.crsFactory.createGeographicCRS(hashMap, this.wgs84EllipsoidHD, ellipsoidalCS);
            coordinateOperation = this.transformFactory.createOperation((CoordinateReferenceSystem)geographicCRS, this.outputCRS);
        } else if (!this.csDefs.contains((Object)"GC") && !this.csDefs.contains((Object)"GCC") && this.csDefs.contains((Object)"UTM")) {
            int n;
            String string = null;
            String string2 = null;
            boolean bl = false;
            for (n = 1; n < stringArray.length; ++n) {
                if (stringArray[n].charAt(0) == 'Z') {
                    string2 = stringArray[n];
                    string = stringArray[n].substring(1);
                    continue;
                }
                if (stringArray[n].charAt(0) != 'S') continue;
                bl = true;
            }
            if (string == null) {
                throw new IllegalArgumentException("No UTM zone specified");
            }
            blArray[0] = !this.csDefs.contains((Object)"easting_first");
            coordinateOperation = this.utmZoneMap.get(string2);
            if (coordinateOperation != null) {
                return coordinateOperation;
            }
            n = 0;
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("UTM zone number not an integer");
            }
            if (n < 0 || n > 60) {
                throw new IllegalArgumentException("UTM zone number not between 0 and 60");
            }
            if (this.csDefs.contains((Object)"WGS84")) {
                System.out.println("cannot handle geoid-based UTM yet");
            }
            ParameterValueGroup parameterValueGroup = this.mathFactory.getDefaultParameters("Transverse_Mercator");
            parameterValueGroup.parameter("semi_major").setValue(this.wgs84Ellipsoid.getSemiMajorAxis());
            parameterValueGroup.parameter("semi_minor").setValue(this.wgs84Ellipsoid.getSemiMinorAxis());
            parameterValueGroup.parameter("central_meridian").setValue(-180 + n * 6 - 3);
            parameterValueGroup.parameter("latitude_of_origin").setValue(0.0);
            parameterValueGroup.parameter("scale_factor").setValue(0.9996);
            parameterValueGroup.parameter("false_easting").setValue(500000.0);
            if (this.csDefs.contains((Object)"S")) {
                parameterValueGroup.parameter("false_northing").setValue(10000000);
            } else {
                parameterValueGroup.parameter("false_northing").setValue(0.0);
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("name", "WGS 84 / UTM Zone " + string);
            ProjectedCRS projectedCRS = this.factoryHelper.createProjectedCRS(hashMap, this.utmGeographicCRS, null, parameterValueGroup, this.utmCartesianCS);
            coordinateOperation = this.transformFactory.createOperation((CoordinateReferenceSystem)projectedCRS, this.outputCRS);
            this.utmZoneMap.put(string2, coordinateOperation);
        }
        return coordinateOperation;
    }

    private Ellipsoid fetchEllipsoid(String[] stringArray) throws FactoryException {
        Ellipsoid ellipsoid = null;
        String string = "WE";
        for (int i = 0; i < stringArray.length; ++i) {
            if (!allEllipsoidSet.contains((Object)stringArray[i])) continue;
            string = stringArray[i];
            break;
        }
        if ((ellipsoid = this.cachedEllipsoidMap.get(string)) == null) {
            ellipsoid = this.addEllipsoidToCache(string);
        }
        return ellipsoid;
    }

    private Ellipsoid addEllipsoidToCache(String string) throws FactoryException {
        Ellipsoid ellipsoid = null;
        if (string.equals("AA")) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("name", "Airy 1830");
            ellipsoid = this.datumFactory.createFlattenedSphere(hashMap, 6377563.396, 299.3249646, (Unit)SI.METER);
        } else if (string.equals("AM")) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("name", "Modified Airy");
            ellipsoid = this.datumFactory.createFlattenedSphere(hashMap, 6377340.189, 299.3249646, (Unit)SI.METER);
        } else if (string.equals("AN")) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("name", "Australia National");
            ellipsoid = this.datumFactory.createFlattenedSphere(hashMap, 6378160.0, 298.25, (Unit)SI.METER);
        } else if (string.equals("BN")) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("name", "Bessel 1841 (Namibia)");
            ellipsoid = this.datumFactory.createFlattenedSphere(hashMap, 6377483.856, 299.1528128, (Unit)SI.METER);
        } else if (string.equals("BR")) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("name", "Bessel 1841 (Ethiopia)");
            ellipsoid = this.datumFactory.createFlattenedSphere(hashMap, 6377397.155, 299.1528128, (Unit)SI.METER);
        } else if (string.equals("CC")) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("name", "Clarke 1866");
            ellipsoid = this.datumFactory.createFlattenedSphere(hashMap, 6378206.4, 294.9786982, (Unit)SI.METER);
        } else if (string.equals("CD")) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("name", "Clarke 1880");
            ellipsoid = this.datumFactory.createFlattenedSphere(hashMap, 6378249.145, 293.465, (Unit)SI.METER);
        } else if (string.equals("EA")) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("name", "Everest (India 1830)");
            ellipsoid = this.datumFactory.createFlattenedSphere(hashMap, 6377276.345, 300.8017, (Unit)SI.METER);
        } else if (string.equals("EB")) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("name", "Everest (Sabah & Sarawak)");
            ellipsoid = this.datumFactory.createFlattenedSphere(hashMap, 6377298.556, 300.8017, (Unit)SI.METER);
        } else if (string.equals("EC")) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("name", "Everest (India 1956)");
            ellipsoid = this.datumFactory.createFlattenedSphere(hashMap, 6377301.243, 300.8017, (Unit)SI.METER);
        } else if (string.equals("ED")) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("name", "Everest (W. Malaysia 1969)");
            ellipsoid = this.datumFactory.createFlattenedSphere(hashMap, 6377295.664, 300.8017, (Unit)SI.METER);
        } else if (string.equals("EE")) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("name", "Everest (W Malaysia & Singapore 1948)");
            ellipsoid = this.datumFactory.createFlattenedSphere(hashMap, 6377304.063, 300.8017, (Unit)SI.METER);
        } else if (string.equals("EF")) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("name", "Everest (Pakistan)");
            ellipsoid = this.datumFactory.createFlattenedSphere(hashMap, 6377309.613, 299.3249646, (Unit)SI.METER);
        } else if (string.equals("FA")) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("name", "Modified Fischer 1960");
            ellipsoid = this.datumFactory.createFlattenedSphere(hashMap, 6378155.0, 298.3, (Unit)SI.METER);
        } else if (string.equals("HE")) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("name", "Helmert 1906");
            ellipsoid = this.datumFactory.createFlattenedSphere(hashMap, 6378200.0, 298.3, (Unit)SI.METER);
        } else if (string.equals("HO")) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("name", "Hough 1960");
            ellipsoid = this.datumFactory.createFlattenedSphere(hashMap, 6378270.0, 297.0, (Unit)SI.METER);
        } else if (string.equals("ID")) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("name", "Indonesia 1974");
            ellipsoid = this.datumFactory.createFlattenedSphere(hashMap, 6378160.0, 298.247, (Unit)SI.METER);
        } else if (string.equals("IN")) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("name", "International 1924");
            ellipsoid = this.datumFactory.createFlattenedSphere(hashMap, 6378388.0, 297.0, (Unit)SI.METER);
        } else if (string.equals("KA")) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("name", "Krassovsky 1940");
            ellipsoid = this.datumFactory.createFlattenedSphere(hashMap, 6378245.0, 298.3, (Unit)SI.METER);
        } else if (string.equals("RF")) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("name", "Geodetic Reference System 1980");
            ellipsoid = this.datumFactory.createFlattenedSphere(hashMap, 6378137.0, 298.257222101, (Unit)SI.METER);
        } else if (string.equals("SA")) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("name", "South American 1969");
            ellipsoid = this.datumFactory.createFlattenedSphere(hashMap, 6378160.0, 298.25, (Unit)SI.METER);
        } else if (string.equals("WD")) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("name", "WGS 72");
            ellipsoid = this.datumFactory.createFlattenedSphere(hashMap, 6378135.0, 298.26, (Unit)SI.METER);
        } else {
            System.out.println("Unknown ellipsoid definition passed: " + string);
        }
        if (ellipsoid != null) {
            this.cachedEllipsoidMap.put(string, ellipsoid);
        }
        return ellipsoid;
    }

    private MathTransform createLunarSystemTransform() throws FactoryException {
        MathTransform mathTransform;
        GeotoolsFactory geotoolsFactory;
        if (this.selenodetic == null) {
            geotoolsFactory = new GeotoolsFactory();
            this.selenodetic = geotoolsFactory.createFromWKT(LUNAR_WKT);
            mathTransform = (GeodeticDatum)((GeographicCRS)this.selenodetic).getDatum();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("name", "<lat>, <long> Selenodetic CS");
            EllipsoidalCS ellipsoidalCS = geotoolsFactory.createEllipsoidalCS(hashMap, this.northAxis, this.eastAxis, this.heightAxis);
            hashMap = new HashMap();
            hashMap.put("name", "Selenodetic CRS");
            this.selenodetic = geotoolsFactory.createGeographicCRS(hashMap, (GeodeticDatum)mathTransform, ellipsoidalCS);
            hashMap = new HashMap();
            hashMap.put("name", "X");
            CoordinateSystemAxis coordinateSystemAxis = geotoolsFactory.createCoordinateSystemAxis(hashMap, "X", AxisDirection.OTHER, (Unit)SI.METER);
            hashMap = new HashMap();
            hashMap.put("name", "Y");
            CoordinateSystemAxis coordinateSystemAxis2 = geotoolsFactory.createCoordinateSystemAxis(hashMap, "Y", AxisDirection.WEST, (Unit)SI.METER);
            hashMap = new HashMap();
            hashMap.put("name", "Z");
            CoordinateSystemAxis coordinateSystemAxis3 = geotoolsFactory.createCoordinateSystemAxis(hashMap, "Z", AxisDirection.NORTH, (Unit)SI.METER);
            hashMap = new HashMap();
            hashMap.put("name", "Selenocentric Cartesian CS");
            CartesianCS cartesianCS = geotoolsFactory.createCartesianCS(hashMap, coordinateSystemAxis, coordinateSystemAxis3, coordinateSystemAxis2);
            hashMap = new HashMap();
            hashMap.put("name", "Selenocentric CRS");
            this.selenocentric = geotoolsFactory.createGeocentricCRS(hashMap, (GeodeticDatum)mathTransform, cartesianCS);
        }
        geotoolsFactory = this.transformFactory.createOperation(this.selenodetic, this.selenocentric);
        mathTransform = geotoolsFactory.getMathTransform();
        return mathTransform;
    }

    static {
        allEllipsoidSet.add((Object)"AA");
        allEllipsoidSet.add((Object)"AM");
        allEllipsoidSet.add((Object)"AN");
        allEllipsoidSet.add((Object)"BN");
        allEllipsoidSet.add((Object)"BR");
        allEllipsoidSet.add((Object)"CC");
        allEllipsoidSet.add((Object)"CD");
        allEllipsoidSet.add((Object)"EA");
        allEllipsoidSet.add((Object)"EB");
        allEllipsoidSet.add((Object)"EC");
        allEllipsoidSet.add((Object)"ED");
        allEllipsoidSet.add((Object)"EE");
        allEllipsoidSet.add((Object)"FA");
        allEllipsoidSet.add((Object)"HE");
        allEllipsoidSet.add((Object)"HO");
        allEllipsoidSet.add((Object)"ID");
        allEllipsoidSet.add((Object)"IN");
        allEllipsoidSet.add((Object)"KA");
        allEllipsoidSet.add((Object)"RF");
        allEllipsoidSet.add((Object)"SA");
        allEllipsoidSet.add((Object)"WD");
        allEllipsoidSet.add((Object)"WE");
        DEGREE = SI.RADIAN.multiply(Math.PI / 180);
    }
}

