/*
 * Decompiled with CFR 0.152.
 */
package mil.navy.nps.net;

import java.util.StringTokenizer;
import mil.navy.nps.dis.EntityID;
import mil.navy.nps.dis.EntityStatePdu;
import mil.navy.nps.net.BehaviorProducerUDP;

class Runner
implements Runnable {
    EntityID id;
    BehaviorProducerUDP writer;
    String data;
    EntityStatePdu espdu;
    float xoff;
    float yoff;
    float zoff;

    public Runner(BehaviorProducerUDP writer, String data, int siteID, int appID, int entityID) {
        this.writer = writer;
        this.data = data;
        this.id = new EntityID(siteID, appID, entityID);
        this.espdu = new EntityStatePdu();
        this.espdu.setEntityID(this.id);
    }

    public void setOffset(float x, float y, float z) {
        this.xoff = x;
        this.yoff = y;
        this.zoff = z;
    }

    public void run() {
        boolean totalPacketsSent = false;
        boolean sendingPDUs = true;
        while (sendingPDUs) {
            StringTokenizer lineTokenizer = new StringTokenizer(this.data, "\r\n");
            while (lineTokenizer.hasMoreTokens() && sendingPDUs) {
                String token;
                float[] pduValues = new float[12];
                int valueCount = 0;
                String lineString = lineTokenizer.nextToken();
                StringTokenizer itemTokenizer = new StringTokenizer(lineString);
                valueCount = 0;
                while (itemTokenizer.hasMoreTokens() && (token = itemTokenizer.nextToken()).indexOf(35) == -1) {
                    float value = Float.valueOf(token).floatValue();
                    if (++valueCount > 12) break;
                    pduValues[valueCount - 1] = value;
                }
                if (valueCount == 0) continue;
                this.espdu.setEntityLocationX(pduValues[0] + this.xoff);
                this.espdu.setEntityLocationY(pduValues[1] + this.yoff);
                this.espdu.setEntityLocationZ(pduValues[2] + this.zoff);
                this.espdu.setEntityLinearVelocityX(pduValues[3]);
                this.espdu.setEntityLinearVelocityY(pduValues[4]);
                this.espdu.setEntityLinearVelocityZ(pduValues[5]);
                this.espdu.setEntityOrientationPsi(pduValues[6]);
                this.espdu.setEntityOrientationTheta(pduValues[7]);
                this.espdu.setEntityOrientationPhi(pduValues[8]);
                this.espdu.setEntityAngularVelocityY(pduValues[9]);
                this.espdu.setEntityAngularVelocityX(pduValues[10]);
                this.espdu.setEntityAngularVelocityZ(pduValues[11]);
                this.writer.write(this.espdu);
                try {
                    Thread.sleep(50L);
                }
                catch (Exception e) {}
            }
        }
    }
}

