/*
 * Decompiled with CFR 0.152.
 */
package mil.navy.nps.math;

import mil.navy.nps.math.Matrix3f;
import mil.navy.nps.math.Matrix4f;
import mil.navy.nps.math.Vec3f;
import mil.navy.nps.math.Vec4f;

public class Quaternion {
    private float[] q = new float[4];

    public Quaternion() {
        this.makeIdent();
    }

    public Quaternion(float[] axis, float angle) {
        this.setAxisAngle(axis, angle);
    }

    public Quaternion(Vec3f axis, float angle) {
        this.setAxisAngle(axis, angle);
    }

    public Quaternion(Matrix3f mat) {
        this.setMat3(mat);
    }

    public Quaternion(Matrix4f mat) {
        this.setMat4(mat);
    }

    public Quaternion(Quaternion quat) {
        this.setQuat(quat);
    }

    public Quaternion(float[] vec1, float[] vec2) {
        this.makeFromVecs(vec1, vec2);
    }

    public Quaternion(Vec3f vec1, Vec3f vec2) {
        this.makeFromVecs(vec1, vec2);
    }

    public void print() {
        System.out.println("q = " + this.q[0] + ", " + this.q[1] + ", " + this.q[2] + ", " + this.q[3]);
    }

    public void setVec(float i, float j, float k) {
        this.q[0] = i;
        this.q[1] = j;
        this.q[2] = k;
        this.q[3] = 0.0f;
    }

    public void getVec(float[] i, float[] j, float[] k) {
        i[0] = this.q[0];
        j[0] = this.q[1];
        k[0] = this.q[2];
    }

    public void setVec(float[] vec) {
        this.q[0] = vec[0];
        this.q[1] = vec[1];
        this.q[2] = vec[2];
        this.q[3] = 0.0f;
    }

    public void getVec(float[] vec) {
        vec[0] = this.q[0];
        vec[1] = this.q[1];
        vec[2] = this.q[2];
    }

    public void setVec(Vec3f vec) {
        this.q[0] = vec.get(0);
        this.q[1] = vec.get(1);
        this.q[2] = vec.get(2);
        this.q[3] = 0.0f;
    }

    public void getVec(Vec3f vec) {
        vec.set(this.q[0], this.q[1], this.q[2]);
    }

    public void setAxisAngle(float[] axis_angle) {
        float length_sqr;
        if (axis_angle[3] == 0.0f) {
            this.makeIdent();
        }
        if ((double)(length_sqr = axis_angle[0] * axis_angle[0] + axis_angle[1] * axis_angle[1] + axis_angle[2] * axis_angle[2]) < 1.0E-4) {
            this.makeIdent();
        }
        float one_over_length = 1.0f / (float)Math.sqrt(length_sqr);
        axis_angle[0] = axis_angle[0] * one_over_length;
        axis_angle[1] = axis_angle[1] * one_over_length;
        axis_angle[2] = axis_angle[2] * one_over_length;
        float sin = (float)Math.sin(axis_angle[3] * 0.5f);
        this.q[0] = axis_angle[0] * sin;
        this.q[1] = axis_angle[1] * sin;
        this.q[2] = axis_angle[2] * sin;
        this.q[3] = (float)Math.cos(axis_angle[3] * 0.5f);
    }

    public void getAxisAngle(float[] axis_angle) {
        axis_angle[3] = 2.0f * (float)Math.acos(this.q[3]);
        if (Math.abs(axis_angle[3]) < 1.0E-4f) {
            axis_angle[0] = 0.0f;
            axis_angle[1] = 1.0f;
            axis_angle[2] = 0.0f;
        } else {
            float one_over_sin = 1.0f / (float)Math.sin(axis_angle[3] * 0.5f);
            axis_angle[0] = this.q[0] * one_over_sin;
            axis_angle[1] = this.q[1] * one_over_sin;
            axis_angle[2] = this.q[2] * one_over_sin;
        }
    }

    public void setAxisAngle(Vec4f axis_angle) {
        float[] aa = new float[4];
        axis_angle.get(aa);
        this.setAxisAngle(aa);
    }

    public void getAxisAngle(Vec4f axis_angle) {
        float[] aa = new float[4];
        this.getAxisAngle(aa);
        axis_angle.set(aa);
    }

    public void setAxisAngle(float[] axis, float angle) {
        float[] aa = new float[]{axis[0], axis[1], axis[2], angle};
        this.setAxisAngle(aa);
    }

    public void getAxisAngle(float[] axis, float[] angle) {
        float[] aa = new float[4];
        this.getAxisAngle(aa);
        axis[0] = aa[0];
        axis[1] = aa[1];
        axis[2] = aa[2];
        angle[0] = aa[3];
    }

    public void setAxisAngle(Vec3f axis, float angle) {
        float[] aa = new float[]{axis.get(0), axis.get(1), axis.get(2), angle};
        this.setAxisAngle(aa);
    }

    public void getAxisAngle(Vec3f axis, float[] angle) {
        float[] aa = new float[4];
        this.getAxisAngle(aa);
        axis.set(aa[0], aa[1], aa[2]);
        angle[0] = aa[3];
    }

    public void setAxisAngle(float i, float j, float k, float angle) {
        float[] aa = new float[]{i, j, k, angle};
        this.setAxisAngle(aa);
    }

    public void getAxisAngle(float[] i, float[] j, float[] k, float[] angle) {
        float[] aa = new float[4];
        this.getAxisAngle(aa);
        i[0] = aa[0];
        j[0] = aa[1];
        k[0] = aa[2];
        angle[0] = aa[3];
    }

    public void setEulers(float[] hpr) {
        float sin_h = (float)Math.sin(hpr[0] * 0.5f);
        float cos_h = (float)Math.cos(hpr[0] * 0.5f);
        float sin_p = (float)Math.sin(hpr[1] * 0.5f);
        float cos_p = (float)Math.cos(hpr[1] * 0.5f);
        float sin_r = (float)Math.sin(hpr[2] * 0.5f);
        float cos_r = (float)Math.cos(hpr[2] * 0.5f);
        this.q[0] = cos_h * sin_p * cos_r + sin_h * cos_p * sin_r;
        this.q[1] = sin_h * cos_p * cos_r - cos_h * sin_p * sin_r;
        this.q[2] = cos_h * cos_p * sin_r - sin_h * sin_p * cos_r;
        this.q[3] = cos_h * cos_p * cos_r + sin_h * sin_p * sin_r;
    }

    public void getEulers(float[] hpr) {
        Matrix3f m = new Matrix3f();
        this.getMat3(m);
        m.getEulers(hpr);
    }

    public void setEulers(float h, float p, float r) {
        float[] hpr = new float[]{h, p, r};
        this.setEulers(hpr);
    }

    public void getEulers(float[] h, float[] p, float[] r) {
        float[] hpr = new float[3];
        this.getEulers(hpr);
        h[0] = hpr[0];
        p[0] = hpr[1];
        r[0] = hpr[2];
    }

    public void setMat3(float[][] mat) {
        float tr = mat[0][0] + mat[1][1] + mat[2][2] + 1.0f;
        if (tr > 0.0625f) {
            float s = (float)Math.sqrt(tr);
            this.q[3] = s * 0.5f;
            s = 0.5f / s;
            this.q[0] = (mat[1][2] - mat[2][1]) * s;
            this.q[1] = (mat[2][0] - mat[0][2]) * s;
            this.q[2] = (mat[0][1] - mat[1][0]) * s;
            return;
        }
        tr = -mat[0][0] - mat[1][1] + mat[2][2] + 1.0f;
        if (tr > 0.0625f) {
            float s = (float)Math.sqrt(tr);
            this.q[2] = s * 0.5f;
            s = 0.5f / s;
            this.q[0] = (mat[2][0] - mat[0][2]) * s;
            this.q[1] = (mat[2][1] + mat[1][2]) * s;
            this.q[3] = (mat[0][1] - mat[1][0]) * s;
            return;
        }
        tr = -mat[0][0] + mat[1][1] - mat[2][2] + 1.0f;
        if (tr > 0.0625f) {
            float s = (float)Math.sqrt(tr);
            this.q[1] = s * 0.5f;
            s = 0.5f / s;
            this.q[0] = (mat[1][0] + mat[0][1]) * s;
            this.q[2] = (mat[2][1] + mat[1][2]) * s;
            this.q[3] = (mat[2][0] - mat[0][2]) * s;
            return;
        }
        tr = mat[0][0] - mat[1][1] - mat[2][2] + 1.0f;
        if (tr > 0.0625f) {
            float s = (float)Math.sqrt(tr);
            this.q[0] = s * 0.5f;
            s = 0.5f / s;
            this.q[1] = (mat[1][0] + mat[0][1]) * s;
            this.q[2] = (mat[2][0] - mat[0][2]) * s;
            this.q[3] = (mat[1][2] - mat[2][1]) * s;
            return;
        }
    }

    public void getMat3(float[][] mat) {
        float two_over_length_sqr = 2.0f / this.length_sqr();
        float xs = this.q[0] * two_over_length_sqr;
        float ys = this.q[1] * two_over_length_sqr;
        float zs = this.q[2] * two_over_length_sqr;
        float wx = this.q[3] * xs;
        float wy = this.q[3] * ys;
        float wz = this.q[3] * zs;
        float xx = this.q[0] * xs;
        float xy = this.q[0] * ys;
        float xz = this.q[0] * zs;
        float yy = this.q[1] * ys;
        float yz = this.q[1] * zs;
        float zz = this.q[2] * zs;
        mat[0][0] = 1.0f - yy - zz;
        mat[0][1] = xy - wz;
        mat[0][2] = xz + wy;
        mat[1][0] = xy + wz;
        mat[1][1] = 1.0f - xx - zz;
        mat[1][2] = yz - wx;
        mat[2][0] = xz - wy;
        mat[2][1] = yz + wx;
        mat[2][2] = 1.0f - xx - yy;
    }

    public void setMat3(Matrix3f mat) {
        float[][] m = new float[3][3];
        mat.getMat(m);
        this.setMat3(m);
    }

    public void getMat3(Matrix3f mat) {
        float[][] m = new float[3][3];
        this.getMat3(m);
        mat.setMat(m);
    }

    public void setMat4(float[][] mat) {
        this.setMat3(mat);
    }

    public void getMat4(float[][] mat) {
        this.getMat3(mat);
        mat[0][3] = 0.0f;
        mat[1][3] = 0.0f;
        mat[2][3] = 0.0f;
        mat[3][0] = 0.0f;
        mat[3][1] = 0.0f;
        mat[3][2] = 0.0f;
        mat[3][3] = 1.0f;
    }

    public void setMat4(Matrix4f mat) {
        float[][] m = new float[4][4];
        mat.getMat(m);
        this.setMat4(m);
    }

    public void getMat4(Matrix4f mat) {
        float[][] m = new float[4][4];
        this.getMat4(m);
        mat.setMat(m);
    }

    public void setQuat(float[] quat) {
        this.q[0] = quat[0];
        this.q[1] = quat[1];
        this.q[2] = quat[2];
        this.q[3] = quat[3];
    }

    public void getQuat(float[] quat) {
        quat[0] = this.q[0];
        quat[1] = this.q[1];
        quat[2] = this.q[2];
        quat[3] = this.q[3];
    }

    public void setQuat(Quaternion quat) {
        float[] quat2 = new float[4];
        quat.getQuat(quat2);
        this.setQuat(quat2);
    }

    public void getQuat(Quaternion quat) {
        float[] quat2 = new float[4];
        this.getQuat(quat2);
        quat.setQuat(quat2);
    }

    public void setQuat(float i, float j, float k, float w) {
        this.q[0] = i;
        this.q[1] = j;
        this.q[2] = k;
        this.q[3] = w;
    }

    public void getQuat(float[] i, float[] j, float[] k, float[] w) {
        i[0] = this.q[0];
        j[0] = this.q[1];
        k[0] = this.q[2];
        w[0] = this.q[3];
    }

    public void setQuatValue(int index, float value) {
        if (index < 0 || index > 3) {
            return;
        }
        this.q[index] = value;
    }

    public float getQuatValue(int index) {
        if (index < 0 || index > 3) {
            return 0.0f;
        }
        return this.q[index];
    }

    public void makeIdent() {
        this.q[0] = 0.0f;
        this.q[1] = 0.0f;
        this.q[2] = 0.0f;
        this.q[3] = 1.0f;
    }

    public float length() {
        return (float)Math.sqrt(this.q[0] * this.q[0] + this.q[1] * this.q[1] + this.q[2] * this.q[2] + this.q[3] * this.q[3]);
    }

    public float length_sqr() {
        return this.q[0] * this.q[0] + this.q[1] * this.q[1] + this.q[2] * this.q[2] + this.q[3] * this.q[3];
    }

    public void normalize() {
        float one_over_length = 1.0f / this.length();
        this.q[0] = this.q[0] * one_over_length;
        this.q[1] = this.q[1] * one_over_length;
        this.q[2] = this.q[2] * one_over_length;
        this.q[3] = this.q[3] * one_over_length;
    }

    public void normalize(Quaternion quat) {
        float one_over_length = 1.0f / quat.length();
        this.q[0] = quat.getQuatValue(0) * one_over_length;
        this.q[1] = quat.getQuatValue(1) * one_over_length;
        this.q[2] = quat.getQuatValue(2) * one_over_length;
        this.q[3] = quat.getQuatValue(3) * one_over_length;
    }

    public void conjugate() {
        this.q[0] = -this.q[0];
        this.q[1] = -this.q[1];
        this.q[2] = -this.q[2];
        this.q[3] = this.q[3];
    }

    public void conjugate(Quaternion quat) {
        this.q[0] = -quat.getQuatValue(0);
        this.q[1] = -quat.getQuatValue(1);
        this.q[2] = -quat.getQuatValue(2);
        this.q[3] = quat.getQuatValue(3);
    }

    public void invert() {
        float one_over_length_sqr = 1.0f / this.length_sqr();
        this.q[0] = -this.q[0] * one_over_length_sqr;
        this.q[1] = -this.q[1] * one_over_length_sqr;
        this.q[2] = -this.q[2] * one_over_length_sqr;
        this.q[3] = this.q[3] * one_over_length_sqr;
    }

    public void invert(Quaternion quat) {
        float one_over_length_sqr = 1.0f / quat.length_sqr();
        this.q[0] = -quat.getQuatValue(0) * one_over_length_sqr;
        this.q[1] = -quat.getQuatValue(1) * one_over_length_sqr;
        this.q[2] = -quat.getQuatValue(2) * one_over_length_sqr;
        this.q[3] = quat.getQuatValue(3) * one_over_length_sqr;
    }

    public void add(Quaternion quat) {
        this.q[0] = this.q[0] + quat.getQuatValue(0);
        this.q[1] = this.q[1] + quat.getQuatValue(1);
        this.q[2] = this.q[2] + quat.getQuatValue(2);
        this.q[3] = this.q[3] + quat.getQuatValue(3);
    }

    public void add(Quaternion quat1, Quaternion quat2) {
        this.q[0] = quat1.getQuatValue(0) + quat2.getQuatValue(0);
        this.q[1] = quat1.getQuatValue(1) + quat2.getQuatValue(1);
        this.q[2] = quat1.getQuatValue(2) + quat2.getQuatValue(2);
        this.q[3] = quat1.getQuatValue(3) + quat2.getQuatValue(3);
    }

    public void sub(Quaternion quat) {
        this.q[0] = this.q[0] - quat.getQuatValue(0);
        this.q[1] = this.q[1] - quat.getQuatValue(1);
        this.q[2] = this.q[2] - quat.getQuatValue(2);
        this.q[3] = this.q[3] - quat.getQuatValue(3);
    }

    public void sub(Quaternion quat1, Quaternion quat2) {
        this.q[0] = quat1.getQuatValue(0) - quat2.getQuatValue(0);
        this.q[1] = quat1.getQuatValue(1) - quat2.getQuatValue(1);
        this.q[2] = quat1.getQuatValue(2) - quat2.getQuatValue(2);
        this.q[3] = quat1.getQuatValue(3) - quat2.getQuatValue(3);
    }

    public void preMult(Quaternion quat1) {
        float[] tmp_q = new float[4];
        float[] q1 = new float[4];
        quat1.getQuat(q1);
        tmp_q[0] = q1[3] * this.q[0] - q1[2] * this.q[1] + q1[1] * this.q[2] + q1[0] * this.q[3];
        tmp_q[1] = q1[2] * this.q[0] + q1[3] * this.q[1] - q1[0] * this.q[2] + q1[1] * this.q[3];
        tmp_q[2] = -q1[1] * this.q[0] + q1[0] * this.q[1] + q1[3] * this.q[2] + q1[2] * this.q[3];
        tmp_q[3] = -q1[0] * this.q[0] - q1[1] * this.q[1] - q1[2] * this.q[2] + q1[3] * this.q[3];
        this.setQuat(tmp_q);
    }

    public void postMult(Quaternion quat2) {
        float[] tmp_q = new float[4];
        float[] q2 = new float[4];
        quat2.getQuat(q2);
        tmp_q[0] = this.q[3] * q2[0] - this.q[2] * q2[1] + this.q[1] * q2[2] + this.q[0] * q2[3];
        tmp_q[1] = this.q[2] * q2[0] + this.q[3] * q2[1] - this.q[0] * q2[2] + this.q[1] * q2[3];
        tmp_q[2] = -this.q[1] * q2[0] + this.q[0] * q2[1] + this.q[3] * q2[2] + this.q[2] * q2[3];
        tmp_q[3] = -this.q[0] * q2[0] - this.q[1] * q2[1] - this.q[2] * q2[2] + this.q[3] * q2[3];
        this.setQuat(tmp_q);
    }

    public void mult(Quaternion quat1, Quaternion quat2) {
        float[] q1 = new float[4];
        float[] q2 = new float[4];
        quat1.getQuat(q1);
        quat2.getQuat(q2);
        this.q[0] = q1[3] * q2[0] - q1[2] * q2[1] + q1[1] * q2[2] + q1[0] * q2[3];
        this.q[1] = q1[2] * q2[0] + q1[3] * q2[1] - q1[0] * q2[2] + q1[1] * q2[3];
        this.q[2] = -q1[1] * q2[0] + q1[0] * q2[1] + q1[3] * q2[2] + q1[2] * q2[3];
        this.q[3] = -q1[0] * q2[0] - q1[1] * q2[1] - q1[2] * q2[2] + q1[3] * q2[3];
    }

    public void makeFromVecs(float i1, float j1, float k1, float i2, float j2, float k2) {
        Vec3f tmp1 = new Vec3f(i1, j1, k1);
        Vec3f tmp2 = new Vec3f(i2, j2, k2);
        this.makeFromVecs(tmp1, tmp2);
    }

    public void makeFromVecs(float[] vec1, float[] vec2) {
        Vec3f tmp1 = new Vec3f(vec1);
        Vec3f tmp2 = new Vec3f(vec2);
        this.makeFromVecs(tmp1, tmp2);
    }

    public void makeFromVecs(Vec3f vec1, Vec3f vec2) {
        Vec3f tmp1 = new Vec3f();
        Vec3f tmp2 = new Vec3f();
        Vec3f axis = new Vec3f();
        tmp1.normalize(vec1);
        tmp2.normalize(vec2);
        float dot = Vec3f.dot(tmp1, tmp2);
        float angle = (float)Math.acos(dot);
        float abs_angle = Math.abs(angle);
        if (abs_angle < 1.0E-4f) {
            this.makeIdent();
            return;
        }
        if (abs_angle > 3.1414928f) {
            axis.set(1.0f, 0.0f, 0.0f);
            if (axis.dot(tmp1) < 0.1f) {
                axis.cross(tmp1);
                axis.normalize();
            } else {
                axis.set(0.0f, 0.0f, 1.0f);
            }
            this.setAxisAngle(axis, angle);
            return;
        }
        axis.cross(tmp1, tmp2);
        axis.normalize();
        this.setAxisAngle(axis, angle);
    }

    public void xform(Vec3f vec) {
        Quaternion vecQuat = new Quaternion();
        Quaternion tmpQuat = new Quaternion();
        vecQuat.setVec(vec);
        tmpQuat.invert(this);
        tmpQuat.mult(vecQuat, tmpQuat);
        tmpQuat.mult(this, tmpQuat);
        tmpQuat.getVec(vec);
    }

    public void xform(float[] v) {
        Quaternion vecQuat = new Quaternion();
        Quaternion tmpQuat = new Quaternion();
        vecQuat.setVec(v);
        tmpQuat.invert(this);
        tmpQuat.mult(vecQuat, tmpQuat);
        tmpQuat.mult(this, tmpQuat);
        tmpQuat.getVec(v);
    }

    public void slerp(Quaternion quat1, Quaternion quat2, float alpha, int spin) {
        float beta;
        boolean bflip;
        float[] q1 = new float[4];
        float[] q2 = new float[4];
        quat1.getQuat(q1);
        quat2.getQuat(q2);
        float cos_t = q1[0] * q2[0] + q1[1] * q2[1] + q1[2] * q2[2] + q1[3] * q2[3];
        if (cos_t < 0.0f) {
            cos_t = -cos_t;
            bflip = true;
        } else {
            bflip = false;
        }
        if (1.0f - cos_t < 1.0E-4f) {
            beta = 1.0f - alpha;
        } else {
            float theta = (float)Math.acos(cos_t);
            float phi = theta + (float)spin * (float)Math.PI;
            float sin_t = (float)Math.sin(theta);
            beta = (float)Math.sin(theta - alpha * phi) / sin_t;
            alpha = (float)Math.sin(alpha * phi) / sin_t;
        }
        if (bflip) {
            alpha = -alpha;
        }
        this.q[0] = beta * q1[0] + alpha * q2[0];
        this.q[1] = beta * q1[1] + alpha * q2[1];
        this.q[2] = beta * q1[2] + alpha * q2[2];
        this.q[3] = beta * q1[3] + alpha * q2[3];
    }
}

