/*
 * Decompiled with CFR 0.152.
 */
package mil.navy.nps.math;

import mil.navy.nps.math.Quaternion;
import mil.navy.nps.math.Vec4f;

public class Matrix4f {
    private float[][] m = new float[4][4];

    public Matrix4f() {
        this.makeNull();
    }

    public Matrix4f(float[][] mat) {
        this.setMat(mat);
    }

    public Matrix4f(Matrix4f mat) {
        this.setMat(mat);
    }

    public Matrix4f(Quaternion quat) {
        this.setQuat(quat);
    }

    public Matrix4f(float[] hpr) {
        this.setEulers(hpr);
    }

    public Matrix4f(float heading, float pitch, float roll) {
        this.setEulers(heading, pitch, roll);
    }

    public void print() {
        System.out.println("m = " + this.m[0][0] + ", " + this.m[0][1] + ", " + this.m[0][2] + ", " + this.m[0][3] + this.m[1][0] + ", " + this.m[1][1] + ", " + this.m[1][2] + ", " + this.m[1][3] + this.m[2][0] + ", " + this.m[2][1] + ", " + this.m[2][2] + ", " + this.m[2][3] + this.m[3][0] + ", " + this.m[3][1] + ", " + this.m[3][2] + ", " + this.m[3][3]);
    }

    public void setMatValue(int row, int col, float val) {
        if (row < 0 || row > 4 || col < 0 || col > 4) {
            return;
        }
        this.m[row][col] = val;
    }

    public float getMatValue(int row, int col) {
        if (row < 0 || row > 4 || col < 0 || col > 4) {
            return 0.0f;
        }
        return this.m[row][col];
    }

    public void setMat(float[][] mat) {
        this.m[0][0] = mat[0][0];
        this.m[0][1] = mat[0][1];
        this.m[0][2] = mat[0][2];
        this.m[0][3] = mat[0][3];
        this.m[1][0] = mat[1][0];
        this.m[1][1] = mat[1][1];
        this.m[1][2] = mat[1][2];
        this.m[1][3] = mat[1][3];
        this.m[2][0] = mat[2][0];
        this.m[2][1] = mat[2][1];
        this.m[2][2] = mat[2][2];
        this.m[2][3] = mat[2][3];
        this.m[3][0] = mat[3][0];
        this.m[3][1] = mat[3][1];
        this.m[3][2] = mat[3][2];
        this.m[3][3] = mat[3][3];
    }

    public void getMat(float[][] mat) {
        mat[0][0] = this.m[0][0];
        mat[0][1] = this.m[0][1];
        mat[0][2] = this.m[0][2];
        mat[0][3] = this.m[0][3];
        mat[1][0] = this.m[1][0];
        mat[1][1] = this.m[1][1];
        mat[1][2] = this.m[1][2];
        mat[1][3] = this.m[1][3];
        mat[2][0] = this.m[2][0];
        mat[2][1] = this.m[2][1];
        mat[2][2] = this.m[2][2];
        mat[2][3] = this.m[2][3];
        mat[3][0] = this.m[3][0];
        mat[3][1] = this.m[3][1];
        mat[3][2] = this.m[3][2];
        mat[3][3] = this.m[3][3];
    }

    public void setMat(Matrix4f mat) {
        float[][] mat2 = new float[4][4];
        mat.getMat(mat2);
        this.setMat(mat2);
    }

    public void getMat(Matrix4f mat) {
        float[][] mat2 = new float[4][4];
        this.getMat(mat2);
        mat.setMat(mat2);
    }

    public void setQuat(Quaternion quat) {
        quat.getMat4(this.m);
    }

    public void getQuat(Quaternion quat) {
        quat.setMat4(this.m);
    }

    public void setEulers(float[] hpr) {
        this.setEulers(hpr[0], hpr[1], hpr[2]);
    }

    public void getEulers(float[] hpr) {
    }

    public void setEulers(float h, float p, float r) {
        float cosh = (float)Math.cos(h);
        float sinh = (float)Math.sin(h);
        float cosp = (float)Math.cos(p);
        float sinp = (float)Math.sin(p);
        float cosr = (float)Math.cos(r);
        float sinr = (float)Math.sin(r);
        this.m[0][0] = cosh * cosp;
        this.m[0][1] = cosh * sinp * sinr - sinh * cosr;
        this.m[0][2] = cosh * sinp * cosr + sinh * sinr;
        this.m[0][3] = 0.0f;
        this.m[1][0] = sinh * cosp;
        this.m[1][1] = cosh * cosr + sinh * sinp * sinr;
        this.m[1][2] = sinh * sinp * cosr - cosh * sinr;
        this.m[1][3] = 0.0f;
        this.m[2][0] = -sinp;
        this.m[2][1] = cosp * sinr;
        this.m[2][2] = cosp * cosr;
        this.m[2][3] = 0.0f;
        this.m[3][0] = 0.0f;
        this.m[3][1] = 0.0f;
        this.m[3][2] = 0.0f;
        this.m[3][3] = 1.0f;
    }

    public void getEulers(float[] h, float[] p, float[] r) {
        float[] hpr = new float[3];
        this.getEulers(hpr);
        h[0] = hpr[0];
        p[0] = hpr[1];
        r[0] = hpr[2];
    }

    public void makeNull() {
        this.m[0][0] = 0.0f;
        this.m[0][1] = 0.0f;
        this.m[0][2] = 0.0f;
        this.m[0][3] = 0.0f;
        this.m[1][0] = 0.0f;
        this.m[1][1] = 0.0f;
        this.m[1][2] = 0.0f;
        this.m[1][3] = 0.0f;
        this.m[2][0] = 0.0f;
        this.m[2][1] = 0.0f;
        this.m[2][2] = 0.0f;
        this.m[2][3] = 0.0f;
        this.m[3][0] = 0.0f;
        this.m[3][1] = 0.0f;
        this.m[3][2] = 0.0f;
        this.m[3][3] = 0.0f;
    }

    public void makeIdent() {
        this.m[0][0] = 1.0f;
        this.m[0][1] = 0.0f;
        this.m[0][2] = 0.0f;
        this.m[0][3] = 0.0f;
        this.m[1][0] = 0.0f;
        this.m[1][1] = 1.0f;
        this.m[1][2] = 0.0f;
        this.m[1][3] = 0.0f;
        this.m[2][0] = 0.0f;
        this.m[2][1] = 0.0f;
        this.m[2][2] = 1.0f;
        this.m[2][3] = 0.0f;
        this.m[3][0] = 0.0f;
        this.m[3][1] = 0.0f;
        this.m[3][2] = 0.0f;
        this.m[3][3] = 1.0f;
    }

    public void xform(Vec4f vec) {
        float[] v = new float[4];
        vec.get(v);
        vec.set(0, v[0] * this.m[0][0] + v[1] * this.m[0][1] + v[2] * this.m[0][2] + v[3] * this.m[0][3]);
        vec.set(1, v[0] * this.m[1][0] + v[1] * this.m[1][1] + v[2] * this.m[1][2] + v[3] * this.m[1][3]);
        vec.set(2, v[0] * this.m[2][0] + v[1] * this.m[2][1] + v[2] * this.m[2][2] + v[3] * this.m[2][3]);
        vec.set(3, v[0] * this.m[3][0] + v[1] * this.m[3][1] + v[2] * this.m[3][2] + v[3] * this.m[3][3]);
    }

    public void xform(float[] v) {
        float[] tmp_v = new float[4];
        tmp_v[0] = v[0] * this.m[0][0] + v[1] * this.m[0][1] + v[2] * this.m[0][2] + v[3] * this.m[0][3];
        tmp_v[1] = v[0] * this.m[1][0] + v[1] * this.m[1][1] + v[2] * this.m[1][2] + v[3] * this.m[1][3];
        tmp_v[2] = v[0] * this.m[2][0] + v[1] * this.m[2][1] + v[2] * this.m[2][2] + v[3] * this.m[2][3];
        tmp_v[2] = v[0] * this.m[3][0] + v[1] * this.m[3][1] + v[2] * this.m[3][2] + v[3] * this.m[3][3];
        v[0] = tmp_v[0];
        v[1] = tmp_v[1];
        v[2] = tmp_v[2];
        v[3] = tmp_v[3];
    }
}

