/*
 * Decompiled with CFR 0.152.
 */
package mil.navy.nps.dis;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.PrintStream;
import mil.navy.nps.dis.ClockTime;
import mil.navy.nps.dis.ProtocolDataUnit;
import mil.navy.nps.dis.SimulationManagementFamily;
import mil.navy.nps.util.UnsignedByte;
import mil.navy.nps.util.UnsignedInt;
import mil.navy.nps.util.UnsignedShort;

public class StopFreezePdu
extends SimulationManagementFamily {
    protected ClockTime realWorldTime;
    protected UnsignedByte reason;
    protected UnsignedByte frozenBehavior;
    protected UnsignedShort padding;
    protected UnsignedInt requestID;
    public static final int sizeOf = 40;
    protected static StopFreezePdu exemplar;

    public StopFreezePdu() {
        this.setPduType((short)14);
        this.realWorldTime = new ClockTime();
        this.reason = new UnsignedByte();
        this.frozenBehavior = new UnsignedByte();
        this.padding = new UnsignedShort();
        this.requestID = new UnsignedInt();
    }

    public void serialize(DataOutputStream outputStream) {
        super.serialize(outputStream);
        this.realWorldTime.serialize(outputStream);
        this.reason.serialize(outputStream);
        this.frozenBehavior.serialize(outputStream);
        this.padding.serialize(outputStream);
        this.requestID.serialize(outputStream);
    }

    public void deSerialize(DataInputStream inputStream) {
        super.deSerialize(inputStream);
        this.realWorldTime.deSerialize(inputStream);
        this.reason.deSerialize(inputStream);
        this.frozenBehavior.deSerialize(inputStream);
        this.padding.deSerialize(inputStream);
        this.requestID.deSerialize(inputStream);
    }

    public Object clone() {
        StopFreezePdu newPdu = (StopFreezePdu)super.clone();
        newPdu.setRealWorldTime(this.getRealWorldTime());
        newPdu.setReason(this.getReason());
        newPdu.setFrozenBehavior(this.getFrozenBehavior());
        newPdu.setRequestID(this.getRequestID());
        return newPdu;
    }

    public int length() {
        return 40;
    }

    public String pduName() {
        return new String("Stop Freeze PDU");
    }

    public void printValues(int indentLevel, PrintStream printStream) {
        StringBuffer indent = ProtocolDataUnit.getPaddingOfLength(indentLevel);
        int superclassIndent = indentLevel;
        printStream.println();
        printStream.println("Stop Freeze PDU");
        if (superclassIndent > 0) {
            --superclassIndent;
        }
        super.printValues(superclassIndent, printStream);
        printStream.println(indent + "Real-World Time");
        this.realWorldTime.printValues(indentLevel + 1, printStream);
        printStream.println(indent + "Reason         : " + this.reason.intValue());
        printStream.println(indent + "Frozen Behavior: " + this.frozenBehavior.intValue());
        printStream.println(indent + "Padding        : ");
        printStream.println(indent + "Request ID     : " + this.requestID.longValue());
    }

    public StopFreezePdu getExemplar() {
        return (StopFreezePdu)exemplar.clone();
    }

    public void setExemplar(StopFreezePdu newExemplar) {
        exemplar = newExemplar;
    }

    public ClockTime getRealWorldTime() {
        return (ClockTime)this.realWorldTime.clone();
    }

    public void setRealWorldTime(ClockTime pRealWorldTime) {
        this.realWorldTime = pRealWorldTime;
    }

    public void setRealWorldTime(long pHour, long pTimePastHour) {
        this.realWorldTime = new ClockTime(pHour, pTimePastHour);
    }

    public UnsignedByte getReason() {
        return (UnsignedByte)this.reason.clone();
    }

    public void setReason(UnsignedByte pReason) {
        this.reason = pReason;
    }

    public void setReason(int pReason) {
        this.reason = new UnsignedByte(pReason);
    }

    public UnsignedByte getFrozenBehavior() {
        return (UnsignedByte)this.frozenBehavior.clone();
    }

    public void setFrozenBehavior(UnsignedByte pFrozenBehavior) {
        this.frozenBehavior = pFrozenBehavior;
    }

    public void setFrozenBehavior(int pFrozenBehavior) {
        this.frozenBehavior = new UnsignedByte(pFrozenBehavior);
    }

    public UnsignedInt getRequestID() {
        return (UnsignedInt)this.requestID.clone();
    }

    public void setRequestID(UnsignedInt pRequestID) {
        this.requestID = pRequestID;
    }

    public void setRequestID(int pRequestID) {
        this.requestID = new UnsignedInt(pRequestID);
    }
}

