/*
 * Decompiled with CFR 0.152.
 */
package mil.navy.nps.dis;

import java.util.Vector;

public class RunningAverage {
    private static boolean DEBUG = false;
    private Vector dataVector;
    private int numberOfDataPoints = 0;

    public RunningAverage(int requestedNumberOfDataPoints) {
        this.numberOfDataPoints = requestedNumberOfDataPoints;
        this.dataVector = new Vector(this.numberOfDataPoints);
    }

    public float addDataPoint(float dataPoint) {
        Float floatData = new Float(dataPoint);
        RunningAverage.debug(" dataVector.size() = " + this.dataVector.size());
        if (this.dataVector.size() >= this.numberOfDataPoints) {
            this.dataVector.removeElementAt(0);
        }
        this.dataVector.addElement(floatData);
        RunningAverage.debug("ave is " + this.average());
        return this.average();
    }

    public float average() {
        int currentSize = this.dataVector.size();
        float result = 0.0f;
        for (int index = 0; index < currentSize; ++index) {
            Float tempFloatObject = (Float)this.dataVector.elementAt(index);
            result += tempFloatObject.floatValue();
        }
        return result /= (float)(currentSize + 1);
    }

    public float getPrevUpdate() {
        return ((Float)this.dataVector.lastElement()).floatValue();
    }

    public boolean getDEBUG() {
        RunningAverage.debug("getDEBUG " + DEBUG);
        return DEBUG;
    }

    public void setDEBUG(boolean pDEBUG) {
        DEBUG = pDEBUG;
        RunningAverage.trace("RunningAverage.java: setDEBUG " + pDEBUG);
        System.out.println("  RunningAverage.java: setDEBUG " + pDEBUG);
    }

    protected static void debug(String pDiagnostic) {
        if (DEBUG) {
            System.out.println("  RunningAverage: " + pDiagnostic);
        }
    }

    protected static void trace(String pDiagnostic) {
        System.out.println("  EspduTransform: " + pDiagnostic);
    }
}

