/*
 * Decompiled with CFR 0.152.
 */
package mil.navy.nps.dis;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import mil.navy.nps.dis.EntityID;
import mil.navy.nps.dis.ProtocolDataUnit;
import mil.navy.nps.dis.RadioCommunicationsFamily;
import mil.navy.nps.util.UnsignedShort;

public class ReceiverPdu
extends RadioCommunicationsFamily {
    protected EntityID entityID = new EntityID();
    protected UnsignedShort radioID = new UnsignedShort(0);
    protected UnsignedShort receiverState = new UnsignedShort(0);
    protected UnsignedShort padding = new UnsignedShort(0);
    protected float receiverPower = 0.0f;
    protected EntityID transmitterEntityID = new EntityID();
    protected UnsignedShort transmitterRadioID = new UnsignedShort(0);
    public static final int sizeOf = 288;

    public ReceiverPdu() {
        super.setPduType((short)27);
    }

    public Object clone() {
        ReceiverPdu newReceiverPdu = (ReceiverPdu)super.clone();
        newReceiverPdu.setEntityID(this.getEntityID());
        newReceiverPdu.setRadioID(this.getRadioID());
        newReceiverPdu.setReceiverState(this.getReceiverState());
        newReceiverPdu.setReceiverPower(this.getReceiverPower());
        newReceiverPdu.setTransmitterEntityID(this.getTransmitterEntityID());
        newReceiverPdu.setTransmitterRadioID(this.getTransmitterRadioID());
        return newReceiverPdu;
    }

    public void serialize(DataOutputStream outputStream) {
        super.serialize(outputStream);
        try {
            this.entityID.serialize(outputStream);
            this.radioID.serialize(outputStream);
            this.receiverState.serialize(outputStream);
            this.padding.serialize(outputStream);
            outputStream.writeFloat(this.receiverPower);
            this.transmitterEntityID.serialize(outputStream);
            this.transmitterRadioID.serialize(outputStream);
        }
        catch (IOException ioError) {
            throw new RuntimeException("Exception in ReceiverPdu.serialize, error writing to wire.");
        }
    }

    public void deSerialize(DataInputStream inputStream) {
        super.deSerialize(inputStream);
        try {
            this.entityID.deSerialize(inputStream);
            this.radioID.deSerialize(inputStream);
            this.receiverState.deSerialize(inputStream);
            this.padding.deSerialize(inputStream);
            this.receiverPower = inputStream.readFloat();
            this.transmitterEntityID.deSerialize(inputStream);
            this.transmitterRadioID.deSerialize(inputStream);
        }
        catch (IOException ioError) {
            throw new RuntimeException("Exception in ReceiverPdu.deSerialize, error reading from wire.");
        }
    }

    public int length() {
        return 288;
    }

    public String pduName() {
        return new String("Receiver PDU");
    }

    public void printValues(int indentLevel, PrintStream printStream) {
        StringBuffer indent = ProtocolDataUnit.getPaddingOfLength(indentLevel);
        int superclassIndent = indentLevel;
        printStream.println();
        printStream.println("Receiver PDU-");
        if (superclassIndent > 0) {
            --superclassIndent;
        }
        super.printValues(superclassIndent, printStream);
        this.entityID.printValues(indentLevel, printStream);
        printStream.println(indent + "radioID: " + this.radioID);
        printStream.println(indent + "receiverState: " + this.receiverState);
        printStream.println(indent + "receiverPower: " + this.receiverPower);
        this.transmitterEntityID.printValues(indentLevel, printStream);
        printStream.println(indent + "transmitterRadioID: " + this.transmitterRadioID);
    }

    public EntityID getEntityID() {
        return (EntityID)this.entityID.clone();
    }

    public void setEntityID(EntityID pEntityID) {
        this.entityID = pEntityID;
    }

    public void setEntityID(short pSiteID, short pApplicationID, short pEntityID) {
        this.entityID = new EntityID(pSiteID, pApplicationID, pEntityID);
    }

    public UnsignedShort getRadioID() {
        return (UnsignedShort)this.radioID.clone();
    }

    public void setRadioID(UnsignedShort pRadioID) {
        this.radioID = pRadioID;
    }

    public UnsignedShort getReceiverState() {
        return (UnsignedShort)this.receiverState.clone();
    }

    public void setReceiverState(UnsignedShort pReceiverState) {
        this.receiverState = pReceiverState;
    }

    public float getReceiverPower() {
        return this.receiverPower;
    }

    public void setReceiverPower(float pReceiverPower) {
        this.receiverPower = pReceiverPower;
    }

    public EntityID getTransmitterEntityID() {
        return (EntityID)this.transmitterEntityID.clone();
    }

    public void setTransmitterEntityID(EntityID pEntityID) {
        this.transmitterEntityID = pEntityID;
    }

    public UnsignedShort getTransmitterRadioID() {
        return (UnsignedShort)this.transmitterRadioID.clone();
    }

    public void setTransmitterRadioID(UnsignedShort pTransmitterRadioID) {
        this.transmitterRadioID = pTransmitterRadioID;
    }

    public String toString() {
        String result = "\nEntityID = " + this.entityID + " \nRadioID = " + this.radioID + "\nReceiverState = " + this.receiverState + "\nPadding = " + this.padding + "\nReceiverPower = " + this.receiverPower + "\nTransmitterEntityID = " + this.transmitterEntityID + "\nTransmitterRadioID = " + this.transmitterRadioID;
        return result;
    }
}

