/*
 * Decompiled with CFR 0.152.
 */
package mil.navy.nps.dis;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import mil.navy.nps.dis.CollisionPdu;
import mil.navy.nps.dis.CommentPdu;
import mil.navy.nps.dis.CreateEntityPdu;
import mil.navy.nps.dis.DataPdu;
import mil.navy.nps.dis.DetonationPdu;
import mil.navy.nps.dis.EntityStatePdu;
import mil.navy.nps.dis.FirePdu;
import mil.navy.nps.dis.ProtocolDataUnit;
import mil.navy.nps.dis.ReceiverPdu;
import mil.navy.nps.dis.RemoveEntityPdu;
import mil.navy.nps.dis.SignalPdu;
import mil.navy.nps.dis.TransmitterPdu;
import mil.navy.nps.disEnumerations.PduTypeField;
import mil.navy.nps.util.UnsignedByte;

public class PduFactory {
    private static boolean debug = false;

    private static void setDebug(boolean debugState) {
        debug = debugState;
    }

    private static void debug(String message) {
        if (debug) {
            System.out.println("PduFactory: " + message);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static ProtocolDataUnit newPdu(byte[] pByteArray) {
        void var1_9;
        UnsignedByte pduType = new UnsignedByte();
        byte[] initialBuf = pByteArray;
        ByteArrayInputStream initialByteStream = new ByteArrayInputStream(initialBuf);
        DataInputStream initialDataStream = new DataInputStream(initialByteStream);
        UnsignedByte firstByte = new UnsignedByte();
        firstByte.deSerialize(initialDataStream);
        int offset = 0;
        offset = firstByte.intValue() == 128 ? 13 : 1;
        try {
            initialDataStream.skipBytes(offset);
            pduType.deSerialize(initialDataStream);
        }
        catch (IOException ioError) {
            throw new RuntimeException("Exception in ProtocolDataUnit. Error instantiating from byte array.");
        }
        try {
            initialDataStream.reset();
        }
        catch (IOException ioException) {
            throw new RuntimeException("byteArrayToPdu:  Exception in ProtocolDataUnit. Error reseting stream.");
        }
        switch (pduType.shortValue()) {
            case 4: {
                PduFactory.debug("got a packet with PduTypeField.COLLISION, instantiating a CollisionPdu");
                ProtocolDataUnit newPdu = new CollisionPdu();
                break;
            }
            case 22: {
                PduFactory.debug("got a packet with PduTypeField.COMMENT, instantiating a CommentPdu");
                ProtocolDataUnit newPdu = new CommentPdu();
                break;
            }
            case 11: {
                PduFactory.debug("got a packet with PduTypeField.CREATEENTITY, instantiating a CreateEntityPdu");
                ProtocolDataUnit newPdu = new CreateEntityPdu();
                break;
            }
            case 20: {
                PduFactory.debug("got a packet with PduTypeField.DATA, instantiating a DataPdu");
                ProtocolDataUnit newPdu = new DataPdu();
                break;
            }
            case 3: {
                PduFactory.debug("got a packet with PduTypeField.DETONATION, instantiating a DetonationPdu");
                ProtocolDataUnit newPdu = new DetonationPdu();
                break;
            }
            case 1: {
                PduFactory.debug("got a packet with PduTypeField.ENTITYSTATE, instantiating an EntityStatePdu (ESPDU)");
                ProtocolDataUnit newPdu = new EntityStatePdu();
                break;
            }
            case 2: {
                PduFactory.debug("got a packet with PduTypeField.FIRE, instantiating a FirePdu");
                ProtocolDataUnit newPdu = new FirePdu();
                break;
            }
            case 27: {
                PduFactory.debug("got a packet with PduTypeField.RECEIVER, instantiating a ReceiverPdu");
                ProtocolDataUnit newPdu = new ReceiverPdu();
                break;
            }
            case 12: {
                PduFactory.debug("got a packet with PduTypeField.REMOVEENTITY, instantiating a RemoveEntityPdu");
                ProtocolDataUnit newPdu = new RemoveEntityPdu();
                break;
            }
            case 26: {
                PduFactory.debug("got a packet with PduTypeField.SIGNAL, instantiating a SignalPdu");
                ProtocolDataUnit newPdu = new SignalPdu();
                break;
            }
            case 25: {
                PduFactory.debug("got a packet with PduTypeField.TRANSMITTER, instantiating a TransmitterPdu");
                ProtocolDataUnit newPdu = new TransmitterPdu();
                break;
            }
            default: {
                PduFactory.debug("Unrecognized PDU type received in packet: " + pduType.shortValue() + ", " + PduTypeField.toString(pduType.shortValue()));
                return null;
            }
        }
        var1_9.deSerialize(initialDataStream);
        PduFactory.debug("translated a datagram into a PDU");
        return var1_9;
    }

    public static ProtocolDataUnit newPdu(DatagramPacket packet) {
        byte[] data = packet.getData();
        return PduFactory.newPdu(data);
    }

    public static byte[] getDisFormat(ProtocolDataUnit pdu) {
        byte[] data = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            pdu.serialize(dos);
            data = baos.toByteArray();
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return data;
    }
}

