/*
 * Decompiled with CFR 0.152.
 */
package mil.navy.nps.dis;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import mil.navy.nps.dis.PduElement;
import mil.navy.nps.dis.ProtocolDataUnit;

public class FixedDatum
extends PduElement {
    protected int fixedDatumID;
    protected int value;
    public static final int sizeOf = 8;

    public FixedDatum() {
        this.fixedDatumID = 0;
        this.value = 0;
    }

    public FixedDatum(int pFixedDatumID, int pValue) {
        this.fixedDatumID = pFixedDatumID;
        this.value = pValue;
    }

    public Object clone() {
        FixedDatum newFixedDatum = new FixedDatum();
        newFixedDatum.setFixedDatumID(this.fixedDatumID);
        newFixedDatum.setValue(this.value);
        return newFixedDatum;
    }

    public void serialize(DataOutputStream outputStream) {
        try {
            outputStream.writeInt(this.fixedDatumID);
            outputStream.writeInt(this.value);
        }
        catch (IOException ioException) {
            throw new RuntimeException("Exception in FixedDatum. Error serializing unit.");
        }
    }

    public void deSerialize(DataInputStream inputStream) {
        try {
            this.fixedDatumID = inputStream.readInt();
            this.value = inputStream.readInt();
        }
        catch (IOException ioException) {
            throw new RuntimeException("Exception in FixedDatum. Error deSerializing unit.");
        }
    }

    public int length() {
        return 8;
    }

    public void printValues(int indentLevel, PrintStream printStream) {
        StringBuffer indent = ProtocolDataUnit.getPaddingOfLength(indentLevel);
        int superclassIndent = indentLevel;
        printStream.println(indent + "fixedDatumID: " + this.fixedDatumID);
        printStream.println(indent + "value: " + this.value);
    }

    public int getFixedDatumID() {
        return this.fixedDatumID;
    }

    public void setFixedDatumID(int pFixedDatumID) {
        this.fixedDatumID = pFixedDatumID;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int pValue) {
        this.value = pValue;
    }
}

