/*
 * Decompiled with CFR 0.152.
 */
package mil.navy.nps.dis;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.PrintStream;
import mil.navy.nps.dis.PduElement;
import mil.navy.nps.dis.ProtocolDataUnit;
import mil.navy.nps.util.UnsignedShort;

public class EventID
extends PduElement {
    protected UnsignedShort siteID;
    protected UnsignedShort applicationID;
    protected UnsignedShort eventID;
    protected static final int sizeOf = 6;

    public EventID() {
        this.siteID = new UnsignedShort(0);
        this.applicationID = new UnsignedShort(0);
        this.eventID = new UnsignedShort(0);
    }

    public EventID(short pSiteID, short pApplicationID, short pEventID) {
        this.siteID = new UnsignedShort(pSiteID);
        this.applicationID = new UnsignedShort(pApplicationID);
        this.eventID = new UnsignedShort(pEventID);
    }

    public Object clone() {
        EventID newEventID = new EventID();
        newEventID.setSiteID(this.getSiteID());
        newEventID.setApplicationID(this.getApplicationID());
        newEventID.setEventID(this.getEventID());
        return newEventID;
    }

    public void serialize(DataOutputStream outputStream) {
        this.siteID.serialize(outputStream);
        this.applicationID.serialize(outputStream);
        this.eventID.serialize(outputStream);
    }

    public void deSerialize(DataInputStream inputStream) {
        this.siteID.deSerialize(inputStream);
        this.applicationID.deSerialize(inputStream);
        this.eventID.deSerialize(inputStream);
    }

    public int length() {
        return 6;
    }

    public void printValues(int indentLevel, PrintStream printStream) {
        StringBuffer indent = ProtocolDataUnit.getPaddingOfLength(indentLevel);
        int superclassIndent = indentLevel;
        printStream.println(indent + "EventID siteID: " + this.siteID.intValue());
        printStream.println(indent + "EventID applicationID: " + this.applicationID.intValue());
        printStream.println(indent + "EventID eventID: " + this.eventID.intValue());
    }

    public int hashCode() {
        int hashCode = 0;
        int site = this.siteID.intValue();
        int event = this.eventID.intValue();
        hashCode = event << 16;
        return hashCode &= site;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EventID compareObj = (EventID)obj;
        int site = this.siteID.intValue();
        int application = this.applicationID.intValue();
        int event = this.eventID.intValue();
        int objSiteID = compareObj.getSiteID().intValue();
        int objApplicationID = compareObj.getApplicationID().intValue();
        int objEventID = compareObj.getEventID().intValue();
        return site == objSiteID && application == objApplicationID && event == objEventID;
    }

    public UnsignedShort getSiteID() {
        return (UnsignedShort)this.siteID.clone();
    }

    public void setSiteID(UnsignedShort pSiteID) {
        this.siteID = pSiteID;
    }

    public void setSiteID(int pSiteID) {
        this.siteID = new UnsignedShort(pSiteID);
    }

    public UnsignedShort getApplicationID() {
        return (UnsignedShort)this.applicationID.clone();
    }

    public void setApplicationID(UnsignedShort pApplicationID) {
        this.applicationID = pApplicationID;
    }

    public void setApplicationID(int pApplicationID) {
        this.applicationID = new UnsignedShort(pApplicationID);
    }

    public UnsignedShort getEventID() {
        return (UnsignedShort)this.eventID.clone();
    }

    public void setEventID(UnsignedShort pEventID) {
        this.eventID = pEventID;
    }

    public void setEventID(int pEventID) {
        this.eventID = new UnsignedShort(pEventID);
    }
}

