/*
 * Decompiled with CFR 0.152.
 */
package mil.navy.nps.dis;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import mil.navy.nps.dis.PduElement;
import mil.navy.nps.dis.ProtocolDataUnit;

public class EulerAngle
extends PduElement {
    protected float psi;
    protected float theta;
    protected float phi;
    public final int sizeOf = 12;

    public EulerAngle() {
        this.psi = 0.0f;
        this.theta = 0.0f;
        this.phi = 0.0f;
    }

    public EulerAngle(float pPsi, float pTheta, float pPhi) {
        this.psi = pPsi;
        this.theta = pTheta;
        this.phi = pPhi;
    }

    public Object clone() {
        EulerAngle newEulerAngle = new EulerAngle(this.psi, this.theta, this.phi);
        return newEulerAngle;
    }

    public void serialize(DataOutputStream outputStream) {
        try {
            outputStream.writeFloat(this.psi);
            outputStream.writeFloat(this.theta);
            outputStream.writeFloat(this.phi);
        }
        catch (IOException ioError) {
            throw new RuntimeException("Exception in EulerAngle. Error writing to wire.");
        }
    }

    public void deSerialize(DataInputStream pInputStream) {
        try {
            this.psi = pInputStream.readFloat();
            this.theta = pInputStream.readFloat();
            this.phi = pInputStream.readFloat();
        }
        catch (IOException ioError) {
            throw new RuntimeException("Exception in EulerAngle. Error reading from wire.");
        }
    }

    public int length() {
        return 12;
    }

    public void printValues(int indentLevel, PrintStream printStream) {
        StringBuffer indent = ProtocolDataUnit.getPaddingOfLength(indentLevel);
        int superclassIndent = indentLevel;
        printStream.println(indent + "EulerAngle psi: " + this.psi);
        printStream.println(indent + "EulerAngle theta: " + this.theta);
        printStream.println(indent + "EulerAngle phi: " + this.phi);
    }

    public void setValues(float pPsi, float pTheta, float pPhi) {
        this.psi = pPsi;
        this.theta = pTheta;
        this.phi = pPhi;
    }

    public float getPsi() {
        return this.psi;
    }

    public void setPsi(float pPsi) {
        this.psi = pPsi;
    }

    public float getTheta() {
        return this.theta;
    }

    public void setTheta(float pTheta) {
        this.theta = pTheta;
    }

    public float getPhi() {
        return this.phi;
    }

    public void setPhi(float pPhi) {
        this.phi = pPhi;
    }
}

