/*
 * Decompiled with CFR 0.152.
 */
package mil.navy.nps.dis;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import mil.navy.nps.dis.AngularVelocity;
import mil.navy.nps.dis.ArticulationParameter;
import mil.navy.nps.dis.EntityID;
import mil.navy.nps.dis.EntityType;
import mil.navy.nps.dis.EulerAngle;
import mil.navy.nps.dis.LinearAcceleration;
import mil.navy.nps.dis.LinearVelocity;
import mil.navy.nps.dis.ProtocolDataUnit;
import mil.navy.nps.dis.WorldCoordinate;
import mil.navy.nps.util.UnsignedByte;
import mil.navy.nps.util.UnsignedInt;
import mil.navy.nps.util.UnsignedShort;

public class EntityStatePdu
extends ProtocolDataUnit {
    public static final boolean DEBUG = false;
    protected EntityID entityID;
    protected UnsignedByte forceID;
    protected EntityType entityType;
    protected EntityType alternativeEntityType;
    protected LinearVelocity entityLinearVelocity;
    protected WorldCoordinate entityLocation;
    protected EulerAngle entityOrientation;
    protected UnsignedInt entityAppearance;
    protected UnsignedByte deadReckoningAlgorithm;
    protected byte[] deadReckoningParameters;
    protected LinearAcceleration entityLinearAcceleration;
    protected AngularVelocity entityAngularVelocity;
    protected UnsignedByte characterSet;
    protected String marking = new String("");
    protected UnsignedInt capabilities;
    protected Vector articulationParameters;
    public static final int sizeOf = 132;
    protected static EntityStatePdu exemplar;

    protected static void debug(String pDiagnostic) {
    }

    protected static void trace(String pDiagnostic) {
        System.out.println("EntityStatePdu: " + pDiagnostic);
    }

    public EntityStatePdu() {
        this.pduType = new UnsignedByte(1);
        this.entityID = new EntityID();
        this.forceID = new UnsignedByte();
        this.entityType = new EntityType();
        this.alternativeEntityType = new EntityType();
        this.entityLinearVelocity = new LinearVelocity();
        this.entityLocation = new WorldCoordinate();
        this.entityOrientation = new EulerAngle();
        this.entityAppearance = new UnsignedInt();
        this.deadReckoningAlgorithm = new UnsignedByte();
        this.deadReckoningParameters = new byte[15];
        this.entityLinearAcceleration = new LinearAcceleration(0.0f, 0.0f, 0.0f);
        this.entityAngularVelocity = new AngularVelocity(0.0f, 0.0f, 0.0f);
        this.characterSet = new UnsignedByte();
        this.capabilities = new UnsignedInt(0);
        this.articulationParameters = new Vector(0);
    }

    public void serialize(DataOutputStream outputStream) {
        int idx = 0;
        byte[] entityMarkingBytes = new byte[11];
        int nullByte = 0;
        EntityStatePdu.debug("Entering ESPDU serialization");
        super.serialize(outputStream);
        EntityStatePdu.debug("Serialized superclass in ESPDU");
        try {
            EntityStatePdu.debug("EntityStatePdu serialized " + outputStream.size());
            this.entityID.serialize(outputStream);
            this.forceID.serialize(outputStream);
            UnsignedByte articulationParameterCount = new UnsignedByte(this.articulationParameters.size());
            articulationParameterCount.serialize(outputStream);
            this.entityType.serialize(outputStream);
            this.alternativeEntityType.serialize(outputStream);
            this.entityLinearVelocity.serialize(outputStream);
            this.entityLocation.serialize(outputStream);
            EntityStatePdu.debug("EntityStatePdu serialized " + outputStream.size());
            this.entityOrientation.serialize(outputStream);
            EntityStatePdu.debug("EntityStatePdu serialized " + outputStream.size());
            this.entityAppearance.serialize(outputStream);
            EntityStatePdu.debug("EntityStatePdu serialized " + outputStream.size());
            this.deadReckoningAlgorithm.serialize(outputStream);
            for (idx = 0; idx < 15; ++idx) {
                outputStream.writeByte(this.deadReckoningParameters[idx]);
            }
            this.entityLinearAcceleration.serialize(outputStream);
            this.entityAngularVelocity.serialize(outputStream);
            EntityStatePdu.debug("EntityStatePdu serialized " + outputStream.size());
            this.characterSet.serialize(outputStream);
            EntityStatePdu.debug("just serialized the character set in ESPDU..");
            String fileEncoding = System.getProperty("file.encoding");
            EntityStatePdu.debug("fileEncoding = " + fileEncoding);
            entityMarkingBytes = this.marking.getBytes(fileEncoding);
            EntityStatePdu.debug("going into entity marking loop, number of bytes=" + entityMarkingBytes.length);
            for (idx = 0; idx < 11; ++idx) {
                if (idx < entityMarkingBytes.length) {
                    outputStream.writeByte(entityMarkingBytes[idx]);
                } else {
                    outputStream.writeByte(nullByte);
                }
                EntityStatePdu.debug("serialized byte " + idx + " of entity marking bytes");
            }
            EntityStatePdu.debug("EntityStatePdu serialized " + outputStream.size());
            this.capabilities.serialize(outputStream);
            for (idx = 0; idx < this.articulationParameters.size(); ++idx) {
                ArticulationParameter aParameter = (ArticulationParameter)this.articulationParameters.elementAt(idx);
                aParameter.serialize(outputStream);
            }
            EntityStatePdu.debug("EntityStatePdu serialized " + outputStream.size());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            EntityStatePdu.trace("Exception in EntityStatePdu.  UnsupportedEncodingException");
            throw new RuntimeException("Error serializing unit.");
        }
        catch (IOException ioException) {
            throw new RuntimeException("Exception in EntityStatePdu. Error serializing unit.");
        }
        EntityStatePdu.debug("Exiting serialize in ESPDU");
    }

    public void deSerialize(DataInputStream dataInputStream) {
        int idx = 0;
        byte[] entityMarkingBytes = new byte[11];
        super.deSerialize(dataInputStream);
        try {
            this.entityID.deSerialize(dataInputStream);
            this.forceID.deSerialize(dataInputStream);
            int articulationParameterCount = dataInputStream.readByte();
            this.entityType.deSerialize(dataInputStream);
            this.alternativeEntityType.deSerialize(dataInputStream);
            this.entityLinearVelocity.deSerialize(dataInputStream);
            this.entityLocation.deSerialize(dataInputStream);
            this.entityOrientation.deSerialize(dataInputStream);
            this.entityAppearance.deSerialize(dataInputStream);
            this.deadReckoningAlgorithm.deSerialize(dataInputStream);
            for (idx = 0; idx < 15; ++idx) {
                this.deadReckoningParameters[idx] = dataInputStream.readByte();
            }
            this.entityLinearAcceleration.deSerialize(dataInputStream);
            this.entityAngularVelocity.deSerialize(dataInputStream);
            this.characterSet.deSerialize(dataInputStream);
            for (idx = 0; idx < 11; ++idx) {
                entityMarkingBytes[idx] = dataInputStream.readByte();
            }
            this.marking = new String(entityMarkingBytes);
            this.capabilities.deSerialize(dataInputStream);
            int cnt = articulationParameterCount < 0 ? 255 + articulationParameterCount + 1 : articulationParameterCount;
            for (idx = 0; idx < cnt; ++idx) {
                ArticulationParameter aParameter = new ArticulationParameter();
                aParameter.deSerialize(dataInputStream);
                this.articulationParameters.addElement(aParameter);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            EntityStatePdu.debug("Exception in EntityStatePdu.  UnsupportedEncodingException ");
            throw new RuntimeException("Error deSerializing unit.");
        }
        catch (IOException ioException) {
            throw new RuntimeException("Exception in EntityStatePdu. Error deSerializing unit.");
        }
    }

    public Object clone() {
        EntityStatePdu newPdu = (EntityStatePdu)super.clone();
        newPdu.setEntityID(this.entityID);
        newPdu.setForceID(this.getForceID());
        UnsignedByte parameterCount = this.articulationParameterCount();
        newPdu.setEntityType(this.getEntityType());
        newPdu.setAlternativeEntityType(this.getAlternativeEntityType());
        newPdu.setEntityLinearVelocity(this.getEntityLinearVelocity());
        newPdu.setEntityLocation(this.getEntityLocation());
        newPdu.setEntityOrientation(this.getEntityOrientation());
        newPdu.setDeadReckoningAlgorithm(this.getDeadReckoningAlgorithm());
        newPdu.setDeadReckoningParameters(this.getDeadReckoningParameters());
        newPdu.setEntityLinearAcceleration(this.getEntityLinearAcceleration());
        newPdu.setEntityAngularVelocity(this.getEntityAngularVelocity());
        newPdu.setCharacterSet(this.getCharacterSet());
        newPdu.setMarking(this.getMarking());
        newPdu.setCapabilities(this.getCapabilities());
        for (int idx = 0; idx < parameterCount.intValue(); ++idx) {
            newPdu.addArticulationParameter(this.getArticulationParameterAt(idx));
        }
        return newPdu;
    }

    public int length() {
        int currentLength = 0;
        currentLength = super.length() + 132 + this.articulationParameters.size() * 16;
        return currentLength;
    }

    public String pduName() {
        return new String("ESPDU");
    }

    public void printValues(int indentLevel, PrintStream printStream) {
        int idx;
        StringBuffer buf = ProtocolDataUnit.getPaddingOfLength(indentLevel);
        int superclassIndent = indentLevel;
        if (superclassIndent > 0) {
            --superclassIndent;
        }
        printStream.println();
        printStream.println("Entity State PDU printValues()");
        super.printValues(superclassIndent, printStream);
        this.entityID.printValues(indentLevel, printStream);
        printStream.println(buf + "forceID: " + this.forceID.intValue());
        printStream.println(buf + "articulationParameterCount: " + this.articulationParameterCount());
        printStream.println("entityType");
        this.entityType.printValues(indentLevel, printStream);
        printStream.println("alternativeEntityType");
        this.alternativeEntityType.printValues(indentLevel, printStream);
        this.entityLinearVelocity.printValues(indentLevel, printStream);
        this.entityLocation.printValues(indentLevel, printStream);
        this.entityOrientation.printValues(indentLevel, printStream);
        printStream.println(buf + "entityAppearance: " + this.entityAppearance.longValue());
        printStream.println(buf + "deadReckoningAlgorithm: " + this.deadReckoningAlgorithm.intValue());
        printStream.print(buf);
        for (idx = 0; idx < 15; ++idx) {
            printStream.print(this.deadReckoningParameters[idx]);
            if (idx >= 14) continue;
            printStream.print(", ");
        }
        printStream.println();
        this.entityLinearAcceleration.printValues(indentLevel, printStream);
        this.entityAngularVelocity.printValues(indentLevel, printStream);
        printStream.println(buf + "characterSet: " + this.characterSet.intValue());
        printStream.println(buf + "marking: " + this.marking);
        printStream.println(buf + "capabilities: " + this.capabilities.longValue());
        for (idx = 0; idx < this.articulationParameters.size(); ++idx) {
            ArticulationParameter aParam = (ArticulationParameter)this.articulationParameters.elementAt(idx);
            aParam.printValues(indentLevel + 4, printStream, idx);
        }
    }

    public static EntityStatePdu getExemplar() {
        return (EntityStatePdu)exemplar.clone();
    }

    public static void setExemplar(EntityStatePdu newExemplar) {
        exemplar = newExemplar;
    }

    public EntityID getEntityID() {
        return (EntityID)this.entityID.clone();
    }

    public void setEntityID(EntityID pEntityID) {
        this.entityID = pEntityID;
    }

    public void setEntityID(short pSiteID, short pApplicationID, short pEntityID) {
        this.entityID = new EntityID(pSiteID, pApplicationID, pEntityID);
    }

    public UnsignedByte getForceID() {
        return (UnsignedByte)this.forceID.clone();
    }

    public void setForceID(UnsignedByte pForceID) {
        this.forceID = pForceID;
    }

    public void setForceID(int pForceID) {
        this.forceID = new UnsignedByte(pForceID);
    }

    public UnsignedByte articulationParameterCount() {
        return new UnsignedByte(this.articulationParameters.size());
    }

    public int articulationParameterCountValue() {
        return this.articulationParameters.size();
    }

    public EntityType getEntityType() {
        return (EntityType)this.entityType.clone();
    }

    public void setEntityType(EntityType pEntityType) {
        this.entityType = pEntityType;
    }

    public UnsignedByte getEntityTypeKind() {
        return this.entityType.getKind();
    }

    public void setEntityTypeKind(UnsignedByte pEntityKind) {
        this.entityType.setKind(pEntityKind);
    }

    public void setEntityTypeKind(int pEntityKind) {
        this.entityType.setKind(pEntityKind);
    }

    public UnsignedByte getEntityTypeDomain() {
        return this.entityType.getDomain();
    }

    public void setEntityTypeDomain(UnsignedByte pEntityDomain) {
        this.entityType.setDomain(pEntityDomain);
    }

    public void setEntityDomain(int pEntityDomain) {
        this.entityType.setDomain(pEntityDomain);
    }

    public UnsignedShort getEntityTypeCountry() {
        return this.entityType.getCountry();
    }

    public void setEntityTypeCountry(UnsignedShort pEntityCountry) {
        this.entityType.setCountry(pEntityCountry);
    }

    public void setEntityTypeCountry(int pEntityCountry) {
        this.entityType.setCountry(pEntityCountry);
    }

    public UnsignedByte getEntityTypeCategory() {
        return this.entityType.getCategory();
    }

    public void setEntityTypeCategory(UnsignedByte pEntityCategory) {
        this.entityType.setCategory(pEntityCategory);
    }

    public void setEntityTypeCategory(int pEntityCategory) {
        this.entityType.setCategory(pEntityCategory);
    }

    public UnsignedByte getEntityTypeSubcategory() {
        return this.entityType.getSubCategory();
    }

    public void setEntityTypeSubcategory(UnsignedByte pEntitySubcategory) {
        this.entityType.setSubCategory(pEntitySubcategory);
    }

    public void setEntityTypeSubcategory(int pEntitySubcategory) {
        this.entityType.setSubCategory(pEntitySubcategory);
    }

    public UnsignedByte getEntityTypeSpecific() {
        return this.entityType.getSpecific();
    }

    public void setEntityTypeSpecific(UnsignedByte pEntitySpecific) {
        this.entityType.setSpecific(pEntitySpecific);
    }

    public void setEntityTypeSpecific(int pEntitySpecific) {
        this.entityType.setSpecific(pEntitySpecific);
    }

    public UnsignedByte getEntityTypeExtra() {
        return this.entityType.getExtra();
    }

    public void setEntityTypeExtra(UnsignedByte pEntityExtra) {
        this.entityType.setExtra(pEntityExtra);
    }

    public void setEntityTypeExtra(int pEntityExtra) {
        this.entityType.setExtra(pEntityExtra);
    }

    public EntityType getAlternativeEntityType() {
        return (EntityType)this.alternativeEntityType.clone();
    }

    public void setAlternativeEntityType(EntityType pNewAltEntity) {
        this.alternativeEntityType = pNewAltEntity;
    }

    public UnsignedByte getAlternativeEntityTypeKind() {
        return this.alternativeEntityType.getKind();
    }

    public void setAlternativeEntityTypeKind(UnsignedByte pEntityKind) {
        this.alternativeEntityType.setKind(pEntityKind);
    }

    public void setAlternativeEntityTypeKind(int pEntityKind) {
        this.alternativeEntityType.setKind(pEntityKind);
    }

    public UnsignedByte getAlternativeEntityTypeDomain() {
        return this.alternativeEntityType.getDomain();
    }

    public void setAlternativeEntityTypeDomain(UnsignedByte pEntityDomain) {
        this.alternativeEntityType.setDomain(pEntityDomain);
    }

    public void setAlternativeEntityDomain(int pEntityDomain) {
        this.alternativeEntityType.setDomain(pEntityDomain);
    }

    public UnsignedShort getAlternativeEntityTypeCountry() {
        return this.alternativeEntityType.getCountry();
    }

    public void setAlternativeEntityTypeCountry(UnsignedShort pEntityCountry) {
        this.alternativeEntityType.setCountry(pEntityCountry);
    }

    public void setAlternativeEntityCountry(int pEntityCountry) {
        this.alternativeEntityType.setCountry(pEntityCountry);
    }

    public UnsignedByte getAlternativeEntityTypeCategory() {
        return this.alternativeEntityType.getCategory();
    }

    public void setAlternativeEntityTypeCategory(UnsignedByte pEntityCategory) {
        this.alternativeEntityType.setCategory(pEntityCategory);
    }

    public void setAlternativeEntityTypeCategory(int pEntityCategory) {
        this.alternativeEntityType.setCategory(pEntityCategory);
    }

    public UnsignedByte getAlternativeEntityTypeSubcategory() {
        return this.alternativeEntityType.getSubCategory();
    }

    public void setAlternativeEntityTypeSubcategory(UnsignedByte pEntitySubcategory) {
        this.alternativeEntityType.setSubCategory(pEntitySubcategory);
    }

    public void setAlternativeEntityTypeSubcategory(int pEntitySubcategory) {
        this.alternativeEntityType.setSubCategory(pEntitySubcategory);
    }

    public UnsignedByte getAlternativeEntityTypeSpecific() {
        return this.alternativeEntityType.getSpecific();
    }

    public void setAlternativeEntityTypeSpecific(UnsignedByte pEntitySpecific) {
        this.alternativeEntityType.setSpecific(pEntitySpecific);
    }

    public void setAlternativeEntityTypeSpecific(int pEntitySpecific) {
        this.alternativeEntityType.setSpecific(pEntitySpecific);
    }

    public UnsignedByte getAlternativeEntityTypeExtra() {
        return this.alternativeEntityType.getExtra();
    }

    public void setAlternativeEntityTypeExtra(UnsignedByte pEntityExtra) {
        this.alternativeEntityType.setExtra(pEntityExtra);
    }

    public void setAlternativeEntityTypeExtra(int pEntityExtra) {
        this.alternativeEntityType.setExtra(pEntityExtra);
    }

    public LinearVelocity getEntityLinearVelocity() {
        return (LinearVelocity)this.entityLinearVelocity.clone();
    }

    public void setEntityLinearVelocity(LinearVelocity pVelocity) {
        this.entityLinearVelocity = pVelocity;
    }

    public float getEntityLinearVelocityX() {
        return this.entityLinearVelocity.getX();
    }

    public void setEntityLinearVelocityX(float pVelocityX) {
        this.entityLinearVelocity.setX(pVelocityX);
    }

    public float getEntityLinearVelocityY() {
        return this.entityLinearVelocity.getY();
    }

    public void setEntityLinearVelocityY(float pVelocityY) {
        this.entityLinearVelocity.setY(pVelocityY);
    }

    public float getEntityLinearVelocityZ() {
        return this.entityLinearVelocity.getZ();
    }

    public void setEntityLinearVelocityZ(float pVelocityZ) {
        this.entityLinearVelocity.setZ(pVelocityZ);
    }

    public WorldCoordinate getEntityLocation() {
        return (WorldCoordinate)this.entityLocation.clone();
    }

    public void setEntityLocation(WorldCoordinate pLocation) {
        this.entityLocation = pLocation;
    }

    public double getEntityLocationX() {
        return this.entityLocation.getX();
    }

    public void setEntityLocationX(double pLocationX) {
        this.entityLocation.setX(pLocationX);
    }

    public double getEntityLocationY() {
        return this.entityLocation.getY();
    }

    public void setEntityLocationY(double pLocationY) {
        this.entityLocation.setY(pLocationY);
    }

    public double getEntityLocationZ() {
        return this.entityLocation.getZ();
    }

    public void setEntityLocationZ(double pLocationZ) {
        this.entityLocation.setZ(pLocationZ);
    }

    public EulerAngle getEntityOrientation() {
        return (EulerAngle)this.entityOrientation.clone();
    }

    public void setEntityOrientation(EulerAngle pNewOrientation) {
        this.entityOrientation = pNewOrientation;
    }

    public float getEntityOrientationPsi() {
        return this.entityOrientation.getPsi();
    }

    public void setEntityOrientationPsi(float pPsi) {
        this.entityOrientation.setPsi(pPsi);
    }

    public float getEntityOrientationTheta() {
        return this.entityOrientation.getTheta();
    }

    public void setEntityOrientationTheta(float pTheta) {
        this.entityOrientation.setTheta(pTheta);
    }

    public float getEntityOrientationPhi() {
        return this.entityOrientation.getPhi();
    }

    public void setEntityOrientationPhi(float pPhi) {
        this.entityOrientation.setPhi(pPhi);
    }

    public UnsignedInt getEntityAppearance() {
        return (UnsignedInt)this.entityAppearance.clone();
    }

    public void setEntityAppearance(UnsignedInt pEntityAppearance) {
        this.entityAppearance = pEntityAppearance;
    }

    public void setEntityAppearance(int pEntityAppearance) {
        this.entityAppearance = new UnsignedInt(pEntityAppearance);
    }

    public UnsignedByte getDeadReckoningAlgorithm() {
        return (UnsignedByte)this.deadReckoningAlgorithm.clone();
    }

    public void setDeadReckoningAlgorithm(UnsignedByte pDeadReckoningAlgorithm) {
        this.deadReckoningAlgorithm = pDeadReckoningAlgorithm;
    }

    public void setDeadReckoningAlgorithm(int pDeadReckoningAlgorithm) {
        this.deadReckoningAlgorithm = new UnsignedByte(pDeadReckoningAlgorithm);
    }

    public byte[] getDeadReckoningParameters() {
        byte[] newDRParams = new byte[11];
        int idx = 0;
        for (idx = 0; idx < 11; ++idx) {
            newDRParams[idx] = this.deadReckoningParameters[idx];
        }
        return newDRParams;
    }

    public void setDeadReckoningParameters(byte[] pDeadReckoningParameters) {
        int idx = 0;
        if (pDeadReckoningParameters.length > 11) {
            throw new RuntimeException("Exception in EntityStatePdu. Length of dead reckoning parameters too long.");
        }
        for (idx = 0; idx < 11; ++idx) {
            this.deadReckoningParameters[idx] = 0;
        }
        for (idx = 0; idx < pDeadReckoningParameters.length; ++idx) {
            this.deadReckoningParameters[idx] = pDeadReckoningParameters[idx];
        }
    }

    public LinearAcceleration getEntityLinearAcceleration() {
        return (LinearAcceleration)this.entityLinearAcceleration.clone();
    }

    public void setEntityLinearAcceleration(LinearAcceleration pAcceleration) {
        this.entityLinearAcceleration = pAcceleration;
    }

    public void setEntityLinearAcceleration(float pX, float pY, float pZ) {
        this.entityLinearAcceleration.setValues(pX, pY, pZ);
    }

    public float getEntityLinearAccelerationX() {
        return this.entityLinearAcceleration.getX();
    }

    public void setEntityLinearAccelerationX(float pEntityAcceleration) {
        this.entityLinearAcceleration.setX(pEntityAcceleration);
    }

    public float getEntityLinearAccelerationY() {
        return this.entityLinearAcceleration.getY();
    }

    public void setEntityLinearAccelerationY(float pEntityAcceleration) {
        this.entityLinearAcceleration.setY(pEntityAcceleration);
    }

    public float getEntityLinearAccelerationZ() {
        return this.entityLinearAcceleration.getZ();
    }

    public void setEntityLinearAccelerationZ(float pEntityAcceleration) {
        this.entityLinearAcceleration.setZ(pEntityAcceleration);
    }

    public AngularVelocity getEntityAngularVelocity() {
        return (AngularVelocity)this.entityAngularVelocity.clone();
    }

    public void setEntityAngularVelocity(AngularVelocity pAngV) {
        this.entityAngularVelocity = pAngV;
    }

    public void setEntityAngularVelocity(float pX, float pY, float pZ) {
        this.entityAngularVelocity.setValues(pX, pY, pZ);
    }

    public float getEntityAngularVelocityX() {
        return this.entityAngularVelocity.getX();
    }

    public void setEntityAngularVelocityX(float pEntityAngularVelocity) {
        this.entityAngularVelocity.setX(pEntityAngularVelocity);
    }

    public float getEntityAngularVelocityY() {
        return this.entityAngularVelocity.getY();
    }

    public void setEntityAngularVelocityY(float pEntityAngularVelocity) {
        this.entityAngularVelocity.setY(pEntityAngularVelocity);
    }

    public float getEntityAngularVelocityZ() {
        return this.entityAngularVelocity.getZ();
    }

    public void setEntityAngularVelocityZ(float pEntityAngularVelocity) {
        this.entityAngularVelocity.setZ(pEntityAngularVelocity);
    }

    public UnsignedByte getCharacterSet() {
        return (UnsignedByte)this.characterSet.clone();
    }

    public void setCharacterSet(UnsignedByte pCharacterSet) {
        this.characterSet = pCharacterSet;
    }

    public void setCharacterSet(int pCharacterSet) {
        this.characterSet = new UnsignedByte(pCharacterSet);
    }

    public String getMarking() {
        if (this.marking == null) {
            EntityStatePdu.debug("getMarking():  marking == null!  reset to blank string");
            this.marking = new String("           ");
            return this.marking;
        }
        StringBuffer readableMarking = new StringBuffer(this.marking);
        for (int i = 0; i < this.marking.length(); ++i) {
            if (readableMarking.charAt(i) != '\u0000' && readableMarking.charAt(i) != '\n' && readableMarking.charAt(i) != '\r' && readableMarking.charAt(i) != '\t') continue;
            readableMarking.setCharAt(i, ' ');
        }
        return readableMarking.toString();
    }

    public String toString() {
        String result = this.entityID.toString();
        result = result + " " + this.timestamp;
        return result;
    }

    public void setMarking(String pMarking) {
        if (pMarking == null) {
            EntityStatePdu.debug("setMarking():  pMarking == null!");
            this.marking = new String("           ");
        }
        if (pMarking.length() > 11) {
            this.marking = new String(pMarking.substring(0, 10));
            EntityStatePdu.debug("marking too long, truncating to fit 11 characters:  " + this.marking);
        } else {
            this.marking = new String(pMarking);
            for (int i = 1; i <= 11 - pMarking.length(); ++i) {
                this.marking = this.marking + " ";
            }
            EntityStatePdu.debug("marking = [" + this.marking + "]");
        }
    }

    public UnsignedInt getCapabilities() {
        return (UnsignedInt)this.capabilities.clone();
    }

    public void setCapabilities(UnsignedInt pCapabilities) {
        this.capabilities = pCapabilities;
    }

    public void setCapabilities(int pCapabilities) {
        this.capabilities = new UnsignedInt(pCapabilities);
    }

    public ArticulationParameter getArticulationParameterAt(int pIdx) {
        ArticulationParameter aParameter = (ArticulationParameter)this.articulationParameters.elementAt(pIdx);
        return aParameter;
    }

    public void getArticulationParameters(ArticulationParameter[] vals) {
        this.articulationParameters.toArray(vals);
    }

    public void addArticulationParameter(ArticulationParameter pParameter) {
        this.articulationParameters.addElement(pParameter);
    }

    public void reset() {
        this.articulationParameters.clear();
    }
}

