/*
 * Decompiled with CFR 0.152.
 */
package mil.navy.nps.dis;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.PrintStream;
import mil.navy.nps.dis.PduElement;
import mil.navy.nps.dis.ProtocolDataUnit;
import mil.navy.nps.util.UnsignedShort;

public class EntityID
extends PduElement {
    public static final int SHORT_HIGH_BYTE_MASK = 65280;
    public static final int SHORT_LOW_BYTE_MASK = 255;
    protected UnsignedShort siteID;
    protected UnsignedShort applicationID;
    protected UnsignedShort entityID;
    private static final int sizeOf = 6;

    public EntityID() {
        this.siteID = new UnsignedShort(0);
        this.applicationID = new UnsignedShort(0);
        this.entityID = new UnsignedShort(0);
    }

    public EntityID(short pSiteID, short pApplicationID, short pEntityID) {
        this.siteID = new UnsignedShort(pSiteID);
        this.applicationID = new UnsignedShort(pApplicationID);
        this.entityID = new UnsignedShort(pEntityID);
    }

    public EntityID(int pSiteID, int pApplicationID, int pEntityID) {
        this.siteID = new UnsignedShort(pSiteID);
        this.applicationID = new UnsignedShort(pApplicationID);
        this.entityID = new UnsignedShort(pEntityID);
    }

    public Object clone() {
        EntityID newEntityID = new EntityID();
        newEntityID.setSiteID(this.getSiteID());
        newEntityID.setApplicationID(this.getApplicationID());
        newEntityID.setEntityID(this.getEntityID());
        return newEntityID;
    }

    public void serialize(DataOutputStream outputStream) {
        this.siteID.serialize(outputStream);
        this.applicationID.serialize(outputStream);
        this.entityID.serialize(outputStream);
    }

    public void deSerialize(DataInputStream inputStream) {
        this.siteID.deSerialize(inputStream);
        this.applicationID.deSerialize(inputStream);
        this.entityID.deSerialize(inputStream);
    }

    public int length() {
        return 6;
    }

    public void printValues(int indentLevel, PrintStream printStream) {
        StringBuffer indent = ProtocolDataUnit.getPaddingOfLength(indentLevel);
        int superclassIndent = indentLevel;
        int[] dottedDecimal = new int[4];
        printStream.println(indent + "EntityID siteID: " + this.siteID.intValue());
        printStream.println(indent + "EntityID applicationID: " + this.applicationID.intValue());
        int siteIDValue = this.siteID.intValue();
        int appIDValue = this.applicationID.intValue();
        dottedDecimal[0] = siteIDValue & 0xFF00;
        dottedDecimal[0] = dottedDecimal[0] >>> 8;
        dottedDecimal[1] = siteIDValue & 0xFF;
        dottedDecimal[2] = appIDValue & 0xFF00;
        dottedDecimal[2] = dottedDecimal[2] >>> 8;
        dottedDecimal[3] = appIDValue & 0xFF;
        printStream.println(indent + "Dotted decimal format: " + dottedDecimal[0] + "." + dottedDecimal[1] + "." + dottedDecimal[2] + "." + dottedDecimal[3]);
        printStream.println(indent + "EntityID entityID: " + this.entityID.intValue());
    }

    public String toString() {
        return "(site, application, entity ID) = (" + this.siteID.toString() + ", " + this.applicationID.toString() + ", " + this.entityID.toString() + ")";
    }

    public int hashCode() {
        int hashCode = 0;
        int site = this.siteID.intValue();
        int entity = this.entityID.intValue();
        hashCode = entity << 16;
        return hashCode |= site;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EntityID compareObj = (EntityID)obj;
        int site = this.siteID.intValue();
        int application = this.applicationID.intValue();
        int entity = this.entityID.intValue();
        int objSiteID = compareObj.getSiteID().intValue();
        int objApplicationID = compareObj.getApplicationID().intValue();
        int objEntityID = compareObj.getEntityID().intValue();
        return site == objSiteID && application == objApplicationID && entity == objEntityID;
    }

    public UnsignedShort getSiteID() {
        return (UnsignedShort)this.siteID.clone();
    }

    public int getSiteIDValue() {
        return this.siteID.intValue();
    }

    public void setSiteID(UnsignedShort pSiteID) {
        this.siteID = pSiteID;
    }

    public void setSiteID(int pSiteID) {
        this.siteID = new UnsignedShort(pSiteID);
    }

    public UnsignedShort getApplicationID() {
        return (UnsignedShort)this.applicationID.clone();
    }

    public int getApplicationIDValue() {
        return this.applicationID.intValue();
    }

    public void setApplicationID(UnsignedShort pApplicationID) {
        this.applicationID = pApplicationID;
    }

    public void setApplicationID(int pApplicationID) {
        this.applicationID = new UnsignedShort(pApplicationID);
    }

    public UnsignedShort getEntityID() {
        return (UnsignedShort)this.entityID.clone();
    }

    public int getEntityIDValue() {
        return this.entityID.intValue();
    }

    public void setEntityID(UnsignedShort pEntityID) {
        this.entityID = pEntityID;
    }

    public void setEntityID(int pEntityID) {
        this.entityID = new UnsignedShort(pEntityID);
    }
}

