/*
 * Decompiled with CFR 0.152.
 */
package mil.navy.nps.dis;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Vector;
import mil.navy.nps.dis.ProtocolDataUnit;
import mil.navy.nps.dis.SimulationManagementFamily;
import mil.navy.nps.util.UnsignedInt;

public class DataQueryPdu
extends SimulationManagementFamily {
    protected UnsignedInt requestID = new UnsignedInt();
    protected UnsignedInt timeInterval = new UnsignedInt();
    protected Vector fixedDatumIDList = new Vector();
    protected Vector variableDatumIDList = new Vector();
    public static final int sizeOf = 16;
    protected static DataQueryPdu exemplar;

    public DataQueryPdu() {
        super.setPduType((short)18);
    }

    public String pduName() {
        return new String("Data Query PDU");
    }

    public void serialize(DataOutputStream outputStream) {
        UnsignedInt aID;
        super.serialize(outputStream);
        this.requestID.serialize(outputStream);
        this.timeInterval.serialize(outputStream);
        UnsignedInt fixedDatumCount = new UnsignedInt(this.fixedDatumIDList.size());
        UnsignedInt variableDatumCount = new UnsignedInt(this.variableDatumIDList.size());
        fixedDatumCount.serialize(outputStream);
        variableDatumCount.serialize(outputStream);
        Enumeration listContents = this.fixedDatumIDList.elements();
        while (listContents.hasMoreElements()) {
            aID = (UnsignedInt)listContents.nextElement();
            aID.serialize(outputStream);
        }
        listContents = this.variableDatumIDList.elements();
        while (listContents.hasMoreElements()) {
            aID = (UnsignedInt)listContents.nextElement();
            aID.serialize(outputStream);
        }
    }

    public void deSerialize(DataInputStream inputStream) {
        UnsignedInt aID;
        int idx = 0;
        UnsignedInt variableDatumCount = new UnsignedInt(0);
        UnsignedInt fixedDatumCount = new UnsignedInt(0);
        super.deSerialize(inputStream);
        this.requestID.deSerialize(inputStream);
        this.timeInterval.deSerialize(inputStream);
        fixedDatumCount.deSerialize(inputStream);
        variableDatumCount.deSerialize(inputStream);
        idx = 0;
        while ((long)idx < fixedDatumCount.longValue()) {
            aID = new UnsignedInt();
            aID.deSerialize(inputStream);
            this.fixedDatumIDList.addElement(aID);
            ++idx;
        }
        idx = 0;
        while ((long)idx < variableDatumCount.longValue()) {
            aID = new UnsignedInt();
            aID.deSerialize(inputStream);
            this.variableDatumIDList.addElement(aID);
            ++idx;
        }
    }

    public Object clone() {
        int idx;
        DataQueryPdu newPdu = (DataQueryPdu)super.clone();
        newPdu.setRequestID(this.requestID.longValue());
        newPdu.setActionID(this.timeInterval.longValue());
        int fixedDatumCount = this.fixedDatumIDList.size();
        for (idx = 0; idx < fixedDatumCount; ++idx) {
            newPdu.addFixedDatumID(this.fixedDatumIDAt(idx));
        }
        int variableDatumCount = this.variableDatumIDList.size();
        for (idx = 0; idx < variableDatumCount; ++idx) {
            newPdu.addVariableDatumID(this.variableDatumIDAt(idx));
        }
        return newPdu;
    }

    public int length() {
        int currentLength = 0;
        currentLength = super.length() + 16 + (this.fixedDatumIDList.size() + this.variableDatumIDList.size()) * 4;
        return currentLength;
    }

    public void printValues(int indentLevel, PrintStream printStream) {
        int idx;
        StringBuffer indent = ProtocolDataUnit.getPaddingOfLength(indentLevel);
        int superclassIndent = indentLevel;
        printStream.println();
        printStream.println("Data Query PDU");
        if (superclassIndent > 0) {
            --superclassIndent;
        }
        super.printValues(superclassIndent, printStream);
        printStream.println(indent + "RequestID    : " + this.requestID.longValue());
        printStream.println(indent + "TimeInterval : " + this.timeInterval.longValue());
        for (idx = 0; idx < this.fixedDatumIDList.size(); ++idx) {
            printStream.println(indent + "Fixed Datum ID#" + idx + ": " + this.fixedDatumIDAt(idx));
        }
        for (idx = 0; idx < this.variableDatumIDList.size(); ++idx) {
            printStream.println(indent + "Variable Datum ID#" + idx + ": " + this.variableDatumIDAt(idx));
        }
    }

    public DataQueryPdu getExemplar() {
        return (DataQueryPdu)exemplar.clone();
    }

    public void setExemplar(DataQueryPdu newExemplar) {
        exemplar = newExemplar;
    }

    public UnsignedInt getRequestID() {
        return (UnsignedInt)this.requestID.clone();
    }

    public void setRequestID(long pRequestID) {
        this.requestID = new UnsignedInt(pRequestID);
    }

    public UnsignedInt getTimeInterval() {
        return (UnsignedInt)this.timeInterval.clone();
    }

    public void setActionID(long pActionID) {
        this.timeInterval = new UnsignedInt(pActionID);
    }

    public int fixedDatumIDCount() {
        return this.fixedDatumIDList.size();
    }

    public int variableDatumIDCount() {
        return this.variableDatumIDList.size();
    }

    public void addFixedDatumID(long pFixedDatumID) {
        this.fixedDatumIDList.addElement(new UnsignedInt(pFixedDatumID));
    }

    public long fixedDatumIDAt(int pIdx) {
        UnsignedInt aID = (UnsignedInt)this.fixedDatumIDList.elementAt(pIdx);
        return aID.longValue();
    }

    public void dropFixedDatumID() {
        this.fixedDatumIDList = new Vector();
    }

    public void addVariableDatumID(long pVariableDatumID) {
        this.variableDatumIDList.addElement(new UnsignedInt(pVariableDatumID));
    }

    public long variableDatumIDAt(int pIdx) {
        UnsignedInt aID = (UnsignedInt)this.variableDatumIDList.elementAt(pIdx);
        return aID.longValue();
    }

    public void dropVariableDatumID() {
        this.variableDatumIDList = new Vector();
    }
}

