/*
 * Decompiled with CFR 0.152.
 */
package mil.navy.nps.dis;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import mil.navy.nps.dis.PduElement;
import mil.navy.nps.util.UnsignedInt;

public class ClockTime
extends PduElement {
    protected int hour;
    protected UnsignedInt timePastHour;
    public static final int sizeOf = 8;

    public ClockTime() {
        this.hour = 0;
        this.timePastHour = new UnsignedInt();
    }

    public ClockTime(long pHour, long pTimePastHour) {
        this.hour = (int)pHour;
        this.timePastHour = new UnsignedInt(pTimePastHour);
    }

    public Object clone() {
        ClockTime newClockTime = new ClockTime();
        newClockTime.setHour(this.hour);
        newClockTime.setTimePastHour(this.getTimePastHour());
        return newClockTime;
    }

    public void serialize(DataOutputStream outputStream) {
        try {
            outputStream.writeInt(this.hour);
            this.timePastHour.serialize(outputStream);
        }
        catch (IOException ioException) {
            throw new RuntimeException("Exception in ClockTime. Error serializing unit.");
        }
    }

    public void deSerialize(DataInputStream inputStream) {
        try {
            this.hour = inputStream.readInt();
            this.timePastHour.deSerialize(inputStream);
        }
        catch (IOException ioException) {
            throw new RuntimeException("Exception in ClockTime. Error deSerializing unit.");
        }
    }

    public int length() {
        return 8;
    }

    public void printValues(int indentLevel, PrintStream printStream) {
        char[] indent = new char[indentLevel];
        int idx = 0;
        for (idx = 0; idx < indentLevel; ++idx) {
            indent[idx] = 32;
        }
        String spacing = new String(indent);
        printStream.println(indent + "Hour: " + this.hour);
        printStream.println(indent + "Time Past Hour: " + this.timePastHour.longValue());
    }

    public int getHour() {
        return this.hour;
    }

    public void setHour(int pHour) {
        this.hour = pHour;
    }

    public void setHour(long pHour) {
        this.hour = (int)pHour;
    }

    public int getTimePastHour() {
        return ((UnsignedInt)this.timePastHour.clone()).intValue();
    }

    public void setTimePastHour(UnsignedInt pTimePastHour) {
        this.timePastHour = pTimePastHour;
    }

    public void setTimePastHour(long pTimePastHour) {
        this.timePastHour = new UnsignedInt(pTimePastHour);
    }

    public void setValues(long pHour, long pTimePastHour) {
        this.hour = (int)pHour;
        this.timePastHour = new UnsignedInt(pTimePastHour);
    }
}

