/*
 * Decompiled with CFR 0.152.
 */
package mil.navy.nps.dis;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.PrintStream;
import mil.navy.nps.dis.EntityType;
import mil.navy.nps.dis.PduElement;
import mil.navy.nps.dis.ProtocolDataUnit;
import mil.navy.nps.util.UnsignedShort;

public class BurstDescriptor
extends PduElement {
    protected EntityType munition = new EntityType();
    protected UnsignedShort warhead = new UnsignedShort();
    protected UnsignedShort fuse = new UnsignedShort();
    protected UnsignedShort quantity = new UnsignedShort();
    protected UnsignedShort rate = new UnsignedShort();
    public static final int sizeOf = 16;

    public Object clone() {
        BurstDescriptor newBurstDescriptor = new BurstDescriptor();
        newBurstDescriptor.setMunition(this.getMunition());
        newBurstDescriptor.setWarhead(this.getWarhead());
        newBurstDescriptor.setFuse(this.getFuse());
        newBurstDescriptor.setQuantity(this.getQuantity());
        newBurstDescriptor.setRate(this.getRate());
        return newBurstDescriptor;
    }

    public void serialize(DataOutputStream outputStream) {
        this.munition.serialize(outputStream);
        this.warhead.serialize(outputStream);
        this.fuse.serialize(outputStream);
        this.quantity.serialize(outputStream);
        this.rate.serialize(outputStream);
    }

    public void deSerialize(DataInputStream inputStream) {
        this.munition.deSerialize(inputStream);
        this.warhead.deSerialize(inputStream);
        this.fuse.deSerialize(inputStream);
        this.quantity.deSerialize(inputStream);
        this.rate.deSerialize(inputStream);
    }

    public int length() {
        return 16;
    }

    public void printValues(int indentLevel, PrintStream printStream) {
        StringBuffer buf = ProtocolDataUnit.getPaddingOfLength(indentLevel);
        int superclassIndent = indentLevel;
        this.munition.printValues(indentLevel, printStream);
        printStream.println(buf + "warhead: " + this.warhead.intValue());
        printStream.println(buf + "fuse: " + this.fuse.intValue());
        printStream.println(buf + "quantity: " + this.quantity.intValue());
        printStream.println(buf + "rate: " + this.rate.intValue());
    }

    public EntityType getMunition() {
        return (EntityType)this.munition.clone();
    }

    public void setMunition(EntityType pMunition) {
        this.munition = pMunition;
    }

    public UnsignedShort getWarhead() {
        return (UnsignedShort)this.warhead.clone();
    }

    public void setWarhead(UnsignedShort pWarhead) {
        this.warhead = pWarhead;
    }

    public void setWarhead(int pWarhead) {
        this.warhead = new UnsignedShort(pWarhead);
    }

    public UnsignedShort getFuse() {
        return (UnsignedShort)this.fuse.clone();
    }

    public void setFuse(UnsignedShort pFuse) {
        this.fuse = pFuse;
    }

    public void setFuse(int pFuse) {
        this.fuse = new UnsignedShort(pFuse);
    }

    public UnsignedShort getQuantity() {
        return (UnsignedShort)this.quantity.clone();
    }

    public void setQuantity(UnsignedShort pQuantity) {
        this.quantity = pQuantity;
    }

    public void setQuantity(int pQuantity) {
        this.quantity = new UnsignedShort(pQuantity);
    }

    public UnsignedShort getRate() {
        return (UnsignedShort)this.rate.clone();
    }

    public void setRate(UnsignedShort pRate) {
        this.rate = pRate;
    }

    public void setRate(int pRate) {
        this.rate = new UnsignedShort(pRate);
    }
}

