/*
 * Decompiled with CFR 0.152.
 */
package mil.navy.nps.dis;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.PrintStream;
import mil.navy.nps.dis.ProtocolDataUnit;
import mil.navy.nps.dis.SimulationManagementFamily;
import mil.navy.nps.util.UnsignedInt;
import mil.navy.nps.util.UnsignedShort;

public class AcknowledgePdu
extends SimulationManagementFamily {
    protected UnsignedShort acknowledgeFlag;
    protected UnsignedShort responseFlag;
    protected UnsignedInt requestID;
    public static final int sizeOf = 32;
    protected static AcknowledgePdu exemplar;

    public AcknowledgePdu() {
        this.setPduType((short)15);
        this.acknowledgeFlag = new UnsignedShort();
        this.responseFlag = new UnsignedShort();
        this.requestID = new UnsignedInt();
    }

    public void serialize(DataOutputStream outputStream) {
        super.serialize(outputStream);
        this.acknowledgeFlag.serialize(outputStream);
        this.responseFlag.serialize(outputStream);
        this.requestID.serialize(outputStream);
    }

    public void deSerialize(DataInputStream inputStream) {
        super.deSerialize(inputStream);
        this.acknowledgeFlag.deSerialize(inputStream);
        this.responseFlag.deSerialize(inputStream);
        this.requestID.deSerialize(inputStream);
    }

    public Object clone() {
        AcknowledgePdu newPdu = (AcknowledgePdu)super.clone();
        newPdu.setAcknowledgeFlag(this.getAcknowledgeFlag());
        newPdu.setResponseFlag(this.getResponseFlag());
        newPdu.setRequestID(this.getRequestID());
        return newPdu;
    }

    public int length() {
        return 32;
    }

    public String pduName() {
        return new String("Acknowledge PDU");
    }

    public void printValues(int indentLevel, PrintStream printStream) {
        StringBuffer buf = ProtocolDataUnit.getPaddingOfLength(indentLevel);
        int superclassIndent = indentLevel;
        printStream.println();
        printStream.println("Acknowledge PDU");
        if (superclassIndent > 0) {
            --superclassIndent;
        }
        super.printValues(superclassIndent, printStream);
        printStream.println(buf + "Acknowledge Flag: " + this.acknowledgeFlag.intValue());
        printStream.println(buf + "Response Flag   : " + this.responseFlag.intValue());
        printStream.println(buf + "Request ID      : " + this.requestID.longValue());
    }

    public AcknowledgePdu getExemplar() {
        return (AcknowledgePdu)exemplar.clone();
    }

    public void setExemplar(AcknowledgePdu newExemplar) {
        exemplar = newExemplar;
    }

    public UnsignedShort getAcknowledgeFlag() {
        return (UnsignedShort)this.acknowledgeFlag.clone();
    }

    public void setAcknowledgeFlag(UnsignedShort pAcknowledgeFlag) {
        this.acknowledgeFlag = pAcknowledgeFlag;
    }

    public void setAcknowledgeFlag(int pAcknowledgeFlag) {
        this.acknowledgeFlag = new UnsignedShort(pAcknowledgeFlag);
    }

    public UnsignedShort getResponseFlag() {
        return (UnsignedShort)this.responseFlag.clone();
    }

    public void setResponseFlag(UnsignedShort pResponseFlag) {
        this.responseFlag = pResponseFlag;
    }

    public void setResponseFlag(int pResponseFlag) {
        this.responseFlag = new UnsignedShort(pResponseFlag);
    }

    public UnsignedInt getRequestID() {
        return (UnsignedInt)this.requestID.clone();
    }

    public void setRequestID(UnsignedInt pRequestID) {
        this.requestID = pRequestID;
    }

    public void setRequestID(int pRequestID) {
        this.requestID = new UnsignedInt(pRequestID);
    }
}

