/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class SocketWriteUI
extends Panel
implements ItemListener {
    public static final String DEFAULT_MCAST = "224.2.181.145";
    public static final String DEFAULT_PORT = "62040";
    public static final String DEFUALT_SITE_APP_ID = "localhost";
    public static final String DEFAULT_UNICAST_DEST_PORT = "8006";
    public static final String DEFAULT_UNICAST_DEST_ADDR = "localhost";
    public static final boolean DEBUG = false;
    private static CheckboxGroup socketTypeRadio;
    private static Checkbox multicastCheckbox;
    private static Checkbox unicastCheckbox;
    private static TextField mcastAddress;
    private static TextField port;
    private static TextField unicastDestAddress;
    private static TextField unicastDestPort;
    private static Choice ttl;
    private static boolean beanIsMulticast;
    private static String beanMcastAddress;
    private static int beanPort;
    private static String beanUnicastDestAddress;
    private static int beanUnicastDestPort;
    private static int beanTTL;

    public void debug(String pDebugString) {
    }

    public SocketWriteUI() {
        Panel socketStyleRegion = new Panel();
        Panel socketTextFieldsRegion = new Panel();
        GridLayout socketRegionLayout = new GridLayout(1, 2);
        GridLayout socketRadioLayout = new GridLayout(2, 2);
        GridLayout socketTextFieldsLayout = new GridLayout(5, 2);
        socketTypeRadio = new CheckboxGroup();
        socketStyleRegion.setLayout(socketRadioLayout);
        multicastCheckbox = new Checkbox("Multicast", socketTypeRadio, true);
        socketStyleRegion.add(multicastCheckbox);
        unicastCheckbox = new Checkbox("Unicast", socketTypeRadio, false);
        socketStyleRegion.add(unicastCheckbox);
        unicastCheckbox.addItemListener(this);
        multicastCheckbox.addItemListener(this);
        socketTextFieldsRegion.setLayout(socketTextFieldsLayout);
        mcastAddress = new TextField(DEFAULT_MCAST, 15);
        socketTextFieldsRegion.add(new Label("Multicast Address:"));
        socketTextFieldsRegion.add(mcastAddress);
        socketTextFieldsRegion.add(new Label("Multicast TTL:"));
        ttl = new Choice();
        ttl.add("Site       15");
        ttl.add("Region   63");
        ttl.add("World  127");
        socketTextFieldsRegion.add(ttl);
        port = new TextField(DEFAULT_PORT, 5);
        socketTextFieldsRegion.add(new Label("Port:"));
        socketTextFieldsRegion.add(port);
        socketTextFieldsRegion.add(new Label("Unicast Destination Port:"));
        unicastDestPort = new TextField(DEFAULT_UNICAST_DEST_PORT, 5);
        socketTextFieldsRegion.add(unicastDestPort);
        unicastDestPort.setEnabled(false);
        unicastDestAddress = new TextField("localhost", 20);
        socketTextFieldsRegion.add(new Label("Unicast Destination Address:"));
        socketTextFieldsRegion.add(unicastDestAddress);
        unicastDestAddress.setEnabled(false);
        this.add((Component)socketStyleRegion, "East");
        this.add((Component)socketTextFieldsRegion, "West");
    }

    public Dimension getPreferredSize() {
        return new Dimension(450, 125);
    }

    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source == unicastCheckbox) {
            this.setMulticastFieldsOn(false);
        }
        if (source == multicastCheckbox) {
            this.setMulticastFieldsOn(true);
        }
    }

    public void setMulticastFieldsOn(boolean pStatus) {
        beanIsMulticast = pStatus;
        if (!pStatus) {
            unicastDestAddress.setEnabled(true);
            unicastDestPort.setEnabled(true);
            mcastAddress.setEnabled(false);
            ttl.setEnabled(false);
        } else {
            unicastDestAddress.setEnabled(false);
            unicastDestPort.setEnabled(false);
            mcastAddress.setEnabled(true);
            ttl.setEnabled(true);
        }
    }

    public void setBeanIsMulticast(boolean pIsMulticast) {
        beanIsMulticast = pIsMulticast;
        if (pIsMulticast) {
            this.setMulticastFieldsOn(true);
        } else {
            this.setMulticastFieldsOn(false);
        }
    }

    public boolean getBeanIsMulticast() {
        Checkbox selectedCheckbox = socketTypeRadio.getSelectedCheckbox();
        if (selectedCheckbox == multicastCheckbox) {
            beanIsMulticast = true;
            return true;
        }
        beanIsMulticast = false;
        return false;
    }

    public void setBeanMcastAddress(String pMcastAddress) {
        beanMcastAddress = pMcastAddress;
        mcastAddress.setText(pMcastAddress);
    }

    public String getBeanMcastAddress() {
        beanMcastAddress = mcastAddress.getText();
        return beanMcastAddress;
    }

    public void setBeanPort(int pBeanPort) {
        beanPort = pBeanPort;
        port.setText(Integer.toString(beanPort));
    }

    public int getBeanPort() {
        beanPort = Integer.parseInt(port.getText());
        return beanPort;
    }

    public void setBeanUnicastDestAddress(String pBeanUnicastDestAddress) {
        beanUnicastDestAddress = pBeanUnicastDestAddress;
        unicastDestAddress.setText(beanUnicastDestAddress);
    }

    public String getBeanUnicastDestAddress() {
        beanUnicastDestAddress = unicastDestAddress.getText();
        return beanUnicastDestAddress;
    }

    public void setBeanUnicastDestPort(int pBeanUnicastDestPort) {
        beanUnicastDestPort = pBeanUnicastDestPort;
        unicastDestPort.setText(Integer.toString(beanUnicastDestPort));
    }

    public int getBeanUnicastDestPort() {
        beanUnicastDestPort = Integer.parseInt(unicastDestPort.getText());
        return beanUnicastDestPort;
    }

    public void setBeanTTL(int pBeanTTL) {
        beanTTL = pBeanTTL;
        if (beanTTL > 127) {
            beanTTL = 127;
        }
        if (beanTTL < 0) {
            beanTTL = 0;
        }
        if (beanTTL <= 15) {
            ttl.select("Site");
        } else if (beanTTL <= 63) {
            ttl.select("Region");
        } else {
            ttl.select("World");
        }
    }

    public int getBeanTTL() {
        String selectedTTL = ttl.getSelectedItem();
        beanTTL = selectedTTL.compareTo("Site") == 0 ? 15 : (selectedTTL.compareTo("Region") == 0 ? 63 : 127);
        return beanTTL;
    }

    public static void main(String[] args) {
        SocketWriteUI socketInfoObject = new SocketWriteUI();
        Frame appFrame = new Frame("Woo hoo");
        appFrame.add(socketInfoObject);
        appFrame.setSize(500, 200);
        appFrame.setVisible(true);
    }
}

