/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class SocketReadUI
extends Panel
implements ItemListener {
    private static final int MULTICAST = 0;
    private static final int UNICAST = 1;
    private static final boolean DEBUGGING = true;
    private static final String DEFAULT_MCAST_ADDRESS = "224.2.181.145";
    private static final int DEFAULT_PORT = 62040;
    private static final int DEFAULT_SOCKET_STYLE = 0;
    private static final int TIME_TO_LIVE = 15;
    private static Panel socketStyleRegion;
    private static Panel socketTextRegion;
    private static Panel socketInfoRegion;
    private static CheckboxGroup socketTypeRadio;
    private static Checkbox multicastCheckbox;
    private static Checkbox unicastCheckbox;
    private static TextField mcastAddressField;
    private static TextField portField;
    private static String lastMulticastAddress;
    private static String lastUnicastAddress;
    private static int lastPort;
    private static boolean multicastSocket;
    private static String address;
    private static int port;
    private static boolean isEnabled;

    public SocketReadUI() {
        GridLayout socketStyleLayout = new GridLayout(2, 2);
        GridLayout socketTextLayout = new GridLayout(2, 2);
        GridLayout socketInfoLayout = new GridLayout(2, 1);
        socketStyleRegion = new Panel();
        socketTextRegion = new Panel();
        socketInfoRegion = new Panel();
        socketStyleRegion.setLayout(socketStyleLayout);
        socketTextRegion.setLayout(socketTextLayout);
        socketInfoRegion.setLayout(socketInfoLayout);
        socketTypeRadio = new CheckboxGroup();
        multicastCheckbox = new Checkbox("Multicast", socketTypeRadio, true);
        socketStyleRegion.add(multicastCheckbox);
        unicastCheckbox = new Checkbox("Unicast", socketTypeRadio, false);
        socketStyleRegion.add(unicastCheckbox);
        unicastCheckbox.addItemListener(this);
        multicastCheckbox.addItemListener(this);
        mcastAddressField = new TextField(DEFAULT_MCAST_ADDRESS, 15);
        socketTextRegion.add(new Label("Internet Address:"));
        socketTextRegion.add(mcastAddressField);
        portField = new TextField(Integer.toString(62040), 5);
        socketTextRegion.add(new Label("Port:"));
        socketTextRegion.add(portField);
        socketInfoRegion.add(socketStyleRegion);
        socketInfoRegion.add(socketTextRegion);
        this.add(socketInfoRegion);
        lastUnicastAddress = "nolocalhost";
        this.validateTree();
    }

    public Dimension getPreferredSize() {
        return new Dimension(300, 100);
    }

    private void debug(String pDebugString) {
        System.out.println(pDebugString);
    }

    public void itemStateChanged(ItemEvent ie) {
        Object source = ie.getSource();
        if (source == unicastCheckbox) {
            mcastAddressField.setEnabled(false);
        }
        if (source == multicastCheckbox) {
            mcastAddressField.setEnabled(true);
            mcastAddressField.setText(lastMulticastAddress);
        }
    }

    public boolean getMulticastSocket() {
        Checkbox selectedCheckbox = socketTypeRadio.getSelectedCheckbox();
        return selectedCheckbox == multicastCheckbox;
    }

    public void setMulticastSocket(boolean pIsMulticast) {
        if (pIsMulticast) {
            socketTypeRadio.setSelectedCheckbox(multicastCheckbox);
            mcastAddressField.setEnabled(true);
        } else {
            mcastAddressField.setEnabled(false);
            socketTypeRadio.setSelectedCheckbox(unicastCheckbox);
        }
    }

    public String getAddress() {
        return mcastAddressField.getText();
    }

    public void setAddress(String pAddress) {
        mcastAddressField.setText(pAddress);
    }

    public int getPort() {
        return Integer.valueOf(portField.getText());
    }

    public void setPort(int pPort) {
        String portValue = Integer.toString(pPort);
    }

    public void setIsEnabled(boolean pIsEnabled) {
        isEnabled = pIsEnabled;
        if (pIsEnabled) {
            if (socketTypeRadio.getSelectedCheckbox() == multicastCheckbox) {
                mcastAddressField.setEnabled(true);
            } else {
                mcastAddressField.setEnabled(false);
            }
            portField.setEnabled(true);
            multicastCheckbox.setEnabled(true);
            unicastCheckbox.setEnabled(true);
        } else {
            mcastAddressField.setEnabled(false);
            portField.setEnabled(false);
            multicastCheckbox.setEnabled(false);
            unicastCheckbox.setEnabled(false);
        }
    }

    public boolean getIsEnabled() {
        return isEnabled;
    }

    public static void main(String[] args) {
        SocketReadUI SocketReadUIObject = new SocketReadUI();
        Frame appFrame = new Frame("Woo hoo");
        appFrame.add(SocketReadUIObject);
        appFrame.setSize(400, 200);
        appFrame.setVisible(true);
    }

    static {
        lastMulticastAddress = DEFAULT_MCAST_ADDRESS;
        lastPort = 62040;
        isEnabled = true;
    }
}

