/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.dom.swing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.w3c.dom.Node;

public class DOMTreeNode
implements MutableTreeNode {
    private Node node;
    private Object userData;
    private ArrayList children;
    private HashMap nodeMap;
    private boolean leaf = false;
    private DOMTreeNode parent;
    boolean kidsLoaded = false;

    public DOMTreeNode(Node node, DOMTreeNode dOMTreeNode) {
        this.node = node;
        this.parent = dOMTreeNode;
        this.children = new ArrayList();
        this.nodeMap = new HashMap();
        this.checkLeaf();
    }

    public void insert(MutableTreeNode mutableTreeNode, int n) {
        if (n == this.children.size()) {
            this.children.add(mutableTreeNode);
        } else {
            this.children.add(n, mutableTreeNode);
        }
        Node node = ((DOMTreeNode)mutableTreeNode).getNode();
        this.nodeMap.put(node, mutableTreeNode);
    }

    public void remove(int n) {
        this.children.remove(n);
    }

    public void remove(MutableTreeNode mutableTreeNode) {
        this.children.remove(mutableTreeNode);
    }

    public void removeFromParent() {
        if (this.parent == null) {
            return;
        }
        this.parent.remove(this);
    }

    public void setParent(MutableTreeNode mutableTreeNode) {
        this.parent = (DOMTreeNode)mutableTreeNode;
    }

    public void setUserObject(Object object) {
        this.userData = object;
    }

    public Enumeration children() {
        return Collections.enumeration(this.children);
    }

    public boolean getAllowsChildren() {
        return this.leaf;
    }

    public TreeNode getChildAt(int n) {
        return (TreeNode)this.children.get(n);
    }

    public int getChildCount() {
        return this.children.size();
    }

    public int getIndex(TreeNode treeNode) {
        return this.children.indexOf(treeNode);
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public boolean isLeaf() {
        return this.leaf;
    }

    public Node getNode() {
        return this.node;
    }

    public Object getUserData() {
        return this.userData;
    }

    DOMTreeNode getTreeNodeChild(Node node) {
        return (DOMTreeNode)this.nodeMap.get(node);
    }

    private void checkLeaf() {
        short s = this.node.getNodeType();
        switch (s) {
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                this.leaf = true;
            }
        }
    }
}

