/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.dom.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.TreeCellRenderer;
import org.w3c.dom.Node;
import org.web3d.util.ShortHashMap;
import org.web3d.x3d.dom.swing.DOMTreeNode;
import org.xj3d.ui.awt.widgets.IconLoader;

public class DOMTreeCellRenderer
extends JLabel
implements TreeCellRenderer {
    private boolean selected;
    private boolean focused;
    private boolean iconFocusBorder;
    private Color textSelectColor = UIManager.getColor("Tree.selectionForeground");
    private Color textUnselectColor = UIManager.getColor("Tree.textForeground");
    private Color bgSelectColor = UIManager.getColor("Tree.selectionBackground");
    private Color bgUnselectColor = UIManager.getColor("Tree.textBackground");
    private Color borderColor = UIManager.getColor("Tree.selectionBorderColor");
    private static final ShortHashMap nodeNameMap = new ShortHashMap();

    public DOMTreeCellRenderer() {
        Object object = UIManager.get("Tree.drawsFocusBorderAroundIcon");
        this.iconFocusBorder = object != null && (Boolean)object != false;
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        this.selected = bl;
        this.focused = bl4;
        Node node = ((DOMTreeNode)object).getNode();
        String string = (String)nodeNameMap.get(node.getNodeType());
        this.setIcon(null);
        switch (node.getNodeType()) {
            case 2: {
                this.setText(node.getNodeName() + "=" + node.getNodeValue());
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                StringBuffer stringBuffer = new StringBuffer(string);
                stringBuffer.append(" \"");
                stringBuffer.append(node.getNodeValue());
                stringBuffer.append('\"');
                this.setText(stringBuffer.toString());
                break;
            }
            case 9: 
            case 11: {
                this.setText(string);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 12: {
                this.setText(node.getNodeName());
                break;
            }
            case 1: {
                String string2 = node.getNodeName();
                this.setText(string2);
                ImageIcon imageIcon = IconLoader.loadIcon((String)string2, null);
                if (imageIcon == null) break;
                this.setIcon(imageIcon);
            }
        }
        this.setComponentOrientation(jTree.getComponentOrientation());
        return this;
    }

    public void paint(Graphics graphics) {
        int n = -1;
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        if (this.focused) {
            if (this.iconFocusBorder) {
                n = 0;
            } else if (n == -1) {
                n = this.getLabelStart();
            }
        }
        if (this.selected) {
            graphics.setColor(this.bgSelectColor);
            if (this.getComponentOrientation().isLeftToRight()) {
                graphics.fillRect(n, 0, n2 - 1 - n, n3);
            } else {
                graphics.fillRect(0, 0, n2 - 1 - n, n3);
            }
            graphics.setColor(this.textSelectColor);
            this.setForeground(this.textSelectColor);
        } else {
            graphics.setColor(this.textSelectColor);
            this.setForeground(this.textSelectColor);
        }
        if (this.focused) {
            graphics.setColor(this.borderColor);
            if (this.getComponentOrientation().isLeftToRight()) {
                graphics.drawRect(n, 0, n2 - 1 - n, n3 - 1);
            } else {
                graphics.drawRect(0, 0, n2 - 1 - n, n3 - 1);
            }
        }
        super.paint(graphics);
    }

    private int getLabelStart() {
        Icon icon = this.getIcon();
        int n = 0;
        if (icon != null && this.getText() != null) {
            n = icon.getIconWidth() + Math.max(0, this.getIconTextGap() - 1);
        }
        return n;
    }

    static {
        nodeNameMap.put((short)2, "Attribute");
        nodeNameMap.put((short)4, "CDATA Section");
        nodeNameMap.put((short)8, "Comment");
        nodeNameMap.put((short)11, "Document Fragment");
        nodeNameMap.put((short)9, "Document");
        nodeNameMap.put((short)10, "Document Type");
        nodeNameMap.put((short)1, "Element");
        nodeNameMap.put((short)6, "Entity");
        nodeNameMap.put((short)5, "Entity Reference");
        nodeNameMap.put((short)12, "Notation");
        nodeNameMap.put((short)7, "Processing Instruction");
        nodeNameMap.put((short)3, "Text");
    }
}

