/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.sai;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xj3d.sai.UndefinedX3DNodeTypes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class X3DNodeTypeMapper {
    private static final String NODE_MAP_FILENAME = "config/3.2/nodemap.xml";
    private static X3DNodeTypeMapper instance;
    private Map<String, String[]> imap;
    private Map<String, Integer> typeMap;

    protected X3DNodeTypeMapper() {
        this.initializeIMap();
        this.initializeTypeMap();
    }

    public static X3DNodeTypeMapper getInstance() {
        if (instance == null) {
            instance = new X3DNodeTypeMapper();
        }
        return instance;
    }

    public String[] getInterfaces(String string) {
        return this.imap.get(string);
    }

    public int[] getInterfaceTypes(String string) {
        int[] nArray = null;
        String[] stringArray = this.imap.get(string);
        if (stringArray != null) {
            int n = stringArray.length;
            nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                String string2 = stringArray[i];
                int n2 = this.getType(string2);
                if (n2 == -1) {
                    System.out.println("Warning: NodeTypeMap: " + string2 + " is of unknown X3DNodeType");
                }
                nArray[i] = n2;
            }
        }
        if (nArray == null) {
            nArray = new int[]{-1};
        }
        return nArray;
    }

    public Map<String, String[]> getInterfaceMap() {
        return this.imap;
    }

    public String getTypeName(int n) {
        String string = null;
        for (Map.Entry<String, Integer> entry : this.typeMap.entrySet()) {
            if (n != entry.getValue()) continue;
            string = entry.getKey();
            break;
        }
        return string;
    }

    public int getType(String string) {
        int n = -1;
        Integer n2 = this.typeMap.get(string);
        if (n2 != null) {
            n = n2;
        }
        return n;
    }

    private void initializeIMap() {
        Object object;
        Object object2;
        Object object3;
        InputStream inputStream = AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

            @Override
            public InputStream run() {
                return ClassLoader.getSystemResourceAsStream(X3DNodeTypeMapper.NODE_MAP_FILENAME);
            }
        });
        if (inputStream == null) {
            object3 = X3DNodeTypeMapper.class.getClassLoader();
            inputStream = ((ClassLoader)object3).getResourceAsStream(NODE_MAP_FILENAME);
        }
        object3 = null;
        try {
            object2 = DocumentBuilderFactory.newInstance();
            ((DocumentBuilderFactory)object2).setValidating(false);
            ((DocumentBuilderFactory)object2).setNamespaceAware(false);
            object = ((DocumentBuilderFactory)object2).newDocumentBuilder();
            object3 = ((DocumentBuilder)object).parse(inputStream);
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (object3 == null) {
            System.out.println("X3DNodeTypeMapper: abstract type inheritance mapping is unavailable");
            this.imap = Collections.unmodifiableMap(new HashMap(0));
        } else {
            object2 = object3.getDocumentElement();
            object = object2.getElementsByTagName("node");
            int n = object.getLength();
            LinkedHashMap<String, String[]> linkedHashMap = new LinkedHashMap<String, String[]>(n);
            for (int i = 0; i < n; ++i) {
                Element element = (Element)object.item(i);
                String string = element.getAttribute("name");
                NodeList nodeList = element.getElementsByTagName("parent");
                int n2 = nodeList.getLength();
                String[] stringArray = new String[n2];
                for (int j = 0; j < n2; ++j) {
                    Element element2 = (Element)nodeList.item(j);
                    stringArray[j] = element2.getAttribute("name");
                }
                linkedHashMap.put(string, stringArray);
            }
            this.imap = Collections.unmodifiableMap(linkedHashMap);
        }
    }

    private void initializeTypeMap() {
        this.typeMap = new HashMap<String, Integer>();
        this.typeMap.put("X3DBoundedObject", new Integer(1));
        this.typeMap.put("X3DMetadataObject", new Integer(2));
        this.typeMap.put("X3DUrlObject", new Integer(3));
        this.typeMap.put("X3DAppearanceNode", new Integer(10));
        this.typeMap.put("X3DAppearanceChildNode", new Integer(11));
        this.typeMap.put("X3DMaterialNode", new Integer(12));
        this.typeMap.put("X3DTextureNode", new Integer(13));
        this.typeMap.put("X3DTexture2DNode", new Integer(14));
        this.typeMap.put("X3DTextureTransformNode", new Integer(16));
        this.typeMap.put("X3DTextureTransform2DNode", new Integer(17));
        this.typeMap.put("X3DGeometryNode", new Integer(18));
        this.typeMap.put("X3DGeometricPropertyNode", new Integer(19));
        this.typeMap.put("X3DParametricGeometryNode", new Integer(20));
        this.typeMap.put("X3DNurbsSurfaceGeometryNode", new Integer(21));
        this.typeMap.put("X3DColorNode", new Integer(22));
        this.typeMap.put("X3DCoordinateNode", new Integer(23));
        this.typeMap.put("X3DNormalNode", new Integer(24));
        this.typeMap.put("X3DTextureCoordinateNode", new Integer(25));
        this.typeMap.put("X3DFontStyleNode", new Integer(26));
        this.typeMap.put("X3DProtoInstance", new Integer(27));
        this.typeMap.put("X3DChildNode", new Integer(28));
        this.typeMap.put("X3DBindableNode", new Integer(29));
        this.typeMap.put("X3DBackgroundNode", new Integer(30));
        this.typeMap.put("X3DGroupingNode", new Integer(31));
        this.typeMap.put("X3DShapeNode", new Integer(32));
        this.typeMap.put("X3DInterpolatorNode", new Integer(33));
        this.typeMap.put("X3DLightNode", new Integer(34));
        this.typeMap.put("X3DScriptNode", new Integer(35));
        this.typeMap.put("X3DSensorNode", new Integer(36));
        this.typeMap.put("X3DEnvironmentalSensorNode", new Integer(37));
        this.typeMap.put("X3DKeyDeviceSensorNode", new Integer(38));
        this.typeMap.put("X3DNetworkSensorNode", new Integer(39));
        this.typeMap.put("X3DPointingDeviceSensorNode", new Integer(40));
        this.typeMap.put("X3DDragSensorNode", new Integer(41));
        this.typeMap.put("X3DTouchSensorNode", new Integer(42));
        this.typeMap.put("X3DSequencerNode", new Integer(43));
        this.typeMap.put("X3DTimeDependentNode", new Integer(44));
        this.typeMap.put("X3DSoundSourceNode", new Integer(45));
        this.typeMap.put("X3DTriggerNode", new Integer(46));
        this.typeMap.put("X3DInfoNode", new Integer(47));
        this.typeMap.put("X3DNurbsControlCurveNode", new Integer(48));
        this.typeMap.put("X3DChaserNode", new Integer(UndefinedX3DNodeTypes.X3DChaserNode));
        this.typeMap.put("X3DComposedGeometryNode", new Integer(UndefinedX3DNodeTypes.X3DComposedGeometryNode));
        this.typeMap.put("X3DDamperNode", new Integer(UndefinedX3DNodeTypes.X3DDamperNode));
        this.typeMap.put("X3DEnvironmentTextureNode", new Integer(UndefinedX3DNodeTypes.X3DEnvironmentTextureNode));
        this.typeMap.put("X3DFogObject", new Integer(UndefinedX3DNodeTypes.X3DFogObject));
        this.typeMap.put("X3DFollowerNode", new Integer(UndefinedX3DNodeTypes.X3DFollowerNode));
        this.typeMap.put("X3DLayerNode", new Integer(UndefinedX3DNodeTypes.X3DLayerNode));
        this.typeMap.put("X3DLayoutNode", new Integer(UndefinedX3DNodeTypes.X3DLayoutNode));
        this.typeMap.put("X3DNBodyCollidableNode", new Integer(UndefinedX3DNodeTypes.X3DNBodyCollidableNode));
        this.typeMap.put("X3DNBodyCollisionSpaceNode", new Integer(UndefinedX3DNodeTypes.X3DNBodyCollisionSpaceNode));
        this.typeMap.put("X3DNode", new Integer(UndefinedX3DNodeTypes.X3DNode));
        this.typeMap.put("X3DParticleEmitterNode", new Integer(UndefinedX3DNodeTypes.X3DParticleEmitterNode));
        this.typeMap.put("X3DParticlePhysicsModelNode", new Integer(UndefinedX3DNodeTypes.X3DParticlePhysicsModelNode));
        this.typeMap.put("X3DPickableObject", new Integer(UndefinedX3DNodeTypes.X3DPickableObject));
        this.typeMap.put("X3DPickingNode", new Integer(UndefinedX3DNodeTypes.X3DPickingNode));
        this.typeMap.put("X3DProductStructureChildNode", new Integer(UndefinedX3DNodeTypes.X3DProductStructureChildNode));
        this.typeMap.put("X3DProgrammableShaderObject", new Integer(UndefinedX3DNodeTypes.X3DProgrammableShaderObject));
        this.typeMap.put("X3DRigidJointNode", new Integer(UndefinedX3DNodeTypes.X3DRigidJointNode));
        this.typeMap.put("X3DShaderNode", new Integer(UndefinedX3DNodeTypes.X3DShaderNode));
        this.typeMap.put("X3DSoundNode", new Integer(UndefinedX3DNodeTypes.X3DSoundNode));
        this.typeMap.put("X3DTexture3DNode", new Integer(UndefinedX3DNodeTypes.X3DTexture3DNode));
        this.typeMap.put("X3DVertexAttributeNode", new Integer(UndefinedX3DNodeTypes.X3DVertexAttributeNode));
        this.typeMap.put("X3DViewpointNode", new Integer(UndefinedX3DNodeTypes.X3DViewpointNode));
        this.typeMap.put("X3DViewportNode", new Integer(UndefinedX3DNodeTypes.X3DViewportNode));
    }

    public static void main(String[] stringArray) {
        X3DNodeTypeMapper x3DNodeTypeMapper = X3DNodeTypeMapper.getInstance();
        Map<String, String[]> map = x3DNodeTypeMapper.getInterfaceMap();
        for (Map.Entry<String, String[]> entry : map.entrySet()) {
            String string = entry.getKey();
            String[] stringArray2 = entry.getValue();
            StringBuffer stringBuffer = new StringBuffer(string + " : ");
            for (int i = 0; i < stringArray2.length; ++i) {
                stringBuffer.append(stringArray2[i]);
                if (i >= stringArray2.length - 1) continue;
                stringBuffer.append(", ");
            }
            System.out.println(stringBuffer.toString());
            x3DNodeTypeMapper.getInterfaceTypes(string);
        }
    }
}

