/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.sai;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class X3DNodeComponentMapper {
    private static final String NODE_MAP_FILENAME = "config/3.2/profiles.xml";
    private static X3DNodeComponentMapper instance;
    private Map<String, String> nodeMap;
    private Map<String, Integer> levelMap;

    protected X3DNodeComponentMapper() {
        this.initializeNodeMap();
    }

    public static X3DNodeComponentMapper getInstance() {
        if (instance == null) {
            instance = new X3DNodeComponentMapper();
        }
        return instance;
    }

    public String getComponentName(String string) {
        return this.nodeMap.get(string);
    }

    public Integer getComponentLevel(String string) {
        return this.levelMap.get(string);
    }

    private void initializeNodeMap() {
        Object object;
        Object object2;
        Object object3;
        InputStream inputStream = (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ClassLoader.getSystemResourceAsStream(X3DNodeComponentMapper.NODE_MAP_FILENAME);
            }
        });
        if (inputStream == null) {
            object3 = X3DNodeComponentMapper.class.getClassLoader();
            inputStream = ((ClassLoader)object3).getResourceAsStream(NODE_MAP_FILENAME);
        }
        object3 = null;
        try {
            object2 = DocumentBuilderFactory.newInstance();
            ((DocumentBuilderFactory)object2).setValidating(false);
            ((DocumentBuilderFactory)object2).setNamespaceAware(false);
            object = ((DocumentBuilderFactory)object2).newDocumentBuilder();
            object3 = ((DocumentBuilder)object).parse(inputStream);
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (object3 == null) {
            System.out.println("X3DNodeComponentMapper: node to component mapping is unavailable");
            this.nodeMap = new HashMap<String, String>(0);
            this.levelMap = new HashMap<String, Integer>(0);
        } else {
            this.nodeMap = new HashMap<String, String>();
            this.levelMap = new HashMap<String, Integer>();
            object2 = object3.getDocumentElement();
            object = object2.getElementsByTagName("componentConfig");
            Element element = (Element)object.item(0);
            NodeList nodeList = element.getElementsByTagName("component");
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element2 = (Element)nodeList.item(i);
                String string = element2.getAttribute("name");
                String string2 = string.toLowerCase().replaceAll("-", "");
                NodeList nodeList2 = element2.getElementsByTagName("componentLevel");
                int n2 = nodeList2.getLength();
                for (int j = 0; j < n2; ++j) {
                    Integer n3 = new Integer(j) + 1;
                    Element element3 = (Element)nodeList2.item(j);
                    NodeList nodeList3 = element3.getElementsByTagName("node");
                    int n4 = nodeList3.getLength();
                    for (int k = 0; k < n4; ++k) {
                        Element element4 = (Element)nodeList3.item(k);
                        String string3 = element4.getAttribute("name");
                        this.nodeMap.put(string3, string2);
                        this.levelMap.put(string3, n3);
                    }
                }
            }
        }
    }
}

