/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.sai;

import java.util.HashMap;
import java.util.Map;
import org.xj3d.sai.UndefinedX3DFieldTypes;

public class X3DFieldTypeMapper {
    private static final int[] fieldConstant = new int[]{3, 4, 4, 3, 5, 7, 6, 8, 7, 9, 8, 10, 31, 5, 32, 6, 1, 1, 2, 2, 13, 15, 14, 16, 29, 17, 30, 18, 15, 19, 16, 20, 17, 21, 18, 22, 25, 29, 26, 30, 9, 11, 10, 12, 11, 13, 12, 14, 27, 31, 28, 32, 19, 24, 20, 23, 21, 26, 22, 25, 23, 28, 24, 27, 33, UndefinedX3DFieldTypes.SFVEC4F, 34, UndefinedX3DFieldTypes.MFVEC4F, 35, UndefinedX3DFieldTypes.SFVEC4D, 36, UndefinedX3DFieldTypes.MFVEC4D, 37, UndefinedX3DFieldTypes.SFMATRIX3F, 38, UndefinedX3DFieldTypes.MFMATRIX3F, 41, UndefinedX3DFieldTypes.SFMATRIX3D, 42, UndefinedX3DFieldTypes.MFMATRIX3D, 39, UndefinedX3DFieldTypes.SFMATRIX4F, 40, UndefinedX3DFieldTypes.MFMATRIX4F, 43, UndefinedX3DFieldTypes.SFMATRIX4D, 44, UndefinedX3DFieldTypes.MFMATRIX4D};
    private static X3DFieldTypeMapper instance;
    private Map<String, Integer> typeMap;

    protected X3DFieldTypeMapper() {
        this.initializeTypeMap();
    }

    public static X3DFieldTypeMapper getInstance() {
        if (instance == null) {
            instance = new X3DFieldTypeMapper();
        }
        return instance;
    }

    public String getTypeName(int n) {
        String string = null;
        for (Map.Entry<String, Integer> entry : this.typeMap.entrySet()) {
            if (n != entry.getValue()) continue;
            string = entry.getKey();
            break;
        }
        return string;
    }

    public int getX3DFieldType(String string) {
        int n = -1;
        Integer n2 = this.typeMap.get(string);
        if (n2 != null) {
            n = n2;
        }
        return n;
    }

    public int getX3DFieldType(int n) {
        int n2 = -1;
        int n3 = fieldConstant.length;
        for (int i = 0; i < n3; i += 2) {
            if (n != fieldConstant[i]) continue;
            n2 = fieldConstant[i + 1];
            break;
        }
        return n2;
    }

    private void initializeTypeMap() {
        this.typeMap = new HashMap<String, Integer>();
        this.typeMap.put("SFInt32", new Integer(4));
        this.typeMap.put("MFInt32", new Integer(3));
        this.typeMap.put("SFFloat", new Integer(7));
        this.typeMap.put("MFFloat", new Integer(8));
        this.typeMap.put("SFDouble", new Integer(9));
        this.typeMap.put("MFDouble", new Integer(10));
        this.typeMap.put("SFLong", new Integer(5));
        this.typeMap.put("MFLong", new Integer(6));
        this.typeMap.put("SFBool", new Integer(1));
        this.typeMap.put("MFBool", new Integer(2));
        this.typeMap.put("SFVec2f", new Integer(15));
        this.typeMap.put("MFVec2f", new Integer(16));
        this.typeMap.put("SFVec2d", new Integer(17));
        this.typeMap.put("MFVec2d", new Integer(18));
        this.typeMap.put("SFVec3f", new Integer(19));
        this.typeMap.put("MFVec3f", new Integer(20));
        this.typeMap.put("SFVec3d", new Integer(21));
        this.typeMap.put("MFVec3d", new Integer(22));
        this.typeMap.put("SFImage", new Integer(29));
        this.typeMap.put("MFImage", new Integer(30));
        this.typeMap.put("SFTime", new Integer(11));
        this.typeMap.put("MFTime", new Integer(12));
        this.typeMap.put("SFNode", new Integer(13));
        this.typeMap.put("MFNode", new Integer(14));
        this.typeMap.put("SFString", new Integer(31));
        this.typeMap.put("MFString", new Integer(32));
        this.typeMap.put("SFRotation", new Integer(24));
        this.typeMap.put("MFRotation", new Integer(23));
        this.typeMap.put("SFColor", new Integer(26));
        this.typeMap.put("MFColor", new Integer(25));
        this.typeMap.put("SFColorRGBA", new Integer(28));
        this.typeMap.put("MFColorRGBA", new Integer(27));
        this.typeMap.put("SFVec4f", new Integer(UndefinedX3DFieldTypes.SFVEC4F));
        this.typeMap.put("MFVec4f", new Integer(UndefinedX3DFieldTypes.MFVEC4F));
        this.typeMap.put("SFVec4d", new Integer(UndefinedX3DFieldTypes.SFVEC4D));
        this.typeMap.put("MFVec4d", new Integer(UndefinedX3DFieldTypes.MFVEC4D));
        this.typeMap.put("SFMatrix3f", new Integer(UndefinedX3DFieldTypes.SFMATRIX3F));
        this.typeMap.put("MFMatrix3f", new Integer(UndefinedX3DFieldTypes.MFMATRIX3F));
        this.typeMap.put("SFMatrix3d", new Integer(UndefinedX3DFieldTypes.SFMATRIX3D));
        this.typeMap.put("MFMatrix3d", new Integer(UndefinedX3DFieldTypes.MFMATRIX3D));
        this.typeMap.put("SFMatrix4f", new Integer(UndefinedX3DFieldTypes.SFMATRIX4F));
        this.typeMap.put("MFMatrix4f", new Integer(UndefinedX3DFieldTypes.MFMATRIX4F));
        this.typeMap.put("SFMatrix4d", new Integer(UndefinedX3DFieldTypes.SFMATRIX4D));
        this.typeMap.put("MFMatrix4d", new Integer(UndefinedX3DFieldTypes.MFMATRIX4D));
    }
}

