/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.sai;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.xj3d.sai.BrowserInterfaceTypes;

public class BrowserConfig {
    private static final String ANTIALIASED_PARAM = "Antialiased";
    private static final String PRIMITIVE_QUALITY_PARAM = "PrimitiveQuality";
    private static final String SHADING_PARAM = "Shading";
    private static final String TEXTURE_QUALITY_PARAM = "TextureQuality";
    private static final String NAV_SHOW_PARAM = "Xj3D_NavbarShown";
    private static final String NAV_POS_PARAM = "Xj3D_NavbarPosition";
    private static final String LOC_SHOW_PARAM = "Xj3D_LocationShown";
    private static final String LOC_POS_PARAM = "Xj3D_LocationPosition";
    private static final String LOC_READONLY_PARAM = "Xj3D_LocationReadOnly";
    private static final String SHOW_CONSOLE_PARAM = "Xj3D_ShowConsole";
    private static final String OPEN_BUTTON_SHOW_PARAM = "Xj3D_OpenButtonShown";
    private static final String RELOAD_BUTTON_SHOW_PARAM = "Xj3D_ReloadButtonShown";
    private static final String STATUS_BAR_SHOW_PARAM = "Xj3D_StatusBarShown";
    private static final String FPS_SHOW_PARAM = "Xj3D_FPSShown";
    private static final String CONTENT_DIRECTORY_PARAM = "Xj3D_ContentDirectory";
    private static final String ANTIALIASING_QUALITY_PARAM = "Xj3D_AntialiasingQuality";
    private static final String DIMENSIONS_PARAM = "Xj3D_PreferredDimensions";
    private static final String SWING_PARAM = "Xj3D_InterfaceType";
    private static final String SKIN_PROPERTIES = "Xj3D_Skin_Properties";
    private static final String SKIN_RESOURCES = "Xj3D_Skin_Resources";
    private static final String CULLING_MODE = "Xj3D_Culling_Mode";
    private static final String NULL_PARAMETER_ERROR = "Null parameter strings not allowed.";
    private static final String MALFORMED_PARAMETER_STRING_ERROR = "Malformed parameter string.  Expecting strings of the form A=B";
    private static final String SKIN_PROPERTY_FILE = "xj3d-skin.properties";
    private static HashSet qualitySet;
    private static HashSet cullingSet;
    public boolean vrml97Only = false;
    public BrowserInterfaceTypes interfaceType = BrowserInterfaceTypes.PARTIAL_LIGHTWEIGHT;
    public boolean showDash = true;
    public boolean dashTop = false;
    public boolean showUrl = true;
    public boolean urlTop = true;
    public boolean urlReadOnly = false;
    public boolean showConsole = false;
    public boolean showOpenButton = false;
    public boolean showReloadButton = false;
    public boolean showStatusBar = false;
    public boolean showFPS = false;
    public String contentDirectory;
    public boolean antialiased = false;
    public String antialiasingQuality = "low";
    public String primitiveQuality = "medium";
    public String textureQuality = "medium";
    public Properties browserSkin = new Properties();
    public Map resourceMap;
    public String cullingMode = "frustum";
    public int preferredWidth;
    public int preferredHeight;

    public BrowserConfig() {
        this.contentDirectory = System.getProperty("user.dir");
    }

    public BrowserConfig(String[] stringArray) {
        this();
        if (stringArray != null && stringArray.length != 0) {
            Map map = this.parseParameters(stringArray);
            this.initialize(map, false);
        } else {
            this.initialize(null, false);
        }
    }

    public BrowserConfig(Map map) {
        this();
        this.initialize(map, true);
    }

    private void initialize(Map map, boolean bl) {
        if (map != null && map.size() != 0) {
            Object v;
            Boolean bl2;
            String string;
            if (qualitySet == null) {
                qualitySet = new HashSet(3);
                qualitySet.add("low");
                qualitySet.add("medium");
                qualitySet.add("high");
            }
            if (cullingSet == null) {
                cullingSet = new HashSet(2);
                cullingSet.add("none");
                cullingSet.add("frustum");
            }
            if ((string = this.getStringValue(map, SWING_PARAM, bl)) != null) {
                if (string.equalsIgnoreCase("awt")) {
                    this.interfaceType = BrowserInterfaceTypes.HEAVYWEIGHT;
                } else if (string.equalsIgnoreCase("swing")) {
                    this.interfaceType = BrowserInterfaceTypes.PARTIAL_LIGHTWEIGHT;
                } else if (string.equalsIgnoreCase("swing-lightweight")) {
                    this.interfaceType = BrowserInterfaceTypes.LIGHTWEIGHT;
                } else if (string.equalsIgnoreCase("offscreen")) {
                    this.interfaceType = BrowserInterfaceTypes.OFFSCREEN;
                }
            }
            if ((bl2 = this.getBooleanValue(map, NAV_SHOW_PARAM, bl)) != null) {
                this.showDash = bl2;
            }
            if ((string = this.getStringValue(map, NAV_POS_PARAM, bl)) != null) {
                this.dashTop = string.equalsIgnoreCase("top");
            }
            if ((bl2 = this.getBooleanValue(map, LOC_SHOW_PARAM, bl)) != null) {
                this.showUrl = bl2;
            }
            if ((string = this.getStringValue(map, LOC_POS_PARAM, bl)) != null) {
                this.urlTop = string.equalsIgnoreCase("top");
            }
            if ((bl2 = this.getBooleanValue(map, LOC_READONLY_PARAM, bl)) != null) {
                this.urlReadOnly = bl2;
            }
            if ((bl2 = this.getBooleanValue(map, SHOW_CONSOLE_PARAM, bl)) != null) {
                this.showConsole = bl2;
            }
            if ((bl2 = this.getBooleanValue(map, OPEN_BUTTON_SHOW_PARAM, bl)) != null) {
                this.showOpenButton = bl2;
            }
            if ((bl2 = this.getBooleanValue(map, RELOAD_BUTTON_SHOW_PARAM, bl)) != null) {
                this.showReloadButton = bl2;
            }
            if ((bl2 = this.getBooleanValue(map, STATUS_BAR_SHOW_PARAM, bl)) != null) {
                this.showStatusBar = bl2;
            }
            if ((bl2 = this.getBooleanValue(map, FPS_SHOW_PARAM, bl)) != null) {
                this.showFPS = bl2;
            }
            if ((string = this.getStringValue(map, CONTENT_DIRECTORY_PARAM, bl)) != null) {
                this.contentDirectory = string;
            }
            if ((bl2 = this.getBooleanValue(map, ANTIALIASED_PARAM, bl)) != null) {
                this.antialiased = bl2;
            }
            if ((string = this.getStringValue(map, PRIMITIVE_QUALITY_PARAM, bl)) != null) {
                if (!qualitySet.contains(string)) {
                    throw new IllegalArgumentException("BrowserConfig: PrimitiveQuality must be low, medium or high");
                }
                this.primitiveQuality = string;
            }
            if ((string = this.getStringValue(map, TEXTURE_QUALITY_PARAM, bl)) != null) {
                if (!qualitySet.contains(string)) {
                    throw new IllegalArgumentException("BrowserConfig: TextureQuality must be low, medium or high");
                }
                this.textureQuality = string;
            }
            if ((string = this.getStringValue(map, ANTIALIASING_QUALITY_PARAM, bl)) != null) {
                if (!qualitySet.contains(string)) {
                    throw new IllegalArgumentException("BrowserConfig: Xj3D_AntialiasingQuality must be low, medium or high");
                }
                this.antialiasingQuality = string;
            }
            if ((v = map.get(SKIN_PROPERTIES)) != null && !(v instanceof Properties)) {
                throw new IllegalArgumentException("BrowserConfig: Xj3D_Skin_Properties must be a Properties object");
            }
            this.browserSkin = (Properties)v;
            v = map.get(SKIN_RESOURCES);
            if (v != null && !(v instanceof Map)) {
                throw new IllegalArgumentException("BrowserConfig: Xj3D_Skin_Resources must be a Map object");
            }
            this.resourceMap = (Map)v;
            string = this.getStringValue(map, CULLING_MODE, bl);
            if (string != null) {
                if (!cullingSet.contains(string)) {
                    throw new IllegalArgumentException("BrowserConfig: Xj3D_Culling_Mode must be none or frustum");
                }
                this.cullingMode = string;
            }
            if ((string = this.getStringValue(map, DIMENSIONS_PARAM, bl)) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "x");
                String string2 = stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                try {
                    this.preferredWidth = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                try {
                    this.preferredHeight = Integer.parseInt(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if (this.browserSkin == null) {
            this.loadBrowserSkin();
        }
        if (this.contentDirectory == null) {
            this.contentDirectory = System.getProperty("user.dir");
        }
    }

    private Boolean getBooleanValue(Map map, String string, boolean bl) {
        Boolean bl2 = null;
        Object v = map.get(string);
        if (v != null) {
            if (bl) {
                if (!(v instanceof Boolean)) {
                    throw new IllegalArgumentException("BrowserConfig: " + string + " must be a Boolean");
                }
                bl2 = (Boolean)v;
            } else {
                bl2 = Boolean.valueOf((String)v);
            }
        }
        return bl2;
    }

    private String getStringValue(Map map, String string, boolean bl) {
        String string2 = null;
        Object v = map.get(string);
        if (v != null) {
            if (bl && !(v instanceof String)) {
                throw new IllegalArgumentException("BrowserConfig: " + string + " must be a String");
            }
            string2 = (String)v;
        }
        return string2;
    }

    private Map parseParameters(String[] stringArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) {
                throw new IllegalArgumentException(NULL_PARAMETER_ERROR);
            }
            int n = stringArray[i].indexOf(61);
            if (n < 1) {
                throw new IllegalArgumentException(MALFORMED_PARAMETER_STRING_ERROR);
            }
            hashMap.put(stringArray[i].substring(0, n), stringArray[i].substring(n + 1));
        }
        return hashMap;
    }

    private void loadBrowserSkin() {
        try {
            this.browserSkin = (Properties)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    InputStream inputStream = null;
                    Properties properties = new Properties();
                    String string = null;
                    String string2 = System.getProperty("user.dir");
                    String string3 = string2 + File.separator + BrowserConfig.SKIN_PROPERTY_FILE;
                    String string4 = "config/common/xj3d-skin.properties";
                    try {
                        inputStream = new FileInputStream(string3);
                        string = string3;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        inputStream = ClassLoader.getSystemClassLoader().getResourceAsStream(string4);
                        string = string4;
                    }
                    if (inputStream == null) {
                        inputStream = BrowserConfig.class.getClassLoader().getResourceAsStream(string4);
                        string = string4;
                    }
                    if (inputStream == null) {
                        System.out.println("Skin properties file: " + string + " not found");
                        System.out.println("Returning default properties.");
                    } else {
                        try {
                            properties.load(inputStream);
                            inputStream.close();
                        }
                        catch (IOException iOException) {
                            System.out.println("Error reading skin properties file: " + string + " " + iOException.getMessage());
                            System.out.println("Returning default properties.");
                        }
                    }
                    return properties;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            System.out.println("Error getting skin properties");
        }
    }
}

