/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.sai;

import java.applet.Applet;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.Properties;
import org.web3d.x3d.sai.BrowserFactoryImpl;
import org.web3d.x3d.sai.ConnectionException;
import org.web3d.x3d.sai.ExternalBrowser;
import org.web3d.x3d.sai.NoSuchBrowserException;
import org.web3d.x3d.sai.NotSupportedException;
import org.web3d.x3d.sai.X3DComponent;
import org.web3d.x3d.sai.X3DException;

public class BrowserFactory {
    private static final String PROPERTIES_FILE_NAME = "x3d.properties";
    private static final String FACTORY_CLASS = "x3d.sai.factory.class";
    private static final String XJ3D_PROPERTIES_FILE = "config/3.0/spec/x3d.properties";
    private static final String DEFAULT_FACTORY_CLASS = "org.web3d.x3d.sai.DefaultBrowserImpl";
    private static final String NULL_BROWSER_FACTORY_IMPL_ERR_MSG = "Provided factory is null";
    private static final String FACTORY_ALREADY_DEFINED_ERR_MSG = "Factory already defined";
    private static final String FACTORY_CLASS_NOT_FOUND_ERR_MSG = "Unable to find X3D browser factory implementation\n";
    private static final String UNABLE_TO_INSTANTIATE_FACTORY_ERR_MSG = "Error instantiating the X3D browser factory\n";
    private static final String CLASS_NOT_A_BROWSER_FACTORY_IMPL_ERR_MSG = "The nominated browser factory is not an instance of ";
    private static final String BROWSER_FACTORY_IMPL_INTERFACE_CLASSNAME = "org.web3d.x3d.sai.BrowserFactoryImpl";
    private static BrowserFactoryImpl factory = null;
    private static Properties vrml_properties = null;

    private BrowserFactory() {
    }

    public static synchronized void setBrowserFactoryImpl(BrowserFactoryImpl browserFactoryImpl) throws IllegalArgumentException, X3DException, SecurityException {
        if (browserFactoryImpl == null) {
            throw new IllegalArgumentException(NULL_BROWSER_FACTORY_IMPL_ERR_MSG);
        }
        if (factory != null) {
            throw new X3DException(FACTORY_ALREADY_DEFINED_ERR_MSG);
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        factory = browserFactoryImpl;
    }

    public static X3DComponent createX3DComponent(Map map) throws NotSupportedException {
        if (factory == null) {
            BrowserFactory.loadFactoryImpl();
        }
        X3DComponent x3DComponent = factory.createComponent(map);
        return x3DComponent;
    }

    public static ExternalBrowser getBrowser(Applet applet) throws NotSupportedException, NoSuchBrowserException, ConnectionException {
        if (factory == null) {
            BrowserFactory.loadFactoryImpl();
        }
        return factory.getBrowser(applet);
    }

    public static ExternalBrowser getBrowser(Applet applet, String string, int n) throws NotSupportedException, NoSuchBrowserException, ConnectionException {
        if (factory == null) {
            BrowserFactory.loadFactoryImpl();
        }
        return factory.getBrowser(applet, string, n);
    }

    public static ExternalBrowser getBrowser(InetAddress inetAddress, int n) throws NotSupportedException, NoSuchBrowserException, UnknownHostException, ConnectionException {
        if (factory == null) {
            BrowserFactory.loadFactoryImpl();
        }
        return factory.getBrowser(inetAddress, n);
    }

    private static void loadFactoryImpl() {
        try {
            String string = vrml_properties.getProperty(FACTORY_CLASS, DEFAULT_FACTORY_CLASS);
            Class<?> clazz = Class.forName(string);
            factory = (BrowserFactoryImpl)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println(FACTORY_CLASS_NOT_FOUND_ERR_MSG);
        }
        catch (InstantiationException instantiationException) {
            System.out.println(UNABLE_TO_INSTANTIATE_FACTORY_ERR_MSG);
        }
        catch (IllegalAccessException illegalAccessException) {
            System.out.println(illegalAccessException);
        }
        catch (ClassCastException classCastException) {
            System.out.println("The nominated browser factory is not an instance of org.web3d.x3d.sai.BrowserFactoryImpl");
        }
    }

    static {
        vrml_properties = new Properties();
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(BrowserFactory.FACTORY_CLASS);
            }
        });
        if (string != null) {
            vrml_properties.put(FACTORY_CLASS, string);
        } else {
            try {
                InputStream inputStream = (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return ClassLoader.getSystemResourceAsStream(BrowserFactory.PROPERTIES_FILE_NAME);
                    }
                });
                if (inputStream == null) {
                    inputStream = BrowserFactory.class.getClassLoader().getResourceAsStream(PROPERTIES_FILE_NAME);
                }
                if (inputStream == null) {
                    inputStream = (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            return ClassLoader.getSystemResourceAsStream(BrowserFactory.XJ3D_PROPERTIES_FILE);
                        }
                    });
                }
                if (inputStream == null) {
                    inputStream = BrowserFactory.class.getClassLoader().getResourceAsStream(XJ3D_PROPERTIES_FILE);
                }
                if (inputStream == null) {
                    vrml_properties.put(FACTORY_CLASS, DEFAULT_FACTORY_CLASS);
                } else {
                    vrml_properties.load(inputStream);
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                System.out.println(iOException);
            }
        }
    }
}

