/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.sai.util;

import java.util.Vector;
import org.web3d.x3d.sai.ComponentInfo;
import org.web3d.x3d.sai.MFNode;
import org.web3d.x3d.sai.ProfileInfo;
import org.web3d.x3d.sai.SFNode;
import org.web3d.x3d.sai.X3DField;
import org.web3d.x3d.sai.X3DFieldDefinition;
import org.web3d.x3d.sai.X3DGroupingNode;
import org.web3d.x3d.sai.X3DNode;
import org.web3d.x3d.sai.X3DRoute;
import org.web3d.x3d.sai.X3DScene;
import org.web3d.x3d.sai.X3DShapeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SceneUtils {
    public static boolean validateSceneCompatibility(X3DScene x3DScene, int n, int n2, ProfileInfo profileInfo, ComponentInfo[] componentInfoArray) {
        block10: {
            String string = x3DScene.getSpecificationVersion();
            int n3 = string.indexOf(".");
            if (n3 != -1) {
                try {
                    int n4 = Integer.parseInt(string.substring(0, n3));
                    int n5 = Integer.parseInt(string.substring(n3 + 1));
                    if (n4 <= n && (n4 != n || n5 < n2)) {
                        return false;
                    }
                    break block10;
                }
                catch (Exception exception) {
                    return false;
                }
            }
            return false;
        }
        ProfileInfo profileInfo2 = x3DScene.getProfile();
        if (!profileInfo2.getName().equals(profileInfo.getName())) {
            return false;
        }
        if (componentInfoArray != null && componentInfoArray.length > 0) {
            ComponentInfo[] componentInfoArray2 = x3DScene.getComponents();
            if (componentInfoArray2 != null) {
                for (int i = 0; i < componentInfoArray.length; ++i) {
                    boolean bl = false;
                    String string = componentInfoArray[i].getName();
                    int n6 = componentInfoArray[i].getLevel();
                    for (int j = 0; j < componentInfoArray2.length; ++j) {
                        if (!componentInfoArray2[j].getName().equals(string) || componentInfoArray2[j].getLevel() < n6) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public static X3DNode[] getPickTargets(X3DScene x3DScene) {
        Vector<X3DNode> vector = new Vector<X3DNode>();
        X3DNode[] x3DNodeArray = x3DScene.getRootNodes();
        SceneUtils.getPickTargets(x3DNodeArray, vector);
        return vector.toArray(new X3DNode[vector.size()]);
    }

    public static void getPickTargets(X3DNode[] x3DNodeArray, Vector<X3DNode> vector) {
        for (int i = 0; i < x3DNodeArray.length; ++i) {
            X3DNode x3DNode = x3DNodeArray[i];
            if (x3DNode instanceof X3DGroupingNode || x3DNode instanceof X3DShapeNode) {
                vector.add(x3DNode);
                continue;
            }
            X3DFieldDefinition[] x3DFieldDefinitionArray = x3DNode.getFieldDefinitions();
            for (int j = 0; j < x3DFieldDefinitionArray.length; ++j) {
                X3DNode[] x3DNodeArray2;
                X3DField x3DField;
                int n = x3DFieldDefinitionArray[j].getFieldType();
                int n2 = x3DFieldDefinitionArray[j].getAccessType();
                if (n2 != 3 && n2 != 2) continue;
                if (n == 14) {
                    x3DField = (MFNode)x3DNode.getField(x3DFieldDefinitionArray[j].getName());
                    x3DNodeArray2 = new X3DNode[x3DField.getSize()];
                    x3DField.getValue(x3DNodeArray2);
                    SceneUtils.getPickTargets(x3DNodeArray2, vector);
                    continue;
                }
                if (n != 13 || (x3DNodeArray2 = new X3DNode[]{(x3DField = (SFNode)x3DNode.getField(x3DFieldDefinitionArray[j].getName())).getValue()})[0] == null) continue;
                SceneUtils.getPickTargets(x3DNodeArray2, vector);
            }
        }
    }

    public static void copyScene(X3DScene x3DScene, X3DScene x3DScene2) {
        for (X3DNode x3DNode : x3DScene.getRootNodes()) {
            x3DScene.removeRootNode(x3DNode);
            x3DScene2.addRootNode(x3DNode);
        }
        for (X3DRoute x3DRoute : x3DScene.getRoutes()) {
            x3DScene.removeRoute(x3DRoute);
            x3DScene2.addRoute(x3DRoute.getSourceNode(), x3DRoute.getSourceField(), x3DRoute.getDestinationNode(), x3DRoute.getDestinationField());
        }
    }
}

