/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.sai;

import java.lang.ref.ReferenceQueue;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.scripting.sai.BaseField;
import org.web3d.vrml.scripting.sai.BaseNode;
import org.web3d.vrml.scripting.sai.BaseNodeFactory;
import org.web3d.vrml.scripting.sai.FieldFactory;
import org.web3d.vrml.scripting.sai.NodeField;
import org.web3d.x3d.sai.InvalidNodeException;
import org.web3d.x3d.sai.SFNode;
import org.web3d.x3d.sai.X3DNode;

class SAISFNode
extends BaseField
implements SFNode,
NodeField {
    private VRMLNodeType localValue;
    private BaseNode saiNode;
    private FieldFactory fieldFactory;
    private ReferenceQueue fieldQueue;
    private BaseNodeFactory baseNodeFactory;

    SAISFNode(VRMLNodeType vRMLNodeType, int n, boolean bl) {
        super(vRMLNodeType, n, bl);
    }

    public X3DNode getValue() {
        this.checkAccess(false);
        return this.saiNode;
    }

    public void setValue(X3DNode x3DNode) throws InvalidNodeException {
        this.checkAccess(true);
        if (x3DNode != null && !x3DNode.isRealized()) {
            x3DNode.realize();
        }
        this.saiNode = (BaseNode)x3DNode;
        this.localValue = x3DNode != null ? ((BaseNode)x3DNode).getImplNode() : null;
        this.dataChanged = true;
    }

    public void updateNodeAndChildren() {
        if (this.saiNode != null) {
            this.saiNode.updateNodeAndChildren();
        }
        if (this.dataChanged) {
            this.node.setValue(this.fieldIndex, this.localValue);
            this.dataChanged = false;
        }
    }

    public void updateFieldAndChildren() {
        this.updateField();
        if (this.saiNode != null) {
            this.saiNode.updateFields();
        }
    }

    public void setAccessValid(boolean bl) {
        super.setAccessValid(bl);
        if (this.saiNode != null) {
            this.saiNode.setAccessValid(bl);
        }
    }

    public void setFieldFactory(FieldFactory fieldFactory) {
        this.fieldFactory = fieldFactory;
    }

    public void setFieldReferenceQueue(ReferenceQueue referenceQueue) {
        this.fieldQueue = referenceQueue;
    }

    public void setNodeFactory(BaseNodeFactory baseNodeFactory) {
        this.baseNodeFactory = baseNodeFactory;
    }

    void updateNode() {
        this.node.setValue(this.fieldIndex, this.localValue);
        this.dataChanged = false;
    }

    void updateField() {
        if (!this.isReadable()) {
            return;
        }
        VRMLFieldData vRMLFieldData = this.node.getFieldValue(this.fieldIndex);
        if (this.localValue != vRMLFieldData.nodeValue) {
            this.localValue = (VRMLNodeType)vRMLFieldData.nodeValue;
            if (this.localValue == null) {
                this.saiNode = null;
            } else {
                this.saiNode = (BaseNode)this.baseNodeFactory.getBaseNode(this.localValue);
                this.saiNode.setAccessValid(this.accessPermitted);
            }
        }
        this.dataChanged = false;
    }
}

