/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.sai;

import java.awt.image.RenderedImage;
import java.awt.image.WritableRenderedImage;
import org.web3d.util.SFImageUtils;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.scripting.sai.BaseField;
import org.web3d.x3d.sai.InvalidFieldException;
import org.web3d.x3d.sai.InvalidFieldValueException;
import org.web3d.x3d.sai.InvalidOperationTimingException;
import org.web3d.x3d.sai.InvalidWritableFieldException;
import org.web3d.x3d.sai.SFImage;

class SAISFImage
extends BaseField
implements SFImage {
    private int[] localValue;

    SAISFImage(VRMLNodeType vRMLNodeType, int n, boolean bl) {
        super(vRMLNodeType, n, bl);
    }

    public int getWidth() {
        this.checkAccess(false);
        if (this.localValue != null && this.localValue.length > 0) {
            return this.localValue[0];
        }
        return 0;
    }

    public int getHeight() {
        this.checkAccess(false);
        if (this.localValue != null && this.localValue.length > 0) {
            return this.localValue[1];
        }
        return 0;
    }

    public int getComponents() {
        this.checkAccess(false);
        if (this.localValue != null && this.localValue.length > 0) {
            return this.localValue[2];
        }
        return 0;
    }

    public void getPixels(int[] nArray) {
        int n;
        this.checkAccess(false);
        if (this.localValue != null && this.localValue.length > 0 && (n = this.localValue[0] * this.localValue[1]) > 0) {
            System.arraycopy(this.localValue, 3, nArray, 0, n);
        }
    }

    public WritableRenderedImage getImage() {
        this.checkAccess(false);
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = this.getComponents();
        int[] nArray = new int[n * n2];
        this.getPixels(nArray);
        return SFImageUtils.convertDataToRenderedImage(n, n2, n3, nArray);
    }

    public void setImage(RenderedImage renderedImage) throws InvalidOperationTimingException, InvalidFieldValueException, InvalidWritableFieldException, InvalidFieldException {
        this.checkAccess(true);
        int n = renderedImage.getHeight() * renderedImage.getWidth() + 3;
        if (this.localValue == null || this.localValue.length != n) {
            this.localValue = new int[n];
        }
        SFImageUtils.convertRenderedImageToData(renderedImage, this.localValue, 0);
        this.dataChanged = true;
    }

    public void setSubImage(RenderedImage renderedImage, int n, int n2, int n3, int n4, int n5, int n6) throws InvalidOperationTimingException, InvalidFieldValueException, InvalidWritableFieldException, InvalidFieldException {
        this.checkAccess(true);
        if (this.getComponents() != renderedImage.getColorModel().getNumComponents() || this.getWidth() < n || this.getHeight() < n2) {
            throw new IllegalArgumentException("Subimage either too large or differs in components");
        }
        SFImageUtils.convertSubRenderedImageToData(renderedImage, this.localValue, 0, n, n2, n3, n4, n5, n6);
        this.dataChanged = true;
    }

    public void setValue(int n, int n2, int n3, int[] nArray) {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid width");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Invalid height");
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("Invalid components");
        }
        this.checkAccess(true);
        int n4 = n * n2 + 3;
        if (this.localValue == null || this.localValue.length != n4) {
            this.localValue = new int[n4];
        }
        this.localValue[0] = n;
        this.localValue[1] = n2;
        this.localValue[2] = n3;
        System.arraycopy(nArray, 0, this.localValue, 3, n4);
        this.dataChanged = true;
    }

    void updateNode() {
        this.node.setValue(this.fieldIndex, this.localValue, this.localValue.length);
        this.dataChanged = false;
    }

    void updateField() {
        if (!this.isReadable()) {
            return;
        }
        VRMLFieldData vRMLFieldData = this.node.getFieldValue(this.fieldIndex);
        int n = vRMLFieldData.intArrayValue.length;
        if (this.localValue == null || this.localValue.length < n) {
            this.localValue = new int[n];
        }
        System.arraycopy(vRMLFieldData.intArrayValue, 0, this.localValue, 0, n);
        this.dataChanged = false;
    }
}

