/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.sai;

import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.scripting.sai.BaseMField;
import org.web3d.x3d.sai.MFVec2f;

class SAIMFVec2f
extends BaseMField
implements MFVec2f {
    private static final int ARRAY_INC = 16;
    private float[] localValue;

    SAIMFVec2f(VRMLNodeType vRMLNodeType, int n, boolean bl) {
        super(vRMLNodeType, n, bl);
    }

    public void append(float[] fArray) {
        this.checkAccess(true);
        if (this.localValue == null || this.localValue.length == this.numElements * 2) {
            float[] fArray2 = new float[this.numElements * 2 + 16];
            System.arraycopy(this.localValue, 0, fArray2, 0, this.numElements * 2);
            this.localValue = fArray2;
        }
        this.localValue[this.numElements * 2] = fArray[0];
        this.localValue[this.numElements * 2 + 1] = fArray[1];
        ++this.numElements;
        this.dataChanged = true;
    }

    public void insertValue(int n, float[] fArray) throws ArrayIndexOutOfBoundsException {
        this.checkAccess(true);
        if (n >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException("Attempting to insert a value past the end of the existing number of elements.");
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("The provided index is negative.");
        }
        if (this.localValue == null || this.localValue.length == this.numElements * 2) {
            float[] fArray2 = new float[this.numElements * 2 + 16];
            System.arraycopy(this.localValue, 0, fArray2, 0, this.numElements * 2);
            this.localValue = fArray2;
        }
        System.arraycopy(this.localValue, n * 2, this.localValue, n * 2 + 2, (this.numElements - n) * 2);
        this.localValue[n * 2] = fArray[0];
        this.localValue[n * 2 + 1] = fArray[1];
        ++this.numElements;
        this.dataChanged = true;
    }

    public void removeValue(int n) throws ArrayIndexOutOfBoundsException {
        this.checkAccess(true);
        if (n >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException("Attempting to remove a value past the end of the existing number of elements.");
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("The provided index is negative.");
        }
        System.arraycopy(this.localValue, n * 2, this.localValue, n * 2 - 2, (this.numElements - n + 1) * 2);
        --this.numElements;
        this.dataChanged = true;
    }

    public void getValue(float[][] fArray) {
        this.checkAccess(false);
        if (this.localValue != null) {
            int n = 0;
            for (int i = 0; i < this.numElements; ++i) {
                fArray[i][0] = this.localValue[n++];
                fArray[i][1] = this.localValue[n++];
            }
        }
    }

    public void getValue(float[] fArray) {
        this.checkAccess(false);
        if (this.localValue != null) {
            System.arraycopy(this.localValue, 0, fArray, 0, this.numElements * 2);
        }
    }

    public void get1Value(int n, float[] fArray) {
        this.checkAccess(false);
        if (n >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException("Attempting to fetch a value past the end of the existing number of elements.");
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("The provided index is negative.");
        }
        fArray[0] = this.localValue[n * 2];
        fArray[1] = this.localValue[n * 2 + 1];
    }

    public void setValue(int n, float[][] fArray) {
        this.checkAccess(false);
        if (this.localValue == null || this.localValue.length < n * 2) {
            this.localValue = new float[n * 2];
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            this.localValue[n2++] = fArray[i][0];
            this.localValue[n2++] = fArray[i][1];
        }
        this.numElements = n;
        this.dataChanged = true;
    }

    public void setValue(int n, float[] fArray) {
        this.checkAccess(true);
        if (this.localValue == null || this.localValue.length < n * 2) {
            this.localValue = new float[n * 2];
        }
        this.numElements = n;
        System.arraycopy(fArray, 0, this.localValue, 0, n * 2);
        this.dataChanged = true;
    }

    public void set1Value(int n, float[] fArray) throws ArrayIndexOutOfBoundsException {
        this.checkAccess(true);
        if (n >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException("Attempting to set a value past the end of the existing number of elements.");
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("The provided index is negative.");
        }
        this.localValue[n * 2] = fArray[0];
        this.localValue[n * 2 + 1] = fArray[1];
        this.dataChanged = true;
    }

    void updateNode() {
        this.node.setValue(this.fieldIndex, this.localValue, this.numElements * 2);
        this.dataChanged = false;
    }

    void updateField() {
        if (!this.isReadable()) {
            return;
        }
        VRMLFieldData vRMLFieldData = this.node.getFieldValue(this.fieldIndex);
        int n = vRMLFieldData.numElements * 2;
        if (this.localValue == null || this.localValue.length < n) {
            this.localValue = new float[n];
        }
        this.numElements = vRMLFieldData.numElements;
        if (this.numElements != 0) {
            System.arraycopy(vRMLFieldData.floatArrayValue, 0, this.localValue, 0, n);
        }
        this.dataChanged = false;
    }
}

