/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.sai;

import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.scripting.sai.BaseMField;
import org.web3d.x3d.sai.MFTime;

class SAIMFTime
extends BaseMField
implements MFTime {
    private static final int ARRAY_INC = 8;
    private double[] localValue;

    SAIMFTime(VRMLNodeType vRMLNodeType, int n, boolean bl) {
        super(vRMLNodeType, n, bl);
    }

    public void append(double d) {
        this.checkAccess(true);
        if (this.localValue == null || this.localValue.length == this.numElements) {
            double[] dArray = new double[this.numElements + 8];
            System.arraycopy(this.localValue, 0, dArray, 0, this.numElements);
            this.localValue = dArray;
        }
        this.localValue[this.numElements] = d;
        ++this.numElements;
        this.dataChanged = true;
    }

    public void insertValue(int n, double d) throws ArrayIndexOutOfBoundsException {
        this.checkAccess(true);
        if (n >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException("Attempting to insert a value past the end of the existing number of elements.");
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("The provided index is negative.");
        }
        if (this.localValue == null || this.localValue.length == this.numElements) {
            double[] dArray = new double[this.numElements + 8];
            System.arraycopy(this.localValue, 0, dArray, 0, this.numElements);
            this.localValue = dArray;
        }
        System.arraycopy(this.localValue, n, this.localValue, n + 1, this.numElements - n);
        this.localValue[n] = d;
        ++this.numElements;
        this.dataChanged = true;
    }

    public void removeValue(int n) throws ArrayIndexOutOfBoundsException {
        this.checkAccess(true);
        if (n >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException("Attempting to remove a value past the end of the existing number of elements.");
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("The provided index is negative.");
        }
        System.arraycopy(this.localValue, n, this.localValue, n - 1, this.numElements - n + 1);
        --this.numElements;
        this.dataChanged = true;
    }

    public void getValue(double[] dArray) {
        this.checkAccess(false);
        if (this.localValue != null) {
            System.arraycopy(this.localValue, 0, dArray, 0, this.numElements);
        }
    }

    public double get1Value(int n) {
        this.checkAccess(false);
        if (n >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException("Attempting to fetch a value past the end of the existing number of elements.");
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("The provided index is negative.");
        }
        return this.localValue[n];
    }

    public void setValue(int n, double[] dArray) {
        this.checkAccess(true);
        if (this.localValue == null || this.localValue.length < n) {
            this.localValue = new double[n];
        }
        this.numElements = n;
        System.arraycopy(dArray, 0, this.localValue, 0, n);
        this.dataChanged = true;
    }

    public void setValue(int n, long[] lArray) {
        this.checkAccess(true);
        if (this.localValue == null || this.localValue.length < n) {
            this.localValue = new double[n];
        }
        this.numElements = n;
        int n2 = n;
        while (--n2 >= 0) {
            this.localValue[n2] = (double)lArray[n2] * 0.001;
        }
        this.dataChanged = true;
    }

    public void set1Value(int n, double d) throws ArrayIndexOutOfBoundsException {
        this.checkAccess(true);
        if (n >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException("Attempting to set a value past the end of the existing number of elements.");
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("The provided index is negative.");
        }
        this.localValue[n] = d;
        this.dataChanged = true;
    }

    void updateNode() {
        this.node.setValue(this.fieldIndex, this.localValue, this.numElements);
        this.dataChanged = false;
    }

    void updateField() {
        if (!this.isReadable()) {
            return;
        }
        VRMLFieldData vRMLFieldData = this.node.getFieldValue(this.fieldIndex);
        int n = vRMLFieldData.numElements;
        if (this.localValue == null || this.localValue.length < n) {
            this.localValue = new double[n];
        }
        this.numElements = vRMLFieldData.numElements;
        if (this.numElements != 0) {
            System.arraycopy(vRMLFieldData.doubleArrayValue, 0, this.localValue, 0, n);
        }
        this.dataChanged = false;
    }
}

