/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.sai;

import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.scripting.sai.BaseMField;
import org.web3d.x3d.sai.MFRotation;

class SAIMFRotation
extends BaseMField
implements MFRotation {
    private static final int ARRAY_INC = 32;
    private float[] localValue;

    SAIMFRotation(VRMLNodeType vRMLNodeType, int n, boolean bl) {
        super(vRMLNodeType, n, bl);
    }

    public void append(float[] fArray) {
        this.checkAccess(true);
        if (this.localValue == null || this.localValue.length == this.numElements * 4) {
            float[] fArray2 = new float[this.numElements * 4 + 32];
            System.arraycopy(this.localValue, 0, fArray2, 0, this.numElements * 4);
            this.localValue = fArray2;
        }
        this.localValue[this.numElements * 4] = fArray[0];
        this.localValue[this.numElements * 4 + 1] = fArray[1];
        this.localValue[this.numElements * 4 + 2] = fArray[2];
        this.localValue[this.numElements * 4 + 3] = fArray[3];
        ++this.numElements;
        this.dataChanged = true;
    }

    public void insertValue(int n, float[] fArray) throws ArrayIndexOutOfBoundsException {
        this.checkAccess(true);
        if (n >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException("Attempting to insert a value past the end of the existing number of elements.");
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("The provided index is negative.");
        }
        if (this.localValue == null || this.localValue.length == this.numElements * 4) {
            float[] fArray2 = new float[this.numElements * 4 + 32];
            System.arraycopy(this.localValue, 0, fArray2, 0, this.numElements * 4);
            this.localValue = fArray2;
        }
        System.arraycopy(this.localValue, n * 4, this.localValue, n * 4 + 4, (this.numElements - n) * 4);
        this.localValue[n * 4] = fArray[0];
        this.localValue[n * 4 + 1] = fArray[1];
        this.localValue[n * 4 + 2] = fArray[2];
        this.localValue[n * 4 + 3] = fArray[3];
        ++this.numElements;
        this.dataChanged = true;
    }

    public void removeValue(int n) throws ArrayIndexOutOfBoundsException {
        this.checkAccess(true);
        if (n >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException("Attempting to remove a value past the end of the existing number of elements.");
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("The provided index is negative.");
        }
        System.arraycopy(this.localValue, n * 4, this.localValue, n * 4 - 4, (this.numElements - n + 1) * 4);
        --this.numElements;
        this.dataChanged = true;
    }

    public void getValue(float[][] fArray) {
        this.checkAccess(false);
        if (this.localValue != null) {
            int n = 0;
            for (int i = 0; i < this.numElements; ++i) {
                fArray[i][0] = this.localValue[n++];
                fArray[i][1] = this.localValue[n++];
                fArray[i][2] = this.localValue[n++];
                fArray[i][3] = this.localValue[n++];
            }
        }
    }

    public void getValue(float[] fArray) {
        this.checkAccess(false);
        if (this.localValue != null) {
            System.arraycopy(this.localValue, 0, fArray, 0, this.numElements * 4);
        }
    }

    public void get1Value(int n, float[] fArray) {
        this.checkAccess(false);
        if (n >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException("Attempting to fetch a value past the end of the existing number of elements.");
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("The provided index is negative.");
        }
        fArray[0] = this.localValue[n * 4];
        fArray[1] = this.localValue[n * 4 + 1];
        fArray[2] = this.localValue[n * 4 + 2];
        fArray[3] = this.localValue[n * 4 + 3];
    }

    public void setValue(int n, float[] fArray) {
        this.checkAccess(true);
        if (this.localValue == null || this.localValue.length < n * 4) {
            this.localValue = new float[n * 4];
        }
        this.numElements = n;
        System.arraycopy(fArray, 0, this.localValue, 0, n * 4);
        this.dataChanged = true;
    }

    public void setValue(int n, float[][] fArray) {
        this.checkAccess(false);
        if (this.localValue == null || this.localValue.length < n * 4) {
            this.localValue = new float[n * 4];
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            this.localValue[n2++] = fArray[i][0];
            this.localValue[n2++] = fArray[i][1];
            this.localValue[n2++] = fArray[i][2];
            this.localValue[n2++] = fArray[i][3];
        }
        this.numElements = n;
        this.dataChanged = true;
    }

    public void set1Value(int n, float[] fArray) throws ArrayIndexOutOfBoundsException {
        this.checkAccess(true);
        if (n >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException("Attempting to set a value past the end of the existing number of elements.");
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("The provided index is negative.");
        }
        this.localValue[n * 4] = fArray[0];
        this.localValue[n * 4 + 1] = fArray[1];
        this.localValue[n * 4 + 2] = fArray[2];
        this.localValue[n * 4 + 3] = fArray[3];
        this.dataChanged = true;
    }

    void updateNode() {
        this.node.setValue(this.fieldIndex, this.localValue, this.numElements * 4);
        this.dataChanged = false;
    }

    void updateField() {
        if (!this.isReadable()) {
            return;
        }
        VRMLFieldData vRMLFieldData = this.node.getFieldValue(this.fieldIndex);
        int n = vRMLFieldData.numElements * 4;
        if (this.localValue == null || this.localValue.length < n) {
            this.localValue = new float[n];
        }
        this.numElements = vRMLFieldData.numElements;
        if (this.numElements != 0) {
            System.arraycopy(vRMLFieldData.floatArrayValue, 0, this.localValue, 0, n);
        }
        this.dataChanged = false;
    }
}

