/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.sai;

import java.lang.ref.ReferenceQueue;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.scripting.sai.BaseMField;
import org.web3d.vrml.scripting.sai.BaseNode;
import org.web3d.vrml.scripting.sai.BaseNodeFactory;
import org.web3d.vrml.scripting.sai.FieldFactory;
import org.web3d.vrml.scripting.sai.NodeField;
import org.web3d.x3d.sai.MFNode;
import org.web3d.x3d.sai.X3DNode;

class SAIMFNode
extends BaseMField
implements MFNode,
NodeField {
    private static final int ARRAY_INC = 8;
    private VRMLNodeType[] localValue;
    private BaseNode[] saiNodes;
    private FieldFactory fieldFactory;
    private ReferenceQueue fieldQueue;
    private BaseNodeFactory baseNodeFactory;

    SAIMFNode(VRMLNodeType vRMLNodeType, int n, boolean bl) {
        super(vRMLNodeType, n, bl);
    }

    public void clear() {
        super.clear();
        for (int i = 0; i < this.numElements; ++i) {
            this.localValue[i] = null;
            this.saiNodes[i] = null;
        }
    }

    public void append(X3DNode x3DNode) {
        this.checkAccess(true);
        if (this.localValue == null || this.localValue.length == this.numElements) {
            VRMLNodeType[] vRMLNodeTypeArray = new VRMLNodeType[this.numElements + 8];
            BaseNode[] baseNodeArray = new BaseNode[this.numElements + 8];
            System.arraycopy(this.localValue, 0, vRMLNodeTypeArray, 0, this.numElements);
            System.arraycopy(this.saiNodes, 0, baseNodeArray, 0, this.numElements);
            this.localValue = vRMLNodeTypeArray;
            this.saiNodes = baseNodeArray;
        }
        if (x3DNode != null && !x3DNode.isRealized()) {
            x3DNode.realize();
        }
        this.saiNodes[this.numElements] = (BaseNode)x3DNode;
        this.localValue[this.numElements] = x3DNode != null ? ((BaseNode)x3DNode).getImplNode() : null;
        ++this.numElements;
        this.dataChanged = true;
    }

    public void insertValue(int n, X3DNode x3DNode) throws ArrayIndexOutOfBoundsException {
        this.checkAccess(true);
        if (n >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException("Attempting to insert a value past the end of the existing number of elements.");
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("The provided index is negative.");
        }
        if (this.localValue == null || this.localValue.length == this.numElements) {
            VRMLNodeType[] vRMLNodeTypeArray = new VRMLNodeType[this.numElements + 8];
            BaseNode[] baseNodeArray = new BaseNode[this.numElements + 8];
            System.arraycopy(this.localValue, 0, vRMLNodeTypeArray, 0, this.numElements);
            System.arraycopy(this.saiNodes, 0, baseNodeArray, 0, this.numElements);
            this.localValue = vRMLNodeTypeArray;
            this.saiNodes = baseNodeArray;
        }
        System.arraycopy(this.localValue, n, this.localValue, n + 1, this.numElements - n);
        System.arraycopy(this.saiNodes, n, this.saiNodes, n + 1, this.numElements - n);
        if (x3DNode != null && !x3DNode.isRealized()) {
            x3DNode.realize();
        }
        this.saiNodes[n] = (BaseNode)x3DNode;
        this.localValue[n] = x3DNode != null ? ((BaseNode)x3DNode).getImplNode() : null;
        ++this.numElements;
        this.dataChanged = true;
    }

    public void removeValue(int n) throws ArrayIndexOutOfBoundsException {
        this.checkAccess(true);
        if (n >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException("Attempting to remove a value past the end of the existing number of elements.");
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("The provided index is negative.");
        }
        if (n == this.numElements - 1) {
            this.localValue[n] = null;
            this.saiNodes[n] = null;
        } else {
            System.arraycopy(this.localValue, n + 1, this.localValue, n, this.numElements - n + 1);
            System.arraycopy(this.saiNodes, n + 1, this.saiNodes, n, this.numElements - n + 1);
        }
        --this.numElements;
        this.dataChanged = true;
    }

    public void getValue(X3DNode[] x3DNodeArray) {
        this.checkAccess(false);
        if (this.localValue != null) {
            System.arraycopy(this.saiNodes, 0, x3DNodeArray, 0, this.numElements);
        }
    }

    public X3DNode get1Value(int n) {
        this.checkAccess(false);
        return this.saiNodes[n];
    }

    public void setValue(int n, X3DNode[] x3DNodeArray) {
        this.checkAccess(true);
        if (this.localValue == null || this.localValue.length < n) {
            this.localValue = new VRMLNodeType[n];
            this.saiNodes = new BaseNode[n];
        }
        this.numElements = n;
        System.arraycopy(x3DNodeArray, 0, this.saiNodes, 0, n);
        for (int i = 0; i < n; ++i) {
            if (x3DNodeArray[i] != null && !x3DNodeArray[i].isRealized()) {
                x3DNodeArray[i].realize();
                ((BaseNode)x3DNodeArray[i]).setAccessValid(this.accessPermitted);
            }
            this.localValue[i] = x3DNodeArray[i] != null ? ((BaseNode)x3DNodeArray[i]).getImplNode() : null;
        }
        this.dataChanged = true;
    }

    public void set1Value(int n, X3DNode x3DNode) {
        this.checkAccess(true);
        if (x3DNode != null && !x3DNode.isRealized()) {
            x3DNode.realize();
        }
        this.saiNodes[n] = (BaseNode)x3DNode;
        this.localValue[n] = x3DNode != null ? ((BaseNode)x3DNode).getImplNode() : null;
        this.dataChanged = true;
    }

    public void updateNodeAndChildren() {
        for (int i = 0; i < this.numElements; ++i) {
            if (this.saiNodes[i] == null) continue;
            this.saiNodes[i].updateNodeAndChildren();
        }
        if (this.dataChanged) {
            this.node.setValue(this.fieldIndex, this.localValue, this.numElements);
            this.dataChanged = false;
        }
    }

    public void updateFieldAndChildren() {
        this.updateField();
        for (int i = 0; i < this.numElements; ++i) {
            if (this.saiNodes[i] == null) continue;
            this.saiNodes[i].updateFields();
        }
    }

    public void setAccessValid(boolean bl) {
        super.setAccessValid(bl);
        for (int i = 0; i < this.numElements; ++i) {
            if (this.saiNodes[i] == null) continue;
            this.saiNodes[i].setAccessValid(bl);
        }
    }

    public void setFieldFactory(FieldFactory fieldFactory) {
        this.fieldFactory = fieldFactory;
    }

    public void setFieldReferenceQueue(ReferenceQueue referenceQueue) {
        this.fieldQueue = referenceQueue;
    }

    public void setNodeFactory(BaseNodeFactory baseNodeFactory) {
        this.baseNodeFactory = baseNodeFactory;
    }

    void updateNode() {
        this.node.setValue(this.fieldIndex, this.localValue, this.numElements);
        this.dataChanged = false;
    }

    void updateField() {
        if (!this.isReadable()) {
            return;
        }
        VRMLFieldData vRMLFieldData = this.node.getFieldValue(this.fieldIndex);
        if (this.numElements != vRMLFieldData.numElements) {
            if (vRMLFieldData.numElements == 0) {
                for (int i = 0; i < vRMLFieldData.numElements; ++i) {
                    this.saiNodes[i] = null;
                }
            } else if (vRMLFieldData.numElements < this.numElements) {
                int n;
                for (n = 0; n < vRMLFieldData.numElements; ++n) {
                    if (vRMLFieldData.nodeArrayValue[n] == this.localValue[n]) continue;
                    this.localValue[n] = (VRMLNodeType)vRMLFieldData.nodeArrayValue[n];
                    if (this.localValue[n] != null) {
                        this.saiNodes[n] = (BaseNode)this.baseNodeFactory.getBaseNode(this.localValue[n]);
                        this.saiNodes[n].setAccessValid(this.accessPermitted);
                        continue;
                    }
                    this.saiNodes[n] = null;
                }
                for (n = vRMLFieldData.numElements; n < this.numElements; ++n) {
                    this.localValue[n] = null;
                    this.saiNodes[n] = null;
                }
            } else {
                if (this.localValue == null || this.localValue.length < vRMLFieldData.numElements) {
                    VRMLNodeType[] vRMLNodeTypeArray = new VRMLNodeType[vRMLFieldData.numElements];
                    BaseNode[] baseNodeArray = new BaseNode[vRMLFieldData.numElements];
                    if (this.localValue != null) {
                        System.arraycopy(this.localValue, 0, vRMLNodeTypeArray, 0, this.numElements);
                        System.arraycopy(this.saiNodes, 0, baseNodeArray, 0, this.numElements);
                    }
                    this.localValue = vRMLNodeTypeArray;
                    this.saiNodes = baseNodeArray;
                }
                for (int i = 0; i < vRMLFieldData.numElements; ++i) {
                    if (vRMLFieldData.nodeArrayValue[i] == this.localValue[i]) continue;
                    this.localValue[i] = (VRMLNodeType)vRMLFieldData.nodeArrayValue[i];
                    if (this.localValue[i] != null) {
                        this.saiNodes[i] = (BaseNode)this.baseNodeFactory.getBaseNode(this.localValue[i]);
                        this.saiNodes[i].setAccessValid(this.accessPermitted);
                        continue;
                    }
                    this.saiNodes[i] = null;
                }
            }
            this.numElements = vRMLFieldData.numElements;
        } else {
            for (int i = 0; i < this.numElements; ++i) {
                if (vRMLFieldData.nodeArrayValue[i] == this.localValue[i]) continue;
                this.localValue[i] = (VRMLNodeType)vRMLFieldData.nodeArrayValue[i];
                if (this.localValue[i] != null) {
                    this.saiNodes[i] = (BaseNode)this.baseNodeFactory.getBaseNode(this.localValue[i]);
                    this.saiNodes[i].setAccessValid(this.accessPermitted);
                    continue;
                }
                this.saiNodes[i] = null;
            }
        }
        this.dataChanged = false;
    }
}

