/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.sai;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLScriptNodeType;
import org.web3d.vrml.scripting.ScriptWrapper;
import org.web3d.vrml.scripting.sai.BaseField;
import org.web3d.vrml.scripting.sai.BaseNodeFactory;
import org.web3d.vrml.scripting.sai.FieldAccessListener;
import org.web3d.vrml.scripting.sai.FieldFactory;
import org.web3d.vrml.scripting.sai.InternalBrowser;
import org.web3d.vrml.scripting.sai.NodeField;
import org.web3d.vrml.scripting.sai.SAIScriptNodeImpl;
import org.web3d.x3d.sai.Browser;
import org.web3d.x3d.sai.InvalidFieldException;
import org.web3d.x3d.sai.X3DPerFrameObserverScript;
import org.web3d.x3d.sai.X3DScriptImplementation;
import org.web3d.x3d.sai.X3DScriptNode;

public class JavaSAIScriptWrapper
implements ScriptWrapper,
FieldAccessListener {
    private static final HashSet NON_USE_FIELDS = new HashSet();
    private X3DScriptImplementation script;
    private X3DPerFrameObserverScript perFrameScript;
    private ErrorReporter errorReporter;
    private HashMap fieldMap;
    private ArrayList pendingEvents;
    private BaseField[] updatableFields;
    private BaseField[] allFields;
    private BaseField[] usedNodes;
    private double timestamp;
    private InternalBrowser browser;
    private FieldFactory fieldFactory;
    private ReferenceQueue fieldQueue;
    private BaseNodeFactory baseNodeFactory;
    private boolean directOutput;
    private boolean initialized;
    private boolean hadInputEvent;

    public JavaSAIScriptWrapper(X3DScriptImplementation x3DScriptImplementation) {
        this.script = x3DScriptImplementation;
        this.fieldMap = new HashMap();
        this.initialized = false;
        this.hadInputEvent = false;
        if (x3DScriptImplementation instanceof X3DPerFrameObserverScript) {
            this.perFrameScript = (X3DPerFrameObserverScript)x3DScriptImplementation;
        }
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(VRMLScriptNodeType vRMLScriptNodeType) {
        Object object;
        int n = vRMLScriptNodeType.getFieldIndex("directOutput");
        try {
            VRMLFieldData vRMLFieldData = vRMLScriptNodeType.getFieldValue(n);
            this.directOutput = vRMLFieldData.booleanValue;
        }
        catch (InvalidFieldException invalidFieldException) {
            invalidFieldException.printStackTrace();
        }
        List list = vRMLScriptNodeType.getAllFields();
        Iterator iterator = list.iterator();
        ArrayList<BaseField> arrayList = new ArrayList<BaseField>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        this.allFields = new BaseField[list.size()];
        int n2 = 0;
        while (iterator.hasNext()) {
            int n3;
            VRMLFieldDeclaration vRMLFieldDeclaration = (VRMLFieldDeclaration)iterator.next();
            String string = vRMLFieldDeclaration.getName();
            BaseField baseField = this.fieldFactory.createField(vRMLScriptNodeType, string, true, true, this.fieldQueue, this.baseNodeFactory);
            object = baseField;
            ((BaseField)object).setFieldAccessListener(this);
            this.fieldMap.put(string, baseField);
            this.allFields[n2++] = object;
            if (NON_USE_FIELDS.contains(string)) {
                ((BaseField)object).setReadOnly();
            }
            if ((n3 = vRMLFieldDeclaration.getAccessType()) == 1) continue;
            arrayList.add(baseField);
            if (n3 != 4) {
                ((BaseField)object).updateField();
            }
            if (n3 != 2 && n3 != 3 || !(object instanceof NodeField)) continue;
            arrayList2.add(object);
        }
        this.pendingEvents = new ArrayList(vRMLScriptNodeType.getFieldCount());
        this.updatableFields = new BaseField[arrayList.size()];
        arrayList.toArray(this.updatableFields);
        this.usedNodes = new BaseField[arrayList2.size()];
        arrayList2.toArray(this.usedNodes);
        this.initialized = true;
        object = new SAIScriptNodeImpl(vRMLScriptNodeType, this.fieldQueue, this.fieldFactory, this, this.baseNodeFactory);
        try {
            this.enableFields();
            this.script.setBrowser((Browser)this.browser);
            this.script.setFields((X3DScriptNode)object, Collections.unmodifiableMap(this.fieldMap));
            this.script.initialize();
        }
        catch (Exception exception) {
            this.errorReporter.errorReport("Unable to initialize script", exception);
        }
        finally {
            this.disableFields();
        }
    }

    public void setTimestamp(double d) {
        this.timestamp = d;
    }

    public boolean prepareEvents() {
        if (this.perFrameScript != null) {
            if (this.directOutput) {
                for (int i = 0; i < this.usedNodes.length; ++i) {
                    ((NodeField)((Object)this.usedNodes[i])).updateFieldAndChildren();
                }
            }
            this.enableFields();
            try {
                this.perFrameScript.prepareEvents();
            }
            catch (Exception exception) {
                this.errorReporter.errorReport("Per-frame observer error", exception);
            }
            this.disableFields();
            if (this.directOutput) {
                for (int i = 0; i < this.usedNodes.length; ++i) {
                    ((NodeField)((Object)this.usedNodes[i])).updateNodeAndChildren();
                }
            }
            return true;
        }
        return false;
    }

    public void queueEvent(int n, String string, int n2) {
        if (!this.initialized) {
            return;
        }
        this.pendingEvents.add(string);
    }

    public void queueEvent(int n, String string, int[] nArray, int n2) {
        if (!this.initialized) {
            return;
        }
        this.pendingEvents.add(string);
    }

    public void queueEvent(int n, String string, long l) {
        if (!this.initialized) {
            return;
        }
        this.pendingEvents.add(string);
    }

    public void queueEvent(int n, String string, long[] lArray, int n2) {
        if (!this.initialized) {
            return;
        }
        this.pendingEvents.add(string);
    }

    public void queueEvent(int n, String string, boolean bl) {
        if (!this.initialized) {
            return;
        }
        this.pendingEvents.add(string);
    }

    public void queueEvent(int n, String string, boolean[] blArray, int n2) {
        if (!this.initialized) {
            return;
        }
        this.pendingEvents.add(string);
    }

    public void queueEvent(int n, String string, float f) {
        if (!this.initialized) {
            return;
        }
        this.pendingEvents.add(string);
    }

    public void queueEvent(int n, String string, float[] fArray, int n2) {
        if (!this.initialized) {
            return;
        }
        this.pendingEvents.add(string);
    }

    public void queueEvent(int n, String string, double d) {
        if (!this.initialized) {
            return;
        }
        this.pendingEvents.add(string);
    }

    public void queueEvent(int n, String string, double[] dArray, int n2) {
        if (!this.initialized) {
            return;
        }
        this.pendingEvents.add(string);
    }

    public void queueEvent(int n, String string, String string2) {
        if (!this.initialized) {
            return;
        }
        this.pendingEvents.add(string);
    }

    public void queueEvent(int n, String string, String[] stringArray, int n2) {
        if (!this.initialized) {
            return;
        }
        this.pendingEvents.add(string);
    }

    public void queueEvent(int n, String string, VRMLNodeType vRMLNodeType) {
        if (!this.initialized) {
            return;
        }
        this.pendingEvents.add(string);
    }

    public void queueEvent(int n, String string, VRMLNodeType[] vRMLNodeTypeArray, int n2) {
        if (!this.initialized) {
            return;
        }
        this.pendingEvents.add(string);
    }

    public boolean sendEvents() {
        int n;
        if (!this.initialized) {
            return false;
        }
        this.hadInputEvent = true;
        int n2 = this.pendingEvents.size();
        if (n2 == 0) {
            return false;
        }
        if (this.directOutput) {
            for (n = 0; n < this.usedNodes.length; ++n) {
                ((NodeField)((Object)this.usedNodes[n])).updateFieldAndChildren();
            }
        }
        this.enableFields();
        for (n = 0; n < n2; ++n) {
            String string = (String)this.pendingEvents.get(n);
            BaseField baseField = (BaseField)this.fieldMap.get(string);
            baseField.updateField();
            try {
                baseField.fireEventNotification(this.timestamp);
                continue;
            }
            catch (Exception exception) {
                this.errorReporter.errorReport("Error while sending event", exception);
            }
        }
        this.disableFields();
        this.pendingEvents.clear();
        return true;
    }

    public void updateEventOuts() {
        if (!this.directOutput) {
            for (int i = 0; i < this.updatableFields.length; ++i) {
                if (!this.updatableFields[i].hasChanged()) continue;
                this.updatableFields[i].updateNode();
            }
        } else {
            for (int i = 0; i < this.updatableFields.length; ++i) {
                if (this.updatableFields[i] instanceof NodeField) {
                    ((NodeField)((Object)this.updatableFields[i])).updateNodeAndChildren();
                    continue;
                }
                if (!this.updatableFields[i].hasChanged()) continue;
                this.updatableFields[i].updateNode();
            }
            this.browser.updateEventOuts();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eventsProcessed() {
        if (!this.hadInputEvent) {
            return;
        }
        this.hadInputEvent = false;
        try {
            this.enableFields();
            this.script.eventsProcessed();
        }
        catch (Exception exception) {
            this.errorReporter.errorReport("Error during script eventProcessed", exception);
        }
        finally {
            this.disableFields();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        try {
            this.enableFields();
            this.script.shutdown();
            this.script = null;
        }
        catch (Exception exception) {
            this.errorReporter.errorReport("Error during script shutdown", exception);
        }
        finally {
            this.disableFields();
        }
    }

    public void childRequiresAccessStateChange(boolean bl) {
        if (bl) {
            if (this.directOutput) {
                for (int i = 0; i < this.usedNodes.length; ++i) {
                    ((NodeField)((Object)this.usedNodes[i])).updateFieldAndChildren();
                }
            }
            this.enableFields();
        } else {
            this.disableFields();
        }
    }

    void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (this.errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }

    void setBrowser(InternalBrowser internalBrowser) {
        this.browser = internalBrowser;
        this.fieldFactory = internalBrowser.getFieldFactory();
        this.fieldQueue = internalBrowser.getSharedFieldQueue();
        this.baseNodeFactory = internalBrowser.getBaseNodeFactory();
    }

    private void enableFields() {
        for (int i = 0; i < this.allFields.length; ++i) {
            this.allFields[i].setAccessValid(true);
        }
    }

    private void disableFields() {
        Reference reference;
        for (int i = 0; i < this.allFields.length; ++i) {
            this.allFields[i].setAccessValid(false);
        }
        while ((reference = this.fieldQueue.poll()) != null) {
            BaseField baseField = (BaseField)reference.get();
            if (baseField == null) continue;
            if (baseField instanceof NodeField) {
                ((NodeField)((Object)baseField)).updateNodeAndChildren();
                continue;
            }
            if (!baseField.hasChanged()) continue;
            baseField.updateNode();
        }
    }

    static {
        NON_USE_FIELDS.add("mustEvaluate");
        NON_USE_FIELDS.add("directOutput");
    }
}

