/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.sai;

import org.web3d.browser.BrowserCore;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.lang.VRMLExecutionSpace;
import org.web3d.vrml.nodes.FrameStateManager;
import org.web3d.vrml.scripting.InvalidScriptContentException;
import org.web3d.vrml.scripting.ScriptEngine;
import org.web3d.vrml.scripting.ScriptWrapper;
import org.web3d.vrml.scripting.sai.InternalBrowser;
import org.web3d.vrml.scripting.sai.JavaSAIScriptBrowserFactory;
import org.web3d.vrml.scripting.sai.JavaSAIScriptWrapper;
import org.web3d.x3d.sai.X3DScriptImplementation;
import org.xj3d.core.eventmodel.RouteManager;
import org.xj3d.core.eventmodel.ViewpointManager;
import org.xj3d.core.loading.WorldLoaderManager;

public class JavaSAIScriptEngine
implements ScriptEngine {
    private static final String[] CONTENT_TYPES = new String[]{"application/x-java", "application/java"};
    private JavaSAIScriptBrowserFactory browserFactory;
    private ErrorReporter errorReporter;

    public JavaSAIScriptEngine(BrowserCore browserCore, ViewpointManager viewpointManager, RouteManager routeManager, FrameStateManager frameStateManager, WorldLoaderManager worldLoaderManager) {
        if (browserCore == null) {
            throw new IllegalArgumentException("BrowserCore is null");
        }
        if (worldLoaderManager == null) {
            throw new IllegalArgumentException("WorldLoaderManager is null");
        }
        if (routeManager == null) {
            throw new IllegalArgumentException("Routemanager is null");
        }
        if (viewpointManager == null) {
            throw new IllegalArgumentException("ViewpointManager is null");
        }
        if (frameStateManager == null) {
            throw new IllegalArgumentException("FrameStateManager is null");
        }
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        this.browserFactory = new JavaSAIScriptBrowserFactory(browserCore, viewpointManager, routeManager, worldLoaderManager, frameStateManager);
        this.browserFactory.setErrorReporter(this.errorReporter);
    }

    public int getSupportedSpecificationVersion() {
        return 3;
    }

    public String[] getSupportedContentTypes() {
        return CONTENT_TYPES;
    }

    public ScriptWrapper buildWrapper(VRMLExecutionSpace vRMLExecutionSpace, String string, Object object) throws InvalidScriptContentException {
        JavaSAIScriptWrapper javaSAIScriptWrapper;
        if (!(object instanceof Class)) {
            throw new InvalidScriptContentException("Not a Java class");
        }
        if (!X3DScriptImplementation.class.isAssignableFrom((Class)object)) {
            throw new InvalidScriptContentException("Not a X3D Java script");
        }
        try {
            X3DScriptImplementation x3DScriptImplementation = (X3DScriptImplementation)((Class)object).newInstance();
            javaSAIScriptWrapper = new JavaSAIScriptWrapper(x3DScriptImplementation);
            InternalBrowser internalBrowser = this.browserFactory.getBrowser(vRMLExecutionSpace, javaSAIScriptWrapper);
            javaSAIScriptWrapper.setBrowser(internalBrowser);
        }
        catch (InstantiationException instantiationException) {
            throw new InvalidScriptContentException("Could not instantiate script" + object.getClass().getName());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InvalidScriptContentException("Could not instantiate script" + object.getClass().getName());
        }
        return javaSAIScriptWrapper;
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
        this.browserFactory.setErrorReporter(this.errorReporter);
    }
}

