/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.sai;

import java.util.LinkedList;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLNodeListener;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.scripting.sai.FieldAccessListener;
import org.web3d.vrml.scripting.sai.FieldListenerMulticaster;
import org.web3d.vrml.scripting.sai.SAIFieldDefinition;
import org.web3d.vrml.scripting.sai.SAIFieldEvent;
import org.web3d.x3d.sai.InvalidOperationTimingException;
import org.web3d.x3d.sai.InvalidReadableFieldException;
import org.web3d.x3d.sai.InvalidWritableFieldException;
import org.web3d.x3d.sai.X3DField;
import org.web3d.x3d.sai.X3DFieldDefinition;
import org.web3d.x3d.sai.X3DFieldEvent;
import org.web3d.x3d.sai.X3DFieldEventListener;

abstract class BaseField
implements X3DField,
VRMLNodeListener {
    protected static final String NO_DIRECT_OUT_ERR = "You cannot write to this field. It is not permitted when the directOutput field is set to false.";
    protected static final String INVALID_TIMING_ERR = "You are attempting to access a field when not permitted by the specification. Please see 19775 Part 2, 4.8.3.7 User code lifecycle for more information";
    protected static final String NOT_WRITABLE_ERR = "This field is not writable in the current state";
    protected static final String NOT_READABLE_ERR = "This field is not readable in the current state";
    private static LinkedList eventList = new LinkedList();
    protected VRMLNodeType node;
    protected int fieldIndex;
    private X3DFieldDefinition fieldDef;
    private X3DFieldEventListener listener;
    protected FieldAccessListener fieldAccessListener;
    private boolean internal;
    protected boolean dataChanged;
    protected boolean accessPermitted;
    protected boolean readOnly;

    BaseField(VRMLNodeType vRMLNodeType, int n, boolean bl) {
        this.node = vRMLNodeType;
        this.fieldIndex = n;
        this.internal = bl;
        this.dataChanged = false;
        this.accessPermitted = false;
        this.readOnly = false;
    }

    public X3DFieldDefinition getDefinition() {
        if (this.fieldDef == null) {
            VRMLFieldDeclaration vRMLFieldDeclaration = this.node.getFieldDeclaration(this.fieldIndex);
            this.fieldDef = new SAIFieldDefinition(vRMLFieldDeclaration.getName(), vRMLFieldDeclaration.getAccessType(), vRMLFieldDeclaration.getFieldType());
        }
        return this.fieldDef;
    }

    public boolean isReadable() {
        VRMLFieldDeclaration vRMLFieldDeclaration = this.node.getFieldDeclaration(this.fieldIndex);
        int n = vRMLFieldDeclaration.getAccessType();
        boolean bl = this.internal ? n == 1 || n == 2 || n == 3 : n == 4 || n == 3;
        return bl;
    }

    public boolean isWritable() {
        VRMLFieldDeclaration vRMLFieldDeclaration = this.node.getFieldDeclaration(this.fieldIndex);
        int n = vRMLFieldDeclaration.getAccessType();
        boolean bl = this.internal ? n == 4 || n == 3 || n == 2 : (this.node.isSetupFinished() ? n == 1 || n == 3 : n == 3 || n == 2);
        return bl;
    }

    public void addX3DEventListener(X3DFieldEventListener x3DFieldEventListener) {
        if (this.isReadable()) {
            boolean bl = this.listener == null;
            this.listener = FieldListenerMulticaster.add(x3DFieldEventListener, this.listener);
            if (bl && !this.internal) {
                this.node.addNodeListener(this);
            }
        }
    }

    public void removeX3DEventListener(X3DFieldEventListener x3DFieldEventListener) {
        if (this.isReadable()) {
            this.listener = FieldListenerMulticaster.remove(x3DFieldEventListener, this.listener);
            if (this.listener == null && !this.internal) {
                this.node.removeNodeListener(this);
            }
        }
    }

    public void setUserData(Object object) {
        this.node.setUserData(this.fieldIndex, object);
    }

    public Object getUserData() {
        return this.node.getUserData(this.fieldIndex);
    }

    public void fieldChanged(int n) {
        if (n == this.fieldIndex) {
            SAIFieldEvent sAIFieldEvent = BaseField.getEventInstance(this);
            sAIFieldEvent.update(this, (double)System.currentTimeMillis() * 0.001, this.node.getUserData(this.fieldIndex));
            this.fieldAccessListener.childRequiresAccessStateChange(true);
            this.listener.readableFieldChanged((X3DFieldEvent)sAIFieldEvent);
            this.fieldAccessListener.childRequiresAccessStateChange(false);
            BaseField.releaseEvent(sAIFieldEvent);
        }
    }

    abstract void updateNode();

    abstract void updateField();

    void setFieldAccessListener(FieldAccessListener fieldAccessListener) {
        this.fieldAccessListener = fieldAccessListener;
    }

    void setReadOnly() {
        this.readOnly = true;
    }

    void setAccessValid(boolean bl) {
        this.accessPermitted = bl;
    }

    void fireEventNotification(double d) {
        if (this.listener == null) {
            return;
        }
        SAIFieldEvent sAIFieldEvent = BaseField.getEventInstance(this);
        sAIFieldEvent.update(this, d, this.node.getUserData(this.fieldIndex));
        this.listener.readableFieldChanged((X3DFieldEvent)sAIFieldEvent);
        BaseField.releaseEvent(sAIFieldEvent);
    }

    boolean hasChanged() {
        boolean bl = this.dataChanged;
        this.dataChanged = false;
        return bl;
    }

    protected void checkAccess(boolean bl) throws InvalidOperationTimingException, InvalidWritableFieldException, InvalidReadableFieldException {
        if (this.readOnly && bl) {
            throw new InvalidWritableFieldException(NO_DIRECT_OUT_ERR);
        }
        if (!this.accessPermitted) {
            throw new InvalidOperationTimingException(INVALID_TIMING_ERR);
        }
        if (bl) {
            if (!this.isWritable()) {
                throw new InvalidWritableFieldException(NOT_WRITABLE_ERR);
            }
        } else if (!this.isReadable()) {
            throw new InvalidReadableFieldException(NOT_READABLE_ERR);
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof BaseField)) {
            return false;
        }
        BaseField baseField = (BaseField)object;
        return baseField.node == this.node && baseField.fieldIndex == this.fieldIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized SAIFieldEvent getEventInstance(Object object) {
        SAIFieldEvent sAIFieldEvent = null;
        if (eventList.size() != 0) {
            LinkedList linkedList = eventList;
            synchronized (linkedList) {
                sAIFieldEvent = (SAIFieldEvent)((Object)eventList.removeFirst());
            }
        } else {
            sAIFieldEvent = new SAIFieldEvent(object);
        }
        return sAIFieldEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void releaseEvent(SAIFieldEvent sAIFieldEvent) {
        LinkedList linkedList = eventList;
        synchronized (linkedList) {
            eventList.add(sAIFieldEvent);
        }
    }
}

