/*
 * Decompiled with CFR 0.152.
 */
package org.odejava.xode;

import java.io.Serializable;
import java.util.LinkedList;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;
import org.odejava.xode.XODEParserDOM;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XODETransform
implements Serializable {
    public static Matrix4f parseTransformNode(Node xodeTransformNode) {
        Node currentNode;
        int j;
        Matrix4f relTransform = new Matrix4f();
        relTransform.setIdentity();
        LinkedList<String> elements = new LinkedList<String>();
        NodeList transformChildren = xodeTransformNode.getChildNodes();
        for (j = 0; j < transformChildren.getLength(); ++j) {
            currentNode = transformChildren.item(j);
            elements.add(currentNode.getNodeName());
        }
        if (elements.contains("matrix")) {
            for (j = 0; j < transformChildren.getLength(); ++j) {
                currentNode = transformChildren.item(j);
                if (!currentNode.getNodeName().equals("matrix")) continue;
                relTransform.m00 = Float.parseFloat(currentNode.getAttributes().getNamedItem("m00").getNodeValue());
                relTransform.m01 = Float.parseFloat(currentNode.getAttributes().getNamedItem("m01").getNodeValue());
                relTransform.m02 = Float.parseFloat(currentNode.getAttributes().getNamedItem("m02").getNodeValue());
                relTransform.m03 = Float.parseFloat(currentNode.getAttributes().getNamedItem("m03").getNodeValue());
                relTransform.m10 = Float.parseFloat(currentNode.getAttributes().getNamedItem("m10").getNodeValue());
                relTransform.m11 = Float.parseFloat(currentNode.getAttributes().getNamedItem("m11").getNodeValue());
                relTransform.m12 = Float.parseFloat(currentNode.getAttributes().getNamedItem("m12").getNodeValue());
                relTransform.m13 = Float.parseFloat(currentNode.getAttributes().getNamedItem("m13").getNodeValue());
                relTransform.m20 = Float.parseFloat(currentNode.getAttributes().getNamedItem("m20").getNodeValue());
                relTransform.m21 = Float.parseFloat(currentNode.getAttributes().getNamedItem("m21").getNodeValue());
                relTransform.m22 = Float.parseFloat(currentNode.getAttributes().getNamedItem("m22").getNodeValue());
                relTransform.m23 = Float.parseFloat(currentNode.getAttributes().getNamedItem("m23").getNodeValue());
                relTransform.m30 = Float.parseFloat(currentNode.getAttributes().getNamedItem("m30").getNodeValue());
                relTransform.m31 = Float.parseFloat(currentNode.getAttributes().getNamedItem("m31").getNodeValue());
                relTransform.m32 = Float.parseFloat(currentNode.getAttributes().getNamedItem("m32").getNodeValue());
                relTransform.m33 = Float.parseFloat(currentNode.getAttributes().getNamedItem("m33").getNodeValue());
            }
        } else {
            Vector3f position = null;
            Vector3f euler = null;
            Quat4f quaternion = null;
            AxisAngle4f axisangle = null;
            float scale = 1.0f;
            for (int j2 = 0; j2 < transformChildren.getLength(); ++j2) {
                Node currentNode2 = transformChildren.item(j2);
                if (currentNode2.getNodeName().equals("position")) {
                    position = new Vector3f(Float.parseFloat(currentNode2.getAttributes().getNamedItem("x").getNodeValue()), Float.parseFloat(currentNode2.getAttributes().getNamedItem("y").getNodeValue()), Float.parseFloat(currentNode2.getAttributes().getNamedItem("z").getNodeValue()));
                    continue;
                }
                if (currentNode2.getNodeName().equals("rotation")) {
                    NodeList kChildren = currentNode2.getChildNodes();
                    for (int k = 0; k < kChildren.getLength(); ++k) {
                        Node aformat;
                        boolean degrees;
                        Node currentNodeK = kChildren.item(k);
                        if (currentNodeK.getNodeName().equals("euler")) {
                            degrees = false;
                            aformat = currentNodeK.getAttributes().getNamedItem("aformat");
                            if (aformat != null) {
                                degrees = aformat.getNodeValue().equalsIgnoreCase("degrees");
                            }
                            euler = new Vector3f(Float.parseFloat(currentNodeK.getAttributes().getNamedItem("x").getNodeValue()), Float.parseFloat(currentNodeK.getAttributes().getNamedItem("y").getNodeValue()), Float.parseFloat(currentNodeK.getAttributes().getNamedItem("z").getNodeValue()));
                            if (degrees) {
                                euler.x = (float)Math.toRadians(euler.x);
                                euler.y = (float)Math.toRadians(euler.y);
                                euler.z = (float)Math.toRadians(euler.z);
                            }
                            XODEParserDOM.log.debug(euler);
                            continue;
                        }
                        if (currentNodeK.getNodeName().equals("axisangle")) {
                            degrees = false;
                            aformat = currentNodeK.getAttributes().getNamedItem("aformat");
                            if (aformat != null) {
                                degrees = aformat.getNodeValue().equalsIgnoreCase("degrees");
                            }
                            if ((axisangle = new AxisAngle4f(Float.parseFloat(currentNodeK.getAttributes().getNamedItem("x").getNodeValue()), Float.parseFloat(currentNodeK.getAttributes().getNamedItem("y").getNodeValue()), Float.parseFloat(currentNodeK.getAttributes().getNamedItem("z").getNodeValue()), Float.parseFloat(currentNodeK.getAttributes().getNamedItem("angle").getNodeValue()))) == null) continue;
                            if (degrees) {
                                axisangle.angle = (float)Math.toRadians(axisangle.angle);
                            }
                            relTransform.setRotation(axisangle);
                            continue;
                        }
                        if (!currentNodeK.getNodeName().equals("quaternion")) continue;
                        degrees = false;
                        aformat = currentNodeK.getAttributes().getNamedItem("aformat");
                        if (aformat != null) {
                            degrees = aformat.getNodeValue().equalsIgnoreCase("degrees");
                        }
                        quaternion = new Quat4f(Float.parseFloat(currentNodeK.getAttributes().getNamedItem("x").getNodeValue()), Float.parseFloat(currentNodeK.getAttributes().getNamedItem("y").getNodeValue()), Float.parseFloat(currentNodeK.getAttributes().getNamedItem("z").getNodeValue()), Float.parseFloat(currentNodeK.getAttributes().getNamedItem("w").getNodeValue()));
                    }
                    continue;
                }
                if (!currentNode2.getNodeName().equals("scale")) continue;
                scale = Float.parseFloat(currentNode2.getAttributes().getNamedItem("scale").getNodeValue());
            }
            relTransform.setIdentity();
            if (euler != null) {
                Matrix4f tmp = new Matrix4f();
                if (euler.x != 0.0f) {
                    tmp.setIdentity();
                    tmp.rotX(euler.x);
                    relTransform.mul(tmp);
                }
                if (euler.y != 0.0f) {
                    tmp.setIdentity();
                    tmp.rotY(euler.y);
                    relTransform.mul(tmp);
                }
                if (euler.z != 0.0f) {
                    tmp.setIdentity();
                    tmp.rotZ(euler.z);
                    relTransform.mul(tmp);
                }
            }
            if (quaternion != null) {
                XODEParserDOM.odeLog.debug("quaternion set");
                relTransform.setRotation(quaternion);
            }
            if (position != null) {
                XODEParserDOM.odeLog.debug("position set");
                relTransform.setTranslation(position);
            }
            relTransform.setScale(scale);
        }
        return relTransform;
    }
}

