/*
 * Decompiled with CFR 0.152.
 */
package org.odejava.xode;

import java.io.Serializable;
import java.util.Iterator;
import javax.vecmath.Matrix4f;
import org.odejava.Geom;
import org.odejava.GeomBox;
import org.odejava.GeomCappedCylinder;
import org.odejava.GeomCone;
import org.odejava.GeomCylinder;
import org.odejava.GeomPlane;
import org.odejava.GeomRay;
import org.odejava.GeomSphere;
import org.odejava.GeomTransform;
import org.odejava.GeomTriMesh;
import org.odejava.PlaceableGeom;
import org.odejava.Space;
import org.odejava.xode.XODEContainer;
import org.odejava.xode.XODEException;
import org.odejava.xode.XODEGeomBox;
import org.odejava.xode.XODEGeomCappedCylinder;
import org.odejava.xode.XODEGeomCone;
import org.odejava.xode.XODEGeomCylinder;
import org.odejava.xode.XODEGeomPlane;
import org.odejava.xode.XODEGeomRay;
import org.odejava.xode.XODEGeomSphere;
import org.odejava.xode.XODEGroup;
import org.odejava.xode.XODEParserDOM;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XODESpace
extends XODEGroup
implements Serializable {
    protected XODESpace() {
    }

    public XODESpace(String name, XODEContainer parent, Matrix4f transform) {
        super(name, parent, transform);
    }

    public XODESpace(XODEContainer parent, Node xodeData) {
        super(parent, xodeData, false);
        NodeList children = xodeData.getChildNodes();
        XODEParserDOM.log.debug("SPAce!");
        this.parseTransform(xodeData);
        this.parseGroup(xodeData);
    }

    public XODESpace(Space space) {
        Iterator i = space.getGeoms().iterator();
        while (i.hasNext()) {
            XODESpace.addChild(this, (Geom)i.next());
        }
    }

    public static void addChild(XODEContainer parent, Geom currentGeom) {
        Matrix4f identity = new Matrix4f();
        identity.setIdentity();
        XODESpace.addChild(parent, currentGeom, identity);
    }

    public static void addChild(XODEContainer parent, Geom currentGeom, Matrix4f transform) {
        if (currentGeom instanceof GeomBox) {
            parent.addChild(new XODEGeomBox(currentGeom, transform));
        } else if (currentGeom instanceof GeomCappedCylinder) {
            parent.addChild(new XODEGeomCappedCylinder(currentGeom, transform));
        } else if (currentGeom instanceof GeomCone) {
            parent.addChild(new XODEGeomCone(currentGeom, transform));
        } else if (currentGeom instanceof GeomCylinder) {
            parent.addChild(new XODEGeomCylinder(currentGeom, transform));
        } else if (currentGeom instanceof GeomPlane) {
            parent.addChild(new XODEGeomPlane(currentGeom, transform));
        } else if (currentGeom instanceof GeomRay) {
            parent.addChild(new XODEGeomRay(currentGeom, transform));
        } else if (currentGeom instanceof GeomSphere) {
            parent.addChild(new XODEGeomSphere(currentGeom, transform));
        } else {
            if (currentGeom instanceof GeomTriMesh) {
                throw new XODEException("Trimesh unsupported currently");
            }
            if (currentGeom instanceof GeomTransform) {
                Matrix4f encapsulatedTransform = new Matrix4f();
                transform.setIdentity();
                PlaceableGeom encapsulatedGeom = ((GeomTransform)currentGeom).getEncapsulatedGeom();
                transform.setRotation(encapsulatedGeom.getQuaternion());
                transform.setTranslation(encapsulatedGeom.getPosition());
                XODESpace.addChild(parent, encapsulatedGeom, encapsulatedTransform);
            } else {
                throw new XODEException("Unknown geom type: " + currentGeom.getClass().getName());
            }
        }
    }
}

