/*
 * Decompiled with CFR 0.152.
 */
package org.odejava.xode;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import javax.vecmath.Matrix4f;
import org.odejava.Space;
import org.odejava.World;
import org.odejava.xode.XODEContainer;
import org.odejava.xode.XODEParserDOM;
import org.odejava.xode.XODEWorld;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XODERoot
extends XODEContainer
implements Serializable {
    protected XODERoot() {
    }

    public XODERoot(String name, Matrix4f transform) {
        super(name, null, transform);
    }

    public XODERoot(Node xode, Matrix4f parentTransform) {
        super(null, xode);
        NodeList children = xode.getChildNodes();
        XODEParserDOM.log.debug("Root!");
        this.relTransform = parentTransform;
        for (int i = 0; i < children.getLength(); ++i) {
            Node currentChild = children.item(i);
            if (!currentChild.getNodeName().equals("world")) continue;
            this.addChild(new XODEWorld((XODEContainer)this, currentChild));
        }
    }

    public XODERoot(String name, Matrix4f transform, World world, Space space) {
        this(name, transform);
        this.addChild(new XODEWorld(world, space));
    }

    public List buildODEScene(World world, Space space, String namePrefix) {
        LinkedList odeObjects = new LinkedList();
        super.buildOde(world, space, namePrefix, odeObjects);
        return odeObjects;
    }

    public List buildODEScene(World world, Space space, String namePrefix, Matrix4f transform) {
        this.setRootTransform(transform);
        return this.buildODEScene(world, space, namePrefix);
    }

    public void setRootTransform(Matrix4f transform) {
        this.relTransform.set(transform);
        this.invalidateTransformCache();
    }
}

